/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.simulatedAnnealing2;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.simulatedAnnealing2.Metric;
import com.sun.electric.tool.placement.simulatedAnnealing2.ProxyNode;
import java.util.Arrays;
import java.util.Map;

public final class MSTMetric
extends Metric {
    Edge[] edges = null;
    UnionFind connected = null;

    public MSTMetric(PlacementFrame.PlacementNetwork net, Map<PlacementFrame.PlacementNode, ProxyNode> hm, ProxyNode[] originals, ProxyNode[] replacements) {
        PlacementFrame.PlacementPort[] ports = new PlacementFrame.PlacementPort[net.getPortsOnNet().size()];
        ports = net.getPortsOnNet().toArray(ports);
        this.connected = new UnionFind(ports.length);
        this.edges = new Edge[(ports.length - 1) * ports.length / 2];
        int c = 0;
        for (int i = 0; i < ports.length; ++i) {
            int j = i + 1;
            while (j < ports.length) {
                this.edges[c] = new Edge(ports[i], ports[j], i, j, hm, originals, replacements);
                ++j;
                ++c;
            }
        }
    }

    public MSTMetric(PlacementFrame.PlacementNetwork net) {
        this(net, null, new ProxyNode[0], new ProxyNode[0]);
    }

    public double compute() {
        double length = 0.0;
        int unions = this.connected.nodes.length - 1;
        Arrays.sort(this.edges);
        for (int i = 0; i < this.edges.length && unions > 0; ++i) {
            int subgraph1 = this.edges[i].from;
            int subgraph2 = this.edges[i].to;
            if (this.connected.find(subgraph1) == this.connected.find(subgraph2)) continue;
            this.connected.union(subgraph1, subgraph2);
            --unions;
            length += Math.sqrt((double)this.edges[i].length / 1000.0);
        }
        return length;
    }

    @Override
    public double netLength(PlacementFrame.PlacementNetwork network) {
        MSTMetric foo = new MSTMetric(network);
        return foo.compute();
    }

    @Override
    public double netLength(PlacementFrame.PlacementNetwork network, Map<PlacementFrame.PlacementNode, ProxyNode> proxyMap, ProxyNode[] originals, ProxyNode[] replacements) {
        MSTMetric foo = new MSTMetric(network, proxyMap, originals, replacements);
        return foo.compute();
    }

    static class UnionFind {
        Node[] nodes;
        Node[] stack;

        public UnionFind(int size2) {
            this.nodes = new Node[size2];
            this.stack = new Node[size2];
        }

        private Node findNode(int a) {
            Node na = this.nodes[a];
            if (na == null) {
                Node root2 = new Node(a);
                root2.child = new Node(a);
                root2.child.parent = root2;
                this.nodes[a] = root2.child;
                return root2;
            }
            return this.findNode(na);
        }

        public int find(int a) {
            return this.findNode((int)a).value;
        }

        private Node findNode(Node node) {
            int top = 0;
            while (node.parent.child == null) {
                this.stack[top++] = node;
                node = node.parent;
            }
            Node rootChild = node;
            while (top > 0) {
                node = this.stack[--top];
                node.parent = rootChild;
            }
            return rootChild.parent;
        }

        public boolean isEquiv(int a, int b) {
            return this.findNode(a) == this.findNode(b);
        }

        public void union(int a, int b) {
            Node nb;
            Node na = this.findNode(a);
            if (na == (nb = this.findNode(b))) {
                return;
            }
            if (na.rank > nb.rank) {
                nb.child.parent = na.child;
                na.value = b;
            } else {
                na.child.parent = nb.child;
                nb.value = b;
                if (na.rank == nb.rank) {
                    ++nb.rank;
                }
            }
        }

        static class Node {
            Node parent;
            Node child;
            int value;
            int rank;

            public Node(int v) {
                this.value = v;
                this.rank = 0;
            }
        }
    }

    private class Edge
    implements Comparable<Edge> {
        int from;
        int to;
        int length;

        public Edge(PlacementFrame.PlacementPort from2, PlacementFrame.PlacementPort to2, int fi, int ti, Map<PlacementFrame.PlacementNode, ProxyNode> hm, ProxyNode[] originals, ProxyNode[] replacements) {
            double y_2;
            double x_2;
            double y_1;
            double x_1;
            this.from = fi;
            this.to = ti;
            if (hm == null) {
                x_1 = from2.getRotatedOffX() + from2.getPlacementNode().getPlacementX();
                y_1 = from2.getRotatedOffY() + from2.getPlacementNode().getPlacementY();
                x_2 = to2.getRotatedOffX() + to2.getPlacementNode().getPlacementX();
                y_2 = to2.getRotatedOffY() + to2.getPlacementNode().getPlacementY();
            } else {
                ProxyNode fromNode = hm.get(from2.getPlacementNode());
                ProxyNode toNode = hm.get(to2.getPlacementNode());
                for (int i = 0; i < originals.length; ++i) {
                    if (fromNode == originals[i]) {
                        fromNode = replacements[i];
                    }
                    if (toNode != originals[i]) continue;
                    toNode = replacements[i];
                }
                x_1 = from2.getRotatedOffX() + fromNode.getPlacementX();
                y_1 = from2.getRotatedOffY() + fromNode.getPlacementY();
                x_2 = to2.getRotatedOffX() + toNode.getPlacementX();
                y_2 = to2.getRotatedOffY() + toNode.getPlacementY();
            }
            this.length = (int)(((x_1 - x_2) * (x_1 - x_2) + (y_1 - y_2) * (y_1 - y_2)) * 1000.0);
        }

        @Override
        public int compareTo(Edge other) {
            return this.length - other.length;
        }
    }
}

