/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.output.Geometry;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.simulation.test.TextUtils;
import com.sun.electric.util.math.MutableInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Telesis
extends Geometry {
    private TelesisPreferences localPrefs;
    private TelesisParamSort sortFunction;
    private Map<Cell, Cell> visitedCells = new HashMap<Cell, Cell>();
    private Map<Cell, List<TelesisParam>> telesisParamsList = new HashMap<Cell, List<TelesisParam>>();
    private Cell topCell;
    private boolean topTelesisCell;
    private String outputPath;

    private static String extractRootNameAndArrayIndices(String name, MutableInteger f2, MutableInteger l) {
        f2.setValue(-1);
        l.setValue(-1);
        int last2 = -1;
        int first = name.indexOf("[");
        if (first != -1) {
            String numberArray = name.substring(first);
            name = name.substring(0, first);
            first = -1;
            last2 = -1;
            StringTokenizer parse = new StringTokenizer(numberArray, "[]: ", false);
            while (parse.hasMoreTokens()) {
                String s = parse.nextToken();
                if (first == -1) {
                    first = TextUtils.atoi(s);
                    continue;
                }
                if (last2 == -1) {
                    last2 = TextUtils.atoi(s);
                    continue;
                }
                assert (false);
            }
        }
        f2.setValue(first);
        l.setValue(last2);
        return name;
    }

    private Telesis(TelesisPreferences gp) {
        this.localPrefs = gp;
        this.sortFunction = new TelesisParamSort();
    }

    @Override
    protected void start() {
        this.initOutput();
    }

    @Override
    protected void done() {
    }

    @Override
    protected void writeCellGeom(Geometry.CellGeom cellGeom) {
    }

    private void initOutput() {
    }

    private TelesisVisitor makeTelesisVisitor(int maxDepth) {
        TelesisVisitor visitor = new TelesisVisitor((Geometry)this, maxDepth);
        return visitor;
    }

    private static String formatString(StringBuffer sb) {
        int maxLen = 68;
        int len = sb.length();
        if (len <= maxLen) {
            return sb.toString();
        }
        int front = sb.indexOf(" ");
        int last2 = 0;
        assert (front != -1);
        int lineCount = last2;
        while (front < len && (front = sb.indexOf(" ", last2 + 1)) != -1) {
            int tmp = lineCount + front - last2;
            if (tmp > maxLen) {
                sb.insert(last2 + 1, ",\n");
                lineCount = 0;
                last2 = front;
                continue;
            }
            last2 = front;
            lineCount = tmp;
        }
        return sb.toString();
    }

    private class TelesisVisitor
    extends Geometry.Visitor {
        TelesisVisitor(Geometry outGeom, int maxHierDepth) {
            super(outGeom, maxHierDepth);
        }

        @Override
        public boolean visitIcons() {
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            if (cell != Telesis.this.topCell || Telesis.this.topTelesisCell) {
                return;
            }
            String cellName = cell.getName();
            System.out.println("Dealing with top cell '" + cellName + "'");
            String fileName = Telesis.this.outputPath + "/" + cellName + "." + FileType.TELESIS.getFirstExtension();
            HashMap<Cell, ArrayList<NodeInst>> subCellsMap = new HashMap<Cell, ArrayList<NodeInst>>();
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (!ni.isCellInstance()) continue;
                Cell c = (Cell)ni.getProto();
                ArrayList<NodeInst> l = (ArrayList<NodeInst>)subCellsMap.get(c);
                if (l == null) {
                    l = new ArrayList<NodeInst>();
                    subCellsMap.put(c, l);
                }
                l.add(ni);
            }
            if (!Telesis.this.openTextOutputStream(fileName)) {
                Telesis.this.printWriter.println("$PACKAGES");
                for (Map.Entry e : subCellsMap.entrySet()) {
                    Telesis.this.printWriter.print("! " + ((Cell)e.getKey()).getName() + " ; ");
                    for (NodeInst ni : (List)e.getValue()) {
                        Telesis.this.printWriter.print(ni.getName() + " ");
                    }
                    Telesis.this.printWriter.println(" (# instances " + ((List)e.getValue()).size() + ")");
                }
                Telesis.this.printWriter.println();
                Telesis.this.printWriter.println("$NETS");
                Netlist netlist = cell.getNetlist();
                Iterator<Network> it2 = netlist.getNetworks();
                while (it2.hasNext()) {
                    Network net = it2.next();
                    int count2 = 0;
                    String name = net.getName();
                    int startBus = name.indexOf("[");
                    int number2 = -1;
                    if (startBus != -1) {
                        int endBus = name.indexOf("]");
                        assert (endBus != -1);
                        number2 = TextUtils.atoi(name.substring(startBus + 1, endBus));
                        String rootName = name.substring(0, startBus);
                        name = rootName + "__" + number2;
                    }
                    StringBuffer netString = new StringBuffer("'" + name + "' ; ");
                    Iterator<PortInst> itP = net.getPorts();
                    while (itP.hasNext()) {
                        String exName;
                        PortInst p = itP.next();
                        NodeInst pi = p.getNodeInst();
                        if (!pi.isCellInstance()) continue;
                        Cell c = (Cell)pi.getProto();
                        if (c.isSchematic()) {
                            Cell iconC = c.iconView();
                            assert (iconC != null);
                            c = iconC;
                        }
                        PortProto ex = p.getPortProto();
                        String rootName = exName = ex.getName();
                        startBus = exName.indexOf("[");
                        if (startBus != -1) {
                            assert (number2 != -1);
                            rootName = exName.substring(0, startBus);
                            exName = exName.substring(0, startBus) + "[" + number2 + "]";
                        }
                        List l = (List)Telesis.this.telesisParamsList.get(c);
                        String theNodeName = p.getNodeInst().getName();
                        String theFinalName = "'" + p.getNodeInst().getName() + "'.'" + exName + "' ";
                        MutableInteger portCount = new MutableInteger(1);
                        if (l != null) {
                            for (TelesisParam ap : l) {
                                if (!ap.rootName.equals(rootName)) continue;
                                theFinalName = ap.extractRealPortName(number2, theNodeName, portCount);
                                break;
                            }
                        }
                        if (theFinalName.isEmpty()) continue;
                        netString.append(theFinalName);
                        count2 += portCount.intValue();
                    }
                    if (count2 == 0) continue;
                    Telesis.this.printWriter.print(Telesis.formatString(netString));
                    Telesis.this.printWriter.println(" (# of ports " + count2 + ")");
                }
                Telesis.this.closeTextOutputStream();
            }
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            if (Telesis.this.visitedCells.get(cell) != null) {
                return false;
            }
            Telesis.this.visitedCells.put(cell, cell);
            String cellName = cell.getName();
            String fileName = Telesis.this.outputPath + "/" + cellName + "." + FileType.TELESIS.getFirstExtension();
            boolean telesisCell = false;
            Cell iconCell = cell.isIcon() ? cell : cell.iconView();
            String packageInfo = "";
            String classInfo = "";
            ArrayList<TelesisParam> pinsList = new ArrayList<TelesisParam>();
            ArrayList<TelesisParam> pinsUndefinedList = new ArrayList<TelesisParam>();
            int totalNumberOfPins = 0;
            if (iconCell == null) {
                System.out.println("No icon cell found for cell '" + cellName + "'");
            } else {
                Iterator<Variable> it = iconCell.getVariables();
                while (it.hasNext()) {
                    Variable var = it.next();
                    boolean pinsHeadFound = false;
                    for (int i = 0; i < var.getLength(); ++i) {
                        int start;
                        String vS = (String)var.getObject(i);
                        int index = vS.indexOf("-text");
                        if (!pinsHeadFound) assert (index != -1);
                        if (vS.toLowerCase().contains("allegro_package")) {
                            packageInfo = vS.substring(index + 5).trim();
                            continue;
                        }
                        if (vS.toLowerCase().contains("allegro_class")) {
                            classInfo = vS.substring(index + 5).trim();
                            continue;
                        }
                        if (!vS.toLowerCase().contains("allegro_pins") && !pinsHeadFound) continue;
                        if (!pinsHeadFound) {
                            pinsHeadFound = vS.toLowerCase().contains("allegro_pins");
                        }
                        String pinsInfo = pinsHeadFound ? vS.trim() : vS.substring(index + 5).trim();
                        int pos = 0;
                        int len = pinsInfo.length();
                        while (pos < len && (start = pinsInfo.indexOf("{", pos)) != -1) {
                            int end;
                            if (start < len && pinsInfo.charAt(start) == '{') {
                                ++start;
                            }
                            int numCurly = 1;
                            for (end = start; end < len && numCurly != 0; ++end) {
                                if (pinsInfo.charAt(end) == '{') {
                                    ++numCurly;
                                    continue;
                                }
                                if (pinsInfo.charAt(end) != '}') continue;
                                --numCurly;
                            }
                            String elem2 = pinsInfo.substring(start, --end).trim();
                            pos = end++;
                            int first = elem2.indexOf(" ");
                            int last2 = elem2.lastIndexOf(" ");
                            assert (first != -1 && last2 != -1);
                            String name = elem2.substring(0, first).trim();
                            String port = elem2.substring(first, last2).trim();
                            String use = elem2.substring(last2, elem2.length()).trim();
                            boolean ignorePin = port.toLowerCase().startsWith("ignorenilpin");
                            if (use.toLowerCase().equals("fiducial")) {
                                use = "unspec";
                            }
                            boolean undefined = use.toLowerCase().equals("unspec");
                            MutableInteger f2 = new MutableInteger(-1);
                            MutableInteger l = new MutableInteger(-1);
                            name = Telesis.extractRootNameAndArrayIndices(name, f2, l);
                            last2 = l.intValue();
                            first = f2.intValue();
                            StringTokenizer parse = new StringTokenizer(port, "{} ", false);
                            boolean descend = first > last2;
                            int count2 = first;
                            ArrayList<String> list2 = new ArrayList<String>();
                            while (parse.hasMoreTokens()) {
                                String s = parse.nextToken();
                                String number2 = name;
                                number2 = number2 + "[" + count2 + "]";
                                if (first != -1) {
                                    count2 = descend ? --count2 : ++count2;
                                }
                                s = Telesis.extractRootNameAndArrayIndices(s, f2, l);
                                int localFirst = f2.intValue();
                                int localLast = l.intValue();
                                if (localFirst == -1) {
                                    list2.add(number2 + "'" + s + "'");
                                    continue;
                                }
                                boolean localDesc = localFirst > localLast;
                                int localLen = localDesc ? localFirst - localLast + 1 : localLast - localFirst + 1;
                                int localCount = localFirst;
                                for (int j = 0; j < localLen; ++j) {
                                    String localNumer = name + "[" + localCount + "]";
                                    list2.add(localNumer + "'" + s + "[" + localCount + "]'");
                                    if (localDesc) {
                                        --localCount;
                                        continue;
                                    }
                                    ++localCount;
                                }
                            }
                            TelesisParam param2 = new TelesisParam(name, list2, first, use, ignorePin);
                            if (!ignorePin) {
                                totalNumberOfPins += list2.size();
                            }
                            if (undefined) {
                                pinsUndefinedList.add(param2);
                                continue;
                            }
                            pinsList.add(param2);
                        }
                    }
                }
                Collections.sort(pinsList, Telesis.this.sortFunction);
                Collections.sort(pinsUndefinedList, Telesis.this.sortFunction);
                pinsList.addAll(pinsUndefinedList);
                boolean bl = telesisCell = pinsList.size() > 0 || !packageInfo.isEmpty() || !classInfo.isEmpty();
            }
            if (cell == Telesis.this.topCell) {
                Telesis.this.topTelesisCell = telesisCell;
            }
            if (!telesisCell) {
                System.out.println("No Allegro information found in '" + cellName + "'. Skipping cell");
                return super.enterCell(info);
            }
            System.out.println("Writing Telesis format for Cell " + cellName);
            if (!Telesis.this.openTextOutputStream(fileName)) {
                Telesis.this.printWriter.println("(Device file for " + cellName + ")");
                Telesis.this.telesisParamsList.put(iconCell, pinsList);
                StringBuffer order = new StringBuffer("PINORDER '" + cellName + "' ");
                StringBuffer uses = new StringBuffer("PINUSE '" + cellName + "' ");
                StringBuffer ports = new StringBuffer("FUNCTION G1 '" + cellName + "' ");
                for (TelesisParam p : pinsList) {
                    if (p.ignorePin) continue;
                    order.append(p.getPorts());
                    uses.append(p.getOrder() + " ");
                    ports.append(p.getPorts());
                }
                Telesis.this.printWriter.println("PACKAGE '" + packageInfo + "'");
                Telesis.this.printWriter.println("CLASS " + classInfo);
                Telesis.this.printWriter.println("PINCOUNT " + totalNumberOfPins);
                Telesis.this.printWriter.println(Telesis.formatString(order));
                Telesis.this.printWriter.println(Telesis.formatString(uses));
                Telesis.this.printWriter.println(Telesis.formatString(ports));
                Telesis.this.printWriter.println("END");
                Telesis.this.closeTextOutputStream();
            }
            return super.enterCell(info);
        }
    }

    private static class TelesisParamSort
    implements Comparator<TelesisParam> {
        private TelesisParamSort() {
        }

        @Override
        public int compare(TelesisParam p1, TelesisParam p2) {
            return p1.rootName.compareTo(p2.rootName);
        }
    }

    private class TelesisParam {
        String rootName;
        List<String> ports;
        String order;
        int first;
        boolean ignorePin;

        TelesisParam(String name, List<String> ports, int first, String use, boolean ignorePin) {
            this.rootName = name;
            this.ports = ports;
            this.order = use;
            this.first = first;
            this.ignorePin = ignorePin;
        }

        String getPorts() {
            String output2 = "";
            if (this.first != -1) {
                Collections.sort(this.ports);
            }
            for (int i = 0; i < this.ports.size(); ++i) {
                String elem2 = this.ports.get(i);
                int index = elem2.indexOf("]");
                assert (index != -1);
                elem2 = elem2.substring(index + 1);
                output2 = output2 + elem2 + " ";
            }
            return output2;
        }

        String composePortName(String nodeName, String portName) {
            int index = portName.indexOf("'");
            assert (index != -1);
            portName = portName.substring(index);
            return "'" + nodeName + "'." + portName + " ";
        }

        String extractRealPortName(int number2, String nodeName, MutableInteger count2) {
            if (this.ignorePin) {
                return "";
            }
            if (number2 == -1 || this.ports.size() == 1) {
                String finalName = "";
                for (String s : this.ports) {
                    finalName = finalName + this.composePortName(nodeName, s);
                }
                count2.setValue(this.ports.size());
                return finalName;
            }
            if (this.ports.size() > 1 && number2 != -1) {
                String key = this.rootName + "[" + number2 + "]";
                for (String s : this.ports) {
                    if (!s.startsWith(key)) continue;
                    count2.setValue(1);
                    return this.composePortName(nodeName, s);
                }
            }
            assert (false);
            return "";
        }

        String getOrder() {
            String output2 = "";
            for (int i = 0; i < this.ports.size() - 1; ++i) {
                output2 = output2 + this.order + " ";
            }
            output2 = output2 + this.order;
            return output2;
        }
    }

    public static class TelesisPreferences
    extends Output.OutputPreferences {
        public TelesisPreferences(boolean factory) {
            super(factory);
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            if (cell.getView() != View.SCHEMATIC) {
                System.out.println("Can only write Telesis for schematics cells based on information found on icon cells");
                return null;
            }
            Telesis out = new Telesis(this);
            out.outputPath = filePath;
            out.topCell = cell;
            out.topTelesisCell = false;
            TelesisVisitor visitor = out.makeTelesisVisitor(Geometry.getMaxHierDepth(cell));
            if (!out.writeCell(cell, context, visitor)) {
                System.out.println(out.outputPath + " written");
                if (out.errorLogger.getNumErrors() != 0) {
                    System.out.println(out.errorLogger.getNumErrors() + " Telesis errors found");
                }
            }
            return out.finishWrite();
        }
    }
}

