/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.waveform;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.simulation.AnalogAnalysis;
import com.sun.electric.tool.simulation.AnalogSignal;
import com.sun.electric.tool.simulation.Analysis;
import com.sun.electric.tool.simulation.DigitalSignal;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.simulation.Waveform;
import com.sun.electric.tool.user.Highlight2;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.WaveformZoom;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.ZoomAndPanListener;
import com.sun.electric.tool.user.waveform.DragButton;
import com.sun.electric.tool.user.waveform.HorizRuler;
import com.sun.electric.tool.user.waveform.StepSize;
import com.sun.electric.tool.user.waveform.WaveSignal;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Panel
extends JPanel
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener {
    private static final boolean USE_VOLATILE_IMAGE = true;
    private static final boolean USE_ANTIALIASING = false;
    private WaveformWindow waveWindow;
    private Dimension sz;
    private boolean szValid;
    private Signal xAxisSignal;
    private LinkedHashMap<JButton, WaveSignal> waveSignals = new LinkedHashMap();
    private JPanel signalButtons;
    private JScrollPane signalButtonsPane;
    private JPanel leftHalf;
    private JPanel rightHalf;
    private JButton close;
    private JButton hide;
    private JButton deleteSignal;
    private JButton deleteAllSignals;
    private JButton digitalSignalButton;
    private JComboBox analysisCombo;
    private double minXPosition;
    private double maxXPosition;
    private double analogLowValue;
    private double analogHighValue;
    private double analogRange;
    private boolean draggingMain;
    private boolean draggingExt;
    private boolean draggingVertAxis;
    private boolean draggingArea;
    private List<Rectangle2D> measurementList;
    private Rectangle2D curMeasurement;
    private boolean selected;
    private boolean hidden;
    private Analysis.AnalysisType analysisType;
    private boolean analog;
    private HorizRuler horizRulerPanel;
    private boolean horizRulerPanelLogarithmic;
    private boolean vertPanelLogarithmic;
    private int panelNumber;
    private double dragStartXD;
    private double dragStartYD;
    private double dragEndXD;
    private double dragEndYD;
    private int vertAxisPos;
    private double smallestXValue;
    private double smallestYValue;
    private static Color background = null;
    private static Color gridColor = new Color(0x808080);
    private static int nextPanelNumber = 1;
    private static long lastClick = 0L;
    private static Panel curPanel;
    private static int curXPos;
    private static final BasicStroke farDottedLine;
    private static final int CONTROLPOINTSIZE = 6;
    private static final int VERTLABELWIDTH = 60;
    private static final ImageIcon iconHidePanel;
    private static final ImageIcon iconClosePanel;
    private static final ImageIcon iconDeleteSignal;
    private static final ImageIcon iconDeleteAllSignals;
    private static final Cursor dragXPositionCursor;
    private boolean needRepaintOffscreenImage;
    private Image offscreen;

    public Panel(WaveformWindow waveWindow, boolean analog, Analysis.AnalysisType analysisType) {
        this.waveWindow = waveWindow;
        this.setAnalysisType(analysisType);
        this.analog = analog;
        this.selected = false;
        this.panelNumber = nextPanelNumber++;
        this.vertAxisPos = 60;
        this.horizRulerPanelLogarithmic = false;
        this.vertPanelLogarithmic = false;
        this.xAxisSignal = null;
        this.measurementList = new ArrayList<Rectangle2D>();
        this.curMeasurement = null;
        int height = User.getWaveformDigitalPanelHeight();
        if (analog) {
            height = User.getWaveformAnalogPanelHeight();
        }
        this.sz = new Dimension(50, height);
        this.szValid = false;
        this.setSize(this.sz.width, this.sz.height);
        this.setPreferredSize(this.sz);
        this.setLayout(new FlowLayout());
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.setXAxisRange(waveWindow.getLowDefaultHorizontalRange(), waveWindow.getHighDefaultHorizontalRange());
        this.leftHalf = new WaveformWindow.OnePanel(this, waveWindow);
        this.leftHalf.setLayout(new GridBagLayout());
        this.leftHalf.setPreferredSize(new Dimension(100, height));
        new DropTarget(this.leftHalf, 0x40000000, WaveformWindow.waveformDropTarget, true);
        JSeparator sep = new JSeparator(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 5;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = new Insets(4, 0, 4, 0);
        this.leftHalf.add((Component)sep, gbc);
        if (analog) {
            DragLabel label = new DragLabel(Integer.toString(this.panelNumber));
            label.setToolTipText("Identification number of this waveform panel (drag the number to rearrange panels)");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 0.2;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.leftHalf.add((Component)label, gbc);
        } else {
            this.digitalSignalButton = new DragButton(Integer.toString(this.panelNumber), this.panelNumber);
            this.digitalSignalButton.setBorderPainted(false);
            this.digitalSignalButton.setForeground(Color.BLACK);
            this.digitalSignalButton.setToolTipText("Identification number of this waveform panel (drag the number to rearrange panels)");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 10;
            gbc.fill = 0;
            gbc.insets = new Insets(0, 4, 0, 4);
            this.leftHalf.add((Component)this.digitalSignalButton, gbc);
            this.digitalSignalButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Panel.this.digitalSignalNameClicked(evt);
                }
            });
        }
        this.close = new JButton(iconClosePanel);
        this.close.setBorderPainted(false);
        this.close.setDefaultCapable(false);
        this.close.setToolTipText("Close this waveform panel");
        Dimension minWid = new Dimension(iconClosePanel.getIconWidth() + 4, iconClosePanel.getIconHeight() + 4);
        this.close.setMinimumSize(minWid);
        this.close.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = analog ? 11 : 10;
        gbc.fill = 0;
        this.leftHalf.add((Component)this.close, gbc);
        this.close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Panel.this.closePanel();
            }
        });
        this.hide = new JButton(iconHidePanel);
        this.hide.setBorderPainted(false);
        this.hide.setDefaultCapable(false);
        this.hide.setToolTipText("Hide this waveform panel");
        minWid = new Dimension(iconHidePanel.getIconWidth() + 4, iconHidePanel.getIconHeight() + 4);
        this.hide.setMinimumSize(minWid);
        this.hide.setPreferredSize(minWid);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 0.2;
        gbc.weighty = 0.0;
        gbc.anchor = analog ? 11 : 10;
        gbc.fill = 0;
        this.leftHalf.add((Component)this.hide, gbc);
        this.hide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Panel.this.hidePanel();
            }
        });
        if (analog) {
            boolean hasMeasData;
            this.deleteSignal = new JButton(iconDeleteSignal);
            this.deleteSignal.setBorderPainted(false);
            this.deleteSignal.setDefaultCapable(false);
            this.deleteSignal.setToolTipText("Remove selected signals from this panel");
            minWid = new Dimension(iconDeleteSignal.getIconWidth() + 4, iconDeleteSignal.getIconHeight() + 4);
            this.deleteSignal.setMinimumSize(minWid);
            this.deleteSignal.setPreferredSize(minWid);
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 1;
            gbc.weightx = 0.2;
            gbc.weighty = 0.0;
            gbc.anchor = 11;
            gbc.fill = 0;
            this.leftHalf.add((Component)this.deleteSignal, gbc);
            this.deleteSignal.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Panel.this.deleteSignalFromPanel();
                }
            });
            this.deleteAllSignals = new JButton(iconDeleteAllSignals);
            this.deleteAllSignals.setBorderPainted(false);
            this.deleteAllSignals.setDefaultCapable(false);
            this.deleteAllSignals.setToolTipText("Remove all signals from this panel");
            minWid = new Dimension(iconDeleteAllSignals.getIconWidth() + 4, iconDeleteAllSignals.getIconHeight() + 4);
            this.deleteAllSignals.setMinimumSize(minWid);
            this.deleteAllSignals.setPreferredSize(minWid);
            gbc = new GridBagConstraints();
            gbc.gridx = 4;
            gbc.gridy = 1;
            gbc.weightx = 0.2;
            gbc.weighty = 0.0;
            gbc.anchor = 11;
            gbc.fill = 0;
            this.leftHalf.add((Component)this.deleteAllSignals, gbc);
            this.deleteAllSignals.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Panel.this.deleteAllSignalsFromPanel();
                }
            });
            boolean hasACData = waveWindow.getSimData().findAnalysis(Analysis.ANALYSIS_AC) != null;
            boolean hasDCData = waveWindow.getSimData().findAnalysis(Analysis.ANALYSIS_DC) != null;
            boolean bl = hasMeasData = waveWindow.getSimData().findAnalysis(Analysis.ANALYSIS_MEAS) != null;
            if (hasACData || hasDCData || hasMeasData) {
                this.analysisCombo = new JComboBox();
                this.analysisCombo.addItem(Analysis.ANALYSIS_TRANS.toString());
                if (hasACData) {
                    this.analysisCombo.addItem(Analysis.ANALYSIS_AC.toString());
                }
                if (hasDCData) {
                    this.analysisCombo.addItem(Analysis.ANALYSIS_DC.toString());
                }
                if (hasMeasData) {
                    this.analysisCombo.addItem(Analysis.ANALYSIS_MEAS.toString());
                }
                this.analysisCombo.setToolTipText("Sets the type of data seen in this panel");
                this.analysisCombo.setSelectedItem(analysisType.toString());
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 2;
                gbc.gridwidth = 5;
                gbc.gridheight = 1;
                gbc.anchor = 10;
                gbc.fill = 2;
                this.leftHalf.add((Component)this.analysisCombo, gbc);
                this.analysisCombo.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        Panel.this.setPanelSignalType();
                    }
                });
            }
            this.signalButtons = new JPanel();
            this.signalButtons.setLayout(new BoxLayout(this.signalButtons, 1));
            this.signalButtonsPane = new JScrollPane(this.signalButtons);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 5;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 10;
            gbc.fill = 1;
            this.leftHalf.add((Component)this.signalButtonsPane, gbc);
        }
        this.rightHalf = new JPanel();
        this.rightHalf.setLayout(new GridBagLayout());
        this.rightHalf.setPreferredSize(new Dimension(100, height));
        new DropTarget(this, 0x40000000, WaveformWindow.waveformDropTarget, true);
        sep = new JSeparator(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = new Insets(4, 0, 4, 0);
        this.rightHalf.add((Component)sep, gbc);
        if (!waveWindow.isXAxisLocked()) {
            this.addHorizRulerPanel();
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.rightHalf.add((Component)this, gbc);
        waveWindow.addPanel(this);
        waveWindow.getWaveformTable().repaint();
        waveWindow.getWaveformTable().doLayout();
        waveWindow.getWaveformTable().updateUI();
        waveWindow.rebuildPanelList();
        waveWindow.redrawAllPanels();
    }

    public WaveformWindow getWaveWindow() {
        return this.waveWindow;
    }

    public void finished() {
        this.removeKeyListener(this);
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeMouseWheelListener(this);
    }

    public JPanel getLeftHalf() {
        return this.leftHalf;
    }

    public JPanel getRightHalf() {
        return this.rightHalf;
    }

    private void makeLinear() {
        this.setPanelLogarithmicVertically(false);
    }

    private void makeLogarithmic() {
        this.setPanelLogarithmicVertically(true);
    }

    public void setPanelLogarithmicVertically(boolean logarithmic) {
        this.vertPanelLogarithmic = logarithmic;
        this.repaintContents();
    }

    public boolean isAnalog() {
        return this.analog;
    }

    public Analysis.AnalysisType getAnalysisType() {
        return this.analysisType;
    }

    public void setAnalysisType(Analysis.AnalysisType a) {
        this.analysisType = a;
        this.computeSmallestValues();
    }

    public boolean wrongPanelType(Signal sSig) {
        if (sSig.getAnalysis().getAnalysisType() == this.getAnalysisType()) {
            return false;
        }
        JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot drop a " + sSig.getAnalysis().getAnalysisType() + " signal onto a " + this.getAnalysisType() + " panel.  " + "First convert the panel with the popup in the upper-left.", "Error Displaying Signals", 0);
        return true;
    }

    public JPanel getSignalButtons() {
        return this.signalButtons;
    }

    public JScrollPane getSignalButtonsPane() {
        return this.signalButtonsPane;
    }

    public JButton getDigitalSignalButton() {
        return this.digitalSignalButton;
    }

    public int getPanelNumber() {
        return this.panelNumber;
    }

    public void setPanelLogarithmicHorizontally(boolean logarithmic) {
        this.horizRulerPanelLogarithmic = logarithmic;
        this.horizRulerPanel.repaint();
    }

    public boolean isPanelLogarithmicHorizontally() {
        if (this.waveWindow.isXAxisLocked()) {
            return this.waveWindow.isWaveWindowLogarithmic();
        }
        return this.horizRulerPanelLogarithmic;
    }

    public boolean isPanelLogarithmicVertically() {
        return this.vertPanelLogarithmic;
    }

    public int getVertAxisPos() {
        return this.vertAxisPos;
    }

    public void setVertAxisPos(int x) {
        this.vertAxisPos = x;
    }

    public static Panel getCurrentPanel() {
        return curPanel;
    }

    public static int getCurrentXPos() {
        return curXPos;
    }

    public void addSignal(WaveSignal sig, JButton but) {
        this.waveSignals.put(but, sig);
    }

    public void removeSignal(JButton but) {
        if (this.signalButtons != null) {
            this.signalButtons.remove(but);
        }
        this.waveSignals.remove(but);
    }

    public void removeAllSignals() {
        this.waveSignals.clear();
    }

    public List<WaveSignal> getSignals() {
        ArrayList<WaveSignal> signals = new ArrayList<WaveSignal>();
        for (JButton but : this.waveSignals.keySet()) {
            WaveSignal ws = this.waveSignals.get(but);
            signals.add(ws);
        }
        return signals;
    }

    public int getNumSignals() {
        return this.waveSignals.size();
    }

    public WaveSignal findWaveSignal(Signal sig) {
        for (JButton but : this.waveSignals.keySet()) {
            WaveSignal ws = this.waveSignals.get(but);
            if (ws.getSignal() != sig) continue;
            return ws;
        }
        return null;
    }

    public WaveSignal findWaveSignal(JButton but) {
        WaveSignal sig = this.waveSignals.get(but);
        return sig;
    }

    public JButton findButton(WaveSignal ws) {
        for (JButton but : this.waveSignals.keySet()) {
            WaveSignal oWs = this.waveSignals.get(but);
            if (oWs != ws) continue;
            return but;
        }
        return null;
    }

    private void deleteSignalFromPanel() {
        this.waveWindow.deleteSignalFromPanel(this);
    }

    private void deleteAllSignalsFromPanel() {
        this.waveWindow.deleteAllSignalsFromPanel(this);
    }

    private void setPanelSignalType() {
        String typeName = (String)this.analysisCombo.getSelectedItem();
        Analysis.AnalysisType analysisType = Analysis.AnalysisType.findAnalysisType(typeName);
        if (this.getAnalysisType() != analysisType && this.getNumSignals() > 0) {
            String warning = "The signals in this panel are not " + analysisType + " data.  Remove them from the panel?";
            int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), warning);
            if (response != 0) {
                this.analysisCombo.setSelectedItem(this.getAnalysisType().toString());
                return;
            }
            this.xAxisSignal = null;
            if (this.waveWindow.isXAxisLocked()) {
                this.waveWindow.setXAxisSignalAll(null);
            }
            this.waveWindow.deleteAllSignalsFromPanel(this);
        }
        this.setAnalysisType(analysisType);
        Analysis an = this.waveWindow.getSimData().findAnalysis(analysisType);
        if (an != null) {
            Rectangle2D bounds = an.getBounds();
            double lowValue = bounds.getMinY();
            double highValue = bounds.getMaxY();
            this.setYAxisRange(lowValue, highValue);
            if (!this.waveWindow.isXAxisLocked() || this.waveWindow.getNumPanels() == 1) {
                this.setXAxisRange(an.getLeftEdge(), an.getRightEdge());
            }
        }
        this.repaintWithRulers();
    }

    public void addHorizRulerPanel() {
        this.horizRulerPanel = new HorizRuler(this, this.waveWindow);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.rightHalf.add((Component)this.horizRulerPanel, gbc);
    }

    public void removeHorizRulerPanel() {
        this.rightHalf.remove(this.horizRulerPanel);
        this.horizRulerPanel = null;
    }

    public HorizRuler getHorizRuler() {
        return this.horizRulerPanel;
    }

    public Signal getXAxisSignal() {
        return this.xAxisSignal;
    }

    public void setXAxisSignal(Signal sig) {
        this.xAxisSignal = sig;
    }

    public void hidePanel() {
        this.waveWindow.hidePanel(this);
    }

    public void closePanel() {
        this.waveWindow.closePanel(this);
        this.waveWindow.saveSignalOrder();
    }

    private void toggleBusContents() {
        DigitalSignal subDS;
        Collection<WaveSignal> theSignals = this.waveSignals.values();
        if (theSignals.size() != 1) {
            return;
        }
        WaveSignal ws = theSignals.iterator().next();
        if (!(ws.getSignal() instanceof DigitalSignal)) {
            return;
        }
        DigitalSignal sDSig = (DigitalSignal)ws.getSignal();
        List<DigitalSignal> bussedSignals = sDSig.getBussedSignals();
        if (bussedSignals == null) {
            return;
        }
        boolean opened = false;
        for (DigitalSignal subSig : bussedSignals) {
            DigitalSignal subDS2 = subSig;
            WaveSignal subWs = this.waveWindow.findDisplayedSignal(subDS2);
            if (subWs == null) continue;
            opened = true;
            break;
        }
        if (opened) {
            ArrayList<Panel> allPanels = new ArrayList<Panel>();
            Iterator<Panel> it = this.waveWindow.getPanels();
            while (it.hasNext()) {
                allPanels.add(it.next());
            }
            for (DigitalSignal subSig : bussedSignals) {
                subDS = subSig;
                WaveSignal subWs = this.waveWindow.findDisplayedSignal(subDS);
                if (subWs == null) continue;
                Panel wp = subWs.getPanel();
                this.waveWindow.closePanel(wp);
                allPanels.remove(wp);
            }
        } else {
            int increment = 1;
            this.waveWindow.stopEditing();
            Iterator<DigitalSignal> i$ = bussedSignals.iterator();
            while (i$.hasNext()) {
                DigitalSignal subSig;
                subDS = subSig = i$.next();
                Panel wp = this.waveWindow.makeNewPanel(null);
                WaveSignal wsig = new WaveSignal(wp, subDS);
                this.waveWindow.removePanel(wsig.getPanel());
                int destIndex = this.waveWindow.getPanelIndex(this);
                this.waveWindow.addPanel(wsig.getPanel(), destIndex + increment);
                ++increment;
            }
            this.waveWindow.reloadTable();
        }
        this.waveWindow.validatePanel();
        this.waveWindow.saveSignalOrder();
    }

    private void computeSmallestValues() {
        if (this.analysisType == null) {
            return;
        }
        Stimuli sd = this.waveWindow.getSimData();
        Analysis an = sd.findAnalysis(this.analysisType);
        if (an == null) {
            return;
        }
        Rectangle2D anBounds = an.getBounds();
        if (anBounds == null) {
            return;
        }
        this.smallestXValue = anBounds.getMinX();
        this.smallestYValue = anBounds.getMinY();
    }

    public void setXAxisRange(double leftEdge, double rightEdge) {
        this.minXPosition = leftEdge;
        this.maxXPosition = rightEdge;
    }

    public double getMinXAxis() {
        return this.minXPosition;
    }

    public double getMaxXAxis() {
        return this.maxXPosition;
    }

    public void fitToSignal(Signal sSig) {
        if (sSig instanceof AnalogSignal) {
            AnalogSignal as = (AnalogSignal)sSig;
            Rectangle2D rangeBounds = as.getBounds();
            double lowValue = rangeBounds.getMinY();
            double highValue = rangeBounds.getMaxY();
            double range = highValue - lowValue;
            if (range == 0.0) {
                range = 2.0;
            }
            double rangeExtra = range / 10.0;
            this.setYAxisRange(lowValue - rangeExtra, highValue + rangeExtra);
        }
    }

    public void setYAxisRange(double low, double high) {
        if (low == high) {
            low -= 0.5;
            high += 0.5;
        }
        this.analogLowValue = low;
        this.analogHighValue = high;
        this.analogRange = this.analogHighValue - this.analogLowValue;
    }

    public double getYAxisRange() {
        return this.analogRange;
    }

    public double getYAxisLowValue() {
        return this.analogLowValue;
    }

    public double getYAxisHighValue() {
        return this.analogHighValue;
    }

    public int convertXDataToScreen(double value) {
        boolean log = this.waveWindow.isWaveWindowLogarithmic();
        if (!this.waveWindow.isXAxisLocked()) {
            log = this.horizRulerPanelLogarithmic;
        }
        if (log) {
            if (value <= this.smallestXValue) {
                value = this.smallestXValue;
            }
            double logValue = Math.log10(value);
            double winMinX = this.minXPosition;
            if (winMinX <= 0.0) {
                winMinX = this.smallestXValue;
            }
            double logWinMinX = Math.log10(winMinX);
            double winMaxX = this.maxXPosition;
            if (winMaxX <= 0.0) {
                winMaxX = this.smallestXValue;
            }
            double logWinMaxX = Math.log10(winMaxX);
            double x = (logValue - logWinMinX) / (logWinMaxX - logWinMinX) * (double)(this.sz.width - this.vertAxisPos) + (double)this.vertAxisPos;
            return (int)x;
        }
        double x = (value - this.minXPosition) / (this.maxXPosition - this.minXPosition) * (double)(this.sz.width - this.vertAxisPos) + (double)this.vertAxisPos;
        return (int)x;
    }

    public double convertXScreenToData(int x) {
        boolean log = this.waveWindow.isWaveWindowLogarithmic();
        if (!this.waveWindow.isXAxisLocked()) {
            log = this.horizRulerPanelLogarithmic;
        }
        if (log) {
            double winMinX = this.minXPosition;
            if (winMinX <= 0.0) {
                winMinX = this.smallestXValue;
            }
            double logWinMinX = Math.log10(winMinX);
            double winMaxX = this.maxXPosition;
            if (winMaxX <= 0.0) {
                winMaxX = this.smallestXValue;
            }
            double logWinMaxX = Math.log10(winMaxX);
            double xValue = Math.pow(10.0, (double)(x - this.vertAxisPos) / (double)(this.sz.width - this.vertAxisPos) * (logWinMaxX - logWinMinX) + logWinMinX);
            return xValue;
        }
        double xValue = (double)(x - this.vertAxisPos) / (double)(this.sz.width - this.vertAxisPos) * (this.maxXPosition - this.minXPosition) + this.minXPosition;
        return xValue;
    }

    private int convertYDataToScreen(double value) {
        if (this.vertPanelLogarithmic) {
            if (value <= this.smallestYValue) {
                value = this.smallestYValue;
            }
            double logValue = Math.log10(value);
            double winMinY = this.analogLowValue;
            if (winMinY <= 0.0) {
                winMinY = this.smallestYValue;
            }
            double logWinMinY = Math.log10(winMinY);
            double winMaxY = this.analogHighValue;
            if (winMaxY <= 0.0) {
                winMaxY = this.smallestYValue;
            }
            double logWinMaxY = Math.log10(winMaxY);
            double y = (double)(this.sz.height - 1) - (logValue - logWinMinY) / (logWinMaxY - logWinMinY) * (double)(this.sz.height - 1);
            return (int)y;
        }
        double y = (double)(this.sz.height - 1) - (value - this.analogLowValue) / this.analogRange * (double)(this.sz.height - 1);
        return (int)y;
    }

    private double convertYScreenToData(int y) {
        if (this.vertPanelLogarithmic) {
            double winMinY = this.analogLowValue;
            if (winMinY <= 0.0) {
                winMinY = this.smallestYValue;
            }
            double logWinMinY = Math.log10(winMinY);
            double winMaxY = this.analogHighValue;
            if (winMaxY <= 0.0) {
                winMaxY = this.smallestYValue;
            }
            double logWinMaxY = Math.log10(winMaxY);
            double yValue = Math.pow(10.0, logWinMinY - (double)(y - this.sz.height + 1) * (logWinMaxY - logWinMinY) / (double)(this.sz.height - 1));
            return yValue;
        }
        double value = 0.0;
        if (this.sz.height > 1) {
            value = this.analogLowValue - (double)(y - this.sz.height + 1) * this.analogRange / (double)(this.sz.height - 1);
        }
        return value;
    }

    public void repaintWithRulers() {
        if (this.horizRulerPanel != null) {
            this.horizRulerPanel.repaint();
        } else {
            this.waveWindow.getMainHorizRuler().repaint();
        }
        this.repaintContents();
    }

    public void repaintContents() {
        this.needRepaintOffscreenImage = true;
        this.waveWindow.getWaveformTable().repaint();
    }

    @Override
    public void paint(Graphics g) {
        this.sz = this.getSize();
        this.szValid = true;
        int wid = this.sz.width;
        int hei = this.sz.height;
        VolatileImage offscreen = (VolatileImage)this.offscreen;
        do {
            int returnCode = 2;
            if (offscreen != null && offscreen.getWidth() == wid && offscreen.getHeight() == hei) {
                returnCode = offscreen.validate(this.getGraphicsConfiguration());
            }
            if (returnCode == 2) {
                if (offscreen != null) {
                    offscreen.flush();
                }
                offscreen = this.createVolatileImage(wid, hei);
                this.offscreen = offscreen;
                this.needRepaintOffscreenImage = true;
            }
            if (returnCode != 0 || this.needRepaintOffscreenImage) {
                this.repaintOffscreenImage(wid, hei);
            }
            if (offscreen.contentsLost()) continue;
            g.drawImage(offscreen, 0, 0, null);
        } while (offscreen.contentsLost());
        Dimension tableSz = this.waveWindow.getWaveformTable().getSize();
        Point screenLoc = this.waveWindow.getWaveformTable().getLocationOnScreen();
        this.waveWindow.setScreenXSize(screenLoc.x + tableSz.width - wid, screenLoc.x + tableSz.width);
        this.paintDragging((Graphics2D)g, wid, hei);
    }

    private void repaintOffscreenImage(int wid, int hei) {
        this.needRepaintOffscreenImage = false;
        Graphics2D offscreenGraphics = (Graphics2D)this.offscreen.getGraphics();
        offscreenGraphics.setColor(new Color(User.getColor(User.ColorPrefType.WAVE_BACKGROUND)));
        offscreenGraphics.fillRect(0, 0, wid, hei);
        this.drawPanelContents(wid, hei, offscreenGraphics, null, null);
        offscreenGraphics.dispose();
    }

    private void paintDragging(Graphics2D g, int wid, int hei) {
        g.setColor(new Color(User.getColor(User.ColorPrefType.WAVE_FOREGROUND)));
        g.setStroke(Highlight2.dashedLine);
        int x = this.convertXDataToScreen(this.waveWindow.getMainXPositionCursor());
        if (x >= this.vertAxisPos) {
            g.drawLine(x, 0, x, hei);
        }
        g.setStroke(farDottedLine);
        x = this.convertXDataToScreen(this.waveWindow.getExtensionXPositionCursor());
        if (x >= this.vertAxisPos) {
            g.drawLine(x, 0, x, hei);
        }
        g.setStroke(Highlight2.solidLine);
        if (this.draggingArea) {
            int lowX = Math.min(this.convertXDataToScreen(this.dragStartXD), this.convertXDataToScreen(this.dragEndXD));
            int highX = Math.max(this.convertXDataToScreen(this.dragStartXD), this.convertXDataToScreen(this.dragEndXD));
            int lowY = Math.min(this.convertYDataToScreen(this.dragStartYD), this.convertYDataToScreen(this.dragEndYD));
            int highY = Math.max(this.convertYDataToScreen(this.dragStartYD), this.convertYDataToScreen(this.dragEndYD));
            g.drawLine(lowX, lowY, lowX, highY);
            g.drawLine(lowX, highY, highX, highY);
            g.drawLine(highX, highY, highX, lowY);
            g.drawLine(highX, lowY, lowX, lowY);
        }
        for (Rectangle2D meas : this.measurementList) {
            int xPos;
            int yPos;
            int yPosText;
            int lowX = Math.min(this.convertXDataToScreen(meas.getMinX()), this.convertXDataToScreen(meas.getMaxX()));
            int highX = Math.max(this.convertXDataToScreen(meas.getMinX()), this.convertXDataToScreen(meas.getMaxX()));
            int lowY = Math.min(this.convertYDataToScreen(meas.getMinY()), this.convertYDataToScreen(meas.getMaxY()));
            int highY = Math.max(this.convertYDataToScreen(meas.getMinY()), this.convertYDataToScreen(meas.getMaxY()));
            g.drawLine(lowX, lowY, lowX, highY);
            g.drawLine(lowX, highY, highX, highY);
            g.drawLine(highX, highY, highX, lowY);
            g.drawLine(highX, lowY, lowX, lowY);
            double lowXValue = this.convertXScreenToData(lowX);
            double highXValue = this.convertXScreenToData(highX);
            double lowValue = this.convertYScreenToData(highY);
            double highValue = this.convertYScreenToData(lowY);
            g.setFont(this.waveWindow.getFont());
            String lowXValueString = TextUtils.convertToEngineeringNotation(lowXValue, "s");
            GlyphVector gv = this.waveWindow.getFont().createGlyphVector(this.waveWindow.getFontRenderContext(), lowXValueString);
            Rectangle2D glyphBounds = gv.getLogicalBounds();
            int textWid = (int)glyphBounds.getWidth();
            int textHei = (int)glyphBounds.getHeight();
            int textY = (lowY + highY) / 2;
            g.drawString(lowXValueString, lowX - textWid - 6, textY + textHei / 2 - 10);
            g.drawLine(lowX - 1, textY, lowX - textWid, textY);
            g.drawLine(lowX - 1, textY, lowX - 6, textY + 4);
            g.drawLine(lowX - 1, textY, lowX - 6, textY - 4);
            String highXValueString = TextUtils.convertToEngineeringNotation(highXValue, "s");
            gv = this.waveWindow.getFont().createGlyphVector(this.waveWindow.getFontRenderContext(), highXValueString);
            glyphBounds = gv.getLogicalBounds();
            textWid = (int)glyphBounds.getWidth();
            textHei = (int)glyphBounds.getHeight();
            int highXValueTextWid = textWid;
            g.drawString(highXValueString, highX + 6, textY + textHei / 2 - 10);
            g.drawLine(highX + 1, textY, highX + textWid, textY);
            g.drawLine(highX + 1, textY, highX + 6, textY + 4);
            g.drawLine(highX + 1, textY, highX + 6, textY - 4);
            String xDiffString = TextUtils.convertToEngineeringNotation(highXValue - lowXValue, "s");
            gv = this.waveWindow.getFont().createGlyphVector(this.waveWindow.getFontRenderContext(), xDiffString);
            glyphBounds = gv.getLogicalBounds();
            textWid = (int)glyphBounds.getWidth();
            textHei = (int)glyphBounds.getHeight();
            if (textWid + 24 < highX - lowX) {
                yPosText = highY + textHei * 5;
                yPos = yPosText - textHei / 2;
                int xCtr = (highX + lowX) / 2;
                g.drawString(xDiffString, xCtr - textWid / 2, yPosText);
                g.drawLine(lowX, yPos, xCtr - textWid / 2 - 2, yPos);
                g.drawLine(highX, yPos, xCtr + textWid / 2 + 2, yPos);
                g.drawLine(lowX, yPos, lowX + 5, yPos + 4);
                g.drawLine(lowX, yPos, lowX + 5, yPos - 4);
                g.drawLine(highX, yPos, highX - 5, yPos + 4);
                g.drawLine(highX, yPos, highX - 5, yPos - 4);
            } else {
                yPosText = highY + textHei * 5;
                yPos = yPosText - textHei / 2;
                g.drawString(xDiffString, highX + 12, yPosText);
                g.drawLine(lowX, yPos, lowX - 10, yPos);
                g.drawLine(highX, yPos, highX + 10, yPos);
                g.drawLine(lowX, yPos, lowX - 5, yPos + 4);
                g.drawLine(lowX, yPos, lowX - 5, yPos - 4);
                g.drawLine(highX, yPos, highX + 5, yPos + 4);
                g.drawLine(highX, yPos, highX + 5, yPos - 4);
            }
            if (!this.analog) continue;
            String lowValueString = TextUtils.convertToEngineeringNotation(highValue, null);
            gv = this.waveWindow.getFont().createGlyphVector(this.waveWindow.getFontRenderContext(), lowValueString);
            glyphBounds = gv.getLogicalBounds();
            textWid = (int)glyphBounds.getWidth();
            textHei = (int)glyphBounds.getHeight();
            int xP = (lowX + highX) / 2;
            int yText = lowY - 10 - textHei;
            g.drawString(lowValueString, xP, yText - 2);
            g.drawLine(xP, lowY - 1, xP, yText);
            g.drawLine(xP, lowY - 1, xP + 4, lowY - 5);
            g.drawLine(xP, lowY - 1, xP - 4, lowY - 5);
            String highValueString = TextUtils.convertToEngineeringNotation(lowValue, null);
            gv = this.waveWindow.getFont().createGlyphVector(this.waveWindow.getFontRenderContext(), highValueString);
            glyphBounds = gv.getLogicalBounds();
            textWid = (int)glyphBounds.getWidth();
            textHei = (int)glyphBounds.getHeight();
            yText = highY + 10 + textHei;
            g.drawString(highValueString, xP, yText + textHei + 2);
            g.drawLine(xP, highY + 1, xP, yText);
            g.drawLine(xP, highY + 1, xP + 4, highY + 5);
            g.drawLine(xP, highY + 1, xP - 4, highY + 5);
            String valueDiffString = TextUtils.convertToEngineeringNotation(highValue - lowValue, null);
            gv = this.waveWindow.getFont().createGlyphVector(this.waveWindow.getFontRenderContext(), valueDiffString);
            glyphBounds = gv.getLogicalBounds();
            textWid = (int)glyphBounds.getWidth();
            textHei = (int)glyphBounds.getHeight();
            if (textHei + 12 < highY - lowY) {
                xPos = highX + highXValueTextWid + 30;
                int yCtr = (highY + lowY) / 2;
                g.drawString(valueDiffString, xPos + 2, yCtr + textHei / 2);
                g.drawLine(xPos, lowY, xPos, highY);
                g.drawLine(xPos, lowY, xPos + 4, lowY + 5);
                g.drawLine(xPos, lowY, xPos - 4, lowY + 5);
                g.drawLine(xPos, highY, xPos + 4, highY - 5);
                g.drawLine(xPos, highY, xPos - 4, highY - 5);
                continue;
            }
            xPos = highX + highXValueTextWid + 30;
            g.drawString(valueDiffString, xPos + 4, lowY - textHei / 2 - 4);
            g.drawLine(xPos, lowY, xPos, lowY - 10);
            g.drawLine(xPos, highY, xPos, highY + 10);
            g.drawLine(xPos, lowY, xPos + 4, lowY - 5);
            g.drawLine(xPos, lowY, xPos - 4, lowY - 5);
            g.drawLine(xPos, highY, xPos + 4, highY + 5);
            g.drawLine(xPos, highY, xPos - 4, highY + 5);
        }
    }

    private void drawPanelContents(int wid, int hei, Graphics2D localGraphics, Rectangle2D bounds, List<PolyBase> polys) {
        double value;
        StepSize ss;
        if (this.analog && this.waveWindow.isShowGrid()) {
            if (localGraphics != null) {
                localGraphics.setStroke(Highlight2.dottedLine);
                localGraphics.setColor(gridColor);
            }
            double displayedXLow = this.convertXScreenToData(this.vertAxisPos);
            double displayedXHigh = this.convertXScreenToData(wid);
            ss = new StepSize(displayedXHigh, displayedXLow, 10);
            if (ss.getSeparation() != 0.0) {
                value = ss.getLowValue();
                while (true) {
                    if (value >= displayedXLow) {
                        if (value > ss.getHighValue()) break;
                        int x = this.convertXDataToScreen(value);
                        if (polys != null) {
                            polys.add(new Poly(new Point2D[]{new Point2D.Double(x, 0.0), new Point2D.Double(x, hei)}));
                        } else {
                            localGraphics.drawLine(x, 0, x, hei);
                        }
                    }
                    value += ss.getSeparation();
                }
            }
            if ((ss = new StepSize(this.analogHighValue, this.analogLowValue, 5)).getSeparation() != 0.0) {
                value = ss.getLowValue();
                while (true) {
                    if (value >= this.analogLowValue) {
                        if (value > this.analogHighValue || value > ss.getHighValue()) break;
                        int y = this.convertYDataToScreen(value);
                        if (polys != null) {
                            polys.add(new Poly(new Point2D[]{new Point2D.Double(this.vertAxisPos, y), new Point2D.Double(wid, y)}));
                        } else {
                            localGraphics.drawLine(this.vertAxisPos, y, wid, y);
                        }
                    }
                    value += ss.getSeparation();
                }
            }
            if (localGraphics != null) {
                localGraphics.setStroke(Highlight2.solidLine);
            }
        }
        this.processSignals(localGraphics, bounds, polys);
        if (localGraphics != null) {
            this.processControlPoints(localGraphics, bounds);
        }
        if (polys != null) {
            polys.add(new Poly(new Point2D[]{new Point2D.Double(this.vertAxisPos, 0.0), new Point2D.Double(this.vertAxisPos, hei)}));
        } else {
            localGraphics.setColor(new Color(User.getColor(User.ColorPrefType.WAVE_FOREGROUND)));
            localGraphics.drawLine(this.vertAxisPos, 0, this.vertAxisPos, hei);
            if (this.selected) {
                localGraphics.drawLine(this.vertAxisPos - 1, 0, this.vertAxisPos - 1, hei);
                localGraphics.drawLine(this.vertAxisPos - 2, 0, this.vertAxisPos - 2, hei - 1);
                localGraphics.drawLine(this.vertAxisPos - 3, 0, this.vertAxisPos - 3, hei - 2);
            }
        }
        if (this.analog) {
            double displayedLow = this.convertYScreenToData(hei);
            double displayedHigh = this.convertYScreenToData(0);
            ss = new StepSize(displayedHigh, displayedLow, 5);
            if (ss.getSeparation() != 0.0) {
                value = ss.getLowValue();
                if (localGraphics != null) {
                    localGraphics.setFont(this.waveWindow.getFont());
                }
                int lastY = -1;
                int i = 0;
                while (!(value > displayedHigh)) {
                    if (value >= displayedLow) {
                        int y = this.convertYDataToScreen(value);
                        if (lastY >= 0) {
                            if (lastY - y > 100) {
                                for (int j = 1; j < 5; ++j) {
                                    int intY = (lastY - y) / 5 * j + y;
                                    if (polys != null) {
                                        polys.add(new Poly(new Point2D[]{new Point2D.Double(this.vertAxisPos - 5, intY), new Point2D.Double(this.vertAxisPos, intY)}));
                                        continue;
                                    }
                                    localGraphics.drawLine(this.vertAxisPos - 5, intY, this.vertAxisPos, intY);
                                }
                            } else if (lastY - y > 25) {
                                int intY = (lastY - y) / 2 + y;
                                if (polys != null) {
                                    polys.add(new Poly(new Point2D[]{new Point2D.Double(this.vertAxisPos - 5, intY), new Point2D.Double(this.vertAxisPos, intY)}));
                                } else {
                                    localGraphics.drawLine(this.vertAxisPos - 5, intY, this.vertAxisPos, intY);
                                }
                            }
                        }
                        if (polys != null) {
                            polys.add(new Poly(new Point2D[]{new Point2D.Double(this.vertAxisPos - 10, y), new Point2D.Double(this.vertAxisPos, y)}));
                        } else {
                            localGraphics.drawLine(this.vertAxisPos - 10, y, this.vertAxisPos, y);
                        }
                        String yValue = TextUtils.convertToEngineeringNotation(value, null);
                        if (polys != null) {
                            Poly poly = new Poly(new Point2D[]{new Point2D.Double(this.vertAxisPos - 12, y)});
                            poly.setStyle(Poly.Type.TEXTRIGHT);
                            poly.setTextDescriptor(TextDescriptor.EMPTY.withAbsSize(6));
                            poly.setString(yValue);
                            polys.add(poly);
                        } else {
                            int xPos;
                            GlyphVector gv = this.waveWindow.getFont().createGlyphVector(this.waveWindow.getFontRenderContext(), yValue);
                            Rectangle2D glyphBounds = gv.getLogicalBounds();
                            int height = (int)glyphBounds.getHeight();
                            int yPos = y + height / 2;
                            if (yPos - height <= 0) {
                                yPos = height + 1;
                            }
                            if (yPos >= hei) {
                                yPos = hei;
                            }
                            if ((xPos = this.vertAxisPos - 10 - (int)glyphBounds.getWidth() - 2) < 0) {
                                xPos = 0;
                            }
                            localGraphics.drawString(yValue, xPos, yPos);
                        }
                        lastY = y;
                    }
                    value += ss.getSeparation();
                    ++i;
                }
            }
        }
    }

    private List<WaveSelection> processSignals(Graphics g, Rectangle2D bounds, List<PolyBase> forPs) {
        ArrayList<WaveSelection> selectedObjects = null;
        if (bounds != null) {
            selectedObjects = new ArrayList<WaveSelection>();
        }
        int hei = this.sz.height;
        Signal xSignal = this.xAxisSignal;
        if (this.waveWindow.isXAxisLocked()) {
            xSignal = this.waveWindow.getXAxisSignalAll();
        }
        double[] result = new double[3];
        int linePointMode = this.waveWindow.getLinePointMode();
        Collection<WaveSignal> sigs = this.waveSignals.values();
        int sigIndex = 0;
        for (WaveSignal ws : sigs) {
            int x;
            int lastX;
            Analysis an;
            if (g != null) {
                if (this.waveWindow.getPrintingMode() == 2) {
                    g.setColor(Color.BLACK);
                } else {
                    g.setColor(ws.getColor());
                }
            }
            if (forPs != null) {
                double yPos = hei / 2;
                Poly.Type style = Poly.Type.TEXTRIGHT;
                if (sigs.size() > 1) {
                    if (sigIndex == sigs.size() - 1) {
                        style = Poly.Type.TEXTBOTRIGHT;
                    } else if (sigIndex == 0) {
                        style = Poly.Type.TEXTTOPRIGHT;
                    }
                    yPos = (double)(hei * sigIndex) / (double)(sigs.size() - 1);
                }
                Poly poly = new Poly(new Point2D[]{new Point2D.Double(0.0, yPos)});
                poly.setStyle(style);
                poly.setTextDescriptor(TextDescriptor.EMPTY.withAbsSize(12));
                poly.setString(ws.getSignal().getFullName());
                forPs.add(poly);
            }
            ++sigIndex;
            if (ws.getSignal() instanceof AnalogSignal) {
                AnalogSignal as = (AnalogSignal)ws.getSignal();
                an = as.getAnalysis();
                int numSweeps = as.getNumSweeps();
                block18: for (int s = 0; s < numSweeps; ++s) {
                    boolean included = this.waveWindow.isSweepSignalIncluded((AnalogAnalysis)an, s);
                    if (!included) continue;
                    Waveform waveform = as.getWaveform(s);
                    Waveform xWaveform = null;
                    if (xSignal != null) {
                        xWaveform = ((AnalogSignal)xSignal).getWaveform(s);
                    }
                    lastX = 0;
                    int lastLY = 0;
                    int lastHY = 0;
                    int numEvents = waveform.getNumEvents();
                    for (int i = 0; i < numEvents; ++i) {
                        waveform.getEvent(i, result);
                        x = this.convertXDataToScreen(result[0]);
                        int lowY = this.convertYDataToScreen(result[1]);
                        int highY = this.convertYDataToScreen(result[2]);
                        if (xWaveform != null) {
                            xWaveform.getEvent(i, result);
                            x = this.convertXDataToScreen(result[1]);
                        }
                        if ((x >= this.vertAxisPos && x <= this.sz.width || lastX > this.vertAxisPos && lastX < this.sz.width) && (i != 0 && linePointMode <= 1 && (this.processALine(g, lastX, lastLY, x, lowY, bounds, forPs, selectedObjects, ws, s) || (lastLY != lastHY || lowY != highY) && (this.processALine(g, lastX, lastHY, x, highY, bounds, forPs, selectedObjects, ws, s) || this.processALine(g, lastX, lastHY, x, lowY, bounds, forPs, selectedObjects, ws, s) || this.processALine(g, lastX, lastLY, x, highY, bounds, forPs, selectedObjects, ws, s))) || an.extrapolateValues() && i == numEvents - 1 && linePointMode <= 1 && this.getMinXAxis() < this.getMaxXAxis() && (this.processALine(g, x, lowY, this.sz.width, lowY, bounds, forPs, selectedObjects, ws, s) || (lastLY != lastHY || lowY != highY) && this.processALine(g, x, highY, this.sz.width, highY, bounds, forPs, selectedObjects, ws, s)) || linePointMode >= 1 && this.processABox(g, x - 2, lowY - 2, x + 2, lowY + 2, bounds, forPs, selectedObjects, ws, false, 0.0))) continue block18;
                        lastX = x;
                        lastLY = lowY;
                        lastHY = highY;
                    }
                }
                continue;
            }
            if (!(ws.getSignal() instanceof DigitalSignal)) continue;
            DigitalSignal ds = (DigitalSignal)ws.getSignal();
            an = ds.getAnalysis();
            List<DigitalSignal> bussedSignals = ds.getBussedSignals();
            if (bussedSignals != null) {
                int wid;
                double nextXValue;
                long curYValue = 0L;
                double curXValue = 0.0;
                lastX = this.vertAxisPos;
                do {
                    nextXValue = Double.MAX_VALUE;
                    int bit = 0;
                    boolean curDefined = true;
                    Iterator<DigitalSignal> i$ = bussedSignals.iterator();
                    while (i$.hasNext()) {
                        DigitalSignal subSig;
                        DigitalSignal subDS = subSig = i$.next();
                        int numEvents = subDS.getNumEvents();
                        boolean undefined = false;
                        for (int i = 0; i < numEvents; ++i) {
                            double xValue = subDS.getTime(i);
                            if (xValue <= curXValue) {
                                switch (subDS.getState(i) & 3) {
                                    case 0: {
                                        curYValue &= (long)(~(1 << bit));
                                        undefined = false;
                                        break;
                                    }
                                    case 2: {
                                        curYValue |= (long)(1 << bit);
                                        undefined = false;
                                        break;
                                    }
                                    case 1: 
                                    case 3: {
                                        undefined = true;
                                    }
                                }
                                continue;
                            }
                            if (!(xValue < nextXValue)) break;
                            nextXValue = xValue;
                            break;
                        }
                        if (undefined) {
                            curDefined = false;
                            break;
                        }
                        ++bit;
                    }
                    if ((x = this.convertXDataToScreen(curXValue)) >= this.vertAxisPos) {
                        if (x < this.vertAxisPos + 5) {
                            if (this.processALine(g, x, hei / 2, x + 5, hei - 5, bounds, forPs, selectedObjects, ws, -1)) {
                                return selectedObjects;
                            }
                            if (this.processALine(g, x, hei / 2, x + 5, 5, bounds, forPs, selectedObjects, ws, -1)) {
                                return selectedObjects;
                            }
                        } else {
                            if (this.processALine(g, x - 5, 5, x + 5, hei - 5, bounds, forPs, selectedObjects, ws, -1)) {
                                return selectedObjects;
                            }
                            if (this.processALine(g, x + 5, 5, x - 5, hei - 5, bounds, forPs, selectedObjects, ws, -1)) {
                                return selectedObjects;
                            }
                        }
                        if (lastX + 5 < x - 5) {
                            if (this.processALine(g, lastX + 5, 5, x - 5, 5, bounds, forPs, selectedObjects, ws, -1)) {
                                return selectedObjects;
                            }
                            if (this.processALine(g, lastX + 5, hei - 5, x - 5, hei - 5, bounds, forPs, selectedObjects, ws, -1)) {
                                return selectedObjects;
                            }
                        }
                        String valString = "XX";
                        if (curDefined) {
                            valString = Long.toString(curYValue);
                        }
                        if (g != null) {
                            g.setFont(this.waveWindow.getFont());
                            GlyphVector gv = this.waveWindow.getFont().createGlyphVector(this.waveWindow.getFontRenderContext(), valString);
                            Rectangle2D glyphBounds = gv.getLogicalBounds();
                            int textHei = (int)glyphBounds.getHeight();
                            g.drawString(valString, x + 2, hei / 2 + textHei / 2);
                        }
                        if (forPs != null) {
                            Point2D[] pts = new Point2D[]{new Point2D.Double(x + 2, hei / 2)};
                            Poly poly = new Poly(pts);
                            poly.setStyle(Poly.Type.TEXTLEFT);
                            poly.setTextDescriptor(TextDescriptor.EMPTY.withAbsSize(8));
                            poly.setString(valString);
                            forPs.add(poly);
                        }
                    }
                    curXValue = nextXValue;
                    lastX = x;
                } while (nextXValue != Double.MAX_VALUE);
                if (!an.extrapolateValues() || lastX + 5 >= (wid = this.sz.width)) continue;
                if (this.processALine(g, lastX + 5, 5, wid, 5, bounds, forPs, selectedObjects, ws, -1)) {
                    return selectedObjects;
                }
                if (!this.processALine(g, lastX + 5, hei - 5, wid, hei - 5, bounds, forPs, selectedObjects, ws, -1)) continue;
                return selectedObjects;
            }
            int lastx = this.vertAxisPos;
            int lastState = 0;
            if (ds.getStateVector() == null) continue;
            int numEvents = ds.getNumEvents();
            int lastLowy = 0;
            int lastHighy = 0;
            for (int i = 0; i < numEvents; ++i) {
                double xValue = ds.getTime(i);
                int x2 = this.convertXDataToScreen(xValue);
                if (Simulation.isWaveformDisplayMultiState() && g != null) {
                    if (this.waveWindow.getPrintingMode() == 2) {
                        g.setColor(Color.BLACK);
                    } else {
                        switch (ds.getState(i) & 0xC) {
                            case 0: {
                                g.setColor(this.waveWindow.getOffStrengthColor());
                                break;
                            }
                            case 4: {
                                g.setColor(this.waveWindow.getNodeStrengthColor());
                                break;
                            }
                            case 8: {
                                g.setColor(this.waveWindow.getGateStrengthColor());
                                break;
                            }
                            case 12: {
                                g.setColor(this.waveWindow.getPowerStrengthColor());
                            }
                        }
                    }
                }
                int state = ds.getState(i) & 3;
                int lowy = 0;
                int highy = 0;
                switch (state) {
                    case 2: {
                        highy = 5;
                        lowy = 5;
                        break;
                    }
                    case 0: {
                        lowy = highy = hei - 5;
                        break;
                    }
                    case 1: {
                        lowy = 5;
                        highy = hei - 5;
                        break;
                    }
                    case 3: {
                        lowy = (hei - 10) / 3 + 5;
                        highy = hei - (hei - 10) / 3 - 5;
                    }
                }
                if (g != null && !Simulation.isWaveformDisplayMultiState()) {
                    g.setColor(Color.RED);
                }
                if (i != 0 && state != lastState && this.processALine(g, x2, Math.min(lowy, lastLowy), x2, Math.max(lowy, lastLowy), bounds, forPs, selectedObjects, ws, -1)) {
                    return selectedObjects;
                }
                if (g != null && !Simulation.isWaveformDisplayMultiState() && lastState == 3) {
                    g.setColor(Color.GREEN);
                }
                if (lastLowy == lastHighy ? this.processALine(g, lastx, lastLowy, x2, lastLowy, bounds, forPs, selectedObjects, ws, -1) : this.processABox(g, lastx, lastLowy, x2, lastHighy, bounds, forPs, selectedObjects, ws, false, 0.0)) {
                    return selectedObjects;
                }
                if (an.extrapolateValues() && i >= numEvents - 1) {
                    if (g != null && !Simulation.isWaveformDisplayMultiState()) {
                        if (state == 3) {
                            g.setColor(Color.GREEN);
                        } else {
                            g.setColor(Color.RED);
                        }
                    }
                    int wid = this.sz.width;
                    if (lowy == highy ? this.processALine(g, x2, lowy, wid - 1, lowy, bounds, forPs, selectedObjects, ws, -1) : this.processABox(g, x2, lowy, wid - 1, highy, bounds, forPs, selectedObjects, ws, false, 0.0)) {
                        return selectedObjects;
                    }
                }
                lastx = x2;
                lastLowy = lowy;
                lastHighy = highy;
                lastState = state;
            }
        }
        return selectedObjects;
    }

    private List<WaveSelection> processControlPoints(Graphics g, Rectangle2D bounds) {
        ArrayList<WaveSelection> selectedObjects = null;
        if (bounds != null) {
            selectedObjects = new ArrayList<WaveSelection>();
        }
        block0: for (WaveSignal ws : this.waveSignals.values()) {
            double xValue;
            int x;
            Double[] points;
            if (g != null) {
                g.setColor(ws.getColor());
            }
            if ((points = ws.getSignal().getControlPoints()) == null) continue;
            if (g != null) {
                g.setColor(ws.getColor());
            }
            for (int i = 0; i < points.length && !this.processABox(g, (x = this.convertXDataToScreen(xValue = points[i].doubleValue())) - 6, this.sz.height - 12, x + 6, this.sz.height, bounds, null, selectedObjects, ws, true, xValue); ++i) {
                boolean found = false;
                if (bounds == null && ws.getSelectedControlPoints() != null) {
                    for (int j = 0; j < ws.getSelectedControlPoints().length; ++j) {
                        if (ws.getSelectedControlPoints()[j] != xValue) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) continue;
                g.setColor(Color.GREEN);
                if (this.processABox(g, x - 6 + 2, this.sz.height - 12 + 2, x + 6 - 2, this.sz.height - 2, bounds, null, selectedObjects, ws, true, xValue)) continue block0;
                g.setColor(ws.getColor());
            }
        }
        return selectedObjects;
    }

    private boolean processABox(Graphics g, int lX, int lY, int hX, int hY, Rectangle2D bounds, List<PolyBase> forPs, List<WaveSelection> result, WaveSignal ws, boolean controlPoint, double controlXValue) {
        if (bounds != null) {
            if ((double)hX > bounds.getMinX() && (double)lX < bounds.getMaxX() && (double)hY > bounds.getMinY() && (double)lY < bounds.getMaxY()) {
                if (forPs != null) {
                    PolyBase poly = new PolyBase((lX + hX) / 2, (lY + hY) / 2, hX - lX, hY - lY);
                    poly.setStyle(Poly.Type.FILLED);
                    poly.setLayer(Artwork.tech().defaultLayer);
                    forPs.add(poly);
                    return false;
                }
                WaveSelection wSel = new WaveSelection();
                wSel.ws = ws;
                wSel.controlPoint = controlPoint;
                wSel.controlXValue = controlXValue;
                result.add(wSel);
                return true;
            }
            return false;
        }
        if (hX <= this.vertAxisPos) {
            return false;
        }
        if (lX < this.vertAxisPos) {
            lX = this.vertAxisPos;
        }
        g.fillRect(lX, lY, hX - lX, hY - lY);
        return false;
    }

    private boolean processALine(Graphics g, int fX, int fY, int tX, int tY, Rectangle2D bounds, List<PolyBase> forPs, List<WaveSelection> result, WaveSignal ws, int sweepNum) {
        if (bounds != null) {
            Point2D.Double from = new Point2D.Double(fX, fY);
            Point2D.Double to = new Point2D.Double(tX, tY);
            if (!GenMath.clipLine(from, to, bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY())) {
                if (forPs != null) {
                    forPs.add(new PolyBase(new Point2D[]{from, to}));
                    return false;
                }
                WaveSelection wSel = new WaveSelection();
                wSel.ws = ws;
                wSel.controlPoint = false;
                result.add(wSel);
                return true;
            }
            return false;
        }
        if (fX < this.vertAxisPos || tX < this.vertAxisPos) {
            Point2D.Double from = new Point2D.Double(fX, fY);
            Point2D.Double to = new Point2D.Double(tX, tY);
            if (GenMath.clipLine(from, to, (double)this.vertAxisPos, (double)this.sz.width, 0.0, (double)this.sz.height)) {
                return false;
            }
            fX = (int)((Point2D)from).getX();
            fY = (int)((Point2D)from).getY();
            tX = (int)((Point2D)to).getX();
            tY = (int)((Point2D)to).getY();
        }
        g.drawLine(fX, fY, tX, tY);
        boolean highlighted = ws.isHighlighted();
        if (ws.getPanel().waveWindow.getHighlightedSweep() >= 0) {
            boolean bl = highlighted = ws.getPanel().waveWindow.getHighlightedSweep() == sweepNum;
        }
        if (highlighted) {
            if (fX == tX) {
                g.drawLine(fX - 1, fY, tX - 1, tY);
                g.drawLine(fX + 1, fY, tX + 1, tY);
            } else if (fY == tY) {
                g.drawLine(fX, fY + 1, tX, tY + 1);
                g.drawLine(fX, fY - 1, tX, tY - 1);
            } else {
                int xDelta = 0;
                int yDelta = 1;
                if (Math.abs(fX - tX) < Math.abs(fY - tY)) {
                    xDelta = 1;
                    yDelta = 0;
                }
                g.drawLine(tX + xDelta, tY + yDelta, fX + xDelta, fY + yDelta);
                g.drawLine(tX - xDelta, tY - yDelta, fX - xDelta, fY - yDelta);
            }
        }
        return false;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.requestFocus();
        this.waveWindow.vcrClickStop();
        this.makeSelectedPanel(evt.getX(), evt.getY());
        Iterator<Panel> it = this.waveWindow.getPanels();
        while (it.hasNext()) {
            Panel wp = it.next();
            if (wp.draggingArea) {
                wp.repaintContents();
            }
            wp.draggingArea = false;
        }
        if (evt.getClickCount() == 2 && evt.getX() < this.vertAxisPos) {
            new WaveformZoom(TopLevel.getCurrentJFrame(), this.analogLowValue, this.analogHighValue, this.minXPosition, this.maxXPosition, this.waveWindow, this);
            return;
        }
        ToolBar.CursorMode mode = ToolBar.getCursorMode();
        if (ClickZoomWireListener.isRightMouse(evt)) {
            if ((evt.getModifiersEx() & 0x40) != 0) {
                mode = ToolBar.CursorMode.ZOOM;
            } else if (evt.getX() < this.vertAxisPos) {
                JPopupMenu menu = new JPopupMenu();
                JMenuItem item = new JMenuItem("Linear");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Panel.this.makeLinear();
                    }
                });
                menu.add(item);
                item = new JMenuItem("Logarithmic");
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Panel.this.makeLogarithmic();
                    }
                });
                menu.add(item);
                menu.show(this, evt.getX(), evt.getY());
                return;
            }
        }
        Iterator<Panel> it2 = this.waveWindow.getPanels();
        while (it2.hasNext()) {
            it2.next().curMeasurement = null;
        }
        if (mode == ToolBar.CursorMode.ZOOM) {
            this.mousePressedZoom(evt);
        } else if (mode == ToolBar.CursorMode.PAN) {
            this.mousePressedPan(evt);
        } else {
            this.mousePressedSelect(evt);
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        ToolBar.CursorMode mode = ToolBar.getCursorMode();
        if (ClickZoomWireListener.isRightMouse(evt) && (evt.getModifiersEx() & 0x40) != 0) {
            mode = ToolBar.CursorMode.ZOOM;
        }
        if (mode == ToolBar.CursorMode.ZOOM) {
            this.mouseReleasedZoom(evt);
        } else if (mode == ToolBar.CursorMode.PAN) {
            this.mouseReleasedPan(evt);
        } else {
            this.mouseReleasedSelect(evt);
        }
        Iterator<Panel> it = this.waveWindow.getPanels();
        while (it.hasNext()) {
            Panel panel = it.next();
            panel.curMeasurement = null;
            if (mode != ToolBar.CursorMode.MEASURE) continue;
            panel.draggingArea = false;
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        curPanel = this;
        curXPos = evt.getX();
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        curPanel = null;
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        curXPos = evt.getX();
        ToolBar.CursorMode mode = ToolBar.getCursorMode();
        if (mode == ToolBar.CursorMode.ZOOM) {
            this.mouseMovedZoom(evt);
        } else if (mode == ToolBar.CursorMode.PAN) {
            this.mouseMovedPan(evt);
        } else {
            this.mouseMovedSelect(evt);
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        curXPos = evt.getX();
        ToolBar.CursorMode mode = ToolBar.getCursorMode();
        if (ClickZoomWireListener.isRightMouse(evt) && (evt.getModifiersEx() & 0x40) != 0) {
            mode = ToolBar.CursorMode.ZOOM;
        }
        if (mode == ToolBar.CursorMode.ZOOM) {
            this.mouseDraggedZoom(evt);
        } else if (mode == ToolBar.CursorMode.PAN) {
            this.mouseDraggedPan(evt);
        } else {
            this.mouseDraggedSelect(evt);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        this.waveWindow.vcrClickStop();
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    private void digitalSignalNameClicked(ActionEvent evt) {
        long delay = evt.getWhen() - lastClick;
        lastClick = evt.getWhen();
        if (delay < (long)TopLevel.getDoubleClickSpeed()) {
            this.toggleBusContents();
            return;
        }
        Set<JButton> set = this.waveSignals.keySet();
        if (set.size() == 0) {
            return;
        }
        JButton but = set.iterator().next();
        WaveSignal ws = this.waveSignals.get(but);
        if ((evt.getModifiers() & 1) == 0) {
            Iterator<Panel> it = this.waveWindow.getPanels();
            while (it.hasNext()) {
                Panel wp = it.next();
                wp.clearHighlightedSignals();
            }
            this.addHighlightedSignal(ws, true);
            this.makeSelectedPanel(-1, -1);
        } else if (ws.isHighlighted()) {
            this.removeHighlightedSignal(ws, true);
        } else {
            this.addHighlightedSignal(ws, true);
        }
        this.waveWindow.crossProbeWaveformToEditWindow();
    }

    private List<WaveSelection> findSignalsInArea(int lX, int hX, int lY, int hY) {
        double swap;
        double lXd = Math.min(lX, hX) - 2;
        double hXd = Math.max(lX, hX) + 2;
        double hYd = Math.min(lY, hY) - 2;
        double lYd = Math.max(lY, hY) + 2;
        if (lXd > hXd) {
            swap = lXd;
            lXd = hXd;
            hXd = swap;
        }
        if (lYd > hYd) {
            swap = lYd;
            lYd = hYd;
            hYd = swap;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double(lXd, lYd, hXd - lXd, hYd - lYd);
        List<WaveSelection> sigs = this.processSignals(null, bounds, null);
        List<WaveSelection> cps = this.processControlPoints(null, bounds);
        for (WaveSelection ws : sigs) {
            cps.add(ws);
        }
        return cps;
    }

    public List<PolyBase> getPolysForPrinting() {
        if (!this.szValid) {
            Iterator<Panel> it = this.waveWindow.getPanels();
            while (it.hasNext()) {
                Panel wp = it.next();
                if (!wp.szValid) continue;
                this.sz = wp.sz;
                this.szValid = true;
                break;
            }
        }
        this.sz = this.getSize();
        ArrayList<PolyBase> polys = new ArrayList<PolyBase>();
        this.drawPanelContents(this.sz.width, this.sz.height, null, new Rectangle2D.Double(this.vertAxisPos, 0.0, this.sz.width, this.sz.height), polys);
        return polys;
    }

    public void clearMeasurements() {
        this.measurementList.clear();
        this.curMeasurement = null;
        this.repaintContents();
    }

    public void mousePressedSelect(MouseEvent evt) {
        this.draggingVertAxis = false;
        this.draggingExt = false;
        this.draggingMain = false;
        int mainX = this.convertXDataToScreen(this.waveWindow.getMainXPositionCursor());
        if (Math.abs(mainX - evt.getX()) < 5) {
            this.draggingMain = true;
            return;
        }
        int extX = this.convertXDataToScreen(this.waveWindow.getExtensionXPositionCursor());
        if (Math.abs(extX - evt.getX()) < 5) {
            this.draggingExt = true;
            return;
        }
        if (Math.abs(this.vertAxisPos - evt.getX()) < 5) {
            this.draggingVertAxis = true;
            return;
        }
        Point pt = new Point(evt.getX(), evt.getY());
        if (ToolBar.getCursorMode() == ToolBar.CursorMode.MEASURE) {
            pt = this.snapPoint(pt);
        }
        double xV = this.convertXScreenToData(pt.x);
        double yV = this.convertYScreenToData(pt.y);
        if (ToolBar.getCursorMode() == ToolBar.CursorMode.MEASURE) {
            if (ClickZoomWireListener.isRightMouse(evt)) {
                this.measurementList.clear();
                this.curMeasurement = null;
                return;
            }
            this.curMeasurement = new Rectangle2D.Double(xV, yV, 0.0, 0.0);
            this.measurementList.add(this.curMeasurement);
        }
        this.dragEndXD = this.dragStartXD = xV;
        this.dragEndYD = this.dragStartYD = yV;
        this.draggingArea = true;
    }

    private Point snapPoint(Point pt) {
        for (WaveSignal ws : this.waveSignals.values()) {
            if (!(ws.getSignal() instanceof AnalogSignal)) continue;
            AnalogSignal as = (AnalogSignal)ws.getSignal();
            double[] result = new double[3];
            AnalogAnalysis an = as.getAnalysis();
            int numSweeps = as.getNumSweeps();
            for (int s = 0; s < numSweeps; ++s) {
                if (!this.waveWindow.isSweepSignalIncluded(an, s)) continue;
                Waveform waveform = as.getWaveform(s);
                int numEvents = waveform.getNumEvents();
                for (int i = 0; i < numEvents; ++i) {
                    waveform.getEvent(i, result);
                    int x = this.convertXDataToScreen(result[0]);
                    int lowY = this.convertYDataToScreen(result[1]);
                    int highY = this.convertYDataToScreen(result[2]);
                    if (Math.abs(x - pt.x) >= 5 || pt.y <= lowY - 5 || pt.y >= highY + 5) continue;
                    pt.x = x;
                    pt.y = Math.max(Math.min(pt.y, highY), lowY);
                    return pt;
                }
            }
        }
        Point2D.Double snap = new Point2D.Double(pt.x, pt.y);
        for (WaveSignal ws : this.waveSignals.values()) {
            if (!(ws.getSignal() instanceof AnalogSignal)) continue;
            AnalogSignal as = (AnalogSignal)ws.getSignal();
            double[] result = new double[3];
            double[] lastResult = new double[3];
            AnalogAnalysis an = as.getAnalysis();
            int numSweeps = as.getNumSweeps();
            block4: for (int s = 0; s < numSweeps; ++s) {
                if (!this.waveWindow.isSweepSignalIncluded(an, s)) continue;
                Waveform waveform = as.getWaveform(s);
                int numEvents = waveform.getNumEvents();
                waveform.getEvent(0, lastResult);
                Point2D.Double lastPt = new Point2D.Double(this.convertXDataToScreen(lastResult[0]), this.convertYDataToScreen((lastResult[1] + lastResult[2]) / 2.0));
                for (int i = 1; i < numEvents; ++i) {
                    waveform.getEvent(i, result);
                    Point2D.Double thisPt = new Point2D.Double(this.convertXDataToScreen(result[0]), this.convertYDataToScreen((result[1] + result[2]) / 2.0));
                    Point2D closest = GenMath.closestPointToSegment(lastPt, thisPt, snap);
                    if (closest.distance(snap) < 5.0) {
                        pt.x = (int)Math.round(closest.getX());
                        pt.y = (int)Math.round(closest.getY());
                        continue block4;
                    }
                    lastPt = thisPt;
                }
            }
        }
        return pt;
    }

    public void mouseReleasedSelect(MouseEvent evt) {
        if (this.draggingArea) {
            this.draggingArea = false;
            Panel wp = (Panel)evt.getSource();
            if (ToolBar.getCursorMode() != ToolBar.CursorMode.MEASURE && ToolBar.getSelectMode() == ToolBar.SelectMode.OBJECTS) {
                List<WaveSelection> selectedObjects = wp.findSignalsInArea(this.convertXDataToScreen(this.dragStartXD), this.convertXDataToScreen(this.dragEndXD), this.convertYDataToScreen(this.dragStartYD), this.convertYDataToScreen(this.dragEndYD));
                if ((evt.getModifiers() & 1) == 0) {
                    if (this.analog) {
                        this.clearHighlightedSignals();
                    } else {
                        Iterator<Panel> it = this.waveWindow.getPanels();
                        while (it.hasNext()) {
                            Panel oWp = it.next();
                            oWp.clearHighlightedSignals();
                        }
                    }
                    for (WaveSelection wSel : selectedObjects) {
                        if (wSel.controlPoint) {
                            wSel.ws.addSelectedControlPoint(wSel.controlXValue);
                        }
                        wp.addHighlightedSignal(wSel.ws, false);
                    }
                } else {
                    for (WaveSelection wSel : selectedObjects) {
                        WaveSignal ws = wSel.ws;
                        if (ws.isHighlighted()) {
                            if (wSel.controlPoint) {
                                ws.removeSelectedControlPoint(wSel.controlXValue);
                            }
                            this.removeHighlightedSignal(ws, false);
                            continue;
                        }
                        if (wSel.controlPoint) {
                            ws.addSelectedControlPoint(wSel.controlXValue);
                        }
                        wp.addHighlightedSignal(ws, false);
                    }
                }
                wp.waveWindow.crossProbeWaveformToEditWindow();
            }
        }
        this.repaintContents();
    }

    public void mouseDraggedSelect(MouseEvent evt) {
        if (this.draggingMain) {
            if (evt.getX() <= 0) {
                return;
            }
            double value = this.convertXScreenToData(evt.getX());
            this.waveWindow.setMainXPositionCursor(value);
            this.waveWindow.repaintAllPanels();
        } else if (this.draggingExt) {
            if (evt.getX() <= 0) {
                return;
            }
            double value = this.convertXScreenToData(evt.getX());
            this.waveWindow.setExtensionXPositionCursor(value);
            this.waveWindow.repaintAllPanels();
        } else if (this.draggingVertAxis) {
            if (evt.getX() <= 0) {
                return;
            }
            if (this.waveWindow.isXAxisLocked()) {
                Iterator<Panel> it = this.waveWindow.getPanels();
                while (it.hasNext()) {
                    Panel wp = it.next();
                    wp.vertAxisPos = evt.getX();
                }
                this.waveWindow.redrawAllPanels();
                this.waveWindow.getMainHorizRuler().repaint();
            } else {
                this.vertAxisPos = evt.getX();
                this.repaintWithRulers();
            }
        } else if (this.draggingArea) {
            int yp;
            HashSet<Panel> measureWindows = new HashSet<Panel>();
            Point cPt = new Point();
            Panel curPanel = this;
            measureWindows.add(curPanel);
            JTable table = this.waveWindow.getWaveformTable();
            int startPanel = 0;
            for (int i = 0; i < table.getRowCount(); ++i) {
                if (this != this.waveWindow.getPanel(i)) continue;
                startPanel = i;
                break;
            }
            Rectangle bou = evt.getComponent().getBounds();
            if (yp >= bou.y && yp < bou.y + bou.height) {
                cPt.setLocation(evt.getX(), evt.getY());
            } else {
                int curPanelNum = startPanel;
                if (yp < bou.y) {
                    for (yp = evt.getY(); yp < bou.y && curPanelNum > 0; yp += table.getRowHeight(curPanelNum)) {
                        measureWindows.add(this.waveWindow.getPanel(--curPanelNum));
                    }
                } else if (yp >= bou.y + bou.height) {
                    while (yp >= bou.y + bou.height && curPanelNum + 1 < table.getRowCount()) {
                        yp -= table.getRowHeight(curPanelNum);
                        measureWindows.add(this.waveWindow.getPanel(++curPanelNum));
                    }
                }
                curPanel = this.waveWindow.getPanel(curPanelNum);
                cPt.setLocation(evt.getX(), yp);
            }
            curPanel.snapPoint(cPt);
            this.dragEndXD = curPanel.convertXScreenToData(cPt.x);
            this.dragEndYD = curPanel.convertYScreenToData(cPt.y);
            if (ToolBar.getCursorMode() == ToolBar.CursorMode.MEASURE && !ClickZoomWireListener.isRightMouse(evt)) {
                Iterator<Panel> it = this.waveWindow.getPanels();
                while (it.hasNext()) {
                    it.next().draggingArea = false;
                }
                for (Panel wp : measureWindows) {
                    if (wp.curMeasurement == null) {
                        wp.curMeasurement = new Rectangle2D.Double();
                        wp.measurementList.add(wp.curMeasurement);
                    }
                    wp.curMeasurement.setRect(this.dragStartXD, this.dragStartYD, this.dragEndXD - this.dragStartXD, this.dragEndYD - this.dragStartYD);
                    wp.dragStartXD = this.dragStartXD;
                    wp.dragStartYD = this.dragStartYD;
                    wp.dragEndXD = this.dragEndXD;
                    wp.dragEndYD = this.dragEndYD;
                    wp.draggingArea = true;
                    wp.repaint();
                }
            }
            this.repaint();
        }
    }

    public void mouseMovedSelect(MouseEvent evt) {
        int mainX = this.convertXDataToScreen(this.waveWindow.getMainXPositionCursor());
        int extX = this.convertXDataToScreen(this.waveWindow.getExtensionXPositionCursor());
        if (Math.abs(mainX - evt.getX()) < 5 || Math.abs(extX - evt.getX()) < 5 || Math.abs(this.vertAxisPos - evt.getX()) < 5) {
            this.setCursor(dragXPositionCursor);
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void clearHighlightedSignals() {
        for (WaveSignal ws : this.waveSignals.values()) {
            if (!ws.isHighlighted()) continue;
            ws.setHighlighted(false);
            ws.clearSelectedControlPoints();
            if (ws.getButton() == null) continue;
            ws.getButton().setBackground(background);
        }
        this.waveWindow.setHighlightedSweep(-1);
        this.repaintContents();
    }

    public void addHighlightedSignal(WaveSignal ws, boolean repaintContents) {
        if (ws.getButton() != null) {
            if (background == null) {
                background = ws.getButton().getBackground();
            }
            ws.getButton().setBackground(new Color(User.getColor(User.ColorPrefType.WAVE_BACKGROUND)));
        }
        ws.setHighlighted(true);
        this.waveWindow.setHighlightedSweep(-1);
        if (repaintContents) {
            this.repaintContents();
        }
    }

    public void removeHighlightedSignal(WaveSignal ws, boolean repaintContents) {
        ws.setHighlighted(false);
        if (ws.getButton() != null) {
            ws.getButton().setBackground(background);
        }
        this.waveWindow.setHighlightedSweep(-1);
        if (repaintContents) {
            this.repaintContents();
        }
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void makeSelectedPanel(int x, int y) {
        Iterator<Panel> it = this.waveWindow.getPanels();
        while (it.hasNext()) {
            Panel wp = it.next();
            if (!wp.selected || wp == this) continue;
            wp.selected = false;
            wp.repaintContents();
        }
        if (!this.selected) {
            this.selected = true;
            this.repaintContents();
        }
        curPanel = this;
        curXPos = x;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void mousePressedZoom(MouseEvent evt) {
        this.dragStartXD = this.convertXScreenToData(evt.getX());
        this.dragStartYD = this.convertYScreenToData(evt.getY());
        ZoomAndPanListener.setProperCursor(evt);
        this.draggingArea = true;
    }

    public void mouseReleasedZoom(MouseEvent evt) {
        ZoomAndPanListener.setProperCursor(evt);
        this.draggingArea = false;
        double lowXValue = Math.min(this.dragEndXD, this.dragStartXD);
        double highXValue = Math.max(this.dragEndXD, this.dragStartXD);
        double xRange = highXValue - lowXValue;
        lowXValue -= xRange / 8.0;
        highXValue += xRange / 8.0;
        double lowValue = Math.min(this.dragEndYD, this.dragStartYD);
        double highValue = Math.max(this.dragEndYD, this.dragStartYD);
        double valueRange = highValue - lowValue;
        lowValue -= valueRange / 8.0;
        highValue += valueRange / 8.0;
        Iterator<Panel> it = this.waveWindow.getPanels();
        while (it.hasNext()) {
            Panel wp = it.next();
            if (!this.waveWindow.isXAxisLocked() && wp != this) continue;
            if ((evt.getModifiers() & 1) == 0 || ClickZoomWireListener.isRightMouse(evt)) {
                if (wp.getMinXAxis() > wp.getMaxXAxis()) {
                    wp.setXAxisRange(highXValue, lowXValue);
                } else {
                    wp.setXAxisRange(lowXValue, highXValue);
                }
                if (wp == this) {
                    wp.setYAxisRange(lowValue, highValue);
                }
            } else {
                double oldRange = wp.maxXPosition - wp.minXPosition;
                double min = (lowXValue + highXValue) / 2.0 - oldRange;
                double max = (lowXValue + highXValue) / 2.0 + oldRange;
                if (wp.getMinXAxis() > wp.getMaxXAxis()) {
                    wp.setXAxisRange(max, min);
                } else {
                    wp.setXAxisRange(min, max);
                }
                if (wp == this) {
                    wp.setYAxisRange((lowValue + highValue) / 2.0 - wp.analogRange, (lowValue + highValue) / 2.0 + wp.analogRange);
                }
            }
            wp.repaintWithRulers();
        }
    }

    public void mouseDraggedZoom(MouseEvent evt) {
        if (this.draggingArea) {
            this.dragEndXD = this.convertXScreenToData(evt.getX());
            this.dragEndYD = this.convertYScreenToData(evt.getY());
            this.repaint();
        }
    }

    public void mouseMovedZoom(MouseEvent evt) {
    }

    public void mousePressedPan(MouseEvent evt) {
        this.dragStartXD = this.convertXScreenToData(evt.getX());
        this.dragStartYD = this.convertYScreenToData(evt.getY());
    }

    public void mouseReleasedPan(MouseEvent evt) {
    }

    public void mouseDraggedPan(MouseEvent evt) {
        this.dragEndXD = this.convertXScreenToData(evt.getX());
        double dXValue = this.dragEndXD - this.dragStartXD;
        this.dragEndYD = this.convertYScreenToData(evt.getY());
        double dYValue = this.dragEndYD - this.dragStartYD;
        Iterator<Panel> it = this.waveWindow.getPanels();
        while (it.hasNext()) {
            Panel wp = it.next();
            if (!this.waveWindow.isXAxisLocked() && wp != this) continue;
            wp.setXAxisRange(wp.minXPosition - dXValue, wp.maxXPosition - dXValue);
            if (wp == this) {
                this.setYAxisRange(this.analogLowValue - dYValue, this.analogHighValue - dYValue);
            }
            wp.repaintWithRulers();
        }
        this.dragStartXD = this.dragEndXD;
        this.dragStartYD = this.dragEndYD;
    }

    public void mouseMovedPan(MouseEvent evt) {
    }

    static {
        farDottedLine = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{4.0f, 12.0f}, 0.0f);
        iconHidePanel = Resources.getResource(WaveformWindow.class, "ButtonSimHide.gif");
        iconClosePanel = Resources.getResource(WaveformWindow.class, "ButtonSimClose.gif");
        iconDeleteSignal = Resources.getResource(WaveformWindow.class, "ButtonSimDelete.gif");
        iconDeleteAllSignals = Resources.getResource(WaveformWindow.class, "ButtonSimDeleteAll.gif");
        dragXPositionCursor = ToolBar.readCursor("CursorDragTime.gif", 8, 8);
    }

    private static class DragLabel
    extends JLabel
    implements DragGestureListener,
    DragSourceListener {
        private DragSource dragSource;

        public DragLabel(String s) {
            this.setText(s);
            this.dragSource = DragSource.getDefaultDragSource();
            this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            StringSelection transferable = new StringSelection("PANEL " + this.getText());
            this.dragSource.startDrag(e, DragSource.DefaultLinkDrop, transferable, this);
        }

        public void dragEnter(DragSourceDragEvent e) {
        }

        public void dragOver(DragSourceDragEvent e) {
        }

        public void dragExit(DragSourceEvent e) {
        }

        public void dragDropEnd(DragSourceDropEvent e) {
        }

        public void dropActionChanged(DragSourceDragEvent e) {
        }
    }

    private static class WaveSelection {
        WaveSignal ws;
        boolean controlPoint;
        double controlXValue;

        private WaveSelection() {
        }
    }
}

