/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.tool.simulation.Analysis;
import java.awt.geom.Rectangle2D;

public abstract class Signal {
    private String signalName;
    private String signalContext;
    protected Rectangle2D bounds;
    protected double leftEdge;
    protected double rightEdge;

    public void finished() {
    }

    public abstract Analysis getAnalysis();

    public void setSignalName(String signalName, String signalContext) {
        this.signalName = signalName;
        this.signalContext = signalContext;
        this.getAnalysis().nameSignal(this, this.getFullName());
    }

    public String getSignalName() {
        return this.signalName;
    }

    public void setSignalContext(String signalContext) {
        this.signalContext = signalContext;
    }

    public String getSignalContext() {
        return this.signalContext;
    }

    public String getFullName() {
        if (this.signalContext != null) {
            return this.signalContext + this.getAnalysis().getStimuli().getSeparatorChar() + this.signalName;
        }
        return this.signalName;
    }

    public Double[] getControlPoints() {
        return this.getAnalysis().getStimuli().getControlPoints(this);
    }

    public void clearControlPoints() {
        this.getAnalysis().getStimuli().clearControlPoints(this);
    }

    public void addControlPoint(double time) {
        this.getAnalysis().getStimuli().addControlPoint(this, time);
    }

    public void removeControlPoint(double time) {
        this.getAnalysis().getStimuli().removeControlPoint(this, time);
    }

    public Rectangle2D getBounds() {
        if (this.bounds == null) {
            this.calcBounds();
        }
        return this.bounds;
    }

    public double getLeftEdge() {
        if (this.bounds == null) {
            this.calcBounds();
        }
        return this.leftEdge;
    }

    public double getRightEdge() {
        if (this.bounds == null) {
            this.calcBounds();
        }
        return this.rightEdge;
    }

    protected void calcBounds() {
    }
}

