/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.IdManager;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.id.TechId;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.AbstractUserInterface;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.ClientJobManager;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.EThread;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.JobManager;
import com.sun.electric.tool.ServerJobManager;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.CantEditException;
import com.sun.electric.tool.user.ErrorLogger;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Job
implements Serializable {
    private static boolean GLOBALDEBUG = false;
    private static int recommendedNumThreads;
    static final int PROTOCOL_VERSION = 19;
    public static boolean LOCALDEBUGFLAG;
    static final Logger logger;
    public static final int MIN_NUM_SECONDS = 60000;
    static JobManager jobManager;
    static AbstractUserInterface currentUI;
    static Thread clientThread;
    boolean deleteWhenDone;
    public long startTime;
    public long endTime;
    boolean started;
    public boolean finished;
    boolean aborted;
    boolean scheduledToAbort;
    public boolean reportExecution = false;
    Tool tool;
    final TechId curTechId;
    final LibId curLibId;
    final CellId curCellId;
    transient EJob ejob;
    transient EDatabase database;

    public static boolean getDebug() {
        return GLOBALDEBUG;
    }

    public static void setDebug(boolean f) {
        GLOBALDEBUG = f;
    }

    public static void initJobManager(int numThreads, String loggingFilePath, int socketPort, AbstractUserInterface ui, Job initDatabaseJob) {
        recommendedNumThreads = numThreads;
        currentUI = ui;
        jobManager = new ServerJobManager(numThreads, loggingFilePath, false, socketPort);
        jobManager.runLoop(initDatabaseJob);
    }

    public static void pipeServer(int numThreads, String loggingFilePath, int socketPort) {
        Pref.forbidPreferences();
        EDatabase.setServerDatabase(new EDatabase(IdManager.stdIdManager.getInitialSnapshot()));
        Tool.initAllTools();
        jobManager = new ServerJobManager(numThreads, loggingFilePath, true, socketPort);
    }

    public static void socketClient(String serverMachineName, int socketPort, AbstractUserInterface ui, Job initDatabaseJob) {
        currentUI = ui;
        try {
            jobManager = new ClientJobManager(serverMachineName, socketPort);
            jobManager.runLoop(initDatabaseJob);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void pipeClient(Process process, AbstractUserInterface ui, Job initDatabaseJob, boolean skipOneLine) {
        currentUI = ui;
        try {
            jobManager = new ClientJobManager(process, skipOneLine);
            jobManager.runLoop(initDatabaseJob);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Job(String jobName, Tool tool, Type jobType, Cell upCell, Cell downCell, Priority priority) {
        this.ejob = new EJob(this, jobType, jobName, EditingPreferences.getThreadEditingPreferences());
        this.database = Job.getUserInterface() != null ? Job.getUserInterface().getDatabase() : EDatabase.clientDatabase();
        this.tool = tool;
        this.deleteWhenDone = true;
        this.endTime = 0L;
        this.startTime = 0L;
        UserInterface ui = Job.getUserInterface();
        Technology curTech = ui != null ? ui.getCurrentTechnology() : null;
        this.curTechId = curTech != null ? curTech.getId() : null;
        Library curLib = ui != null ? ui.getCurrentLibrary() : null;
        this.curLibId = curLib != null ? curLib.getId() : null;
        Cell curCell = ui != null ? ui.getCurrentCell() : null;
        this.curCellId = curCell != null ? curCell.getId() : null;
    }

    public void startJob() {
        this.startJob(true);
    }

    public void startJobOnMyResult() {
        this.startJob(true, true);
    }

    public void startJob(boolean deleteWhenDone) {
        this.startJob(deleteWhenDone, false);
    }

    private void startJob(boolean deleteWhenDone, boolean onMySnapshot) {
        this.deleteWhenDone = deleteWhenDone;
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof EThread && ((EThread)currentThread).ejob.jobType != Type.CLIENT_EXAMINE) {
            this.ejob.startedByServer = true;
            this.ejob.client = ((EThread)currentThread).ejob.client;
            this.ejob.jobKey = this.ejob.client.newJobId(this.ejob.startedByServer, true);
            this.ejob.serverJob.startTime = System.currentTimeMillis();
            this.ejob.serialize(EDatabase.serverDatabase());
            this.ejob.clientJob = null;
        } else {
            this.ejob.client = Job.getExtendedUserInterface();
            this.ejob.jobKey = this.ejob.client.newJobId(this.ejob.startedByServer, false);
            this.ejob.clientJob.startTime = System.currentTimeMillis();
            this.ejob.serverJob = null;
            if (this.ejob.jobType != Type.CLIENT_EXAMINE) {
                this.ejob.serialize(EDatabase.clientDatabase());
            }
        }
        jobManager.addJob(this.ejob, onMySnapshot);
    }

    protected void fieldVariableChanged(String variableName) {
        this.ejob.fieldVariableChanged(variableName);
    }

    public abstract boolean doIt() throws JobException;

    public void terminateIt(Throwable jobException) {
        if (jobException == null) {
            this.terminateOK();
        } else {
            this.terminateFail(jobException);
        }
    }

    public void terminateOK() {
    }

    public void terminateFail(Throwable jobException) {
        if (jobException instanceof CantEditException) {
            ((CantEditException)jobException).presentProblem();
        } else if (jobException instanceof JobException) {
            String message = jobException.getMessage();
            if (message == null) {
                message = "Job " + this.ejob.jobName + " failed";
            }
            System.out.println(message);
        } else {
            ActivityLogger.logException(jobException);
        }
    }

    protected void setReportExecutionFlag(boolean flag) {
        this.reportExecution = flag;
    }

    protected synchronized void setProgress(String progress) {
        jobManager.setProgress(this.ejob, progress);
    }

    private synchronized String getProgress() {
        return this.ejob.progress;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public synchronized void abort() {
        if (this.aborted) {
            System.out.println("Job already aborted: " + this.getStatus());
            return;
        }
        this.scheduledToAbort = true;
        if (this.ejob.jobType != Type.CLIENT_EXAMINE && this.ejob.serverJob != null) {
            this.ejob.serverJob.scheduledToAbort = true;
        }
    }

    private synchronized void setAborted() {
        this.aborted = true;
    }

    protected synchronized boolean getScheduledToAbort() {
        return this.scheduledToAbort;
    }

    private synchronized boolean getAborted() {
        return this.aborted;
    }

    public boolean getDeleteWhenDone() {
        return this.deleteWhenDone;
    }

    public boolean checkAbort() {
        if (this.getAborted()) {
            return true;
        }
        boolean scheduledAbort = this.getScheduledToAbort();
        if (scheduledAbort) {
            System.out.println(this + ": aborted");
            this.setReportExecutionFlag(true);
            this.setAborted();
        }
        return scheduledAbort;
    }

    public static Iterator<Job> getAllJobs() {
        return jobManager.getAllJobs();
    }

    public static Job getRunningJob() {
        Thread thread = Thread.currentThread();
        return thread instanceof EThread ? ((EThread)thread).getRunningJob() : null;
    }

    static EJob getRunningEJob() {
        Thread thread = Thread.currentThread();
        return thread instanceof EThread ? ((EThread)thread).getRunningEJob() : null;
    }

    public static boolean inServerThread() {
        Thread thread = Thread.currentThread();
        return thread instanceof EThread && ((EThread)thread).isServerThread;
    }

    public static void setCurrentLibraryInJob(Library lib) {
        EThread thread = (EThread)Thread.currentThread();
        assert (thread.ejob.jobType == Type.CHANGE);
        thread.userInterface.curLibId = lib != null ? lib.getId() : null;
    }

    public String getStatus() {
        switch (this.ejob.state) {
            case WAITING: {
                return "waiting";
            }
            case RUNNING: {
                return this.getProgress() == null ? "running" : this.getProgress();
            }
            case SERVER_DONE: {
                return this.getProgress() == null ? "done" : this.getProgress();
            }
            case CLIENT_DONE: {
                return "cdone";
            }
        }
        if (!this.started) {
            return "waiting";
        }
        if (this.aborted) {
            return "aborted";
        }
        if (this.finished) {
            return "done";
        }
        if (this.scheduledToAbort) {
            return "scheduled to abort";
        }
        if (this.getProgress() == null) {
            return "running";
        }
        return this.getProgress();
    }

    public boolean remove() {
        if (!this.finished && !this.aborted) {
            return false;
        }
        jobManager.removeJob(this);
        return true;
    }

    public static UserInterface getUserInterface() {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof EThread) {
            return ((EThread)currentThread).getUserInterface();
        }
        return currentUI;
    }

    public static AbstractUserInterface getExtendedUserInterface() {
        return currentUI;
    }

    public static boolean isClientThread() {
        return Thread.currentThread() == clientThread;
    }

    public EDatabase getDatabase() {
        return this.database;
    }

    public Environment getEnvironment() {
        return this.database.getEnvironment();
    }

    public TechPool getTechPool() {
        return this.database.getTechPool();
    }

    public Tool getTool() {
        return this.tool;
    }

    public EditingPreferences getEditingPreferences() {
        return this.ejob.editingPreferences;
    }

    public static void updateNetworkErrors(Cell cell, List<ErrorLogger.MessageLog> errors) {
        if (currentUI != null) {
            currentUI.updateNetworkErrors(cell, errors);
        }
    }

    public static void updateIncrementalDRCErrors(Cell cell, List<ErrorLogger.MessageLog> newErrors, List<ErrorLogger.MessageLog> delErrors) {
        currentUI.updateIncrementalDRCErrors(cell, newErrors, delErrors);
    }

    public String toString() {
        return this.ejob.jobName + " (" + this.getStatus() + ")";
    }

    public String getInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append("Job " + this.toString());
        if (this.finished) {
            long time = this.endTime - this.startTime;
            buf.append(" took: " + TextUtils.getElapsedTime(time));
            Date start = new Date(this.startTime);
            buf.append(" (started at " + start + ")");
        } else if (this.getProgress() == null) {
            long time = System.currentTimeMillis() - this.startTime;
            buf.append(" has not finished. Current running time: " + TextUtils.getElapsedTime(time));
        } else {
            buf.append(" did not successfully finish.");
        }
        return buf.toString();
    }

    public Key getKey() {
        return this.ejob.jobKey;
    }

    public Inform getInform() {
        return new Inform(this);
    }

    static {
        logger = Logger.getLogger("com.sun.electric.tool.job");
    }

    public static class Inform
    implements Serializable {
        private final Key jobKey;
        private final boolean isChange;
        private final String toString;
        private final long startTime;
        private final long endTime;
        private final int finished;

        Inform(Job job) {
            this.jobKey = job.getKey();
            this.isChange = job.ejob.jobType == Type.CHANGE || job.ejob.jobType == Type.UNDO;
            this.toString = job.toString();
            this.startTime = job.startTime;
            this.endTime = job.endTime;
            this.finished = job.finished ? 1 : (job.getProgress() == null ? 0 : -1);
        }

        Inform(Key jobKey, boolean isChange, String toString, long startTime, long endTime, int finished) {
            this.jobKey = jobKey;
            this.isChange = isChange;
            this.toString = toString;
            this.startTime = startTime;
            this.endTime = endTime;
            this.finished = finished;
        }

        public void abort() {
            Iterator<Job> it = Job.getAllJobs();
            while (it.hasNext()) {
                Job job = it.next();
                if (!job.getKey().equals(this.jobKey)) continue;
                job.abort();
                break;
            }
        }

        public boolean remove() {
            return false;
        }

        public Key getKey() {
            return this.jobKey;
        }

        public String toString() {
            return this.toString;
        }

        public String getInfo() {
            StringBuilder buf = new StringBuilder();
            buf.append("Job " + this.toString());
            if (this.finished == 1) {
                long time = this.endTime - this.startTime;
                buf.append(" took: " + TextUtils.getElapsedTime(time));
                Date start = new Date(this.startTime);
                buf.append(" (started at " + start + ")");
            } else if (this.finished == 0) {
                long time = System.currentTimeMillis() - this.startTime;
                buf.append(" has not finished. Current running time: " + TextUtils.getElapsedTime(time));
            } else {
                buf.append(" did not successfully finish.");
            }
            return buf.toString();
        }

        public boolean isChangeJobQueuedOrRunning() {
            return this.finished != 1 && this.isChange;
        }

        public void write(IdWriter writer) throws IOException {
            this.jobKey.write(writer);
            writer.writeBoolean(this.isChange);
            writer.writeString(this.toString);
            writer.writeLong(this.startTime);
            writer.writeLong(this.endTime);
            writer.writeInt(this.finished);
        }

        public static Inform read(IdReader reader) throws IOException {
            Key jobKey = Key.read(reader);
            boolean isChange = reader.readBoolean();
            String toString = reader.readString();
            long startTime = reader.readLong();
            long endTime = reader.readLong();
            int finished = reader.readInt();
            return new Inform(jobKey, isChange, toString, startTime, endTime, finished);
        }
    }

    public static class Key
    implements Serializable {
        public final int clientId;
        public final int jobId;
        public final boolean doItOnServer;

        Key(int clientId, int jobId, boolean doItOnServer) {
            this.clientId = clientId;
            this.jobId = jobId;
            this.doItOnServer = doItOnServer;
        }

        Key(Client client, int jobId, boolean doItOnServer) {
            this(client.connectionId, jobId, doItOnServer);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Key) {
                Key that = (Key)o;
                if (this.clientId == that.clientId && this.jobId == that.jobId) {
                    assert (this.doItOnServer == that.doItOnServer);
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.jobId;
        }

        public void write(IdWriter writer) throws IOException {
            writer.writeInt(this.clientId);
            writer.writeInt(this.jobId);
            writer.writeBoolean(this.doItOnServer);
        }

        public static Key read(IdReader reader) throws IOException {
            int clientId = reader.readInt();
            int jobId = reader.readInt();
            boolean doItOnServer = reader.readBoolean();
            return new Key(clientId, jobId, doItOnServer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        USER,
        VISCHANGES,
        INVISCHANGES,
        ANALYSIS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        CHANGE,
        UNDO,
        SERVER_EXAMINE,
        CLIENT_EXAMINE;

    }
}

