/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.processing;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.netlist.Mos;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.Subcircuit;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialParallelMerge {
    private NccGlobals globals;

    private SerialParallelMerge(NccGlobals globals) {
        this.globals = globals;
    }

    private boolean serialMerge() {
        int numMerged = 0;
        EquivRecord wires = this.globals.getWires();
        if (wires != null) {
            Iterator<Circuit> it = wires.getCircuits();
            while (it.hasNext()) {
                Circuit ckt = it.next();
                Iterator<NetObject> ni = ckt.getNetObjs();
                while (ni.hasNext()) {
                    Wire w = (Wire)ni.next();
                    if (!Mos.joinOnWire(w)) continue;
                    ++numMerged;
                }
            }
        }
        this.globals.status2("    Serial merged " + numMerged + " Transistors");
        return numMerged > 0;
    }

    private int parallelMergeAllCandidatesInSet(Collection<Part> parts) {
        Iterator it;
        int numMerged = 0;
        LinkedList<Part> pts = new LinkedList<Part>(parts);
        while ((it = pts.iterator()).hasNext()) {
            Part first = (Part)it.next();
            it.remove();
            while (it.hasNext()) {
                Part p = (Part)it.next();
                if (!first.parallelMerge(p)) continue;
                it.remove();
                ++numMerged;
            }
        }
        return numMerged;
    }

    private int parallelMergeEachSetInMap(Map<Integer, Set<Part>> map) {
        int numMerged = 0;
        for (Integer i : map.keySet()) {
            Set<Part> j = map.get(i);
            numMerged += this.parallelMergeAllCandidatesInSet(j);
        }
        return numMerged;
    }

    private int parallelMergePartsOnWire(Wire w) {
        if (w.isDeleted()) {
            return 0;
        }
        HashMap<Integer, Set<Part>> map = new HashMap<Integer, Set<Part>>();
        Iterator<Part> it = w.getParts();
        while (it.hasNext()) {
            Part p = it.next();
            if (p.isDeleted() || p instanceof Subcircuit) continue;
            Integer code = p.hashCodeForParallelMerge();
            Set<Part> set = map.get(code);
            if (set == null) {
                set = new HashSet<Part>();
                map.put(code, set);
            }
            set.add(p);
        }
        return this.parallelMergeEachSetInMap(map);
    }

    private boolean parallelMerge() {
        int numMerged = 0;
        EquivRecord er = this.globals.getWires();
        if (er != null) {
            Iterator<Circuit> it = er.getCircuits();
            while (it.hasNext()) {
                Circuit ckt = it.next();
                Iterator<NetObject> ni = ckt.getNetObjs();
                while (ni.hasNext()) {
                    Wire w = (Wire)ni.next();
                    numMerged += this.parallelMergePartsOnWire(w);
                }
            }
        }
        this.globals.status2("    Parallel merged " + numMerged + " Parts");
        return numMerged > 0;
    }

    private int countUndeletedParts(EquivRecord parts) {
        int numParts = 0;
        Iterator<Circuit> it = parts.getCircuits();
        while (it.hasNext()) {
            Circuit ckt = it.next();
            numParts += ckt.numUndeletedNetObjs();
        }
        return numParts;
    }

    private void serialParallelMerge() {
        EquivRecord parts = this.globals.getParts();
        if (parts == null) {
            return;
        }
        int numParts = this.countUndeletedParts(parts);
        this.globals.status2("--- NCC starting merge process with " + numParts + " Parts");
        boolean first = true;
        int tripNumber = 1;
        while (!this.globals.userWantsToAbort()) {
            this.globals.status2("  parallel and series merge trip " + tripNumber);
            boolean progress = this.parallelMerge();
            if (!first && !progress) break;
            first = false;
            if (this.globals.userWantsToAbort() || !(progress = this.serialMerge())) break;
            ++tripNumber;
        }
        numParts = this.countUndeletedParts(parts);
        this.globals.status2("--- NCC finishing merge process with " + numParts + " Parts");
        this.globals.status2("");
    }

    private static void putInFinalForm(EquivRecord er) {
        if (er == null) {
            return;
        }
        Iterator<Circuit> it = er.getCircuits();
        while (it.hasNext()) {
            it.next().putInFinalForm();
        }
    }

    public static void doYourJob(NccGlobals globals) {
        SerialParallelMerge sp = new SerialParallelMerge(globals);
        sp.serialParallelMerge();
        SerialParallelMerge.putInFinalForm(globals.getParts());
        SerialParallelMerge.putInFinalForm(globals.getWires());
    }
}

