/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.tool.user.ErrorHighlight;
import com.sun.electric.tool.user.Highlighter;
import java.io.PrintStream;

class ErrorHighLine
extends ErrorHighlight {
    private final EPoint p1;
    private final EPoint p2;
    private final boolean thickLine;

    public ErrorHighLine(Cell c, EPoint x1, EPoint x2, boolean thick) {
        super(c, null);
        this.thickLine = thick;
        this.p1 = x1;
        this.p2 = x2;
    }

    void xmlDescription(PrintStream msg, EDatabase database) {
        msg.append("\t\t<" + (this.thickLine ? "ERRORTYPETHICKLINE " : "ERRORTYPELINE "));
        msg.append("p1=\"(" + this.p1.getX() + "," + this.p1.getY() + ")\" ");
        msg.append("p2=\"(" + this.p2.getX() + "," + this.p2.getY() + ")\" ");
        msg.append("cellName=\"" + this.getCell(database).describe(false) + "\"");
        msg.append(" />\n");
    }

    public void addToHighlighter(Highlighter h, EDatabase database) {
        Cell cell = this.getCell(database);
        if (this.thickLine) {
            h.addThickLine(this.p1, this.p2, cell);
        } else {
            h.addLine(this.p1, this.p2, cell);
        }
    }
}

