/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.xml.Xml807;
import java.awt.Color;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.PrintWriter;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitivePort
implements PortProto,
Comparable<PrimitivePort>,
Serializable {
    private PrimitivePortId portId;
    private final Name name;
    private final PrimitiveNode parent;
    private final int portIndex;
    private ArcProto[] portArcs;
    private EdgeH left;
    private EdgeV bottom;
    private EdgeH right;
    private EdgeV top;
    private PortCharacteristic characteristic;
    private int angle;
    private int angleRange;
    private int portTopology;
    private boolean isolated;
    private boolean negatable;

    private PrimitivePort(Technology tech, PrimitiveNode parent, ArcProto[] portArcs, String protoName, int portAngle, int portRange, int portTopology, EdgeH left, EdgeV bottom, EdgeH right, EdgeV top) {
        this.name = Name.findName(protoName);
        this.portId = parent.getId().newPortId(this.name.toString());
        this.parent = parent;
        this.portIndex = parent.getNumPorts();
        parent.addPrimitivePort(this);
        if (!Technology.jelibSafeName(protoName)) {
            System.out.println("PrimitivePort name " + protoName + " is not safe to write into JELIB");
        }
        this.setAngle(portAngle);
        this.setAngleRange(portRange);
        this.portTopology = portTopology;
        this.portArcs = portArcs;
        for (ArcProto ap : portArcs) {
            Technology apTech = ap.getTechnology();
            if (apTech == tech || apTech == apTech.generic) continue;
            throw new IllegalArgumentException("portArcs in " + this.name);
        }
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this.top = top;
        this.negatable = false;
    }

    protected Object writeReplace() {
        return new PrimitivePortKey(this);
    }

    public static PrimitivePort newInstance(Technology tech, PrimitiveNode parent, ArcProto[] portArcs, String protoName, int portAngle, int portRange, int portTopology, PortCharacteristic characteristic, EdgeH left, EdgeV bottom, EdgeH right, EdgeV top) {
        if (parent == null) {
            System.out.println("PrimitivePort " + protoName + " has no parent");
        }
        assert (tech == parent.getTechnology());
        if (!(tech instanceof Generic)) {
            Generic generic = tech.generic;
            ArcProto[] realPortArcs = new ArcProto[portArcs.length + 3];
            for (int i = 0; i < portArcs.length; ++i) {
                realPortArcs[i] = portArcs[i];
            }
            realPortArcs[portArcs.length] = generic.universal_arc;
            realPortArcs[portArcs.length + 1] = generic.invisible_arc;
            realPortArcs[portArcs.length + 2] = generic.unrouted_arc;
            portArcs = realPortArcs;
        }
        PrimitivePort pp = new PrimitivePort(tech, parent, portArcs, protoName, portAngle, portRange, portTopology, left, bottom, right, top);
        pp.characteristic = characteristic;
        return pp;
    }

    @Override
    public PrimitivePortId getId() {
        return this.portId;
    }

    PrimitivePortId setEmptyId() {
        assert (this.parent.getNumPorts() == 1);
        this.portId = this.parent.getId().newPortId("");
        return this.portId;
    }

    @Override
    public Name getNameKey() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name.toString();
    }

    @Override
    public PrimitiveNode getParent() {
        return this.parent;
    }

    @Override
    public int getPortIndex() {
        return this.portIndex;
    }

    public void setConnections(ArcProto[] portArcs) {
        this.portArcs = portArcs;
    }

    public ArcProto[] getConnections(TechPool allTechs) {
        if (this.parent.getTechnology().isUniversalConnectivityPort(this)) {
            return allTechs.getUnivList();
        }
        return this.portArcs;
    }

    public ArcProto[] getConnections() {
        if (this.parent.getTechnology().isUniversalConnectivityPort(this)) {
            return EDatabase.theDatabase.getTechPool().getUnivList();
        }
        return this.portArcs;
    }

    public ArcProto getConnection() {
        return this.portArcs[0];
    }

    @Override
    public PrimitivePort getBasePort() {
        return this;
    }

    public EdgeH getLeft() {
        return this.left;
    }

    public EdgeH getRight() {
        return this.right;
    }

    public EdgeV getTop() {
        return this.top;
    }

    public EdgeV getBottom() {
        return this.bottom;
    }

    @Override
    public PortCharacteristic getCharacteristic() {
        return this.characteristic;
    }

    @Override
    public boolean isPower() {
        return this.characteristic == PortCharacteristic.PWR;
    }

    @Override
    public boolean isGround() {
        return this.characteristic == PortCharacteristic.GND;
    }

    public boolean isNamedGround() {
        String name = TextUtils.canonicString(this.getName());
        if (name.indexOf("vss") >= 0) {
            return true;
        }
        if (name.indexOf("gnd") >= 0) {
            return true;
        }
        return name.indexOf("ground") >= 0;
    }

    public int getAngle() {
        return this.angle;
    }

    void setAngle(int angle) {
        this.angle = angle;
    }

    public int getAngleRange() {
        return this.angleRange;
    }

    void setAngleRange(int angleRange) {
        this.angleRange = angleRange;
    }

    public int getTopology() {
        return this.portTopology;
    }

    public void setIsolated() {
        this.isolated = true;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public boolean isNegatable() {
        return this.negatable;
    }

    public void setNegatable(boolean negatable) {
        this.negatable = negatable;
    }

    @Override
    public boolean connectsTo(ArcProto arc) {
        for (int i = 0; i < this.portArcs.length; ++i) {
            if (this.portArcs[i] != arc) continue;
            return true;
        }
        return this.parent.getTechnology().isUniversalConnectivityPort(this);
    }

    public Color getPortColor() {
        Technology tech = this.getParent().getTechnology();
        int numColors = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        for (int i = 0; i < this.portArcs.length; ++i) {
            ArcProto ap = this.portArcs[i];
            if (ap.getTechnology() != tech) continue;
            Layer layer = ap.getLayer(0);
            EGraphics graphics = layer.getGraphics();
            Color layerCol = graphics.getColor();
            r += layerCol.getRed();
            g += layerCol.getGreen();
            b += layerCol.getBlue();
            ++numColors;
        }
        if (numColors == 0) {
            return null;
        }
        return new Color(r / numColors, g / numColors, b / numColors);
    }

    @Override
    public int compareTo(PrimitivePort that) {
        int cmp;
        if (this.parent != that.parent && (cmp = this.parent.compareTo(that.parent)) != 0) {
            return cmp;
        }
        return this.portIndex - that.portIndex;
    }

    public String toString() {
        return "PrimitivePort " + this.getName();
    }

    void dump(PrintWriter out) {
        out.println("\tport " + this.getName() + " angle=" + this.getAngle() + " range=" + this.getAngleRange() + " topology=" + this.getTopology() + " " + (Object)((Object)this.getCharacteristic()));
        out.println("\t\tlm=" + this.left.getMultiplier() + " la=" + this.left.getAdder() + " rm=" + this.right.getMultiplier() + " ra=" + this.right.getAdder() + " bm=" + this.bottom.getMultiplier() + " ba=" + this.bottom.getAdder() + " tm=" + this.top.getMultiplier() + " ta=" + this.top.getAdder());
        out.println("\t\tisolated=" + this.isolated + " negatable=" + this.negatable);
        for (ArcProto ap : this.portArcs) {
            out.println("\t\tportArc " + ap.getName());
        }
    }

    Xml.PrimitivePort makeXml(EPoint minFullSize) {
        Xml.PrimitivePort ppd = new Xml.PrimitivePort();
        ppd.name = this.getName();
        ppd.portAngle = this.getAngle();
        ppd.portRange = this.getAngleRange();
        ppd.portTopology = this.getTopology();
        ppd.lx.k = this.getLeft().getMultiplier() * 2.0;
        ppd.lx.addLambda(DBMath.round(this.getLeft().getAdder() + minFullSize.getLambdaX() * this.getLeft().getMultiplier() * 2.0));
        ppd.hx.k = this.getRight().getMultiplier() * 2.0;
        ppd.hx.addLambda(DBMath.round(this.getRight().getAdder() + minFullSize.getLambdaX() * this.getRight().getMultiplier() * 2.0));
        ppd.ly.k = this.getBottom().getMultiplier() * 2.0;
        ppd.ly.addLambda(DBMath.round(this.getBottom().getAdder() + minFullSize.getLambdaY() * this.getBottom().getMultiplier() * 2.0));
        ppd.hy.k = this.getTop().getMultiplier() * 2.0;
        ppd.hy.addLambda(DBMath.round(this.getTop().getAdder() + minFullSize.getLambdaY() * this.getTop().getMultiplier() * 2.0));
        Technology tech = this.parent.getTechnology();
        for (ArcProto ap : this.getConnections()) {
            if (ap.getTechnology() != tech) continue;
            ppd.portArcs.add(ap.getName());
        }
        return ppd;
    }

    Xml807.PrimitivePort makeXml807(EPoint minFullSize) {
        Xml807.PrimitivePort ppd = new Xml807.PrimitivePort();
        ppd.name = this.getName();
        ppd.portAngle = this.getAngle();
        ppd.portRange = this.getAngleRange();
        ppd.portTopology = this.getTopology();
        ppd.lx.k = this.getLeft().getMultiplier() * 2.0;
        ppd.lx.addLambda(DBMath.round(this.getLeft().getAdder() + minFullSize.getLambdaX() * this.getLeft().getMultiplier() * 2.0));
        ppd.hx.k = this.getRight().getMultiplier() * 2.0;
        ppd.hx.addLambda(DBMath.round(this.getRight().getAdder() + minFullSize.getLambdaX() * this.getRight().getMultiplier() * 2.0));
        ppd.ly.k = this.getBottom().getMultiplier() * 2.0;
        ppd.ly.addLambda(DBMath.round(this.getBottom().getAdder() + minFullSize.getLambdaY() * this.getBottom().getMultiplier() * 2.0));
        ppd.hy.k = this.getTop().getMultiplier() * 2.0;
        ppd.hy.addLambda(DBMath.round(this.getTop().getAdder() + minFullSize.getLambdaY() * this.getTop().getMultiplier() * 2.0));
        Technology tech = this.parent.getTechnology();
        for (ArcProto ap : this.getConnections()) {
            if (ap.getTechnology() != tech) continue;
            ppd.portArcs.add(ap.getName());
        }
        return ppd;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrimitivePortKey
    extends EObjectInputStream.Key<PrimitivePort> {
        public PrimitivePortKey() {
        }

        private PrimitivePortKey(PrimitivePort pp) {
            super(pp);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, PrimitivePort pp) throws IOException {
            out.writeObject(pp.getParent());
            out.writeInt(pp.getId().chronIndex);
        }

        @Override
        public PrimitivePort readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            int chronIndex;
            PrimitiveNode pn = (PrimitiveNode)in.readObject();
            PrimitivePort pp = pn.getPrimitivePortByChronIndex(chronIndex = in.readInt());
            if (pp == null) {
                throw new InvalidObjectException("primitive port not linked");
            }
            return pp;
        }
    }
}

