/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.Snapshot;
import com.sun.electric.database.SnapshotWriter;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.Job;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class StreamClient
extends Client {
    private static final ReentrantLock lock = new ReentrantLock();
    private static final Condition queueChanged = lock.newCondition();
    private static Client.ServerEvent queueTail = new Client.ServerEvent();
    private final SnapshotWriter writer;
    private Snapshot currentSnapshot = EDatabase.serverDatabase().getInitialSnapshot();
    private Snapshot initialSnapshot;
    private final ServerEventDispatcher dispatcher;
    private final ClientReader reader;
    private static final long STACK_SIZE_EVENT = StreamClient.isOSMac() ? 0L : 20480L;
    private static final int STACK_SIZE_READER = StreamClient.isOSMac() ? 0 : 1024;

    StreamClient(int connectionId, InputStream inputStream, OutputStream outputStream, Snapshot initialSnapshot) {
        super(connectionId);
        this.writer = new SnapshotWriter(initialSnapshot.idManager, new DataOutputStream(outputStream));
        this.initialSnapshot = initialSnapshot;
        this.dispatcher = new ServerEventDispatcher();
        this.reader = inputStream != null ? new ClientReader(inputStream) : null;
    }

    void start() {
        this.dispatcher.start();
    }

    protected void dispatchServerEvent(Client.ServerEvent serverEvent) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addEvent(Client.ServerEvent newEvent) {
        lock.lock();
        try {
            assert (StreamClient.queueTail.next == null);
            assert (newEvent.next == null);
            queueTail = StreamClient.queueTail.next = newEvent;
            queueChanged.signalAll();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Client.ServerEvent getQueueTail() {
        lock.lock();
        try {
            Client.ServerEvent serverEvent = queueTail;
            return serverEvent;
        }
        finally {
            lock.unlock();
        }
    }

    void writeSnapshot(Snapshot newSnapshot, boolean undoRedo) throws IOException {
        this.writer.writeByte((byte)1);
        newSnapshot.writeDiffs(this.writer, this.currentSnapshot);
        this.currentSnapshot = newSnapshot;
    }

    void writeEJobEvent(EJob ejob, EJob.State newState, long timeStamp) throws IOException {
        if (ejob.newSnapshot != null && ejob.newSnapshot != this.currentSnapshot) {
            this.writeSnapshot(ejob.newSnapshot, ejob.jobType == Job.Type.UNDO);
        }
        switch (newState) {
            case WAITING: 
            case RUNNING: 
            case SERVER_DONE: {
                this.writer.writeByte((byte)2);
                this.writer.writeInt(ejob.jobId);
                this.writer.writeString(ejob.jobName);
                this.writer.writeString(ejob.jobType.toString());
                this.writer.writeString(newState.toString());
                this.writer.writeLong(timeStamp);
                if (newState == EJob.State.WAITING) {
                    this.writer.writeBoolean(ejob.serializedJob != null);
                    if (ejob.serializedJob != null) {
                        this.writer.writeBytes(ejob.serializedJob);
                    }
                }
                if (newState != EJob.State.SERVER_DONE) break;
                this.writer.writeBytes(ejob.serializedResult);
            }
        }
    }

    void writeString(String s) throws IOException {
        this.writer.writeByte((byte)3);
        this.writer.writeString(s);
    }

    private class ClientReader
    extends Thread {
        private final DataInputStream in;

        private ClientReader(InputStream inputStream) {
            super(null, null, "ClientReader-" + StreamClient.this.connectionId, STACK_SIZE_READER);
            this.in = new DataInputStream(new BufferedInputStream(inputStream));
        }

        public void run() {
            try {
                while (true) {
                    int jobId = this.in.readInt();
                    Job.Type jobType = Job.Type.valueOf(this.in.readUTF());
                    String jobName = this.in.readUTF();
                    int len = this.in.readInt();
                    byte[] bytes = new byte[len];
                    this.in.readFully(bytes);
                    Job.jobManager.addJob(new EJob(StreamClient.this, jobId, jobType, jobName, bytes), false);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    class ServerEventDispatcher
    extends Thread {
        private Client.ServerEvent lastEvent;

        private ServerEventDispatcher() {
            super(null, null, "Dispatcher-" + StreamClient.this.connectionId, STACK_SIZE_EVENT);
            this.lastEvent = StreamClient.getQueueTail();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                if (StreamClient.this.reader != null) {
                    StreamClient.this.reader.start();
                }
                StreamClient.this.writer.writeInt(16);
                StreamClient.this.writeSnapshot(StreamClient.this.initialSnapshot, false);
                StreamClient.this.initialSnapshot = null;
                while (true) {
                    lock.lock();
                    try {
                        while (this.lastEvent.next == null) {
                            queueChanged.await();
                        }
                        this.lastEvent = this.lastEvent.next;
                    }
                    finally {
                        lock.unlock();
                    }
                    this.lastEvent.dispatchOnStreamClient(StreamClient.this);
                    StreamClient.this.writer.flush();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace(System.out);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }
}

