/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.LibId;
import com.sun.electric.database.SnapshotReader;
import com.sun.electric.database.SnapshotWriter;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.variable.Variable;
import java.io.IOException;
import java.net.URL;

public class ImmutableLibrary
extends ImmutableElectricObject {
    public final LibId libId;
    public final URL libFile;
    public final Version version;

    private ImmutableLibrary(LibId libId, URL libFile, Version version, int flags, Variable[] vars) {
        super(vars, flags);
        this.libId = libId;
        this.libFile = libFile;
        this.version = version;
    }

    public static ImmutableLibrary newInstance(LibId libId, URL libFile, Version version) {
        if (libId == null) {
            throw new NullPointerException("libId");
        }
        return new ImmutableLibrary(libId, libFile, version, 0, Variable.NULL_ARRAY);
    }

    public ImmutableLibrary withLibFile(URL libFile) {
        if (this.libFile == libFile) {
            return this;
        }
        if (this.libFile != null && this.libFile.equals(libFile)) {
            return this;
        }
        return new ImmutableLibrary(this.libId, libFile, this.version, this.flags, this.getVars());
    }

    public ImmutableLibrary withVersion(Version version) {
        if (this.version == version) {
            return this;
        }
        if (this.version != null && version != null && this.version.equals(version)) {
            return this;
        }
        return new ImmutableLibrary(this.libId, this.libFile, version, this.flags, this.getVars());
    }

    public ImmutableLibrary withVariable(Variable var) {
        Variable[] vars = this.arrayWithVariable(var.withParam(false));
        if (this.getVars() == vars) {
            return this;
        }
        return new ImmutableLibrary(this.libId, this.libFile, this.version, this.flags, vars);
    }

    public ImmutableLibrary withoutVariable(Variable.Key key) {
        Variable[] vars = this.arrayWithoutVariable(key);
        if (this.getVars() == vars) {
            return this;
        }
        return new ImmutableLibrary(this.libId, this.libFile, this.version, this.flags, vars);
    }

    ImmutableLibrary withRenamedIds(IdMapper idMapper) {
        Variable[] vars = this.arrayWithRenamedIds(idMapper);
        LibId libId = idMapper.get(this.libId);
        if (this.getVars() == vars && this.libId == libId) {
            return this;
        }
        return new ImmutableLibrary(libId, this.libFile, this.version, this.flags, vars);
    }

    public ImmutableLibrary withFlags(int flags) {
        if (this.flags == flags) {
            return this;
        }
        return new ImmutableLibrary(this.libId, this.libFile, this.version, flags, this.getVars());
    }

    void write(SnapshotWriter writer) throws IOException {
        writer.writeLibId(this.libId);
        writer.writeString(this.libFile != null ? this.libFile.toString() : "");
        writer.writeString(this.version != null ? this.version.toString() : "");
        writer.writeInt(this.flags);
        super.write(writer);
    }

    static ImmutableLibrary read(SnapshotReader reader) throws IOException {
        LibId libId = reader.readLibId();
        String libFileString = reader.readString();
        URL libFile = libFileString.length() > 0 ? new URL(libFileString) : null;
        String versionString = reader.readString();
        Version version = versionString.length() > 0 ? Version.parseVersion(versionString) : null;
        int flags = reader.readInt();
        boolean hasVars = reader.readBoolean();
        Variable[] vars = hasVars ? ImmutableLibrary.readVars(reader) : Variable.NULL_ARRAY;
        return new ImmutableLibrary(libId, libFile, version, flags, vars);
    }

    public int hashCodeExceptVariables() {
        return this.libId.hashCode();
    }

    public boolean equalsExceptVariables(ImmutableElectricObject o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableLibrary)) {
            return false;
        }
        ImmutableLibrary that = (ImmutableLibrary)o;
        return this.libId == that.libId && this.libFile == that.libFile && this.version == that.version && this.flags == that.flags;
    }

    public String toString() {
        return this.libId.toString();
    }

    public void check() {
        this.check(false);
        assert (this.libId != null);
    }
}

