/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fill;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.Tech;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FillRouter {
    private HashMap<String, List<PortInst>> portMap = new HashMap();

    private String makeKey(PortInst pi) {
        EPoint center = pi.getCenter();
        String x = "" + center.getX();
        String y = "" + center.getY();
        return x + "x" + y;
    }

    private ArcProto findCommonArc(PortInst p1, PortInst p2) {
        ArcProto[] metals = new ArcProto[]{Tech.m6, Tech.m5, Tech.m4, Tech.m3, Tech.m2, Tech.m1};
        PortProto pp1 = p1.getPortProto();
        PortProto pp2 = p2.getPortProto();
        for (int i = 0; i < metals.length; ++i) {
            if (!pp1.connectsTo(metals[i]) || !pp2.connectsTo(metals[i])) continue;
            return metals[i];
        }
        return null;
    }

    private void connectPorts(List<PortInst> ports) {
        Iterator<PortInst> it = ports.iterator();
        while (it.hasNext()) {
            PortInst first = it.next();
            double width = LayoutLib.widestWireWidth(first);
            it.remove();
            for (PortInst pi : ports) {
                ArcProto a = this.findCommonArc(first, pi);
                if (a == null) continue;
                LayoutLib.newArcInst(a, width, first, pi);
            }
        }
    }

    private FillRouter(ArrayList<PortInst> ports) {
        for (PortInst pi : ports) {
            String key = this.makeKey(pi);
            List<PortInst> l = this.portMap.get(key);
            if (l == null) {
                l = new LinkedList<PortInst>();
                this.portMap.put(key, l);
            }
            l.add(pi);
        }
        for (String str : this.portMap.keySet()) {
            this.connectPorts(this.portMap.get(str));
        }
    }

    public static void connectCoincident(ArrayList<PortInst> ports) {
        new FillRouter(ports);
    }
}

