/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool;

import com.sun.electric.database.Snapshot;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.Client;
import com.sun.electric.tool.EJob;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.ServerJobManager;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.User;
import java.util.ArrayList;
import java.util.logging.Level;

class EThread
extends Thread {
    private static final String CLASS_NAME = EThread.class.getName();
    private static final ArrayList<Snapshot> snapshotCache = new ArrayList();
    private static int maximumSnapshots = User.getMaxUndoHistory();
    EJob ejob;
    EDatabase database;
    private final UserInterface userInterface = new ServerJobManager.UserInterfaceRedirect();

    EThread(int id) {
        super("EThread-" + id);
        Job.logger.logp(Level.FINER, CLASS_NAME, "constructor", this.getName());
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Job.logger.logp(Level.FINE, CLASS_NAME, "run", this.getName());
        EJob finishedEJob = null;
        while (true) {
            this.ejob = Job.jobManager.selectEJob(finishedEJob);
            Job.logger.logp(Level.FINER, CLASS_NAME, "run", "selectedJob {0}", this.ejob.jobName);
            this.database = this.ejob.jobType != Job.Type.EXAMINE ? EDatabase.serverDatabase() : EDatabase.clientDatabase();
            this.ejob.changedFields = new ArrayList();
            Object jobException = null;
            this.database.lock(!this.ejob.isExamine());
            this.ejob.oldSnapshot = this.database.backup();
            try {
                Throwable e;
                if (this.ejob.jobType != Job.Type.EXAMINE && !this.ejob.startedByServer && (e = this.ejob.deserializeToServer()) != null) {
                    throw e;
                }
                switch (this.ejob.jobType) {
                    case CHANGE: {
                        this.database.lowLevelBeginChanging(this.ejob.serverJob.tool);
                        this.database.getNetworkManager().startBatch();
                        Constraints.getCurrent().startBatch(this.ejob.oldSnapshot);
                        if (!this.ejob.serverJob.doIt()) {
                            throw new JobException("job " + this.ejob.jobName + " returned false");
                        }
                        Constraints.getCurrent().endBatch(this.ejob.client.userName);
                        this.database.getNetworkManager().endBatch();
                        this.database.lowLevelEndChanging();
                        this.ejob.newSnapshot = this.database.backup();
                        break;
                    }
                    case UNDO: {
                        this.database.lowLevelSetCanUndoing(true);
                        this.database.getNetworkManager().startBatch();
                        int snapshotId = ((Undo.UndoJob)this.ejob.serverJob).getSnapshotId();
                        Snapshot undoSnapshot = EThread.findInCache(snapshotId);
                        if (undoSnapshot == null) {
                            throw new JobException("Snapshot " + snapshotId + " not found");
                        }
                        this.database.undo(undoSnapshot);
                        this.database.getNetworkManager().endBatch();
                        this.database.lowLevelSetCanUndoing(false);
                        break;
                    }
                    case REMOTE_EXAMINE: {
                        if (this.ejob.serverJob.doIt()) break;
                        throw new JobException("job " + this.ejob.jobName + " returned false");
                    }
                    case EXAMINE: {
                        Throwable e2;
                        if (this.ejob.startedByServer && (e2 = this.ejob.deserializeToClient()) != null) {
                            throw e2;
                        }
                        if (this.ejob.clientJob.doIt()) break;
                        throw new JobException("job " + this.ejob.jobName + " returned false");
                    }
                }
                this.ejob.serializeResult(this.database);
                this.ejob.newSnapshot = this.database.backup();
            }
            catch (Throwable e) {
                e.getStackTrace();
                e.printStackTrace();
                if (!this.ejob.isExamine()) {
                    this.recoverDatabase(e instanceof JobException);
                    this.database.lowLevelEndChanging();
                    this.database.lowLevelSetCanUndoing(false);
                }
                this.ejob.serializeExceptionResult(e, this.database);
            }
            finally {
                this.database.unlock();
            }
            EThread.putInCache(this.ejob.oldSnapshot, this.ejob.newSnapshot);
            finishedEJob = this.ejob;
            this.ejob = null;
            this.database = null;
            Job.logger.logp(Level.FINER, CLASS_NAME, "run", "finishedJob {0}", finishedEJob.jobName);
        }
    }

    private void recoverDatabase(boolean quick) {
        this.database.lowLevelSetCanUndoing(true);
        try {
            if (quick) {
                this.database.undo(this.ejob.oldSnapshot);
            } else {
                this.database.recover(this.ejob.oldSnapshot);
            }
            this.database.getNetworkManager().endBatch();
            this.ejob.newSnapshot = this.ejob.oldSnapshot;
            return;
        }
        catch (Throwable e) {
            ActivityLogger.logException(e);
            while (true) {
                try {
                    Snapshot snapshot = EThread.findValidSnapshot();
                    this.database.recover(snapshot);
                    this.database.getNetworkManager().endBatch();
                    this.ejob.newSnapshot = snapshot;
                    return;
                }
                catch (Throwable e2) {
                    ActivityLogger.logException(e2);
                    continue;
                }
                break;
            }
        }
    }

    UserInterface getUserInterface() {
        return this.userInterface;
    }

    void print(String str) {
        Client client = this.ejob != null ? this.ejob.client : null;
        Client.print(client, str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Snapshot findValidSnapshot() {
        while (true) {
            Snapshot snapshot;
            ArrayList<Snapshot> arrayList = snapshotCache;
            synchronized (arrayList) {
                if (snapshotCache.isEmpty()) {
                    return EDatabase.serverDatabase().getInitialSnapshot();
                }
                snapshot = snapshotCache.remove(snapshotCache.size() - 1);
            }
            try {
                snapshot.check();
                return snapshot;
            }
            catch (Throwable e) {
                ActivityLogger.logException(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Snapshot findInCache(int snapshotId) {
        ArrayList<Snapshot> arrayList = snapshotCache;
        synchronized (arrayList) {
            for (int i = snapshotCache.size() - 1; i >= 0; --i) {
                Snapshot snapshot = snapshotCache.get(i);
                if (snapshot.snapshotId != snapshotId) continue;
                return snapshot;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putInCache(Snapshot oldSnapshot, Snapshot newSnapshot) {
        ArrayList<Snapshot> arrayList = snapshotCache;
        synchronized (arrayList) {
            if (!snapshotCache.contains(newSnapshot)) {
                while (!snapshotCache.isEmpty() && snapshotCache.get(snapshotCache.size() - 1) != oldSnapshot) {
                    snapshotCache.remove(snapshotCache.size() - 1);
                }
                snapshotCache.add(newSnapshot);
            }
            while (snapshotCache.size() > maximumSnapshots) {
                snapshotCache.remove(0);
            }
        }
    }

    public static int setHistoryListSize(int newSize) {
        if (newSize <= 0) {
            return maximumSnapshots;
        }
        int oldSize = maximumSnapshots;
        maximumSnapshots = newSize;
        while (snapshotCache.size() > maximumSnapshots) {
            snapshotCache.remove(0);
        }
        return oldSize;
    }
}

