/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.Aborter;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.NccRandom;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.netlist.NccNetlist;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import com.sun.electric.tool.ncc.trees.LeafEquivRecords;
import com.sun.electric.tool.user.ncc.NccComparisonMismatches;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NccGlobals {
    private static final int CODE_PART = 0;
    private static final int CODE_WIRE = 1;
    private static final int CODE_PORT = 2;
    private NccRandom randGen = new NccRandom();
    private final NccOptions options;
    private final Aborter aborter;
    private EquivRecord root;
    private EquivRecord parts;
    private EquivRecord wires;
    private EquivRecord ports;
    private Cell[] rootCells;
    private VarContext[] rootContexts;
    public int passNumber;
    private LeafEquivRecords partLeafRecs;
    private LeafEquivRecords wireLeafRecs;
    private LeafEquivRecords portLeafRecs;
    private boolean[] cantBuildNetlist;
    private boolean hashFailuresPrinted = false;
    private NccComparisonMismatches compMismatches;

    private List getNetObjs(int code, NccNetlist nets) {
        switch (code) {
            case 0: {
                return nets.getPartArray();
            }
            case 1: {
                return nets.getWireArray();
            }
            case 2: {
                return nets.getPortArray();
            }
        }
        this.error("invalid code");
        return null;
    }

    private void countNetObjs(int[] counts, Iterator it) {
        while (it.hasNext()) {
            EquivRecord er = (EquivRecord)it.next();
            this.error(!er.isLeaf(), "Must be leaf");
            int numCkts = er.numCircuits();
            this.error(counts.length != numCkts, "different number of Circuits");
            Iterator it2 = er.getCircuits();
            int i = 0;
            while (i < numCkts) {
                int n = i++;
                counts[n] = counts[n] + ((Circuit)it2.next()).numNetObjs();
            }
        }
    }

    private int[] getNetObjCounts(LeafEquivRecords leaves) {
        int[] counts = new int[this.getNumNetlistsBeingCompared()];
        this.countNetObjs(counts, leaves.getMatched());
        this.countNetObjs(counts, leaves.getNotMatched());
        return counts;
    }

    private EquivRecord buildEquivRec(int code, List nccNets) {
        boolean atLeastOneNetObj = false;
        ArrayList<Circuit> ckts = new ArrayList<Circuit>();
        Iterator it = nccNets.iterator();
        while (it.hasNext()) {
            NccNetlist nets = (NccNetlist)it.next();
            List netObjs = this.getNetObjs(code, nets);
            if (netObjs.size() != 0) {
                atLeastOneNetObj = true;
            }
            ckts.add(Circuit.please(netObjs));
        }
        if (!atLeastOneNetObj) {
            return null;
        }
        return EquivRecord.newLeafRecord(code, ckts, this);
    }

    public NccGlobals(NccOptions options, Aborter aborter) {
        this.options = options;
        this.aborter = aborter;
        this.compMismatches = new NccComparisonMismatches();
    }

    public void prln(String s) {
        System.out.println(s);
        System.out.flush();
    }

    public void pr(String s) {
        System.out.print(s);
        System.out.flush();
    }

    public void setInitialNetlists(List nccNets) {
        this.parts = this.buildEquivRec(0, nccNets);
        this.wires = this.buildEquivRec(1, nccNets);
        this.ports = this.buildEquivRec(2, nccNets);
        ArrayList<EquivRecord> el = new ArrayList<EquivRecord>();
        if (this.parts != null) {
            el.add(this.parts);
        }
        if (this.wires != null) {
            el.add(this.wires);
        }
        if (this.ports != null) {
            el.add(this.ports);
        }
        this.root = EquivRecord.newRootRecord(el);
        this.rootCells = new Cell[nccNets.size()];
        this.rootContexts = new VarContext[nccNets.size()];
        this.cantBuildNetlist = new boolean[nccNets.size()];
        int i = 0;
        Iterator it = nccNets.iterator();
        while (it.hasNext()) {
            NccNetlist nl = (NccNetlist)it.next();
            this.rootCells[i] = nl.getRootCell();
            this.rootContexts[i] = nl.getRootContext();
            this.cantBuildNetlist[i] = nl.cantBuildNetlist();
            ++i;
        }
    }

    public void initLeafLists() {
        this.partLeafRecs = new LeafEquivRecords(this.parts, this);
        this.wireLeafRecs = new LeafEquivRecords(this.wires, this);
        this.portLeafRecs = new LeafEquivRecords(this.ports, this);
    }

    public EquivRecord getRoot() {
        return this.root;
    }

    public EquivRecord getParts() {
        return this.parts;
    }

    public EquivRecord getWires() {
        return this.wires;
    }

    public EquivRecord getPorts() {
        return this.ports;
    }

    public int getNumNetlistsBeingCompared() {
        return this.rootCells.length;
    }

    public Cell[] getRootCells() {
        return this.rootCells;
    }

    public VarContext[] getRootContexts() {
        return this.rootContexts;
    }

    public String[] getRootCellNames() {
        String[] rootCellNames = new String[this.rootCells.length];
        for (int i = 0; i < this.rootCells.length; ++i) {
            rootCellNames[i] = NccUtils.fullName(this.rootCells[i]);
        }
        return rootCellNames;
    }

    public void status1(String msg) {
        if (this.options.howMuchStatus >= 1) {
            this.prln(msg);
        }
    }

    public void status2(String msg) {
        if (this.options.howMuchStatus >= 2) {
            this.prln(msg);
        }
    }

    public void flush() {
        System.out.flush();
    }

    public void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public void error(String msg) {
        LayoutLib.error(true, msg);
    }

    public NccOptions getOptions() {
        return this.options;
    }

    public int getRandom() {
        return this.randGen.next();
    }

    public LeafEquivRecords getPartLeafEquivRecs() {
        return this.partLeafRecs;
    }

    public LeafEquivRecords getWireLeafEquivRecs() {
        return this.wireLeafRecs;
    }

    public LeafEquivRecords getPortLeafEquivRecs() {
        return this.portLeafRecs;
    }

    public HierarchyEnumerator.NetNameProxy[][] getEquivalentNets() {
        int numDes = this.getNumNetlistsBeingCompared();
        HierarchyEnumerator.NetNameProxy[][] equivNets = new HierarchyEnumerator.NetNameProxy[numDes][];
        int numMatched = this.wireLeafRecs.numMatched();
        for (int i = 0; i < numDes; ++i) {
            equivNets[i] = new HierarchyEnumerator.NetNameProxy[numMatched];
        }
        int wireNdx = 0;
        Iterator it = this.wireLeafRecs.getMatched();
        while (it.hasNext()) {
            EquivRecord er = (EquivRecord)it.next();
            int cktNdx = 0;
            Iterator cit = er.getCircuits();
            while (cit.hasNext()) {
                Circuit ckt = (Circuit)cit.next();
                LayoutLib.error(ckt.numNetObjs() != 1, "not matched?");
                Wire w = (Wire)ckt.getNetObjs().next();
                equivNets[cktNdx][wireNdx] = w.getNameProxy().getNetNameProxy();
                ++cktNdx;
            }
            ++wireNdx;
        }
        return equivNets;
    }

    public NccComparisonMismatches getComparisonResult() {
        return this.compMismatches;
    }

    public boolean cantBuildNetlist() {
        for (int i = 0; i < this.cantBuildNetlist.length; ++i) {
            if (!this.cantBuildNetlist[i]) continue;
            return true;
        }
        return false;
    }

    public boolean[] cantBuildNetlistBits() {
        return this.cantBuildNetlist;
    }

    public void setPrintHashFailures(boolean b) {
        this.hashFailuresPrinted = b;
    }

    public boolean isPrintHashFailures() {
        return this.hashFailuresPrinted;
    }

    public int[] getPartCounts() {
        return this.getNetObjCounts(this.partLeafRecs);
    }

    public int[] getWireCounts() {
        return this.getNetObjCounts(this.wireLeafRecs);
    }

    public int[] getPortCounts() {
        return this.getNetObjCounts(this.portLeafRecs);
    }

    public boolean userWantsToAbort() {
        return this.aborter.userWantsToAbort();
    }
}

