/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class ArcInst
extends Geometric {
    public static final int HEADEND = 0;
    public static final int TAILEND = 1;
    public static final Variable.Key ARC_NAME = ElectricObject.newKey("ARC_name");
    public static final Variable.Key ARC_RADIUS = ElectricObject.newKey("ARC_radius");
    static final double MINPORTDISTANCE = DBMath.getEpsilon() * 0.71;
    private static final int FIXED = 1;
    private static final int FIXANG = 2;
    private static final int AANGLE = 16352;
    private static final int AANGLESH = 5;
    private static final int NOEXTEND = 131072;
    private static final int ISDIRECTIONAL = 524288;
    private static final int NOTEND0 = 0x100000;
    private static final int NOTEND1 = 0x200000;
    private static final int REVERSEEND = 0x400000;
    private static final int CANTSLIDE = 0x800000;
    private static final int FIXEDMOD = 0x1000000;
    private static final int HARDSELECTA = Integer.MIN_VALUE;
    private static final Name BASENAME = Name.findName("net@");
    private double width;
    private double length;
    private ArcProto protoType;
    private Connection[] ends;
    private int arcIndex = -1;
    private int angle;
    private static final int MAXARCPIECES = 16;
    private static int[] extendFactor = new int[]{0, 11459, 5729, 3819, 2864, 2290, 1908, 1635, 1430, 1271, 1143, 1039, 951, 878, 814, 760, 712, 669, 631, 598, 567, 540, 514, 492, 470, 451, 433, 417, 401, 387, 373, 361, 349, 338, 327, 317, 308, 299, 290, 282, 275, 267, 261, 254, 248, 241, 236, 230, 225, 219, 214, 210, 205, 201, 196, 192, 188, 184, 180, 177, 173, 170, 166, 163, 160, 157, 154, 151, 148, 146, 143, 140, 138, 135, 133, 130, 128, 126, 123, 121, 119, 117, 115, 113, 111, 109, 107, 105, 104, 102, 100};
    private static final int MAXANGLES = 3;
    private static int[] shortAngles = new int[3];

    private ArcInst() {
    }

    public static ArcInst makeInstance(ArcProto type, double width, PortInst head, PortInst tail) {
        ArcInst ai = ArcInst.newInstance(type, width, head, tail);
        if (ai != null) {
            ai.setDefaultConstraints();
        }
        return ai;
    }

    public static ArcInst makeInstance(ArcProto type, double width, PortInst head, PortInst tail, Point2D headPt, Point2D tailPt, String name) {
        ArcInst ai = ArcInst.newInstance(type, width, head, tail, headPt, tailPt, name, 0);
        if (ai != null) {
            ai.setDefaultConstraints();
        }
        return ai;
    }

    public static ArcInst makeDummyInstance(PrimitiveArc ap, double arcLength) {
        PrimitiveNode npEnd = ap.findPinProto();
        if (npEnd == null) {
            System.out.println("Cannot find pin for arc " + ap.describe());
            return null;
        }
        NodeInst niH = NodeInst.lowLevelAllocate();
        niH.lowLevelPopulate(npEnd, new Point2D.Double(-arcLength / 2.0, 0.0), npEnd.getDefWidth(), npEnd.getDefHeight(), 0, null);
        PortInst piH = niH.getOnlyPortInst();
        Rectangle2D boundsH = piH.getBounds();
        double xH = boundsH.getCenterX();
        double yH = boundsH.getCenterY();
        NodeInst niT = NodeInst.lowLevelAllocate();
        niT.lowLevelPopulate(npEnd, new Point2D.Double(arcLength / 2.0, 0.0), npEnd.getDefWidth(), npEnd.getDefHeight(), 0, null);
        PortInst piT = niT.getOnlyPortInst();
        Rectangle2D boundsT = piT.getBounds();
        double xT = boundsT.getCenterX();
        double yT = boundsT.getCenterY();
        ArcInst ai = ArcInst.lowLevelAllocate();
        ai.lowLevelPopulate(ap, ap.getDefaultWidth(), piH, new Point2D.Double(xH, yH), piT, new Point2D.Double(xT, yT), 0);
        return ai;
    }

    public static ArcInst newInstance(ArcProto type, double width, PortInst head, PortInst tail) {
        return ArcInst.newInstance(type, width, head, tail, null, null, null, 0);
    }

    public static ArcInst newInstance(ArcProto type, double width, PortInst head, PortInst tail, Point2D headPt, Point2D tailPt, String name, int defAngle) {
        if (headPt == null) {
            Rectangle2D headBounds = head.getBounds();
            headPt = new Point2D.Double(headBounds.getCenterX(), headBounds.getCenterY());
        }
        if (tailPt == null) {
            Rectangle2D tailBounds = tail.getBounds();
            tailPt = new Point2D.Double(tailBounds.getCenterX(), tailBounds.getCenterY());
        }
        if (type == null || head == null || tail == null) {
            return null;
        }
        ArcInst ai = ArcInst.lowLevelAllocate();
        if (ai.lowLevelPopulate(type, width, head, headPt, tail, tailPt, defAngle)) {
            return null;
        }
        if (!ai.stillInPort(ai.getHead(), headPt, false) && !ai.stillInPort(ai.getHead(), headPt, false)) {
            Cell parent = head.getNodeInst().getParent();
            Poly poly = ai.getHead().getPortInst().getPoly();
            System.out.println("Error in cell " + parent.describe() + ": head of " + type.getName() + " arc at (" + headPt.getX() + "," + headPt.getY() + ") does not fit in port " + ai.getHead().getPortInst().describe() + " which is centered at (" + poly.getCenterX() + "," + poly.getCenterY() + ")");
            return null;
        }
        if (!ai.stillInPort(ai.getTail(), tailPt, false) && !ai.stillInPort(ai.getTail(), tailPt, false)) {
            Cell parent = tail.getNodeInst().getParent();
            Poly poly = ai.getTail().getPortInst().getPoly();
            System.out.println("Error in cell " + parent.describe() + ": tail of " + type.getName() + " arc at (" + tailPt.getX() + "," + tailPt.getY() + ") does not fit in port " + ai.getTail().getPortInst().describe() + " which is centered at (" + poly.getCenterX() + "," + poly.getCenterY() + ")");
            return null;
        }
        if (name != null) {
            ai.setName(name);
        }
        if (ai.lowLevelLink()) {
            return null;
        }
        Undo.newObject(ai);
        return ai;
    }

    public void kill() {
        this.lowLevelUnlink();
        Undo.killObject(this);
    }

    public void modify(double dWidth, double dHeadX, double dHeadY, double dTailX, double dTailY) {
        double oldxA = this.ends[0].getLocation().getX();
        double oldyA = this.ends[0].getLocation().getY();
        double oldxB = this.ends[1].getLocation().getX();
        double oldyB = this.ends[1].getLocation().getY();
        double oldWidth = this.getWidth();
        this.lowLevelModify(dWidth, dHeadX, dHeadY, dTailX, dTailY);
        Undo.modifyArcInst(this, oldxA, oldyA, oldxB, oldyB, oldWidth);
    }

    public ArcInst replace(ArcProto ap) {
        Connection head = this.getHead();
        Connection tail = this.getTail();
        PortInst piH = head.getPortInst();
        PortInst piT = tail.getPortInst();
        if (!piH.getPortProto().connectsTo(ap) || !piT.getPortProto().connectsTo(ap)) {
            System.out.println("Cannot replace arc " + this.describe() + " with one of type " + ap.getName() + " because the nodes cannot connect to it");
            return null;
        }
        double newwid = this.getWidth() - this.getProto().getWidthOffset() + ap.getWidthOffset();
        ArcInst newar = ArcInst.newInstance(ap, newwid, piH, piT, head.getLocation(), tail.getLocation(), null, 0);
        if (newar == null) {
            System.out.println("Cannot replace arc " + this.describe() + " with one of type " + ap.getName() + " because the new arc failed to create");
            return null;
        }
        newar.copyPropertiesFrom(this);
        this.kill();
        newar.setName(this.getName());
        return newar;
    }

    public static ArcInst lowLevelAllocate() {
        ArcInst ai = new ArcInst();
        ai.ends = new Connection[2];
        return ai;
    }

    public boolean lowLevelPopulate(ArcProto protoType, double width, PortInst headPort, Point2D headPt, PortInst tailPort, Point2D tailPt, int defAngle) {
        this.protoType = protoType;
        if (width < 0.0) {
            width = protoType.getWidth();
        }
        this.width = DBMath.round(width);
        headPt.setLocation(DBMath.round(headPt.getX()), DBMath.round(headPt.getY()));
        tailPt.setLocation(DBMath.round(tailPt.getX()), DBMath.round(tailPt.getY()));
        Cell parent = headPort.getNodeInst().getParent();
        if (parent != tailPort.getNodeInst().getParent()) {
            System.out.println("ArcProto.newInst: the 2 PortInsts are in different Cells!");
            return true;
        }
        this.parent = parent;
        PortProto headProto = headPort.getPortProto();
        PrimitivePort headPrimPort = headProto.getBasePort();
        if (!headPrimPort.connectsTo(protoType)) {
            System.out.println("Cannot create " + protoType.describe() + " arc in cell " + parent.describe() + " because it cannot connect to port " + headProto.getName());
            return true;
        }
        PortProto tailProto = tailPort.getPortProto();
        PrimitivePort tailPrimPort = tailProto.getBasePort();
        if (!tailPrimPort.connectsTo(protoType)) {
            System.out.println("Cannot create " + protoType.describe() + " arc in cell " + parent.describe() + " because it cannot connect to port " + tailProto.getName());
            return true;
        }
        this.ends[0] = new Connection(this, headPort, headPt);
        this.ends[1] = new Connection(this, tailPort, tailPt);
        this.updateGeometric(defAngle);
        return false;
    }

    public boolean lowLevelLink() {
        if (!(this.isUsernamed() || this.getName() != null && this.parent.isUniqueName(this.name, this.getClass(), (ElectricObject)this) || !this.setNameKey(this.parent.getAutoname(BASENAME)))) {
            return true;
        }
        if (this.ends[0] != null) {
            this.ends[0].getPortInst().getNodeInst().addConnection(this.ends[0]);
        }
        if (this.ends[1] != null) {
            this.ends[1].getPortInst().getNodeInst().addConnection(this.ends[1]);
        }
        this.linkGeom(this.parent);
        this.parent.addArc(this);
        for (int k = 0; k < 2; ++k) {
            this.updateShrinkage(this.ends[k].getPortInst().getNodeInst());
        }
        return false;
    }

    public void lowLevelUnlink() {
        this.ends[0].getPortInst().getNodeInst().removeConnection(this.ends[0]);
        this.ends[1].getPortInst().getNodeInst().removeConnection(this.ends[1]);
        this.unLinkGeom(this.parent);
        this.parent.removeArc(this);
        for (int k = 0; k < 2; ++k) {
            this.updateShrinkage(this.ends[k].getPortInst().getNodeInst());
        }
    }

    public void lowLevelModify(double dWidth, double dHeadX, double dHeadY, double dTailX, double dTailY) {
        Point2D pt;
        this.unLinkGeom(this.parent);
        this.width = DBMath.round(this.width + dWidth);
        if (dHeadX != 0.0 || dHeadY != 0.0) {
            pt = this.ends[0].getLocation();
            this.ends[0].setLocation(new Point2D.Double(DBMath.round(dHeadX + pt.getX()), DBMath.round(pt.getY() + dHeadY)));
        }
        if (dTailX != 0.0 || dTailY != 0.0) {
            pt = this.ends[1].getLocation();
            this.ends[1].setLocation(new Point2D.Double(DBMath.round(dTailX + pt.getX()), DBMath.round(pt.getY() + dTailY)));
        }
        this.updateGeometric(this.getAngle());
        for (int k = 0; k < 2; ++k) {
            this.updateShrinkage(this.ends[k].getPortInst().getNodeInst());
        }
        this.linkGeom(this.parent);
    }

    public double getWidth() {
        return this.width;
    }

    public double getLength() {
        return this.length;
    }

    public int getAngle() {
        return this.angle;
    }

    public void setAngle(int angle) {
        this.angle = angle;
    }

    public Poly makePoly(double length, double width, Poly.Type style) {
        Poly poly;
        Poly curvedPoly;
        if (this.protoType.isCurvable() && (curvedPoly = this.curvedArcOutline(style, width)) != null) {
            return curvedPoly;
        }
        Point2D endH = this.ends[0].getLocation();
        Point2D endT = this.ends[1].getLocation();
        if (width == 0.0) {
            Poly poly2 = new Poly(new Point2D.Double[]{new Point2D.Double(endH.getX(), endH.getY()), new Point2D.Double(endT.getX(), endT.getY())});
            if (style == Poly.Type.FILLED) {
                style = Poly.Type.OPENED;
            }
            poly2.setStyle(style);
            return poly2;
        }
        double extendH = width / 2.0;
        int headShrink = this.getHead().getEndShrink();
        if (headShrink != 0) {
            extendH = ArcInst.getExtendFactor(width, headShrink);
        }
        double extendT = width / 2.0;
        int tailShrink = this.getTail().getEndShrink();
        if (tailShrink != 0) {
            extendT = ArcInst.getExtendFactor(width, tailShrink);
        }
        if (!this.isExtended()) {
            if (!this.isSkipTail()) {
                extendH = 0.0;
            }
            if (!this.isSkipHead()) {
                extendT = 0.0;
            }
        }
        if ((poly = Poly.makeEndPointPoly(length, width, this.getAngle(), endH, extendH, endT, extendT)) != null) {
            poly.setStyle(style);
        }
        return poly;
    }

    public Double getRadius() {
        Variable var = this.getVar(ARC_RADIUS);
        if (var == null) {
            return null;
        }
        Object obj = var.getObject();
        if (obj instanceof Integer) {
            return new Double((double)((Integer)obj).intValue() / 2000.0);
        }
        if (obj instanceof Double) {
            return new Double((Double)obj);
        }
        return null;
    }

    public Poly curvedArcOutline(Poly.Type style, double wid) {
        int pieces;
        Point2D tailPt;
        Point2D headPt;
        double length;
        Double radiusDouble = this.getRadius();
        if (radiusDouble == null) {
            return null;
        }
        double radius = radiusDouble;
        double pureRadius = Math.abs(radius);
        if (pureRadius * 2.0 < (length = (headPt = this.getTail().getLocation()).distance(tailPt = this.getHead().getLocation()))) {
            return null;
        }
        Point2D[] centers = DBMath.findCenters(pureRadius, headPt, tailPt, length);
        if (centers == null) {
            return null;
        }
        Point2D centerPt = centers[1];
        if (radius < 0.0) {
            radius = -radius;
            centerPt = centers[0];
        }
        int angleBase = DBMath.figureAngle(centerPt, headPt);
        int angleRange = DBMath.figureAngle(centerPt, tailPt);
        if (this.isReverseEnds()) {
            int i = angleBase;
            angleBase = angleRange;
            angleRange = i;
        }
        if ((angleRange -= angleBase) < 0) {
            angleRange += 3600;
        }
        for (pieces = angleRange; pieces > 16; pieces /= 2) {
        }
        int points = (pieces + 1) * 2;
        Point2D[] pointArray = new Point2D[points];
        double outerRadius = radius + wid / 2.0;
        double innerRadius = outerRadius - wid;
        for (int i = 0; i <= pieces; ++i) {
            int a = (angleBase + i * angleRange / pieces) % 3600;
            double sin = DBMath.sin(a);
            double cos = DBMath.cos(a);
            pointArray[i] = new Point2D.Double(cos * innerRadius + centerPt.getX(), sin * innerRadius + centerPt.getY());
            pointArray[points - 1 - i] = new Point2D.Double(cos * outerRadius + centerPt.getX(), sin * outerRadius + centerPt.getY());
        }
        Poly poly = new Poly(pointArray);
        poly.setStyle(style);
        return poly;
    }

    public Poly[] getAllText(boolean hardToSelect, EditWindow wnd) {
        int dispVars = this.numDisplayableVariables(false);
        int totalText = dispVars;
        if (totalText == 0) {
            return null;
        }
        Poly[] polys = new Poly[totalText];
        this.addDisplayableVariables(this.getBounds(), polys, 0, wnd, false);
        return polys;
    }

    public static double getExtendFactor(double width, int extend) {
        if (extend <= 0) {
            return width / 2.0;
        }
        if (extend > 90) {
            return width / 2.0;
        }
        return width * 50.0 / (double)extendFactor[extend];
    }

    private void updateShrinkage(NodeInst ni) {
        ni.clearShortened();
        Iterator it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            short shrink = this.checkShortening(ni, con.getPortInst().getPortProto());
            if (shrink != 0) {
                ni.setShortened();
            }
            con.setEndShrink(shrink);
        }
    }

    private short checkShortening(NodeInst ni, PortProto pp) {
        NodeProto np = ni.getProto();
        if (!(np instanceof PrimitiveNode)) {
            return 0;
        }
        PrimitiveNode pn = (PrimitiveNode)np;
        if (!pn.canShrink() && !pn.isArcsShrink()) {
            return 0;
        }
        int total = 0;
        int off90 = 0;
        Iterator it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            ArcInst ai = con.getArc();
            if (ai.getWidth() == 0.0 || !pn.isArcsShrink() && con.getPortInst().getPortProto() != pp) continue;
            int ang = ai.getAngle() / 10;
            if (ai.getHead() == con) {
                ang += 180;
            }
            if ((ang %= 360) % 90 != 0) {
                ++off90;
            }
            if (total >= 3) break;
            ArcInst.shortAngles[total++] = ang;
        }
        if (pn.canShrink()) {
            PrimitivePort pRp = (PrimitivePort)pp;
            int ang = pRp.getAngle();
            ang += (ni.getAngle() + 5) / 10;
            if ((ang = (ang + 180) % 360) % 90 != 0) {
                ++off90;
            }
            if (total < 3) {
                ArcInst.shortAngles[total++] = ang;
            }
        }
        if (off90 == 0) {
            return 0;
        }
        if (total != 2) {
            return 0;
        }
        int ang = Math.abs(shortAngles[1] - shortAngles[0]);
        if (ang > 180) {
            ang = 360 - ang;
        }
        if (ang > 90) {
            ang = 180 - ang;
        }
        return (short)ang;
    }

    private void updateGeometric(int defAngle) {
        this.checkChanging();
        Point2D p1 = this.ends[1].getLocation();
        Point2D p2 = this.ends[0].getLocation();
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        this.length = Math.sqrt(dx * dx + dy * dy);
        this.angle = p1.equals(p2) ? defAngle : DBMath.figureAngle(p1, p2);
        Poly poly = this.makePoly(this.length, this.width, Poly.Type.FILLED);
        this.visBounds.setRect(poly.getBounds2D());
        if (this.parent != null) {
            this.parent.setDirty();
        }
    }

    public Connection getHead() {
        return this.ends[0];
    }

    public Connection getTail() {
        return this.ends[1];
    }

    public Connection getConnection(boolean onHead) {
        return onHead ? this.ends[0] : this.ends[1];
    }

    public Connection getConnection(int index) {
        return this.ends[index];
    }

    public boolean stillInPort(Connection con, Point2D pt, boolean reduceForArc) {
        PortInst pi = con.getPortInst();
        Poly poly = pi.getPoly();
        if (reduceForArc) {
            ArcInst ai = con.getArc();
            double wid = ai.getWidth() - ai.getProto().getWidthOffset();
            poly.reducePortPoly(pi, wid, ai.getAngle());
        }
        if (poly.isInside(pt)) {
            return true;
        }
        return poly.polyDistance(pt.getX(), pt.getY()) < MINPORTDISTANCE;
    }

    public boolean isDeprecatedVariable(Variable.Key key) {
        if (key == ARC_NAME) {
            return true;
        }
        return super.isDeprecatedVariable(key);
    }

    public String describe() {
        String description = this.protoType.describe();
        String name = this.getName();
        if (name != null) {
            description = description + "[" + name + "]";
        }
        return description;
    }

    public String toString() {
        if (this.protoType == null) {
            return "ArcInst null protoType";
        }
        return "ArcInst " + this.protoType.getName();
    }

    public int checkAndRepair(boolean repair, ErrorLogger errorLogger) {
        ErrorLogger.MessageLog error;
        String msg;
        int errorCount = 0;
        Point2D headPt = this.getHead().getLocation();
        if (!this.stillInPort(this.getHead(), headPt, false)) {
            Poly poly = this.getHead().getPortInst().getPoly();
            msg = "Cell " + this.parent.describe() + ", arc " + this.describe() + ": head not in port, is at (" + headPt.getX() + "," + headPt.getY() + ") distance to port is " + poly.polyDistance(headPt.getX(), headPt.getY()) + " port center is (" + poly.getCenterX() + "," + poly.getCenterY() + ")";
            System.out.println(msg);
            if (errorLogger != null) {
                error = errorLogger.logError(msg, this.parent, 1);
                error.addGeom(this, true, this.parent, null);
                error.addGeom(this.getHead().getPortInst().getNodeInst(), true, this.parent, null);
            }
            if (repair) {
                double x = DBMath.round(poly.getCenterX());
                double y = DBMath.round(poly.getCenterY());
                this.getHead().setLocation(new Point2D.Double(x, y));
                this.updateGeometric(this.getAngle());
            }
            ++errorCount;
        }
        Point2D tailPt = this.getTail().getLocation();
        if (!this.stillInPort(this.getTail(), tailPt, false)) {
            Poly poly = this.getTail().getPortInst().getPoly();
            String msg2 = "Cell " + this.parent.describe() + ", arc " + this.describe() + ": tail not in port, is at (" + tailPt.getX() + "," + tailPt.getY() + ") distance to port is " + poly.polyDistance(tailPt.getX(), tailPt.getY()) + " port center is (" + poly.getCenterX() + "," + poly.getCenterY() + ")";
            System.out.println(msg2);
            if (errorLogger != null) {
                ErrorLogger.MessageLog error2 = errorLogger.logError(msg2, this.parent, 1);
                error2.addGeom(this, true, this.parent, null);
                error2.addGeom(this.getTail().getPortInst().getNodeInst(), true, this.parent, null);
            }
            if (repair) {
                double x = DBMath.round(poly.getCenterX());
                double y = DBMath.round(poly.getCenterY());
                this.getTail().setLocation(new Point2D.Double(x, y));
                this.updateGeometric(this.getAngle());
            }
            ++errorCount;
        }
        if (this.getWidth() < 0.0) {
            msg = "Cell " + this.parent.describe() + ", arc " + this.describe() + ": has negative width (" + this.getWidth() + ")";
            System.out.println(msg);
            if (errorLogger != null) {
                error = errorLogger.logError(msg, this.parent, 1);
                error.addGeom(this, true, this.parent, null);
            }
            if (repair) {
                this.checkChanging();
                this.width = DBMath.round(Math.abs(this.width));
            }
            ++errorCount;
        }
        return errorCount;
    }

    public void setArcIndex(int arcIndex) {
        this.arcIndex = arcIndex;
    }

    public final int getArcIndex() {
        return this.arcIndex;
    }

    public boolean isLinked() {
        return this.arcIndex >= 0;
    }

    public boolean isActuallyLinked() {
        Cell parent = this.getParent();
        return parent != null && parent.isActuallyLinked() && 0 <= this.arcIndex && this.arcIndex < parent.getNumArcs() && parent.getArc(this.arcIndex) == this;
    }

    public Name getBasename() {
        return BASENAME;
    }

    public ArcProto getProto() {
        return this.protoType;
    }

    public void copyPropertiesFrom(ArcInst fromAi) {
        if (fromAi == null) {
            return;
        }
        this.copyVarsFrom(fromAi);
        this.copyConstraintsFrom(fromAi);
        this.setNameTextDescriptor(fromAi.getNameTextDescriptor());
    }

    public void copyConstraintsFrom(ArcInst fromAi) {
        if (fromAi == null) {
            return;
        }
        this.lowLevelSetUserbits(fromAi.lowLevelGetUserbits());
        this.getHead().setNegated(fromAi.getHead().isNegated());
        this.getTail().setNegated(fromAi.getTail().isNegated());
    }

    public void setRigid(boolean state) {
        this.userBits = state ? (this.userBits |= 1) : (this.userBits &= 0xFFFFFFFE);
    }

    public boolean isRigid() {
        return (this.userBits & 1) != 0;
    }

    public void setFixedAngle(boolean state) {
        this.userBits = state ? (this.userBits |= 2) : (this.userBits &= 0xFFFFFFFD);
    }

    public boolean isFixedAngle() {
        return (this.userBits & 2) != 0;
    }

    public void setSlidable(boolean state) {
        this.userBits = state ? (this.userBits &= 0xFF7FFFFF) : (this.userBits |= 0x800000);
    }

    public boolean isSlidable() {
        return (this.userBits & 0x800000) == 0;
    }

    public void setRigidModified() {
        this.userBits &= 0xFEFFFFFF;
    }

    public void clearRigidModified() {
        this.userBits |= 0x1000000;
    }

    public boolean isRigidModified() {
        return (this.userBits & 0x1000000) == 0;
    }

    private void setDefaultConstraints() {
        this.setRigid(this.protoType.isRigid());
        this.setFixedAngle(this.protoType.isFixedAngle());
        this.setSlidable(this.protoType.isSlidable());
        this.setExtended(this.protoType.isExtended());
        this.setDirectional(this.protoType.isDirectional());
    }

    public void lowLevelSetArcAngle(int angle) {
        this.userBits = this.userBits & 0xFFFFC01F | angle << 5;
    }

    public int lowLevelGetArcAngle() {
        return (this.userBits & 0x3FE0) >> 5;
    }

    public void setExtended(boolean state) {
        this.userBits = state ? (this.userBits &= 0xFFFDFFFF) : (this.userBits |= 0x20000);
        this.updateGeometric(this.getAngle());
    }

    public boolean isExtended() {
        return (this.userBits & 0x20000) == 0;
    }

    public void setDirectional(boolean state) {
        this.userBits = state ? (this.userBits |= 0x80000) : (this.userBits &= 0xFFF7FFFF);
    }

    public boolean isDirectional() {
        return (this.userBits & 0x80000) != 0;
    }

    public void setSkipHead(boolean state) {
        this.userBits = state ? (this.userBits |= 0x100000) : (this.userBits &= 0xFFEFFFFF);
        this.updateGeometric(this.getAngle());
    }

    public boolean isSkipHead() {
        return (this.userBits & 0x100000) != 0;
    }

    public void setSkipTail(boolean state) {
        this.userBits = state ? (this.userBits |= 0x200000) : (this.userBits &= 0xFFDFFFFF);
        this.updateGeometric(this.getAngle());
    }

    public boolean isSkipTail() {
        return (this.userBits & 0x200000) != 0;
    }

    public void setReverseEnds(boolean state) {
        this.userBits = state ? (this.userBits |= 0x400000) : (this.userBits &= 0xFFBFFFFF);
        this.updateGeometric(this.getAngle());
    }

    public boolean isReverseEnds() {
        return (this.userBits & 0x400000) != 0;
    }

    public void setHardSelect(boolean state) {
        this.userBits = state ? (this.userBits |= Integer.MIN_VALUE) : (this.userBits &= Integer.MAX_VALUE);
    }

    public boolean isHardSelect() {
        return (this.userBits & Integer.MIN_VALUE) != 0;
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        Poly[] aPolyList;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ArcInst a = (ArcInst)obj;
        if (this.protoType.getClass() != a.getProto().getClass()) {
            return false;
        }
        ArcProto arcType = a.getProto();
        Technology tech = arcType.getTechnology();
        if (this.getProto().getTechnology() != tech) {
            if (buffer != null) {
                buffer.append("No same technology for arcs " + this.getName() + " and " + a.getName() + "\n");
            }
            return false;
        }
        Poly[] polyList = this.getProto().getTechnology().getShapeOfArc(this);
        if (polyList.length != (aPolyList = tech.getShapeOfArc(a)).length) {
            if (buffer != null) {
                buffer.append("No same number of geometries in " + this.getName() + " and " + a.getName() + "\n");
            }
            return false;
        }
        ArrayList<Poly> noCheckAgain = new ArrayList<Poly>();
        for (int i = 0; i < polyList.length; ++i) {
            boolean found = false;
            for (int j = 0; j < aPolyList.length; ++j) {
                if (noCheckAgain.contains(aPolyList[j]) || !polyList[i].compare(aPolyList[j], buffer)) continue;
                found = true;
                noCheckAgain.add(aPolyList[j]);
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public Poly cropPerLayer(Poly poly) {
        Rectangle2D polyBounds = poly.getBox();
        if (polyBounds == null) {
            return poly;
        }
        polyBounds = new Rectangle2D.Double(polyBounds.getMinX(), polyBounds.getMinY(), polyBounds.getWidth(), polyBounds.getHeight());
        for (int i = 0; i < 2; ++i) {
            Connection con = this.getConnection(i);
            PortInst pi = con.getPortInst();
            NodeInst ni = pi.getNodeInst();
            AffineTransform trans = ni.rotateOut();
            Technology tech = ni.getProto().getTechnology();
            Poly[] activeCropPolyList = tech.getShapeOfNode(ni, null, false, false, null);
            int nTot = activeCropPolyList.length;
            for (int k = 0; k < nTot; ++k) {
                Poly nPoly = activeCropPolyList[k];
                if (nPoly.getLayer() != poly.getLayer()) continue;
                nPoly.transform(trans);
                Rectangle2D nPolyBounds = nPoly.getBox();
                if (nPolyBounds == null) continue;
                int result = Poly.cropBoxComplete(polyBounds, nPolyBounds, true);
                if (result == 1) {
                    return null;
                }
                if (result == -2) {
                    System.out.println("When is this case?");
                }
                Poly newPoly = new Poly(polyBounds);
                newPoly.setLayer(poly.getLayer());
                newPoly.setStyle(poly.getStyle());
                return newPoly;
            }
        }
        return poly;
    }
}

