dnl Copyright (C) 1993-2002 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible, Marcus Daniels.

AC_PREREQ(2.13)

AC_DEFUN([RL_SELECT],
[AC_CHECK_FUNCS(select)dnl
if test $ac_cv_func_select = yes; then
CL_COMPILE_CHECK([sys/select.h], cl_cv_header_sys_select_h,
[#ifdef __BEOS__
#include <sys/socket.h>
#endif
#include <sys/time.h>
#include <sys/select.h>], ,
AC_DEFINE(HAVE_SYS_SELECT_H))dnl
fi
])

AC_DEFUN([CL_SELECT],
[AC_CHECK_FUNCS(select)dnl
if test $ac_cv_func_select = yes; then
CL_COMPILE_CHECK([sys/select.h], cl_cv_header_sys_select_h,
[#ifdef __BEOS__
#include <sys/socket.h>
#endif
#include <sys/time.h>
#include <sys/select.h>], ,
AC_DEFINE(HAVE_SYS_SELECT_H))dnl
CL_PROTO([select], [
for z in '' 'const'; do
for y in 'fd_set' 'int' 'void' 'struct fd_set'; do
for x in 'int' 'size_t'; do
if test -z "$have_select"; then
CL_PROTO_TRY([
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#ifdef __BEOS__
#include <sys/socket.h>
#endif
#include <sys/time.h>
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif
], [int select ($x width, $y * readfds, $y * writefds, $y * exceptfds, $z struct timeval * timeout);],
[int select();], [
cl_cv_proto_select_arg1="$x"
cl_cv_proto_select_arg2="$y"
cl_cv_proto_select_arg5="$z"
have_select=1])
fi
done
done
done
], [extern int select ($cl_cv_proto_select_arg1, $cl_cv_proto_select_arg2 *, $cl_cv_proto_select_arg2 *, $cl_cv_proto_select_arg2 *, $cl_cv_proto_select_arg5 struct timeval *);])
AC_DEFINE_UNQUOTED(SELECT_WIDTH_T,$cl_cv_proto_select_arg1)
AC_DEFINE_UNQUOTED(SELECT_SET_T,$cl_cv_proto_select_arg2)
AC_DEFINE_UNQUOTED(SELECT_CONST,$cl_cv_proto_select_arg5)
else
AC_CHECK_FUNCS(poll)dnl
fi
])
