;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: XIT -*-
;;;_____________________________________________________________________________
;;;
;;;                       System: XAM
;;;                       Module: Catalog
;;;                       Version: 1.0
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Juergen Herczeg
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/lisp/xit/xam/catalog.lisp
;;; File Creation Date: 10/08/92 14:13:06
;;; Last Modification Time: 10/08/92 16:06:22
;;; Last Modification By: Juergen Herczeg
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;
;;;_____________________________________________________________________________

(in-package :xit)

(defun select-meta-catalog ()
  (declare (special *meta-catalog*))
  (unless (and (boundp '*meta-catalog*) *meta-catalog*)
    (setq *meta-catalog* (make-meta-catalog)))
  (totop-window *meta-catalog*))

(defun destroy-meta-catalog ()
  (declare (special *meta-catalog*))
  (destroy-and-make-unbound *meta-catalog*))

(defun make-meta-catalog ()
  (while-busy nil
    (make-gio 
     'paned-window
     :name :catalog
     :adjust-size? nil
     :reactivity-entries '((:select))
     :parts
     '((:class text-dispel
       :name :title
       :adjust-size? nil
       :text "Catalog"
       :font (:face :bold)
       :background "black"
       :foreground "white"
       :inside-border 2
       :display-position :center)
     
      (:class text-dispel
       :name :load-button
       :text "Load"
       :font (:size 14 :face :bold)
       :mouse-feedback :border
       :reactivity-entries
       ((:select "Load catalog entries"
         (call :eval (load-catalog-entries)))))
      ;; global operations
      (:class text-dispel
       :name :save-button
       :text "Save"
       :font (:size 14 :face :bold)
       :mouse-feedback :border
       :reactivity-entries
       ((:select "Save catalog entries"
         (call :eval (save-catalog-entries)))))
      (:class text-dispel
       :name :clear-button
       :text "Clear"
       :font (:size 14 :face :bold)
       :mouse-feedback :border
       :reactivity-entries
       ((:select "Remove all catalog entries"
	 (call :eval (broadcast (client-window (part (part-of *self*) :work-area))
				#'destroy)))))

      ;; window operation buttons 
      (:class window-button
       :name :button-refresh
       :bitmap "button-refresh"
       :view-of refresh-window
       :action-docu "Refresh Window")
      (:class window-button
       :name :button-move
       :bitmap "button-move"
       :view-of move-window
       :action-docu "Move Window")
      (:class window-button
       :name :button-resize
       :bitmap "button-resize"
       :view-of resize-window
       :action-docu "Resize Window")
      (:class window-button
       :name :button-totop
       :bitmap "button-totop"
       :view-of totop-window
       :action-docu "Put Window on Top")
      (:class window-button
       :name :button-tobottom
       :bitmap "button-tobottom"
       :view-of tobottom-window
       :action-docu "Put Window to Bottom")
      (:class window-button
       :name :button-shrink
       :bitmap "button-shrink"
       :view-of bury-window
       :action-docu "Shrink Window to Icon")
      (:class window-button
       :name :button-kill
       :bitmap "button-kill"
       :view-of destroy
       :action-docu "Remove Window")
     
      (:class margined-window
       :name :work-area
       :adjust-size? nil
       :border-width 0
       :margins
       ((standard-margins-with-scroll-bars-without-label
	  :scroll-bar-options (:locations (:right :bottom))))
       :client-window
       (intel
	:name :client
	:adjust-size? nil
	:width 1000
	:height 1000)))

     :layouter
     '(pane-layouter
       :configuration configuration-1
       :configurations
       ((configuration-1
	  ((:title :ask)
	   (empty 3)
	   (button-strip (:ask :button-move) :h
			 (empty 10)
			 (:load-button :ask)
			 (empty 20)
			 (:save-button :ask)
			 (empty 20)
			 (:clear-button :ask)
			 (empty :even)
			 (:button-refresh :ask)
			 (empty 3)
			 (:button-move :ask)
			 (empty 3)
			 (:button-resize :ask)
			 (empty 3)
			 (:button-totop :ask)
			 (empty 3)
			 (:button-tobottom :ask)
			 (empty 3)
			 (:button-shrink :ask)
			 (empty 3)
			 (:button-kill :ask)
			 (empty 3))
	   (empty 3)
	   (:work-area :rest))))
       ))))
	   

(defun load-catalog-entries ()
  )
(defun save-catalog-entries ()
  )