/* LocaleInformation_so.java --
   Copyright (C) 2005  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_so extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "KES";

  private static final String currenciesDisplayNameValues = "KES";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "\u00A6");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "KES";

  private static final String currenciesSymbolValues = "Ksh";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "\u00A6");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "Kob",
    "Lab",
    "Sad",
    "Afr",
    "Sha",
    "Lix",
    "Tod",
    "Sid",
    "Sag",
    "Tob",
    "KIT",
    "LIT",
    null,
  };

  private static final String[] months = {
    "Bisha Koobaad",
    "Bisha Labaad",
    "Bisha Saddexaad",
    "Bisha Afraad",
    "Bisha Shanaad",
    "Bisha Lixaad",
    "Bisha Todobaad",
    "Bisha Sideedaad",
    "Bisha Sagaalaad",
    "Bisha Tobnaad",
    "Bisha Kow iyo Tobnaad",
    "Bisha Laba iyo Tobnaad",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "Axa",
    "Isn",
    "Sal",
    "Arb",
    "Kha",
    "Jim",
    "Sab",
  };

  private static final String[] weekdays = {
    null,
    "Axad",
    "Isniin",
    "Salaaso",
    "Arbaco",
    "Khamiis",
    "Jimco",
    "Sabti",
  };

  private static final String[] eras = {
    "Ciise ka hor",
    "Ciise ka dib",
  };

  private static final String[] ampms = {
    "sn",
    "gn",
  };

  private static final String territoriesKeys = "AU\u00A6TD\u00A6AT\u00A6MZ\u00A6AO\u00A6MX\u00A6MW\u00A6GR\u00A6AM\u00A6ZA\u00A6MV\u00A6SY\u00A6MT\u00A6GN\u00A6MR\u00A6AF\u00A6AE\u00A6ML\u00A6MK\u00A6SO\u00A6GD\u00A6SL\u00A6MC\u00A6MA\u00A6SE\u00A6SD\u00A6SA\u00A6YE\u00A6LY\u00A6FR\u00A6LV\u00A6LU\u00A6LS\u00A6LR\u00A6RU\u00A6FI\u00A6LK\u00A6RO\u00A6LB\u00A6KZ\u00A6ET\u00A6ES\u00A6KW\u00A6KR\u00A6KP\u00A6EG\u00A6KH\u00A6KE\u00A6QA\u00A6JP\u00A6DK\u00A6PT\u00A6JO\u00A6DJ\u00A6JM\u00A6DE\u00A6PL\u00A6PK\u00A6VN\u00A6PH\u00A6VE\u00A6CU\u00A6VA\u00A6IT\u00A6IS\u00A6CN\u00A6IR\u00A6CM\u00A6IQ\u00A6CL\u00A6IN\u00A6CH\u00A6IL\u00A6US\u00A6OM\u00A6CA\u00A6IE\u00A6ID\u00A6UG\u00A6BR\u00A6NZ\u00A6HU\u00A6HR\u00A6TZ\u00A6BJ\u00A6BH\u00A6NO\u00A6BE\u00A6BD\u00A6ZW\u00A6TR\u00A6BB\u00A6BA\u00A6TN\u00A6NI\u00A6NG\u00A6ZM\u00A6TH\u00A6TG\u00A6NA";

  private static final String territoriesValues = "Awstraaliya\u00A6Jaad\u00A6Osteeriya\u00A6Musambiig\u00A6Angoola\u00A6Meksiko\u00A6Malaawi\u00A6Giriigga\u00A6Armeeniya\u00A6Koonfur Afrika\u00A6Maaldiqeen\u00A6Suuriya\u00A6Maalda\u00A6Gini\u00A6Muritaaniya\u00A6Afgaanistaan\u00A6Imaaraadka Carabta ee Midoobay\u00A6Maali\u00A6Makadooniya\u00A6Soomaaliya\u00A6Giriinaada\u00A6Siraaliyoon\u00A6Moonako\u00A6Marooko\u00A6Iswidhan\u00A6Sudaan\u00A6Sacuudi Carabiya\u00A6Yaman\u00A6Liibiya\u00A6Faransiis\u00A6Laatfiya\u00A6Luksemboorg\u00A6Losooto\u00A6Laybeeriya\u00A6Ruush\u00A6Fiinlaand\u00A6Siirilaanka\u00A6Rumaaniya\u00A6Lubnaan\u00A6Kasaakhistaan\u00A6Itoobiya\u00A6Isbeyn\u00A6Kuwayt\u00A6Kuuriyada Koonfureed\u00A6Kuuriyada Waqooyi\u00A6Masar\u00A6Kamboodiya\u00A6Kiiniya\u00A6Qadar\u00A6Jabbaan\u00A6Danmaark\u00A6Bortuqaal\u00A6Urdun\u00A6Jabuuti\u00A6Jameyka\u00A6Jarmal\u00A6Booland\u00A6Bakistaan\u00A6Fiyetnaam\u00A6Filibiin\u00A6Fenisuweela\u00A6Kuuba\u00A6Faatikaan\u00A6Talyaani\u00A6Iislaand\u00A6Shiinaha\u00A6Iiraan\u00A6Kameruun\u00A6Ciraaq\u00A6Jili\u00A6Hindiya\u00A6Swiiserlaand\u00A6Israa'iil\u00A6Qaramada Midoobey ee Maraykanka\u00A6Cumaan\u00A6Kanada\u00A6Ayrlaanda\u00A6Indoneesiya\u00A6Ugaanda\u00A6Braasiil\u00A6Neyuusilaand\u00A6Hangeri\u00A6Korweeshiya\u00A6Tansaaniya\u00A6Beniin\u00A6Baxrayn\u00A6Noorweey\u00A6Beljiyam\u00A6Bangaala-Deesh\u00A6Simbaabwe\u00A6Turki\u00A6Baarbadoos\u00A6Boosniya Heersigoviina\u00A6Tuniisiya\u00A6Nikaraaguwa\u00A6Nayjeeriya\u00A6Saambiya\u00A6Taylaand\u00A6Toogo\u00A6Namiibiya";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(territoriesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "so";

  private static final String languagesValues = "Soomaali";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(languagesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "firstDayOfWeek", "sat" },
    { "eras", eras },
    { "ampms", ampms },
    { "shortDateFormat", "dd/MM/yy" },
    { "mediumDateFormat", "dd-MMM-yyyy" },
    { "longDateFormat", "dd MMMM yyyy" },
    { "fullDateFormat", "EEEE, MMMM dd, yyyy" },
    { "shortTimeFormat", "h:mm a" },
    { "mediumTimeFormat", "h:mm:ss a" },
    { "longTimeFormat", "h:mm:ss a" },
    { "fullTimeFormat", "h:mm:ss a" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
