#ifndef __GAMESTATE_H__
#define __GAMESTATE_H__

#include "gamestatemanager.h"

class GameState
{
public:
  virtual bool getTransitioning () = 0;
  virtual void init () = 0;
  virtual void cleanup () = 0;
  virtual void pause () = 0;
  virtual void resume () = 0;
  virtual void handleEvents (GameStateManager * gameStateManager) = 0;
  virtual void draw (GameStateManager * gameStateManager) = 0;
  virtual void update (GameStateManager * gameStateManager) = 0;
protected:
    GameState ()
  {
  };
};

#endif
