'use client';
'use strict';

var React = require('react');
var react = require('@floating-ui/react');
var hooks = require('@mantine/hooks');
var useFloatingAutoUpdate = require('../Floating/use-floating-auto-update.cjs');
require('../Floating/FloatingArrow/FloatingArrow.cjs');

function getDefaultMiddlewares(middlewares) {
  if (middlewares === void 0) {
    return { shift: true, flip: true };
  }
  const result = { ...middlewares };
  if (middlewares.shift === void 0) {
    result.shift = true;
  }
  if (middlewares.flip === void 0) {
    result.flip = true;
  }
  return result;
}
function getPopoverMiddlewares(options, getFloating) {
  const middlewaresOptions = getDefaultMiddlewares(options.middlewares);
  const middlewares = [react.offset(options.offset)];
  if (middlewaresOptions.shift) {
    middlewares.push(
      react.shift(
        typeof middlewaresOptions.shift === "boolean" ? { limiter: react.limitShift(), padding: 5 } : { limiter: react.limitShift(), padding: 5, ...middlewaresOptions.shift }
      )
    );
  }
  if (middlewaresOptions.flip) {
    middlewares.push(
      typeof middlewaresOptions.flip === "boolean" ? react.flip() : react.flip(middlewaresOptions.flip)
    );
  }
  if (middlewaresOptions.inline) {
    middlewares.push(
      typeof middlewaresOptions.inline === "boolean" ? react.inline() : react.inline(middlewaresOptions.inline)
    );
  }
  middlewares.push(react.arrow({ element: options.arrowRef, padding: options.arrowOffset }));
  if (middlewaresOptions.size || options.width === "target") {
    middlewares.push(
      react.size({
        ...typeof middlewaresOptions.size === "boolean" ? {} : middlewaresOptions.size,
        apply({ rects, availableWidth, availableHeight, ...rest }) {
          const floating = getFloating();
          const styles = floating.refs.floating.current?.style ?? {};
          if (middlewaresOptions.size) {
            if (typeof middlewaresOptions.size === "object" && !!middlewaresOptions.size.apply) {
              middlewaresOptions.size.apply({ rects, availableWidth, availableHeight, ...rest });
            } else {
              Object.assign(styles, {
                maxWidth: `${availableWidth}px`,
                maxHeight: `${availableHeight}px`
              });
            }
          }
          if (options.width === "target") {
            Object.assign(styles, {
              width: `${rects.reference.width}px`
            });
          }
        }
      })
    );
  }
  return middlewares;
}
function usePopover(options) {
  const [_opened, setOpened] = hooks.useUncontrolled({
    value: options.opened,
    defaultValue: options.defaultOpened,
    finalValue: false,
    onChange: options.onChange
  });
  const previouslyOpened = React.useRef(_opened);
  const onClose = () => {
    if (_opened) {
      setOpened(false);
    }
  };
  const onToggle = () => setOpened(!_opened);
  const floating = react.useFloating({
    strategy: options.strategy,
    placement: options.position,
    middleware: getPopoverMiddlewares(options, () => floating)
  });
  useFloatingAutoUpdate.useFloatingAutoUpdate({
    opened: _opened,
    position: options.position,
    positionDependencies: options.positionDependencies || [],
    floating
  });
  hooks.useDidUpdate(() => {
    options.onPositionChange?.(floating.placement);
  }, [floating.placement]);
  hooks.useDidUpdate(() => {
    if (_opened !== previouslyOpened.current) {
      if (!_opened) {
        options.onClose?.();
      } else {
        options.onOpen?.();
      }
    }
    previouslyOpened.current = _opened;
  }, [_opened, options.onClose, options.onOpen]);
  return {
    floating,
    controlled: typeof options.opened === "boolean",
    opened: _opened,
    onClose,
    onToggle
  };
}

exports.usePopover = usePopover;
//# sourceMappingURL=use-popover.cjs.map
