/**
 * Ported from `react-beautiful-dnd`
 */
export function findClosestScrollContainer(element) {
  var _getComputedStyle = getComputedStyle(element),
    overflowX = _getComputedStyle.overflowX,
    overflowY = _getComputedStyle.overflowY;
  if (overflowX === 'scroll' || overflowX === 'auto' || overflowY === 'scroll' || overflowY === 'auto') {
    return element;
  }
  var parentElement = element.parentElement;
  if (parentElement === null) {
    return null;
  }
  return findClosestScrollContainer(parentElement);
}