// eslint-disable-next-line import/no-extraneous-dependencies

import { warning } from '../dev-warning';
function getPosition(location) {
  return location.index + 1;
}
export var defaultMessage = {
  onDragStart: function onDragStart(_ref) {
    var source = _ref.source;
    var startPosition = getPosition(source);
    return "You have lifted an item in position ".concat(startPosition, ".");
  },
  onDragUpdate: function onDragUpdate(_ref2) {
    var source = _ref2.source,
      destination = _ref2.destination;
    if (!destination) {
      return 'You are currently not dragging over a droppable area.';
    }
    var startPosition = getPosition(source);
    var endPosition = getPosition(destination);
    var isSameList = source.droppableId === destination.droppableId;
    if (isSameList) {
      return "You have moved the item from position ".concat(startPosition, " to position ").concat(endPosition, ".");
    }
    return "You have moved the item from position ".concat(startPosition, " in list ").concat(source.droppableId, " to list ").concat(destination.droppableId, " in position ").concat(endPosition, ".");
  },
  onDragEnd: function onDragEnd(_ref3) {
    var source = _ref3.source,
      destination = _ref3.destination,
      reason = _ref3.reason;
    var startPosition = getPosition(source);
    if (reason === 'CANCEL') {
      return "Movement cancelled. The item has returned to its starting position of ".concat(startPosition, ".");
    }
    if (!destination) {
      return "The item has been dropped while not over a droppable location. The item has returned to its starting position of ".concat(startPosition, ".");
    }
    var endPosition = getPosition(destination);
    var isSameList = source.droppableId === destination.droppableId;
    if (isSameList) {
      return "You have dropped the item. It has moved from position ".concat(startPosition, " to ").concat(endPosition, ".");
    }
    return "You have dropped the item. It has moved from position ".concat(startPosition, " in list ").concat(source.droppableId, " to position ").concat(endPosition, " in list ").concat(destination.droppableId, ".");
  }
};
export function getDefaultMessage(event, data) {
  // @ts-expect-error - narrowing issue
  return defaultMessage[event](data);
}
export function getProvided(event, data) {
  /**
   * The custom message to be used.
   */
  var userMessage = null;

  /**
   * Whether the message has been read yet.
   *
   * After it has been read, the user can no longer override it.
   */
  var hasExpired = false;
  var provided = {
    /**
     * Used to capture custom messages for screen readers.
     *
     * Does not announce directly, but exposes the message that should be
     * announced. This may or may not be the default message.
     */
    announce: function announce(message) {
      if (process.env.NODE_ENV !== 'production') {
        if (userMessage) {
          warning('Announcement already made. Not making a second announcement');
        }
        if (hasExpired) {
          warning("\n            Announcements cannot be made asynchronously.\n            Default message has already been announced.\n          ");
        }
      }
      userMessage = message;
    }
  };

  /**
   * Returns the message that should be announced.
   */
  function getMessage() {
    hasExpired = true;
    return userMessage !== null && userMessage !== void 0 ? userMessage : getDefaultMessage(event, data);
  }
  return {
    provided: provided,
    getMessage: getMessage
  };
}
export var defaultDragHandleUsageInstructions = "\n  Press space bar to start a drag.\n  When dragging you can use the arrow keys to move the item around and escape to cancel.\n  Some screen readers may require you to be in focus mode or to use your pass through key\n";