import { type FeatureFlagResolverBoolean } from './resolvers';
/**
 * This creates a boolean flag resolver that allows calls to `getBooleanFF` inside of Platform components to use a Product's
 * feature flag client and LD project, rather than installing a feature flag client of their own, or passing those flags in via props.
 *
 * @param flagResolver
 */
export declare function setBooleanFeatureFlagResolver(flagResolver: FeatureFlagResolverBoolean): void;
/**
 * Returns the value of a feature flag. If the flag does not resolve, it returns the "false" as a default value.
 *
 * @deprecated Use {@link fg} function instead.
 * @param name
 */
export declare function getBooleanFF(name: string): boolean;
/**
 * Returns the value of a feature flag. If the flag does not resolve, it returns the "false" as a default value.
 *
 * @param name
 */
export declare function fg(name: string): boolean;
