define("feature-gate-js-client", [], function() { return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _client_FeatureGates__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _client_FeatureGates__WEBPACK_IMPORTED_MODULE_0__["default"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FeatureGateEnvironment", function() { return _client_FeatureGates__WEBPACK_IMPORTED_MODULE_0__["FeatureGateEnvironment"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PerimeterType", function() { return _client_FeatureGates__WEBPACK_IMPORTED_MODULE_0__["PerimeterType"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CLIENT_VERSION", function() { return _client_FeatureGates__WEBPACK_IMPORTED_MODULE_0__["CLIENT_VERSION"]; });

/* harmony import */ var _client_compat_DynamicConfig__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(64);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DynamicConfig", function() { return _client_compat_DynamicConfig__WEBPACK_IMPORTED_MODULE_1__["DynamicConfig"]; });

/* harmony import */ var _client_compat_Layer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(80);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Layer", function() { return _client_compat_Layer__WEBPACK_IMPORTED_MODULE_2__["Layer"]; });

/* harmony import */ var _client_compat_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(78);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "EvaluationReason", function() { return _client_compat_types__WEBPACK_IMPORTED_MODULE_3__["EvaluationReason"]; });






/***/ }),
/* 1 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Client__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6);
/* harmony import */ var _version__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(83);
/* harmony import */ var _compat_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(78);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "EvaluationReason", function() { return _compat_types__WEBPACK_IMPORTED_MODULE_3__["EvaluationReason"]; });

/* harmony import */ var _compat_DynamicConfig__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(64);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DynamicConfig", function() { return _compat_DynamicConfig__WEBPACK_IMPORTED_MODULE_4__["DynamicConfig"]; });

/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(79);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FeatureGateEnvironment", function() { return _types__WEBPACK_IMPORTED_MODULE_5__["FeatureGateEnvironment"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PerimeterType", function() { return _types__WEBPACK_IMPORTED_MODULE_5__["PerimeterType"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CLIENT_VERSION", function() { return _version__WEBPACK_IMPORTED_MODULE_2__["CLIENT_VERSION"]; });


var _FeatureGates;






/**
 * Access the FeatureGates object via the default export.
 * ```ts
 * import FeatureGates from '@atlaskit/feature-gate-js-client';
 * ```
 */
class FeatureGates {
  static isGateExists(gateName) {
    return this.client.isGateExist(gateName);
  }
  static isExperimentExists(experimentName) {
    return this.client.isExperimentExist(experimentName);
  }
}
_FeatureGates = FeatureGates;
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "client", new _Client__WEBPACK_IMPORTED_MODULE_1__["Client"]());
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "hasCheckGateErrorOccurred", false);
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "hasGetExperimentValueErrorOccurred", false);
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "checkGate", (gateName, options) => {
  try {
    // Check if the CRITERION override mechanism is available
    if (typeof window !== 'undefined' && window.__CRITERION__ && typeof window.__CRITERION__.getFeatureFlagOverride === 'function') {
      // Attempt to retrieve an override value for the feature gate
      const overrideValue = window.__CRITERION__.getFeatureFlagOverride(gateName);
      // If an override value is found, return it immediately
      if (overrideValue !== undefined) {
        return overrideValue;
      }
    }
  } catch (error) {
    // Log the first occurrence of the error
    if (!_FeatureGates.hasCheckGateErrorOccurred) {
      // eslint-disable-next-line no-console
      console.warn({
        msg: 'An error has occurred checking the feature gate from criterion override. Only the first occurrence of this error is logged.',
        gateName,
        error
      });
      _FeatureGates.hasCheckGateErrorOccurred = true;
    }
  }

  // Proceed with the main logic if no override is found
  return _FeatureGates.client.checkGate(gateName, options);
});
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "getExperimentValue", (experimentName, parameterName, defaultValue, options) => {
  try {
    // Check if the CRITERION override mechanism is available
    if (typeof window !== 'undefined' && window.__CRITERION__ && typeof window.__CRITERION__.getExperimentValueOverride === 'function') {
      const overrideValue = window.__CRITERION__.getExperimentValueOverride(experimentName, parameterName);
      if (overrideValue !== undefined && overrideValue !== null) {
        return overrideValue;
      }
    }
  } catch (error) {
    // Log the first occurrence of the error
    if (!_FeatureGates.hasGetExperimentValueErrorOccurred) {
      // eslint-disable-next-line no-console
      console.warn({
        msg: 'An error has occurred getting the experiment value from criterion override. Only the first occurrence of this error is logged.',
        experimentName,
        defaultValue,
        options,
        error
      });
      _FeatureGates.hasGetExperimentValueErrorOccurred = true;
    }
    return defaultValue;
  }

  // Proceed with the main logic if no override is found
  return _FeatureGates.client.getExperimentValue(experimentName, parameterName, defaultValue, options);
});
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "initializeCalled", _FeatureGates.client.initializeCalled.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "initializeCompleted", _FeatureGates.client.initializeCompleted.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "initialize", _FeatureGates.client.initialize.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "initializeWithProvider", _FeatureGates.client.initializeWithProvider.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "initializeFromValues", _FeatureGates.client.initializeFromValues.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "manuallyLogGateExposure", _FeatureGates.client.manuallyLogGateExposure.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "getExperiment", _FeatureGates.client.getExperiment.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "manuallyLogExperimentExposure", _FeatureGates.client.manuallyLogExperimentExposure.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "manuallyLogLayerExposure", _FeatureGates.client.manuallyLogLayerExposure.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "shutdownStatsig", _FeatureGates.client.shutdownStatsig.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "overrideGate", _FeatureGates.client.overrideGate.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "clearGateOverride", _FeatureGates.client.clearGateOverride.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "overrideConfig", _FeatureGates.client.overrideConfig.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "clearConfigOverride", _FeatureGates.client.clearConfigOverride.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "setOverrides", _FeatureGates.client.setOverrides.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "getOverrides", _FeatureGates.client.getOverrides.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "clearAllOverrides", _FeatureGates.client.clearAllOverrides.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "isCurrentUser", _FeatureGates.client.isCurrentUser.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "onGateUpdated", _FeatureGates.client.onGateUpdated.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "onExperimentValueUpdated", _FeatureGates.client.onExperimentValueUpdated.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "onAnyUpdated", _FeatureGates.client.onAnyUpdated.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "updateUser", _FeatureGates.client.updateUser.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "updateUserWithProvider", _FeatureGates.client.updateUserWithProvider.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "updateUserWithValues", _FeatureGates.client.updateUserWithValues.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "getPackageVersion", _FeatureGates.client.getPackageVersion.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "getLayer", _FeatureGates.client.getLayer.bind(_FeatureGates.client));
_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(FeatureGates, "getLayerValue", _FeatureGates.client.getLayerValue.bind(_FeatureGates.client));
let boundFGJS = FeatureGates;

// This makes it possible to get a reference to the FeatureGates client at runtime.
// This is important for overriding values in Cypress tests, as there needs to be a
// way to get the exact instance for a window in order to mock some of its methods.
if (typeof window !== 'undefined') {
  if (window.__FEATUREGATES_JS__ === undefined) {
    window.__FEATUREGATES_JS__ = FeatureGates;
  } else {
    var _boundFGJS, _boundFGJS$getPackage;
    boundFGJS = window.__FEATUREGATES_JS__;
    const boundVersion = ((_boundFGJS = boundFGJS) === null || _boundFGJS === void 0 ? void 0 : (_boundFGJS$getPackage = _boundFGJS.getPackageVersion) === null || _boundFGJS$getPackage === void 0 ? void 0 : _boundFGJS$getPackage.call(_boundFGJS)) || '4.10.0 or earlier';
    if (boundVersion !== _version__WEBPACK_IMPORTED_MODULE_2__["CLIENT_VERSION"]) {
      const message = `Multiple versions of FeatureGateClients found on the current page.
      The currently bound version is ${boundVersion} when module version ${_version__WEBPACK_IMPORTED_MODULE_2__["CLIENT_VERSION"]} was loading.`;
      // eslint-disable-next-line no-console
      console.warn(message);
    }
  }
}

/**
 * @property {FeatureGates} FeatureGate default export
 */
/* harmony default export */ __webpack_exports__["default"] = (boundFGJS);

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

var toPropertyKey = __webpack_require__(3);
function _defineProperty(e, r, t) {
  return (r = toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
    value: t,
    enumerable: !0,
    configurable: !0,
    writable: !0
  }) : e[r] = t, e;
}
module.exports = _defineProperty, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

var _typeof = __webpack_require__(4)["default"];
var toPrimitive = __webpack_require__(5);
function toPropertyKey(t) {
  var i = toPrimitive(t, "string");
  return "symbol" == _typeof(i) ? i : i + "";
}
module.exports = toPropertyKey, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),
/* 4 */
/***/ (function(module, exports) {

function _typeof(o) {
  "@babel/helpers - typeof";

  return module.exports = _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) {
    return typeof o;
  } : function (o) {
    return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o;
  }, module.exports.__esModule = true, module.exports["default"] = module.exports, _typeof(o);
}
module.exports = _typeof, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

var _typeof = __webpack_require__(4)["default"];
function toPrimitive(t, r) {
  if ("object" != _typeof(t) || !t) return t;
  var e = t[Symbol.toPrimitive];
  if (void 0 !== e) {
    var i = e.call(t, r || "default");
    if ("object" != _typeof(i)) return i;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return ("string" === r ? String : Number)(t);
}
module.exports = toPrimitive, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),
/* 6 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Client", function() { return Client; });
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7);
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _statsig_js_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9);
/* harmony import */ var _statsig_js_client__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_statsig_js_client__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _subscriptions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61);
/* harmony import */ var _compat_DynamicConfig__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(64);
/* harmony import */ var _compat_Layer__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(80);
/* harmony import */ var _compat_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(78);
/* harmony import */ var _fetcher__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(81);
/* harmony import */ var _NoFetchDataAdapter__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(85);
/* harmony import */ var _PersistentOverrideAdapter__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(86);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(79);
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(65);
/* harmony import */ var _version__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(83);


const _excluded = ["sdkKey", "environment", "updateUserCompletionCallback", "perimeter"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }











const DEFAULT_CLIENT_KEY = 'client-default-key';
// default event logging api is Atlassian proxy rather than Statsig's domain, to avoid ad blockers
const DEFAULT_EVENT_LOGGING_API = 'https://xp.atlassian.com/v1/rgstr';
class Client {
  constructor({
    localStorageKey = _PersistentOverrideAdapter__WEBPACK_IMPORTED_MODULE_9__["LOCAL_STORAGE_KEY"]
  } = {}) {
    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(this, "initPromise", null);
    /** True if an initialize method was called and completed successfully. */
    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(this, "initCompleted", false);
    /**
     * True if an initialize method was called and completed, meaning the client is now usable.
     * However if there was an error during initialization it may have initialized with default
     * values. Use {@link initCompleted} to check for this.
     */
    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(this, "initWithDefaults", false);
    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(this, "hasCheckGateErrorOccurred", false);
    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(this, "hasGetExperimentErrorOccurred", false);
    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(this, "hasGetExperimentValueErrorOccurred", false);
    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(this, "hasGetLayerErrorOccurred", false);
    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(this, "hasGetLayerValueErrorOccurred", false);
    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(this, "subscriptions", new _subscriptions__WEBPACK_IMPORTED_MODULE_3__["default"]());
    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(this, "dataAdapter", new _NoFetchDataAdapter__WEBPACK_IMPORTED_MODULE_8__["NoFetchDataAdapter"]());
    /**
     * Call this if modifying the values being served by the Statsig library since it has its own
     * memoization cache which will not be updated if the values are changed outside of the library.
     */
    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(this, "statsigValuesUpdated", () => {
      if (this.user) {
        // Trigger a reset of the memoize cache
        this.statsigClient.updateUserSync(this.user, {
          disableBackgroundCacheRefresh: true
        });
      }
      this.subscriptions.anyUpdated();
    });
    this.overrideAdapter = new _PersistentOverrideAdapter__WEBPACK_IMPORTED_MODULE_9__["PersistentOverrideAdapter"](localStorageKey);
  }

  /**
   * @description
   * This method initializes the client using a network call to fetch the bootstrap values.
   * If the client is inialized with an `analyticsWebClient`, it will send an operational event
   * to GASv3 with the following attributes:
   * - targetApp: the target app of the client
   * - clientVersion: the version of the client
   * - success: whether the initialization was successful
   * - startTime: the time when the initialization started
   * - totalTime: the total time it took to initialize the client
   * - apiKey: the api key used to initialize the client
   * @param clientOptions {ClientOptions}
   * @param identifiers {Identifiers}
   * @param customAttributes {CustomAttributes}
   * @returns {Promise<void>}
   */
  async initialize(clientOptions, identifiers, customAttributes) {
    const clientOptionsWithDefaults = Object(_utils__WEBPACK_IMPORTED_MODULE_11__["getOptionsWithDefaults"])(clientOptions);
    if (this.initPromise) {
      if (!Object(_utils__WEBPACK_IMPORTED_MODULE_11__["shallowEquals"])(clientOptionsWithDefaults, this.initOptions)) {
        // eslint-disable-next-line no-console
        console.warn('Feature Gates client already initialized with different options. New options were not applied.');
      }
      return this.initPromise;
    }
    const startTime = performance.now();
    this.initOptions = clientOptionsWithDefaults;
    this.initPromise = this.init(clientOptionsWithDefaults, identifiers, customAttributes).then(() => {
      this.initCompleted = true;
      this.initWithDefaults = true;
    }).finally(() => {
      const endTime = performance.now();
      const totalTime = endTime - startTime;
      this.fireClientEvent(startTime, totalTime, 'initialize', this.initCompleted, clientOptionsWithDefaults.apiKey);
    });
    return this.initPromise;
  }

  /**
   * @description
   * This method initializes the client using the provider given to call to fetch the bootstrap values.
   * If the client is initialized with an `analyticsWebClient`, it will send an operational event
   * to GASv3 with the following attributes:
   * - targetApp: the target app of the client
   * - clientVersion: the version of the client
   * - success: whether the initialization was successful
   * - startTime: the time when the initialization started
   * - totalTime: the total time it took to initialize the client
   * - apiKey: the api key used to initialize the client
   * @param clientOptions {ClientOptions}
   * @param provider {Provider}
   * @param identifiers {Identifiers}
   * @param customAttributes {CustomAttributes}
   * @returns {Promise<void>}
   */
  async initializeWithProvider(clientOptions, provider, identifiers, customAttributes) {
    const clientOptionsWithDefaults = Object(_utils__WEBPACK_IMPORTED_MODULE_11__["getOptionsWithDefaults"])(clientOptions);
    if (this.initPromise) {
      if (!Object(_utils__WEBPACK_IMPORTED_MODULE_11__["shallowEquals"])(clientOptionsWithDefaults, this.initOptions)) {
        // eslint-disable-next-line no-console
        console.warn('Feature Gates client already initialized with different options. New options were not applied.');
      }
      return this.initPromise;
    }
    const startTime = performance.now();
    this.initOptions = clientOptionsWithDefaults;
    this.provider = provider;
    this.provider.setClientVersion(_version__WEBPACK_IMPORTED_MODULE_12__["CLIENT_VERSION"]);
    if (this.provider.setApplyUpdateCallback) {
      this.provider.setApplyUpdateCallback(this.applyUpdateCallback.bind(this));
    }
    this.initPromise = this.initWithProvider(clientOptionsWithDefaults, provider, identifiers, customAttributes).then(() => {
      this.initCompleted = true;
      this.initWithDefaults = true;
    }).finally(() => {
      const endTime = performance.now();
      const totalTime = endTime - startTime;
      this.fireClientEvent(startTime, totalTime, 'initializeWithProvider', this.initCompleted, provider.getApiKey ? provider.getApiKey() : undefined);
    });
    return this.initPromise;
  }
  applyUpdateCallback(experimentsResult) {
    try {
      if (this.initCompleted || this.initWithDefaults) {
        this.assertInitialized(this.statsigClient);
        this.dataAdapter.setBootstrapData(experimentsResult.experimentValues);
        this.dataAdapter.setData(JSON.stringify(experimentsResult.experimentValues));
        this.statsigValuesUpdated();
      }
    } catch (error) {
      // eslint-disable-next-line no-console
      console.warn('Error when attempting to apply update', error);
    }
  }
  fireClientEvent(startTime, totalTime, action, success, apiKey = undefined) {
    var _analyticsWebClient;
    (_analyticsWebClient = this.initOptions.analyticsWebClient) === null || _analyticsWebClient === void 0 ? void 0 : _analyticsWebClient.then(analyticsWebClient => {
      const attributes = _objectSpread({
        targetApp: this.initOptions.targetApp,
        clientVersion: _version__WEBPACK_IMPORTED_MODULE_12__["CLIENT_VERSION"],
        success,
        startTime,
        totalTime
      }, apiKey && {
        apiKey
      });
      analyticsWebClient.sendOperationalEvent({
        action,
        actionSubject: 'featureGatesClient',
        attributes,
        tags: ['measurement'],
        source: '@atlaskit/feature-gate-js-client'
      });
    }).catch(err => {
      if (this.initOptions.environment !== _types__WEBPACK_IMPORTED_MODULE_10__["FeatureGateEnvironment"].Production) {
        // eslint-disable-next-line no-console
        console.error('Analytics web client promise did not resolve', err);
      }
    });
  }
  async initializeFromValues(clientOptions, identifiers, customAttributes, initializeValues = {}) {
    const clientOptionsWithDefaults = Object(_utils__WEBPACK_IMPORTED_MODULE_11__["getOptionsWithDefaults"])(clientOptions);
    if (this.initPromise) {
      if (!Object(_utils__WEBPACK_IMPORTED_MODULE_11__["shallowEquals"])(clientOptionsWithDefaults, this.initOptions)) {
        // eslint-disable-next-line no-console
        console.warn('Feature Gates client already initialized with different options. New options were not applied.');
      }
      return this.initPromise;
    }

    // This makes sure the new Statsig client behaves like the old when bootstrap data is
    // passed, and `has_updates` isn't specified (which happens a lot in product integration tests).
    if (!Object.prototype.hasOwnProperty.call(initializeValues, 'has_updates')) {
      initializeValues['has_updates'] = true;
    }
    const startTime = performance.now();
    this.initOptions = clientOptionsWithDefaults;
    this.initPromise = this.initFromValues(clientOptionsWithDefaults, identifiers, customAttributes, initializeValues).then(() => {
      this.initCompleted = true;
      this.initWithDefaults = true;
    }).finally(() => {
      const endTime = performance.now();
      const totalTime = endTime - startTime;
      this.fireClientEvent(startTime, totalTime, 'initializeFromValues', this.initCompleted);
    });
    return this.initPromise;
  }
  assertInitialized(statsigClient) {
    if (!statsigClient) {
      throw new Error('Client must be initialized before using this method');
    }
  }

  /**
   * This method updates the user using a network call to fetch the new set of values.
   * @param fetchOptions {FetcherOptions}
   * @param identifiers {Identifiers}
   * @param customAttributes {CustomAttributes}
   */
  async updateUser(fetchOptions, identifiers, customAttributes) {
    this.assertInitialized(this.statsigClient);
    const fetchOptionsWithDefaults = Object(_utils__WEBPACK_IMPORTED_MODULE_11__["getOptionsWithDefaults"])(fetchOptions);
    const initializeValuesProducer = () => _fetcher__WEBPACK_IMPORTED_MODULE_7__["default"].fetchExperimentValues(fetchOptionsWithDefaults, identifiers, customAttributes).then(({
      experimentValues,
      customAttributes
    }) => ({
      experimentValues,
      customAttributesFromFetch: customAttributes
    }));
    await this.updateUserUsingInitializeValuesProducer(initializeValuesProducer, identifiers, customAttributes);
  }

  /**
   * This method updates the user using the provider given on initialisation to get the new set of
   * values.
   * @param identifiers {Identifiers}
   * @param customAttributes {CustomAttributes}
   */
  async updateUserWithProvider(identifiers, customAttributes) {
    this.assertInitialized(this.statsigClient);
    if (!this.provider) {
      throw new Error('Cannot update user using provider as the client was not initialised with a provider');
    }
    await this.provider.setProfile(this.initOptions, identifiers, customAttributes);
    await this.updateUserUsingInitializeValuesProducer(() => this.provider.getExperimentValues(), identifiers, customAttributes);
  }

  /**
   * This method updates the user given a new set of bootstrap values obtained from one of the
   * server-side SDKs.
   *
   * @param identifiers {Identifiers}
   * @param customAttributes {CustomAttributes}
   * @param initializeValues {Record<string,unknown>}
   */
  async updateUserWithValues(identifiers, customAttributes, initializeValues = {}) {
    this.assertInitialized(this.statsigClient);
    const initializeValuesProducer = () => Promise.resolve({
      experimentValues: initializeValues,
      customAttributesFromFetch: customAttributes
    });
    await this.updateUserUsingInitializeValuesProducer(initializeValuesProducer, identifiers, customAttributes);
  }
  initializeCalled() {
    return this.initPromise != null;
  }
  initializeCompleted() {
    return this.initCompleted;
  }

  /**
   * Returns the value for a feature gate. Returns false if there are errors.
   * @param {string} gateName - The name of the feature gate.
   * @param {Object} options
   * @param {boolean} options.fireGateExposure
   *        Whether or not to fire the exposure event for the gate. Defaults to true.
   *        To log an exposure event manually at a later time, use {@link Client.manuallyLogGateExposure}
   *        (see [Statsig docs about manually logging exposures](https://docs.statsig.com/client/jsClientSDK#manual-exposures-)).
   */
  checkGate(gateName, options = {}) {
    try {
      this.assertInitialized(this.statsigClient);
      const {
        fireGateExposure = true
      } = options;
      return this.statsigClient.checkGate(gateName, {
        disableExposureLog: !fireGateExposure
      });
    } catch (error) {
      // Log the first occurrence of the error
      if (!this.hasCheckGateErrorOccurred) {
        // eslint-disable-next-line no-console
        console.warn({
          msg: 'An error has occurred checking the feature gate. Only the first occurrence of this error is logged.',
          gateName,
          error
        });
        this.hasCheckGateErrorOccurred = true;
      }
      return false;
    }
  }
  isGateExist(gateName) {
    try {
      this.assertInitialized(this.statsigClient);
      const gate = this.statsigClient.getFeatureGate(gateName, {
        disableExposureLog: true
      });
      return !gate.details.reason.includes('Unrecognized');
    } catch (error) {
      // eslint-disable-next-line no-console
      console.error(`Error occurred when trying to check FeatureGate: ${error}`);
      // in case of error report true to avoid false positives.
      return true;
    }
  }
  isExperimentExist(experimentName) {
    try {
      this.assertInitialized(this.statsigClient);
      const config = this.statsigClient.getExperiment(experimentName, {
        disableExposureLog: true
      });
      return !config.details.reason.includes('Unrecognized');
    } catch (error) {
      // eslint-disable-next-line no-console
      console.error(`Error occurred when trying to check Experiment: ${error}`);
      // in case of error report true to avoid false positives.
      return true;
    }
  }

  /**
   * Manually log a gate exposure (see [Statsig docs about manually logging exposures](https://docs.statsig.com/client/jsClientSDK#manual-exposures-)).
   * This is useful if you have evaluated a gate earlier via {@link Client.checkGate} where
   * <code>options.fireGateExposure</code> is false.
   * @param gateName
   */
  manuallyLogGateExposure(gateName) {
    this.assertInitialized(this.statsigClient);
    // This is the approach recommended in the docs
    // https://docs.statsig.com/client/javascript-sdk/#manual-exposures-
    this.statsigClient.checkGate(gateName);
  }

  /**
   * Returns the entire config for a given experiment.
   *
   * @param {string} experimentName - The name of the experiment
   * @param {Object} options
   * @param {boolean} options.fireExperimentExposure - Whether or not to fire the exposure event
   * for the experiment. Defaults to true. To log an exposure event manually at a later time, use
   * {@link Client.manuallyLogExperimentExposure} (see [Statsig docs about manually logging exposures](https://docs.statsig.com/client/jsClientSDK#manual-exposures-)).
   * @returns The config for an experiment
   * @example
   * ```ts
   * const experimentConfig = client.getExperiment('example-experiment-name');
   * const backgroundColor: string = experimentConfig.get('backgroundColor', 'yellow');
   * ```
   */
  getExperiment(experimentName, options = {}) {
    try {
      this.assertInitialized(this.statsigClient);
      const {
        fireExperimentExposure = true
      } = options;
      return _compat_DynamicConfig__WEBPACK_IMPORTED_MODULE_4__["DynamicConfig"].fromExperiment(this.statsigClient.getExperiment(experimentName, {
        disableExposureLog: !fireExperimentExposure
      }));
    } catch (error) {
      // Log the first occurrence of the error
      if (!this.hasGetExperimentErrorOccurred) {
        // eslint-disable-next-line no-console
        console.warn({
          msg: 'An error has occurred getting the experiment. Only the first occurrence of this error is logged.',
          experimentName,
          error
        });
        this.hasGetExperimentErrorOccurred = true;
      }

      // Return a default value
      return new _compat_DynamicConfig__WEBPACK_IMPORTED_MODULE_4__["DynamicConfig"](experimentName, {}, '', {
        time: Date.now(),
        reason: _compat_types__WEBPACK_IMPORTED_MODULE_6__["EvaluationReason"].Error
      });
    }
  }

  /**
   * Returns the value of a given parameter in an experiment config.
   *
   * @template T
   * @param {string} experimentName - The name of the experiment
   * @param {string} parameterName - The name of the parameter to fetch from the experiment config
   * @param {T} defaultValue - The value to serve if the experiment or parameter do not exist, or
   * if the returned value does not match the expected type.
   * @param {Object} options
   * @param {boolean} options.fireExperimentExposure - Whether or not to fire the exposure event
   * for the experiment. Defaults to true. To log an exposure event manually at a later time, use
   * {@link Client.manuallyLogExperimentExposure} (see [Statsig docs about manually logging exposures](https://docs.statsig.com/client/jsClientSDK#manual-exposures-))
   * @param {function} options.typeGuard - A function that asserts that the return value has the
   * expected type. If this function returns false, then the default value will be returned
   * instead. This can be set to protect your code from unexpected values being set remotely. By
   * default, this will be done by asserting that the default value and value are the same primitive
   * type.
   * @returns The value of the parameter if the experiment and parameter both exist, otherwise the
   * default value.
   * @example
   ``` ts
   type ValidColor = 'blue' | 'red' | 'yellow';
   type ValidColorTypeCheck = (value: unknown) => value is ValidColor;
  	 const isValidColor: ValidColorTypeCheck =
  		(value: unknown) => typeof value === 'string' && ['blue', 'red', 'yellow'].includes(value);
  	 const buttonColor: ValidColor = client.getExperimentValue(
  		'example-experiment-name',
  		'backgroundColor',
  		'yellow',
  		{
  				typeGuard: isValidColor
  		}
   );
   ```
  */
  getExperimentValue(experimentName, parameterName, defaultValue, options = {}) {
    const experiment = this.getExperiment(experimentName, options);
    try {
      const {
        typeGuard
      } = options;
      return experiment.get(parameterName, defaultValue, typeGuard);
    } catch (error) {
      // Log the first occurrence of the error
      if (!this.hasGetExperimentValueErrorOccurred) {
        // eslint-disable-next-line no-console
        console.warn({
          msg: 'An error has occurred getting the experiment value. Only the first occurrence of this error is logged.',
          experimentName,
          defaultValue,
          options,
          error
        });
        this.hasGetExperimentValueErrorOccurred = true;
      }
      return defaultValue;
    }
  }

  /**
   * Manually log an experiment exposure (see [Statsig docs about manually logging exposures](https://docs.statsig.com/client/jsClientSDK#manual-exposures-)).
   * This is useful if you have evaluated an experiment earlier via {@link Client.getExperimentValue} or
   * {@link Client.getExperiment} where <code>options.fireExperimentExposure</code> is false.
   * @param experimentName
   */
  manuallyLogExperimentExposure(experimentName) {
    this.assertInitialized(this.statsigClient);
    // This is the approach recommended in the docs
    // https://docs.statsig.com/client/javascript-sdk/#manual-exposures-
    this.statsigClient.getExperiment(experimentName);
  }

  /**
   * Manually log a layer exposure (see [Statsig docs about manually logging exposures](https://docs.statsig.com/client/jsClientSDK#manual-exposures-)).
   * This is useful if you have evaluated a layer earlier via {@link Client.getLayerValue} where <code>options.fireExperimentExposure</code> is false.
   * @param layerName
   * @param parameterName
   */
  manuallyLogLayerExposure(layerName, parameterName) {
    var _this$statsigClient$g;
    this.assertInitialized(this.statsigClient);
    // This is the approach recommended in the docs
    // https://docs.statsig.com/client/javascript-sdk/#manual-exposures-
    (_this$statsigClient$g = this.statsigClient.getLayer(layerName)) === null || _this$statsigClient$g === void 0 ? void 0 : _this$statsigClient$g.get(parameterName);
  }
  shutdownStatsig() {
    this.assertInitialized(this.statsigClient);
    this.statsigClient.shutdown();
  }

  /**
   * Adds a new override for the given gate.
   *
   * This method is additive, meaning you can call it multiple times with different gate names to
   * build your full set of overrides.
   *
   * Overrides are persisted to the `STATSIG_OVERRIDES` key in localStorage, so they
   * will continue to affect every client that is initialized on the same domain after this method
   * is called. If you are using this API for testing purposes, you should call
   * {@link Client.clearGateOverride} after your tests are completed to remove this
   * localStorage entry.
   *
   * @param {string} gateName
   * @param {boolean} value
   */
  overrideGate(gateName, value) {
    this.overrideAdapter.overrideGate(gateName, value);
    // Trigger a reset of the memoized gate value
    if (this.user) {
      var _this$statsigClient;
      (_this$statsigClient = this.statsigClient) === null || _this$statsigClient === void 0 ? void 0 : _this$statsigClient.updateUserSync(this.user, {
        disableBackgroundCacheRefresh: true
      });
    }
    this.statsigValuesUpdated();
  }

  /**
   * Removes any overrides that have been set for the given gate.
   */
  clearGateOverride(gateName) {
    this.overrideAdapter.removeGateOverride(gateName);
    this.statsigValuesUpdated();
  }

  /**
   * Adds a new override for the given config (or experiment).
   *
   * This method is additive, meaning you can call it multiple times with different experiment
   * names to build your full set of overrides.
   *
   * Overrides are persisted to the `STATSIG_OVERRIDES` key in localStorage, so they
   * will continue to affect every client that is initialized on the same domain after this method
   * is called. If you are using this API for testing purposes, you should call
   * {@link Client.clearConfigOverride} after your tests are completed to remove this
   * localStorage entry.
   *
   * @param {string} experimentName
   * @param {object} values
   */
  overrideConfig(experimentName, values) {
    this.overrideAdapter.overrideDynamicConfig(experimentName, values);
    this.statsigValuesUpdated();
  }

  /**
   * Removes any overrides that have been set for the given experiment.
   * @param {string} experimentName
   */
  clearConfigOverride(experimentName) {
    this.overrideAdapter.removeDynamicConfigOverride(experimentName);
    this.statsigValuesUpdated();
  }

  /**
   * Set overrides for gates, experiments and layers in batch.
   *
   * Note that these overrides are **not** additive and will completely replace any that have been
   * added via prior calls to {@link Client.overrideConfig} or
   * {@link Client.overrideGate}.
   *
   * Overrides are persisted to the `STATSIG_OVERRIDES` key in localStorage, so they
   * will continue to affect every client that is initialized on the same domain after this method
   * is called. If you are using this API for testing purposes, you should call
   * {@link Client.clearAllOverrides} after your tests are completed to remove this
   * localStorage entry.
   */
  setOverrides(overrides) {
    this.overrideAdapter.setOverrides(overrides);
    this.statsigValuesUpdated();
  }

  /**
   * @returns The current overrides for gates, configs (including experiments) and layers.
   */
  getOverrides() {
    return this.overrideAdapter.getOverrides();
  }

  /**
   * Clears overrides for all gates, configs (including experiments) and layers.
   */
  clearAllOverrides() {
    this.overrideAdapter.removeAllOverrides();
    this.statsigValuesUpdated();
  }

  /**
   * Returns whether the given identifiers and customAttributes align with the current
   * set that is being used by the client.
   *
   * If this method returns false, then the {@link Client.updateUser},
   * {@link Client.updateUserWithValues} or {@link Client.updateUserWithProvider}
   * methods can be used to re-align these values.
   *
   * @param identifiers
   * @param customAttributes
   * @returns a flag indicating whether the clients current configuration aligns with the given values
   */
  isCurrentUser(identifiers, customAttributes) {
    return Object(_utils__WEBPACK_IMPORTED_MODULE_11__["shallowEquals"])(this.currentIdentifiers, identifiers) && Object(_utils__WEBPACK_IMPORTED_MODULE_11__["shallowEquals"])(this.currentAttributes, customAttributes);
  }

  /**
   * Subscribe to updates where the given callback will be called with the current checkGate value
   * @param gateName
   * @param callback
   * @param options
   * @returns off function to unsubscribe from updates
   */
  onGateUpdated(gateName, callback, options = {}) {
    const wrapCallback = value => {
      const {
        fireGateExposure = true
      } = options;
      if (fireGateExposure) {
        this.manuallyLogGateExposure(gateName);
      }
      try {
        callback(value);
      } catch (error) {
        // eslint-disable-next-line no-console
        console.warn(`Error calling callback for gate ${gateName} with value ${value}`, error);
      }
    };
    return this.subscriptions.onGateUpdated(gateName, wrapCallback, this.checkGate.bind(this), options);
  }

  /**
   * Subscribe to updates where the given callback will be called with the current experiment value
   * @param experimentName
   * @param parameterName
   * @param defaultValue
   * @param callback
   * @param options
   * @returns off function to unsubscribe from updates
   */
  onExperimentValueUpdated(experimentName, parameterName, defaultValue, callback, options = {}) {
    const wrapCallback = value => {
      const {
        fireExperimentExposure = true
      } = options;
      if (fireExperimentExposure) {
        this.manuallyLogExperimentExposure(experimentName);
      }
      try {
        callback(value);
      } catch (error) {
        // eslint-disable-next-line no-console
        console.warn(`Error calling callback for experiment ${experimentName} with value ${value}`, error);
      }
    };
    return this.subscriptions.onExperimentValueUpdated(experimentName, parameterName, defaultValue, wrapCallback, this.getExperimentValue.bind(this), options);
  }

  /**
   * Subscribe so on any update the callback will be called.
   * NOTE: The callback will be called whenever the values are updated even if the values have not
   * changed.
   * @param callback
   * @returns off function to unsubscribe from updates
   */
  onAnyUpdated(callback) {
    return this.subscriptions.onAnyUpdated(callback);
  }

  /**
   * This method initializes the client using a network call to fetch the bootstrap values for the
   * given user.
   *
   * @param clientOptions
   * @param identifiers
   * @param customAttributes
   * @private
   */
  async init(clientOptions, identifiers, customAttributes) {
    const fromValuesClientOptions = _objectSpread({}, clientOptions);
    let experimentValues;
    let customAttributesFromResult;
    try {
      // If client sdk key fetch fails, an error would be thrown and handled instead of waiting for
      // the experiment values request to be settled, and it will fall back to use default values.
      const clientSdkKeyPromise = _fetcher__WEBPACK_IMPORTED_MODULE_7__["default"].fetchClientSdk(clientOptions).then(value => fromValuesClientOptions.sdkKey = value.clientSdkKey);
      const experimentValuesPromise = _fetcher__WEBPACK_IMPORTED_MODULE_7__["default"].fetchExperimentValues(clientOptions, identifiers, customAttributes);

      // Only wait for the experiment values request to finish and try to initialise the client
      // with experiment values if both requests are successful. Else an error would be thrown and
      // handled by the catch
      const [, experimentValuesResult] = await Promise.all([clientSdkKeyPromise, experimentValuesPromise]);
      experimentValues = experimentValuesResult.experimentValues;
      customAttributesFromResult = experimentValuesResult.customAttributes;
    } catch (error) {
      if (error instanceof Error) {
        // eslint-disable-next-line no-console
        console.error(`Error occurred when trying to fetch the Feature Gates client values, error: ${error === null || error === void 0 ? void 0 : error.message}`);
      }
      // eslint-disable-next-line no-console
      console.warn(`Initialising Statsig client without values`);
      await this.initFromValues(fromValuesClientOptions, identifiers, customAttributes);
      throw error;
    }
    return this.initFromValues(fromValuesClientOptions, identifiers, customAttributesFromResult, experimentValues);
  }
  async initWithProvider(baseClientOptions, provider, identifiers, customAttributes) {
    const fromValuesClientOptions = _objectSpread(_objectSpread({}, baseClientOptions), {}, {
      disableCurrentPageLogging: true
    });
    let experimentValues;
    let customAttributesFromResult;
    try {
      await provider.setProfile(baseClientOptions, identifiers, customAttributes);

      // If client sdk key fetch fails, an error would be thrown and handled instead of waiting for
      // the experiment values request to be settled, and it will fall back to use default values.
      const clientSdkKeyPromise = provider.getClientSdkKey().then(value => fromValuesClientOptions.sdkKey = value);
      const experimentValuesPromise = provider.getExperimentValues();

      // Only wait for the experiment values request to finish and try to initialise the client
      // with experiment values if both requests are successful. Else an error would be thrown and
      // handled by the catch
      const [, experimentValuesResult] = await Promise.all([clientSdkKeyPromise, experimentValuesPromise]);
      experimentValues = experimentValuesResult.experimentValues;
      customAttributesFromResult = experimentValuesResult.customAttributesFromFetch;
    } catch (error) {
      if (error instanceof Error) {
        // eslint-disable-next-line no-console
        console.error(`Error occurred when trying to fetch the Feature Gates client values, error: ${error === null || error === void 0 ? void 0 : error.message}`);
      }
      // eslint-disable-next-line no-console
      console.warn(`Initialising Statsig client without values`);
      await this.initFromValues(fromValuesClientOptions, identifiers, customAttributes);
      throw error;
    }
    return this.initFromValues(fromValuesClientOptions, identifiers, customAttributesFromResult, experimentValues);
  }

  /**
   * This method initializes the client using a set of boostrap values obtained from one of the
   * server-side SDKs.
   *
   * @param clientOptions
   * @param identifiers
   * @param customAttributes
   * @param initializeValues
   * @private
   */
  async initFromValues(clientOptions, identifiers, customAttributes, initializeValues = {}) {
    var _newClientOptions$net;
    this.overrideAdapter.initFromStoredOverrides();
    this.currentIdentifiers = identifiers;
    this.currentAttributes = customAttributes;
    const newClientOptions = Object(_utils__WEBPACK_IMPORTED_MODULE_11__["migrateInitializationOptions"])(clientOptions);
    if (!newClientOptions.sdkKey) {
      newClientOptions.sdkKey = DEFAULT_CLIENT_KEY;
    }
    if (!((_newClientOptions$net = newClientOptions.networkConfig) !== null && _newClientOptions$net !== void 0 && _newClientOptions$net.logEventUrl)) {
      newClientOptions.networkConfig = _objectSpread(_objectSpread({}, newClientOptions.networkConfig), {}, {
        logEventUrl: DEFAULT_EVENT_LOGGING_API
      });
    }
    if (newClientOptions.perimeter === _types__WEBPACK_IMPORTED_MODULE_10__["PerimeterType"].FEDRAMP_MODERATE) {
      // disable all logging in FedRAMP to prevent egress of sensitive data
      newClientOptions.disableLogging = true;
    }
    const {
        sdkKey,
        environment,
        updateUserCompletionCallback: _updateUserCompletionCallback,
        perimeter: _perimeter
      } = newClientOptions,
      restClientOptions = _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_0___default()(newClientOptions, _excluded);
    this.sdkKey = sdkKey;
    this.user = Object(_utils__WEBPACK_IMPORTED_MODULE_11__["toStatsigUser"])(identifiers, customAttributes, this.sdkKey);
    const statsigOptions = _objectSpread(_objectSpread({}, restClientOptions), {}, {
      environment: {
        tier: environment
      },
      includeCurrentPageUrlWithEvents: false,
      dataAdapter: this.dataAdapter,
      overrideAdapter: this.overrideAdapter
    });
    try {
      this.statsigClient = new _statsig_js_client__WEBPACK_IMPORTED_MODULE_2__["StatsigClient"](sdkKey, this.user, statsigOptions);
      this.dataAdapter.setBootstrapData(initializeValues);
      await this.statsigClient.initializeAsync();
    } catch (error) {
      if (error instanceof Error) {
        // eslint-disable-next-line no-console
        console.error(`Error occurred when trying to initialise the Statsig client, error: ${error === null || error === void 0 ? void 0 : error.message}`);
      }
      // eslint-disable-next-line no-console
      console.warn(`Initialising Statsig client with default sdk key and without values`);
      this.statsigClient = new _statsig_js_client__WEBPACK_IMPORTED_MODULE_2__["StatsigClient"](DEFAULT_CLIENT_KEY, this.user, statsigOptions);
      this.dataAdapter.setBootstrapData();
      await this.statsigClient.initializeAsync();
      this.initWithDefaults = true;
      throw error;
    }
  }

  /**
   * This method updates the user for this client with the bootstrap values returned from a given
   * Promise.
   * It uses the customAttributes from fetching experiment values to update the Statsig user but
   * uses the customAttributes from given input to check if the user has changed.
   *
   * @param {Identifiers} identifiers
   * @param {CustomAttributes} customAttributes
   * @param {Promise<InitializeValues>} getInitializeValues
   * @private
   */
  async updateUserUsingInitializeValuesProducer(getInitializeValues, identifiers, customAttributes) {
    this.assertInitialized(this.statsigClient);
    if (!this.initPromise) {
      throw new Error('The client must be initialized before you can update the user.');
    }

    // If the user isn't changing at all, then exit immediately
    if (this.isCurrentUser(identifiers, customAttributes)) {
      return this.initPromise;
    }

    // Wait for the current initialize/update to finish
    const originalInitPromise = this.initPromise;
    try {
      await this.initPromise;
    } catch (err) {
      // Proceed with the user update even if the init failed, since this update
      // may put the client back into a valid state.
    }
    const initializeValuesPromise = getInitializeValues();
    const updateUserPromise = this.updateStatsigClientUser(initializeValuesPromise, identifiers, customAttributes);

    // We replace the init promise here since we are essentially re-initializing the client at this
    // point. Any subsequent calls to await client.initialize() or client.updateUser()
    // will now also await this user update.
    this.initPromise = updateUserPromise.catch(async () => {
      // If the update failed then it changed nothing, so revert back to the original promise.
      this.initPromise = originalInitPromise;

      // Set the user profile again to revert back to the current user
      if (this.provider) {
        await this.provider.setProfile(this.initOptions, this.currentIdentifiers, this.currentAttributes);
      }
    });
    return updateUserPromise;
  }

  /**
   * This method updates the user on the nested Statsig client
   *
   * @param identifiers
   * @param customAttributes
   * @param initializeValuesPromise
   * @private
   */
  async updateStatsigClientUser(initializeValuesPromise, identifiers, customAttributes) {
    var _this$initOptions, _this$initOptions$upd;
    this.assertInitialized(this.statsigClient);
    let initializeValues, user;
    try {
      initializeValues = await initializeValuesPromise;
      user = Object(_utils__WEBPACK_IMPORTED_MODULE_11__["toStatsigUser"])(identifiers, initializeValues.customAttributesFromFetch, this.sdkKey);
    } catch (err) {
      var _updateUserCompletion, _ref;
      // Make sure the updateUserCompletionCallback is called for any errors in our custom code.
      // This is not necessary for the updateUserWithValues call, because the Statsig client will
      // already invoke the callback itself.
      const errMsg = err instanceof Error ? err.message : JSON.stringify(err);
      (_updateUserCompletion = (_ref = this.initOptions).updateUserCompletionCallback) === null || _updateUserCompletion === void 0 ? void 0 : _updateUserCompletion.call(_ref, false, errMsg);
      throw err;
    }
    let success = true;
    let errorMessage = null;
    try {
      this.dataAdapter.setBootstrapData(initializeValues.experimentValues);
      this.user = user;
      await this.statsigClient.updateUserAsync(this.user);
    } catch (err) {
      success = false;
      errorMessage = String(err);
    }
    (_this$initOptions = this.initOptions) === null || _this$initOptions === void 0 ? void 0 : (_this$initOptions$upd = _this$initOptions.updateUserCompletionCallback) === null || _this$initOptions$upd === void 0 ? void 0 : _this$initOptions$upd.call(_this$initOptions, success, errorMessage);
    if (success) {
      this.currentIdentifiers = identifiers;
      this.currentAttributes = customAttributes;
      this.subscriptions.anyUpdated();
    } else {
      throw new Error('Failed to update user. An unexpected error occured.');
    }
  }
  /**
   * @returns string version of the current package in semver style.
   */
  getPackageVersion() {
    return _version__WEBPACK_IMPORTED_MODULE_12__["CLIENT_VERSION"];
  }

  /**
   * Returns a specified layer otherwise returns an empty layer as a default value if the layer doesn't exist.
   *
   * @param {string} layerName - The name of the layer
   * @param {Object} options
   * @param {boolean} options.fireLayerExposure - Whether or not to fire the exposure event for the
   * layer. Defaults to true. To log an exposure event manually at a later time, use
   * {@link Client.manuallyLogLayerExposure} (see [Statsig docs about manually logging exposures](https://docs.statsig.com/client/jsClientSDK#manual-exposures-)).
   * @returns A layer
   * @example
   * ```ts
   * const layer = client.getLayer('example-layer-name');
   * const exampletitle: string = layer.get("title", "Welcome to Statsig!");
   * ```
   */
  getLayer( /** The name of the layer */
  layerName, options = {}) {
    try {
      this.assertInitialized(this.statsigClient);
      const {
        fireLayerExposure = true
      } = options;
      return _compat_Layer__WEBPACK_IMPORTED_MODULE_5__["Layer"].fromLayer(this.statsigClient.getLayer(layerName, {
        disableExposureLog: !fireLayerExposure
      }));
    } catch (error) {
      // Log the first occurrence of the error
      if (!this.hasGetLayerErrorOccurred) {
        // eslint-disable-next-line no-console
        console.warn({
          msg: 'An error has occurred getting the layer. Only the first occurrence of this error is logged.',
          layerName,
          error
        });
        this.hasGetLayerErrorOccurred = true;
      }

      // Return a default value
      return _compat_Layer__WEBPACK_IMPORTED_MODULE_5__["Layer"].fromLayer(Object(_statsig_js_client__WEBPACK_IMPORTED_MODULE_2__["_makeLayer"])(layerName, {
        reason: 'Error'
      }, null));
    }
  }

  /**
   * Returns the value of a given parameter in a layer config.
   *
   * @template T
   * @param {string} layerName - The name of the layer
   * @param {string} parameterName - The name of the parameter to fetch from the layer config
   * @param {T} defaultValue - The value to serve if the layer or parameter do not exist, or if the
   * returned value does not match the expected type.
   * @param {Object} options
   * @param {boolean} options.fireLayerExposure - Whether or not to fire the exposure event for the
   * layer. Defaults to true. To log an exposure event manually at a later time, use
   * {@link Client.manuallyLogLayerExposure} (see [Statsig docs about manually logging exposures](https://docs.statsig.com/client/jsClientSDK#manual-exposures-))
   * @param {function} options.typeGuard - A function that asserts that the return value has the expected type. If this function returns false, then the default value will be returned instead. This can be set to protect your code from unexpected values being set remotely. By default, this will be done by asserting that the default value and value are the same primitive type.
   * @returns The value of the parameter if the layer and parameter both exist, otherwise the default value.
   * @example
   * ``` ts
   * type ValidColor = 'blue' | 'red' | 'yellow';
   * type ValidColorTypeCheck = (value: unknown) => value is ValidColor;
   *
   * const isValidColor: ValidColorTypeCheck =
   *    (value: unknown) => typeof value === 'string' && ['blue', 'red', 'yellow'].includes(value);
   *
   * const buttonColor: ValidColor = client.getLayerValue(
   *    'example-layer-name',
   *    'backgroundColor',
   *    'yellow',
   *    {
   *        typeGuard: isValidColor
   *    }
   * );
   * ```
   */
  getLayerValue(layerName, parameterName, defaultValue, options = {}) {
    const layer = this.getLayer(layerName, options);
    try {
      const {
        typeGuard
      } = options;
      return layer.get(parameterName, defaultValue, typeGuard);
    } catch (error) {
      // Log the first occurrence of the error
      if (!this.hasGetLayerValueErrorOccurred) {
        // eslint-disable-next-line no-console
        console.warn({
          msg: 'An error has occurred getting the layer value. Only the first occurrence of this error is logged.',
          layerName,
          defaultValue,
          options,
          error
        });
        this.hasGetLayerValueErrorOccurred = true;
      }
      return defaultValue;
    }
  }
}

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

var objectWithoutPropertiesLoose = __webpack_require__(8);
function _objectWithoutProperties(e, t) {
  if (null == e) return {};
  var o,
    r,
    i = objectWithoutPropertiesLoose(e, t);
  if (Object.getOwnPropertySymbols) {
    var s = Object.getOwnPropertySymbols(e);
    for (r = 0; r < s.length; r++) o = s[r], t.includes(o) || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]);
  }
  return i;
}
module.exports = _objectWithoutProperties, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),
/* 8 */
/***/ (function(module, exports) {

function _objectWithoutPropertiesLoose(r, e) {
  if (null == r) return {};
  var t = {};
  for (var n in r) if ({}.hasOwnProperty.call(r, n)) {
    if (e.includes(n)) continue;
    t[n] = r[n];
  }
  return t;
}
module.exports = _objectWithoutPropertiesLoose, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StatsigClient = void 0;
const StatsigClient_1 = __webpack_require__(10);
exports.StatsigClient = StatsigClient_1.default;
__exportStar(__webpack_require__(11), exports);
__STATSIG__ = Object.assign(Object.assign({}, (__STATSIG__ !== null && __STATSIG__ !== void 0 ? __STATSIG__ : {})), { StatsigClient: StatsigClient_1.default });
exports.default = __STATSIG__;


/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const client_core_1 = __webpack_require__(11);
const EvaluationStore_1 = __webpack_require__(56);
const Network_1 = __webpack_require__(57);
const ParamStoreGetterFactory_1 = __webpack_require__(59);
const StatsigEvaluationsDataAdapter_1 = __webpack_require__(60);
class StatsigClient extends client_core_1.StatsigClientBase {
    /**
     * Retrieves an instance of the StatsigClient based on the provided SDK key.
     *  If no SDK key is provided, the method returns the most recently created instance of the StatsigClient.
     *  The method ensures that each unique SDK key corresponds to a single instance of StatsigClient, effectively implementing a singleton pattern for each key.
     *
     * @param {string} [sdkKey] - Optional. The SDK key used to identify a specific instance of the StatsigClient. If omitted, the method returns the last created instance.
     * @returns {StatsigClient|undefined} Returns the StatsigClient instance associated with the given SDK key, or undefined if no instance is associated with the key or if no key is provided and no instances exist.
     */
    static instance(sdkKey) {
        const instance = (0, client_core_1._getStatsigGlobal)().instance(sdkKey);
        if (instance instanceof StatsigClient) {
            return instance;
        }
        client_core_1.Log.warn((0, client_core_1._isServerEnv)()
            ? 'StatsigClient.instance is not supported in server environments'
            : 'Unable to find StatsigClient instance');
        return new StatsigClient(sdkKey !== null && sdkKey !== void 0 ? sdkKey : '', {});
    }
    /**
     * StatsigClient constructor
     *
     * @param {string} sdkKey A Statsig client SDK key. eg "client-xyz123..."
     * @param {StatsigUser} user StatsigUser object containing various attributes related to a user.
     * @param {StatsigOptions | null} options StatsigOptions, used to customize the behavior of the SDK.
     */
    constructor(sdkKey, user, options = null) {
        var _a, _b;
        client_core_1.SDKType._setClientType(sdkKey, 'javascript-client');
        const network = new Network_1.default(options, (e) => {
            this.$emt(e);
        });
        super(sdkKey, (_a = options === null || options === void 0 ? void 0 : options.dataAdapter) !== null && _a !== void 0 ? _a : new StatsigEvaluationsDataAdapter_1.StatsigEvaluationsDataAdapter(), network, options);
        /**
         * Retrieves the value of a feature gate for the current user, represented as a {@link FeatureGate} object.
         *
         * @param {string} name - The name of the feature gate to retrieve.
         * @param {FeatureGateEvaluationOptions} [options] - Optional. Additional options to customize the method call.
         * @returns {FeatureGate} - The {@link FeatureGate} object representing the gate's current evaluation results for the user.
         */
        this.getFeatureGate = this._memoize(client_core_1.MemoPrefix._gate, this._getFeatureGateImpl.bind(this));
        /**
         * Retrieves the value of a dynamic config for the current user.
         *
         * @param {string} name The name of the dynamic config to get.
         * @param {DynamicConfigEvaluationOptions} [options] - Optional. Additional options to customize the method call.
         * @returns {DynamicConfig} - The {@link DynamicConfig} object representing the dynamic configs's current evaluation results for the user.
         */
        this.getDynamicConfig = this._memoize(client_core_1.MemoPrefix._dynamicConfig, this._getDynamicConfigImpl.bind(this));
        /**
         * Retrieves the value of a experiment for the current user.
         *
         * @param {string} name The name of the experiment to get.
         * @param {ExperimentEvaluationOptions} [options] - Optional. Additional options to customize the method call.
         * @returns {Experiment} - The {@link Experiment} object representing the experiments's current evaluation results for the user.
         */
        this.getExperiment = this._memoize(client_core_1.MemoPrefix._experiment, this._getExperimentImpl.bind(this));
        /**
         * Retrieves the value of a layer for the current user.
         *
         * @param {string} name The name of the layer to get.
         * @param {LayerEvaluationOptions} [options] - Optional. Additional options to customize the method call.
         * @returns {Layer} - The {@link Layer} object representing the layers's current evaluation results for the user.
         */
        this.getLayer = this._memoize(client_core_1.MemoPrefix._layer, this._getLayerImpl.bind(this));
        /**
         * Retrieves the value of a parameter store for the current user.
         *
         * @param {string} name The name of the parameter store to get.
         * @param {ParameterStoreEvaluationOptions} [options] - Optional. Additional options to customize the method call.
         * @returns {ParameterStore} - The {@link ParameterStore} object representing the parameter store's current mappings for the user.
         */
        this.getParameterStore = this._memoize(client_core_1.MemoPrefix._paramStore, this._getParameterStoreImpl.bind(this));
        this._store = new EvaluationStore_1.default(sdkKey);
        this._network = network;
        this._user = this._configureUser(user, options);
        const plugins = (_b = options === null || options === void 0 ? void 0 : options.plugins) !== null && _b !== void 0 ? _b : [];
        for (const plugin of plugins) {
            plugin.bind(this);
        }
    }
    /**
     * Initializes the StatsigClient using cached values. This method sets up the client synchronously by utilizing previously cached values.
     * After initialization, cache values are updated in the background for future use, either in subsequent sessions or when `updateUser` is called.
     * This is useful for quickly starting with the last-known-good configurations while refreshing data to keep settings up-to-date.
     *
     * @see {@link initializeAsync} for the asynchronous version of this method.
     */
    initializeSync(options) {
        var _a;
        if (this.loadingStatus !== 'Uninitialized') {
            return (0, client_core_1.createUpdateDetails)(true, this._store.getSource(), -1, null, null, ['MultipleInitializations', ...((_a = this._store.getWarnings()) !== null && _a !== void 0 ? _a : [])]);
        }
        this._logger.start();
        return this.updateUserSync(this._user, options);
    }
    /**
     * Initializes the StatsigClient asynchronously by first using cached values and then updating to the latest values from the network.
     * Once the network values are fetched, they replace the existing cached values. If this method's promise is not awaited,
     * there might be a transition from cached to network values during the session, which can affect consistency.
     * This method is useful when it's acceptable to begin with potentially stale data and switch to the latest configuration as it becomes available.
     *
     * @param {AsyncUpdateOptions} [options] - Optional. Additional options to customize the method call.
     * @returns {Promise<void>} A promise that resolves once the client is fully initialized with the latest values from the network or a timeout (if set) is hit.
     * @see {@link initializeSync} for the synchronous version of this method.
     */
    initializeAsync(options) {
        return __awaiter(this, void 0, void 0, function* () {
            if (this._initializePromise) {
                return this._initializePromise;
            }
            this._initializePromise = this._initializeAsyncImpl(options);
            return this._initializePromise;
        });
    }
    /**
     * Synchronously updates the user in the Statsig client and switches the internal state to use cached values for the newly specified user.
     * After the initial switch to cached values, this method updates these values in the background, preparing them for future sessions or subsequent calls to updateUser.
     * This method ensures the client is quickly ready with available data.
     *
     * @param {StatsigUser} user - The new StatsigUser for which the client should update its internal state.
     * @see {@link updateUserAsync} for the asynchronous version of this method.
     */
    updateUserSync(user, options) {
        var _a;
        const startTime = performance.now();
        const warnings = [...((_a = this._store.getWarnings()) !== null && _a !== void 0 ? _a : [])];
        this._resetForUser(user);
        const result = this.dataAdapter.getDataSync(this._user);
        if (result == null) {
            warnings.push('NoCachedValues');
        }
        this._store.setValues(result, this._user);
        this._finalizeUpdate(result);
        const disable = options === null || options === void 0 ? void 0 : options.disableBackgroundCacheRefresh;
        if (disable === true ||
            (disable == null && (result === null || result === void 0 ? void 0 : result.source) === 'Bootstrap')) {
            return (0, client_core_1.createUpdateDetails)(true, this._store.getSource(), performance.now() - startTime, this._errorBoundary.getLastSeenErrorAndReset(), this._network.getLastUsedInitUrlAndReset(), warnings);
        }
        this._runPostUpdate(result !== null && result !== void 0 ? result : null, this._user);
        return (0, client_core_1.createUpdateDetails)(true, this._store.getSource(), performance.now() - startTime, this._errorBoundary.getLastSeenErrorAndReset(), this._network.getLastUsedInitUrlAndReset(), warnings);
    }
    /**
     * Asynchronously updates the user in the Statsig client by initially using cached values and then fetching the latest values from the network.
     * When the latest values are fetched, they replace the cached values. If the promise returned by this method is not awaited,
     * the client's state may shift from cached to updated network values during the session, potentially affecting consistency.
     * This method is best used in scenarios where up-to-date configuration is critical and initial delays are acceptable.
     *
     * @param {StatsigUser} user - The new StatsigUser for which the client should update its internal state.
     * @param {AsyncUpdateOptions} [options] - Optional. Additional options to customize the method call.
     * @returns {Promise<void>} A promise that resolves once the client is fully updated with the latest values from the network or a timeout (if set) is hit.
     * @see {@link updateUserSync} for the synchronous version of this method.
     */
    updateUserAsync(user, options) {
        return __awaiter(this, void 0, void 0, function* () {
            this._resetForUser(user);
            const initiator = this._user;
            client_core_1.Diagnostics._markInitOverallStart(this._sdkKey);
            let result = this.dataAdapter.getDataSync(initiator);
            this._store.setValues(result, this._user);
            this._setStatus('Loading', result);
            result = yield this.dataAdapter.getDataAsync(result, initiator, options);
            // ensure the user hasn't changed while we were waiting
            if (initiator !== this._user) {
                return (0, client_core_1.createUpdateDetails)(false, this._store.getSource(), -1, new Error('User changed during update'), this._network.getLastUsedInitUrlAndReset());
            }
            let isUsingNetworkValues = false;
            if (result != null) {
                client_core_1.Diagnostics._markInitProcessStart(this._sdkKey);
                isUsingNetworkValues = this._store.setValues(result, this._user);
                client_core_1.Diagnostics._markInitProcessEnd(this._sdkKey, {
                    success: isUsingNetworkValues,
                });
            }
            this._finalizeUpdate(result);
            if (!isUsingNetworkValues) {
                this._errorBoundary.attachErrorIfNoneExists(client_core_1.UPDATE_DETAIL_ERROR_MESSAGES.NO_NETWORK_DATA);
                this.$emt({ name: 'initialization_failure' });
            }
            client_core_1.Diagnostics._markInitOverallEnd(this._sdkKey, isUsingNetworkValues, this._store.getCurrentSourceDetails());
            const initDuration = client_core_1.Diagnostics._enqueueDiagnosticsEvent(this._user, this._logger, this._sdkKey, this._options);
            return (0, client_core_1.createUpdateDetails)(isUsingNetworkValues, this._store.getSource(), initDuration, this._errorBoundary.getLastSeenErrorAndReset(), this._network.getLastUsedInitUrlAndReset(), this._store.getWarnings());
        });
    }
    /**
     * Retrieves a synchronous context containing data currently being used by the SDK. Represented as a {@link PrecomputedEvaluationsContext} object.
     *
     * @returns {PrecomputedEvaluationsContext} The current synchronous context for the this StatsigClient instance.
     */
    getContext() {
        return {
            sdkKey: this._sdkKey,
            options: this._options,
            values: this._store.getValues(),
            user: JSON.parse(JSON.stringify(this._user)),
            errorBoundary: this._errorBoundary,
            session: client_core_1.StatsigSession.get(this._sdkKey),
            stableID: client_core_1.StableID.get(this._sdkKey),
        };
    }
    /**
     * Retrieves the value of a feature gate for the current user, represented as a simple boolean.
     *
     * @param {string} name - The name of the feature gate to retrieve.
     * @param {FeatureGateEvaluationOptions} [options] - Optional. Additional options to customize the method call.
     * @returns {boolean} - The boolean value representing the gate's current evaluation results for the user.
     */
    checkGate(name, options) {
        return this.getFeatureGate(name, options).value;
    }
    /**
     * Logs an event to the internal logging system. This function allows logging by either passing a fully formed event object or by specifying the event name with optional value and metadata.
     *
     * @param {StatsigEvent|string} eventOrName - The event object conforming to the StatsigEvent interface, or the name of the event as a string.
     * @param {string|number} value - Optional. The value associated with the event, which can be a string or a number. This parameter is ignored if the first parameter is a StatsigEvent object.
     * @param {Record<string, string>} metadata - Optional. A key-value record containing metadata about the event. This is also ignored if the first parameter is an event object.
     */
    logEvent(eventOrName, value, metadata) {
        const event = typeof eventOrName === 'string'
            ? {
                eventName: eventOrName,
                value,
                metadata,
            }
            : eventOrName;
        this._logger.enqueue(Object.assign(Object.assign({}, event), { user: this._user, time: Date.now() }));
    }
    _primeReadyRipcord() {
        this.$on('error', () => {
            this.loadingStatus === 'Loading' && this._finalizeUpdate(null);
        });
    }
    _initializeAsyncImpl(options) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!client_core_1.Storage.isReady()) {
                yield client_core_1.Storage.isReadyResolver();
            }
            this._logger.start();
            return this.updateUserAsync(this._user, options);
        });
    }
    _finalizeUpdate(values) {
        this._store.finalize();
        this._setStatus('Ready', values);
    }
    _runPostUpdate(current, user) {
        this.dataAdapter
            .getDataAsync(current, user, { priority: 'low' })
            .catch((err) => {
            client_core_1.Log.error('An error occurred after update.', err);
        });
    }
    _resetForUser(user) {
        this._logger.reset();
        this._store.reset();
        this._user = this._configureUser(user, this._options);
    }
    _configureUser(originalUser, options) {
        var _a;
        const user = (0, client_core_1._normalizeUser)(originalUser, options);
        const stableIdOverride = (_a = user.customIDs) === null || _a === void 0 ? void 0 : _a.stableID;
        if (stableIdOverride) {
            client_core_1.StableID.setOverride(stableIdOverride, this._sdkKey);
        }
        return user;
    }
    _getFeatureGateImpl(name, options) {
        var _a, _b;
        const { result: evaluation, details } = this._store.getGate(name);
        const gate = (0, client_core_1._makeFeatureGate)(name, details, evaluation);
        const overridden = (_b = (_a = this.overrideAdapter) === null || _a === void 0 ? void 0 : _a.getGateOverride) === null || _b === void 0 ? void 0 : _b.call(_a, gate, this._user, options);
        const result = overridden !== null && overridden !== void 0 ? overridden : gate;
        this._enqueueExposure(name, (0, client_core_1._createGateExposure)(this._user, result), options);
        this.$emt({ name: 'gate_evaluation', gate: result });
        return result;
    }
    _getDynamicConfigImpl(name, options) {
        var _a, _b;
        const { result: evaluation, details } = this._store.getConfig(name);
        const config = (0, client_core_1._makeDynamicConfig)(name, details, evaluation);
        const overridden = (_b = (_a = this.overrideAdapter) === null || _a === void 0 ? void 0 : _a.getDynamicConfigOverride) === null || _b === void 0 ? void 0 : _b.call(_a, config, this._user, options);
        const result = overridden !== null && overridden !== void 0 ? overridden : config;
        this._enqueueExposure(name, (0, client_core_1._createConfigExposure)(this._user, result), options);
        this.$emt({ name: 'dynamic_config_evaluation', dynamicConfig: result });
        return result;
    }
    _getExperimentImpl(name, options) {
        var _a, _b;
        const { result: evaluation, details } = this._store.getConfig(name);
        const experiment = (0, client_core_1._makeExperiment)(name, details, evaluation);
        const overridden = (_b = (_a = this.overrideAdapter) === null || _a === void 0 ? void 0 : _a.getExperimentOverride) === null || _b === void 0 ? void 0 : _b.call(_a, experiment, this._user, options);
        const result = overridden !== null && overridden !== void 0 ? overridden : experiment;
        this._enqueueExposure(name, (0, client_core_1._createConfigExposure)(this._user, result), options);
        this.$emt({ name: 'experiment_evaluation', experiment: result });
        return result;
    }
    _getLayerImpl(name, options) {
        var _a, _b, _c;
        const { result: evaluation, details } = this._store.getLayer(name);
        const layer = (0, client_core_1._makeLayer)(name, details, evaluation);
        const overridden = (_b = (_a = this.overrideAdapter) === null || _a === void 0 ? void 0 : _a.getLayerOverride) === null || _b === void 0 ? void 0 : _b.call(_a, layer, this._user, options);
        if (options === null || options === void 0 ? void 0 : options.disableExposureLog) {
            this._logger.incrementNonExposureCount(name);
        }
        const result = (0, client_core_1._mergeOverride)(layer, overridden, (_c = overridden === null || overridden === void 0 ? void 0 : overridden.__value) !== null && _c !== void 0 ? _c : layer.__value, (param) => {
            if (options === null || options === void 0 ? void 0 : options.disableExposureLog) {
                return;
            }
            this._enqueueExposure(name, (0, client_core_1._createLayerParameterExposure)(this._user, result, param), options);
        });
        this.$emt({ name: 'layer_evaluation', layer: result });
        return result;
    }
    _getParameterStoreImpl(name, options) {
        const { result: configuration, details } = this._store.getParamStore(name);
        this._logger.incrementNonExposureCount(name);
        return {
            name,
            details,
            __configuration: configuration,
            get: (0, ParamStoreGetterFactory_1._makeParamStoreGetter)(this, configuration, options),
        };
    }
}
exports.default = StatsigClient;


/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Storage = exports.Log = exports.EventLogger = exports.Diagnostics = void 0;
/** Statsig Global should go first */
__webpack_require__(12);
const Diagnostics_1 = __webpack_require__(15);
Object.defineProperty(exports, "Diagnostics", { enumerable: true, get: function () { return Diagnostics_1.Diagnostics; } });
const EventLogger_1 = __webpack_require__(16);
Object.defineProperty(exports, "EventLogger", { enumerable: true, get: function () { return EventLogger_1.EventLogger; } });
const Log_1 = __webpack_require__(14);
Object.defineProperty(exports, "Log", { enumerable: true, get: function () { return Log_1.Log; } });
const StatsigMetadata_1 = __webpack_require__(27);
const StorageProvider_1 = __webpack_require__(24);
Object.defineProperty(exports, "Storage", { enumerable: true, get: function () { return StorageProvider_1.Storage; } });
__exportStar(__webpack_require__(12), exports);
__exportStar(__webpack_require__(17), exports);
__exportStar(__webpack_require__(28), exports);
__exportStar(__webpack_require__(29), exports);
__exportStar(__webpack_require__(15), exports);
__exportStar(__webpack_require__(34), exports);
__exportStar(__webpack_require__(35), exports);
__exportStar(__webpack_require__(37), exports);
__exportStar(__webpack_require__(38), exports);
__exportStar(__webpack_require__(18), exports);
__exportStar(__webpack_require__(39), exports);
__exportStar(__webpack_require__(14), exports);
__exportStar(__webpack_require__(40), exports);
__exportStar(__webpack_require__(20), exports);
__exportStar(__webpack_require__(41), exports);
__exportStar(__webpack_require__(46), exports);
__exportStar(__webpack_require__(47), exports);
__exportStar(__webpack_require__(21), exports);
__exportStar(__webpack_require__(36), exports);
__exportStar(__webpack_require__(44), exports);
__exportStar(__webpack_require__(30), exports);
__exportStar(__webpack_require__(48), exports);
__exportStar(__webpack_require__(45), exports);
__exportStar(__webpack_require__(49), exports);
__exportStar(__webpack_require__(23), exports);
__exportStar(__webpack_require__(27), exports);
__exportStar(__webpack_require__(50), exports);
__exportStar(__webpack_require__(51), exports);
__exportStar(__webpack_require__(52), exports);
__exportStar(__webpack_require__(53), exports);
__exportStar(__webpack_require__(32), exports);
__exportStar(__webpack_require__(24), exports);
__exportStar(__webpack_require__(33), exports);
__exportStar(__webpack_require__(19), exports);
__exportStar(__webpack_require__(25), exports);
__exportStar(__webpack_require__(31), exports);
__exportStar(__webpack_require__(26), exports);
__exportStar(__webpack_require__(54), exports);
__exportStar(__webpack_require__(55), exports);
__STATSIG__ = Object.assign(Object.assign({}, (__STATSIG__ !== null && __STATSIG__ !== void 0 ? __STATSIG__ : {})), { Log: Log_1.Log,
    SDK_VERSION: StatsigMetadata_1.SDK_VERSION });


/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {
/* eslint-disable @typescript-eslint/no-unsafe-assignment */
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports._getInstance = exports._getStatsigGlobalFlag = exports._getStatsigGlobal = void 0;
const Log_1 = __webpack_require__(14);
const _getStatsigGlobal = () => {
    return __STATSIG__ ? __STATSIG__ : statsigGlobal;
};
exports._getStatsigGlobal = _getStatsigGlobal;
const _getStatsigGlobalFlag = (flag) => {
    return (0, exports._getStatsigGlobal)()[flag];
};
exports._getStatsigGlobalFlag = _getStatsigGlobalFlag;
const _getInstance = (sdkKey) => {
    const gbl = (0, exports._getStatsigGlobal)();
    if (!sdkKey) {
        if (gbl.instances && Object.keys(gbl.instances).length > 1) {
            Log_1.Log.warn('Call made to Statsig global instance without an SDK key but there is more than one client instance. If you are using mulitple clients, please specify the SDK key.');
        }
        return gbl.firstInstance;
    }
    return gbl.instances && gbl.instances[sdkKey];
};
exports._getInstance = _getInstance;
const GLOBAL_KEY = '__STATSIG__';
const _window = typeof window !== 'undefined' ? window : {};
const _global = typeof global !== 'undefined' ? global : {};
const _globalThis = typeof globalThis !== 'undefined' ? globalThis : {};
const statsigGlobal = (_c = (_b = (_a = _window[GLOBAL_KEY]) !== null && _a !== void 0 ? _a : _global[GLOBAL_KEY]) !== null && _b !== void 0 ? _b : _globalThis[GLOBAL_KEY]) !== null && _c !== void 0 ? _c : {
    instance: exports._getInstance,
};
_window[GLOBAL_KEY] = statsigGlobal;
_global[GLOBAL_KEY] = statsigGlobal;
_globalThis[GLOBAL_KEY] = statsigGlobal;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(13)))

/***/ }),
/* 13 */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || new Function("return this")();
} catch (e) {
	// This works if the window reference is available
	if (typeof window === "object") g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/* eslint-disable no-console */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Log = exports.LogLevel = void 0;
// intentionally spaced for formatting
const DEBUG = ' DEBUG ';
const _INFO = '  INFO ';
const _WARN = '  WARN ';
const ERROR = ' ERROR ';
function addTag(args) {
    args.unshift('[Statsig]');
    return args; // ['[Statsig]', ...args];
}
exports.LogLevel = {
    None: 0,
    Error: 1,
    Warn: 2,
    Info: 3,
    Debug: 4,
};
class Log {
    static info(...args) {
        if (Log.level >= exports.LogLevel.Info) {
            console.info(_INFO, ...addTag(args));
        }
    }
    static debug(...args) {
        if (Log.level >= exports.LogLevel.Debug) {
            console.debug(DEBUG, ...addTag(args));
        }
    }
    static warn(...args) {
        if (Log.level >= exports.LogLevel.Warn) {
            console.warn(_WARN, ...addTag(args));
        }
    }
    static error(...args) {
        if (Log.level >= exports.LogLevel.Error) {
            console.error(ERROR, ...addTag(args));
        }
    }
}
exports.Log = Log;
Log.level = exports.LogLevel.Warn;


/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Diagnostics = void 0;
const MARKER_MAP = new Map();
const ACT_START = 'start';
const ACT_END = 'end';
const DIAGNOSTICS_EVENT = 'statsig::diagnostics';
exports.Diagnostics = {
    _getMarkers: (sdkKey) => {
        return MARKER_MAP.get(sdkKey);
    },
    _markInitOverallStart: (sdkKey) => {
        _addMarker(sdkKey, _createMarker({}, ACT_START, 'overall'));
    },
    _markInitOverallEnd: (sdkKey, success, evaluationDetails) => {
        _addMarker(sdkKey, _createMarker({
            success,
            error: success
                ? undefined
                : { name: 'InitializeError', message: 'Failed to initialize' },
            evaluationDetails,
        }, ACT_END, 'overall'));
    },
    _markInitNetworkReqStart: (sdkKey, data) => {
        _addMarker(sdkKey, _createMarker(data, ACT_START, 'initialize', 'network_request'));
    },
    _markInitNetworkReqEnd: (sdkKey, data) => {
        _addMarker(sdkKey, _createMarker(data, ACT_END, 'initialize', 'network_request'));
    },
    _markInitProcessStart: (sdkKey) => {
        _addMarker(sdkKey, _createMarker({}, ACT_START, 'initialize', 'process'));
    },
    _markInitProcessEnd: (sdkKey, data) => {
        _addMarker(sdkKey, _createMarker(data, ACT_END, 'initialize', 'process'));
    },
    _clearMarkers: (sdkKey) => {
        MARKER_MAP.delete(sdkKey);
    },
    _formatError(e) {
        if (!(e && typeof e === 'object')) {
            return;
        }
        return {
            code: _safeGetField(e, 'code'),
            name: _safeGetField(e, 'name'),
            message: _safeGetField(e, 'message'),
        };
    },
    _getDiagnosticsData(res, attempt, body, e) {
        var _a;
        return {
            success: (res === null || res === void 0 ? void 0 : res.ok) === true,
            statusCode: res === null || res === void 0 ? void 0 : res.status,
            sdkRegion: (_a = res === null || res === void 0 ? void 0 : res.headers) === null || _a === void 0 ? void 0 : _a.get('x-statsig-region'),
            isDelta: body.includes('"is_delta":true') === true ? true : undefined,
            attempt,
            error: exports.Diagnostics._formatError(e),
        };
    },
    _enqueueDiagnosticsEvent(user, logger, sdk, options) {
        const markers = exports.Diagnostics._getMarkers(sdk);
        if (markers == null || markers.length <= 0) {
            return -1;
        }
        const overallInitDuration = markers[markers.length - 1].timestamp - markers[0].timestamp;
        exports.Diagnostics._clearMarkers(sdk);
        const event = _makeDiagnosticsEvent(user, {
            context: 'initialize',
            markers: markers.slice(),
            statsigOptions: options,
        });
        logger.enqueue(event);
        return overallInitDuration;
    },
};
function _createMarker(data, action, key, step) {
    return Object.assign({ key: key, action: action, step: step, timestamp: Date.now() }, data);
}
function _makeDiagnosticsEvent(user, data) {
    const latencyEvent = {
        eventName: DIAGNOSTICS_EVENT,
        user,
        value: null,
        metadata: data,
        time: Date.now(),
    };
    return latencyEvent;
}
function _addMarker(sdkKey, marker) {
    var _a;
    const markers = (_a = MARKER_MAP.get(sdkKey)) !== null && _a !== void 0 ? _a : [];
    markers.push(marker);
    MARKER_MAP.set(sdkKey, markers);
}
function _safeGetField(data, field) {
    if (field in data) {
        return data[field];
    }
    return undefined;
}


/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventLogger = void 0;
const CacheKey_1 = __webpack_require__(17);
const Hashing_1 = __webpack_require__(18);
const Log_1 = __webpack_require__(14);
const NetworkConfig_1 = __webpack_require__(20);
const SafeJs_1 = __webpack_require__(21);
const StatsigEvent_1 = __webpack_require__(23);
const StorageProvider_1 = __webpack_require__(24);
const UrlConfiguration_1 = __webpack_require__(25);
const VisibilityObserving_1 = __webpack_require__(26);
const DEFAULT_QUEUE_SIZE = 100;
const DEFAULT_FLUSH_INTERVAL_MS = 10000;
const MAX_DEDUPER_KEYS = 1000;
const DEDUPER_WINDOW_DURATION_MS = 600000;
const MAX_FAILED_LOGS = 500;
const QUICK_FLUSH_WINDOW_MS = 200;
const EVENT_LOGGER_MAP = {};
const RetryFailedLogsTrigger = {
    Startup: 'startup',
    GainedFocus: 'gained_focus',
};
class EventLogger {
    static _safeFlushAndForget(sdkKey) {
        var _a;
        (_a = EVENT_LOGGER_MAP[sdkKey]) === null || _a === void 0 ? void 0 : _a.flush().catch(() => {
            // noop
        });
    }
    static _safeRetryFailedLogs(sdkKey) {
        var _a;
        (_a = EVENT_LOGGER_MAP[sdkKey]) === null || _a === void 0 ? void 0 : _a._retryFailedLogs(RetryFailedLogsTrigger.GainedFocus);
    }
    constructor(_sdkKey, _emitter, _network, _options) {
        var _a;
        this._sdkKey = _sdkKey;
        this._emitter = _emitter;
        this._network = _network;
        this._options = _options;
        this._queue = [];
        this._lastExposureTimeMap = {};
        this._nonExposedChecks = {};
        this._hasRunQuickFlush = false;
        this._creationTime = Date.now();
        this._isLoggingDisabled = (_options === null || _options === void 0 ? void 0 : _options.disableLogging) === true;
        this._maxQueueSize = (_a = _options === null || _options === void 0 ? void 0 : _options.loggingBufferMaxSize) !== null && _a !== void 0 ? _a : DEFAULT_QUEUE_SIZE;
        const config = _options === null || _options === void 0 ? void 0 : _options.networkConfig;
        this._logEventUrlConfig = new UrlConfiguration_1.UrlConfiguration(NetworkConfig_1.Endpoint._rgstr, config === null || config === void 0 ? void 0 : config.logEventUrl, config === null || config === void 0 ? void 0 : config.api, config === null || config === void 0 ? void 0 : config.logEventFallbackUrls);
    }
    setLoggingDisabled(isDisabled) {
        this._isLoggingDisabled = isDisabled;
    }
    enqueue(event) {
        if (!this._shouldLogEvent(event)) {
            return;
        }
        this._normalizeAndAppendEvent(event);
        this._quickFlushIfNeeded();
        if (this._queue.length > this._maxQueueSize) {
            EventLogger._safeFlushAndForget(this._sdkKey);
        }
    }
    incrementNonExposureCount(name) {
        var _a;
        const current = (_a = this._nonExposedChecks[name]) !== null && _a !== void 0 ? _a : 0;
        this._nonExposedChecks[name] = current + 1;
    }
    reset() {
        this._lastExposureTimeMap = {};
    }
    start() {
        if ((0, SafeJs_1._isServerEnv)()) {
            return; // do not run in server environments
        }
        EVENT_LOGGER_MAP[this._sdkKey] = this;
        (0, VisibilityObserving_1._subscribeToVisiblityChanged)((visibility) => {
            if (visibility === 'background') {
                EventLogger._safeFlushAndForget(this._sdkKey);
            }
            else if (visibility === 'foreground') {
                EventLogger._safeRetryFailedLogs(this._sdkKey);
            }
        });
        this._retryFailedLogs(RetryFailedLogsTrigger.Startup);
        this._startBackgroundFlushInterval();
    }
    stop() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this._flushIntervalId) {
                clearInterval(this._flushIntervalId);
                this._flushIntervalId = null;
            }
            delete EVENT_LOGGER_MAP[this._sdkKey];
            yield this.flush();
        });
    }
    flush() {
        return __awaiter(this, void 0, void 0, function* () {
            this._appendAndResetNonExposedChecks();
            if (this._queue.length === 0) {
                return;
            }
            const events = this._queue;
            this._queue = [];
            yield this._sendEvents(events);
        });
    }
    /**
     * We 'Quick Flush' following the very first event enqueued
     * within the quick flush window
     */
    _quickFlushIfNeeded() {
        if (this._hasRunQuickFlush) {
            return;
        }
        this._hasRunQuickFlush = true;
        if (Date.now() - this._creationTime > QUICK_FLUSH_WINDOW_MS) {
            return;
        }
        setTimeout(() => EventLogger._safeFlushAndForget(this._sdkKey), QUICK_FLUSH_WINDOW_MS);
    }
    _shouldLogEvent(event) {
        if ((0, SafeJs_1._isServerEnv)()) {
            return false; // do not run in server environments
        }
        if (!(0, StatsigEvent_1._isExposureEvent)(event)) {
            return true;
        }
        const user = event.user ? event.user : { statsigEnvironment: undefined };
        const userKey = (0, CacheKey_1._getUserStorageKey)(this._sdkKey, user);
        const metadata = event.metadata ? event.metadata : {};
        const key = [
            event.eventName,
            userKey,
            metadata['gate'],
            metadata['config'],
            metadata['ruleID'],
            metadata['allocatedExperiment'],
            metadata['parameterName'],
            String(metadata['isExplicitParameter']),
            metadata['reason'],
        ].join('|');
        const previous = this._lastExposureTimeMap[key];
        const now = Date.now();
        if (previous && now - previous < DEDUPER_WINDOW_DURATION_MS) {
            return false;
        }
        if (Object.keys(this._lastExposureTimeMap).length > MAX_DEDUPER_KEYS) {
            this._lastExposureTimeMap = {};
        }
        this._lastExposureTimeMap[key] = now;
        return true;
    }
    _sendEvents(events) {
        var _a, _b;
        return __awaiter(this, void 0, void 0, function* () {
            if (this._isLoggingDisabled) {
                this._saveFailedLogsToStorage(events);
                return false;
            }
            try {
                const isClosing = (0, VisibilityObserving_1._isUnloading)();
                const shouldUseBeacon = isClosing &&
                    this._network.isBeaconSupported() &&
                    ((_b = (_a = this._options) === null || _a === void 0 ? void 0 : _a.networkConfig) === null || _b === void 0 ? void 0 : _b.networkOverrideFunc) == null;
                this._emitter({
                    name: 'pre_logs_flushed',
                    events,
                });
                const response = shouldUseBeacon
                    ? yield this._sendEventsViaBeacon(events)
                    : yield this._sendEventsViaPost(events);
                if (response.success) {
                    this._emitter({
                        name: 'logs_flushed',
                        events,
                    });
                    return true;
                }
                else {
                    Log_1.Log.warn('Failed to flush events.');
                    this._saveFailedLogsToStorage(events);
                    return false;
                }
            }
            catch (_c) {
                Log_1.Log.warn('Failed to flush events.');
                return false;
            }
        });
    }
    _sendEventsViaPost(events) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const result = yield this._network.post(this._getRequestData(events));
            const code = (_a = result === null || result === void 0 ? void 0 : result.code) !== null && _a !== void 0 ? _a : -1;
            return { success: code >= 200 && code < 300 };
        });
    }
    _sendEventsViaBeacon(events) {
        return __awaiter(this, void 0, void 0, function* () {
            return {
                success: yield this._network.beacon(this._getRequestData(events)),
            };
        });
    }
    _getRequestData(events) {
        return {
            sdkKey: this._sdkKey,
            data: {
                events,
            },
            urlConfig: this._logEventUrlConfig,
            retries: 3,
            isCompressable: true,
            params: {
                [NetworkConfig_1.NetworkParam.EventCount]: String(events.length),
            },
        };
    }
    _saveFailedLogsToStorage(events) {
        while (events.length > MAX_FAILED_LOGS) {
            events.shift();
        }
        const storageKey = this._getStorageKey();
        try {
            (0, StorageProvider_1._setObjectInStorage)(storageKey, events);
        }
        catch (_a) {
            Log_1.Log.warn('Unable to save failed logs to storage');
        }
    }
    _retryFailedLogs(trigger) {
        const storageKey = this._getStorageKey();
        (() => __awaiter(this, void 0, void 0, function* () {
            if (!StorageProvider_1.Storage.isReady()) {
                yield StorageProvider_1.Storage.isReadyResolver();
            }
            const events = (0, StorageProvider_1._getObjectFromStorage)(storageKey);
            if (!events) {
                return;
            }
            if (trigger === RetryFailedLogsTrigger.Startup) {
                StorageProvider_1.Storage.removeItem(storageKey);
            }
            const isSuccess = yield this._sendEvents(events);
            if (isSuccess && trigger === RetryFailedLogsTrigger.GainedFocus) {
                StorageProvider_1.Storage.removeItem(storageKey);
            }
        }))().catch(() => {
            Log_1.Log.warn('Failed to flush stored logs');
        });
    }
    _getStorageKey() {
        return `statsig.failed_logs.${(0, Hashing_1._DJB2)(this._sdkKey)}`;
    }
    _normalizeAndAppendEvent(event) {
        if (event.user) {
            event.user = Object.assign({}, event.user);
            delete event.user.privateAttributes;
        }
        const extras = {};
        const currentPage = this._getCurrentPageUrl();
        if (currentPage) {
            extras.statsigMetadata = { currentPage };
        }
        const final = Object.assign(Object.assign({}, event), extras);
        Log_1.Log.debug('Enqueued Event:', final);
        this._queue.push(final);
    }
    _appendAndResetNonExposedChecks() {
        if (Object.keys(this._nonExposedChecks).length === 0) {
            return;
        }
        this._normalizeAndAppendEvent({
            eventName: 'statsig::non_exposed_checks',
            user: null,
            time: Date.now(),
            metadata: {
                checks: Object.assign({}, this._nonExposedChecks),
            },
        });
        this._nonExposedChecks = {};
    }
    _getCurrentPageUrl() {
        var _a;
        if (((_a = this._options) === null || _a === void 0 ? void 0 : _a.includeCurrentPageUrlWithEvents) === false) {
            return;
        }
        return (0, SafeJs_1._getCurrentPageUrlSafe)();
    }
    _startBackgroundFlushInterval() {
        var _a, _b;
        const flushInterval = (_b = (_a = this._options) === null || _a === void 0 ? void 0 : _a.loggingIntervalMs) !== null && _b !== void 0 ? _b : DEFAULT_FLUSH_INTERVAL_MS;
        const intervalId = setInterval(() => {
            const logger = EVENT_LOGGER_MAP[this._sdkKey];
            if (!logger || logger._flushIntervalId !== intervalId) {
                clearInterval(intervalId);
            }
            else {
                EventLogger._safeFlushAndForget(this._sdkKey);
            }
        }, flushInterval);
        this._flushIntervalId = intervalId;
    }
}
exports.EventLogger = EventLogger;


/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports._getStorageKey = exports._getUserStorageKey = void 0;
const Hashing_1 = __webpack_require__(18);
function _getUserStorageKey(sdkKey, user, customKeyGenerator) {
    var _a;
    if (customKeyGenerator) {
        return customKeyGenerator(sdkKey, user);
    }
    const cids = user && user.customIDs ? user.customIDs : {};
    const parts = [
        `uid:${(_a = user === null || user === void 0 ? void 0 : user.userID) !== null && _a !== void 0 ? _a : ''}`,
        `cids:${Object.keys(cids)
            .sort((leftKey, rightKey) => leftKey.localeCompare(rightKey))
            .map((key) => `${key}-${cids[key]}`)
            .join(',')}`,
        `k:${sdkKey}`,
    ];
    return (0, Hashing_1._DJB2)(parts.join('|'));
}
exports._getUserStorageKey = _getUserStorageKey;
function _getStorageKey(sdkKey, user, customKeyGenerator) {
    if (user) {
        return _getUserStorageKey(sdkKey, user, customKeyGenerator);
    }
    return (0, Hashing_1._DJB2)(`k:${sdkKey}`);
}
exports._getStorageKey = _getStorageKey;


/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports._getSortedObject = exports._DJB2Object = exports._DJB2 = void 0;
const TypingUtils_1 = __webpack_require__(19);
const _DJB2 = (value) => {
    let hash = 0;
    for (let i = 0; i < value.length; i++) {
        const character = value.charCodeAt(i);
        hash = (hash << 5) - hash + character;
        hash = hash & hash; // Convert to 32bit integer
    }
    return String(hash >>> 0);
};
exports._DJB2 = _DJB2;
const _DJB2Object = (value, maxLevels) => {
    return (0, exports._DJB2)(JSON.stringify((0, exports._getSortedObject)(value, maxLevels)));
};
exports._DJB2Object = _DJB2Object;
const _getSortedObject = (object, maxDepth) => {
    if (object == null) {
        return null;
    }
    const keys = Object.keys(object).sort();
    const sortedObject = {};
    keys.forEach((key) => {
        const value = object[key];
        if (maxDepth === 0 || (0, TypingUtils_1._typeOf)(value) !== 'object') {
            sortedObject[key] = value;
            return;
        }
        sortedObject[key] = (0, exports._getSortedObject)(value, maxDepth != null ? maxDepth - 1 : maxDepth);
    });
    return sortedObject;
};
exports._getSortedObject = _getSortedObject;


/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports._isTypeMatch = exports._typeOf = void 0;
function _typeOf(input) {
    return Array.isArray(input) ? 'array' : typeof input;
}
exports._typeOf = _typeOf;
function _isTypeMatch(a, b) {
    const typeOf = (x) => (Array.isArray(x) ? 'array' : typeof x);
    return typeOf(a) === typeOf(b);
}
exports._isTypeMatch = _isTypeMatch;


/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkParam = exports.NetworkDefault = exports.Endpoint = void 0;
exports.Endpoint = {
    _initialize: 'initialize',
    _rgstr: 'rgstr',
    _download_config_specs: 'download_config_specs',
};
exports.NetworkDefault = {
    [exports.Endpoint._rgstr]: 'https://prodregistryv2.org/v1',
    [exports.Endpoint._initialize]: 'https://featureassets.org/v1',
    [exports.Endpoint._download_config_specs]: 'https://api.statsigcdn.com/v1',
};
exports.NetworkParam = {
    EventCount: 'ec',
    SdkKey: 'k',
    SdkType: 'st',
    SdkVersion: 'sv',
    Time: 't',
    SessionID: 'sid',
    StatsigEncoded: 'se',
    IsGzipped: 'gz',
};


/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {
Object.defineProperty(exports, "__esModule", { value: true });
exports._getCurrentPageUrlSafe = exports._addDocumentEventListenerSafe = exports._addWindowEventListenerSafe = exports._isServerEnv = exports._getDocumentSafe = exports._getWindowSafe = void 0;
const _getWindowSafe = () => {
    return typeof window !== 'undefined' ? window : null;
};
exports._getWindowSafe = _getWindowSafe;
const _getDocumentSafe = () => {
    var _a;
    const win = (0, exports._getWindowSafe)();
    return (_a = win === null || win === void 0 ? void 0 : win.document) !== null && _a !== void 0 ? _a : null;
};
exports._getDocumentSafe = _getDocumentSafe;
const _isServerEnv = () => {
    if ((0, exports._getDocumentSafe)() !== null) {
        return false;
    }
    const isNode = typeof process !== 'undefined' &&
        process.versions != null &&
        process.versions.node != null;
    const isVercel = typeof EdgeRuntime === 'string';
    return isVercel || isNode;
};
exports._isServerEnv = _isServerEnv;
const _addWindowEventListenerSafe = (key, listener) => {
    const win = (0, exports._getWindowSafe)();
    if (typeof (win === null || win === void 0 ? void 0 : win.addEventListener) === 'function') {
        win.addEventListener(key, listener);
    }
};
exports._addWindowEventListenerSafe = _addWindowEventListenerSafe;
const _addDocumentEventListenerSafe = (key, listener) => {
    const doc = (0, exports._getDocumentSafe)();
    if (typeof (doc === null || doc === void 0 ? void 0 : doc.addEventListener) === 'function') {
        doc.addEventListener(key, listener);
    }
};
exports._addDocumentEventListenerSafe = _addDocumentEventListenerSafe;
const _getCurrentPageUrlSafe = () => {
    var _a;
    try {
        return (_a = (0, exports._getWindowSafe)()) === null || _a === void 0 ? void 0 : _a.location.href.split(/[?#]/)[0];
    }
    catch (_b) {
        return;
    }
};
exports._getCurrentPageUrlSafe = _getCurrentPageUrlSafe;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(22)))

/***/ }),
/* 22 */
/***/ (function(module, exports) {

// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };


/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports._createLayerParameterExposure = exports._createConfigExposure = exports._createGateExposure = exports._isExposureEvent = void 0;
const CONFIG_EXPOSURE_NAME = 'statsig::config_exposure';
const GATE_EXPOSURE_NAME = 'statsig::gate_exposure';
const LAYER_EXPOSURE_NAME = 'statsig::layer_exposure';
const _createExposure = (eventName, user, details, metadata, secondaryExposures) => {
    if (details.bootstrapMetadata) {
        metadata['bootstrapMetadata'] = details.bootstrapMetadata;
    }
    return {
        eventName,
        user,
        value: null,
        metadata: _addEvaluationDetailsToMetadata(details, metadata),
        secondaryExposures,
        time: Date.now(),
    };
};
const _isExposureEvent = ({ eventName, }) => {
    return (eventName === GATE_EXPOSURE_NAME ||
        eventName === CONFIG_EXPOSURE_NAME ||
        eventName === LAYER_EXPOSURE_NAME);
};
exports._isExposureEvent = _isExposureEvent;
const _createGateExposure = (user, gate) => {
    var _a, _b, _c;
    const metadata = {
        gate: gate.name,
        gateValue: String(gate.value),
        ruleID: gate.ruleID,
    };
    if (((_a = gate.__evaluation) === null || _a === void 0 ? void 0 : _a.version) != null) {
        metadata['configVersion'] = gate.__evaluation.version;
    }
    return _createExposure(GATE_EXPOSURE_NAME, user, gate.details, metadata, (_c = (_b = gate.__evaluation) === null || _b === void 0 ? void 0 : _b.secondary_exposures) !== null && _c !== void 0 ? _c : []);
};
exports._createGateExposure = _createGateExposure;
const _createConfigExposure = (user, config) => {
    var _a, _b, _c, _d;
    const metadata = {
        config: config.name,
        ruleID: config.ruleID,
    };
    if (((_a = config.__evaluation) === null || _a === void 0 ? void 0 : _a.version) != null) {
        metadata['configVersion'] = config.__evaluation.version;
    }
    if (((_b = config.__evaluation) === null || _b === void 0 ? void 0 : _b.passed) != null) {
        metadata['rulePassed'] = String(config.__evaluation.passed);
    }
    return _createExposure(CONFIG_EXPOSURE_NAME, user, config.details, metadata, (_d = (_c = config.__evaluation) === null || _c === void 0 ? void 0 : _c.secondary_exposures) !== null && _d !== void 0 ? _d : []);
};
exports._createConfigExposure = _createConfigExposure;
const _createLayerParameterExposure = (user, layer, parameterName) => {
    var _a, _b, _c, _d;
    const evaluation = layer.__evaluation;
    const isExplicit = ((_a = evaluation === null || evaluation === void 0 ? void 0 : evaluation.explicit_parameters) === null || _a === void 0 ? void 0 : _a.includes(parameterName)) === true;
    let allocatedExperiment = '';
    let secondaryExposures = (_b = evaluation === null || evaluation === void 0 ? void 0 : evaluation.undelegated_secondary_exposures) !== null && _b !== void 0 ? _b : [];
    if (isExplicit) {
        allocatedExperiment = (_c = evaluation.allocated_experiment_name) !== null && _c !== void 0 ? _c : '';
        secondaryExposures = evaluation.secondary_exposures;
    }
    const metadata = {
        config: layer.name,
        parameterName,
        ruleID: layer.ruleID,
        allocatedExperiment,
        isExplicitParameter: String(isExplicit),
    };
    if (((_d = layer.__evaluation) === null || _d === void 0 ? void 0 : _d.version) != null) {
        metadata['configVersion'] = layer.__evaluation.version;
    }
    return _createExposure(LAYER_EXPOSURE_NAME, user, layer.details, metadata, secondaryExposures);
};
exports._createLayerParameterExposure = _createLayerParameterExposure;
const _addEvaluationDetailsToMetadata = (details, metadata) => {
    metadata['reason'] = details.reason;
    if (details.lcut) {
        metadata['lcut'] = String(details.lcut);
    }
    if (details.receivedAt) {
        metadata['receivedAt'] = String(details.receivedAt);
    }
    return metadata;
};


/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports._setObjectInStorage = exports._getObjectFromStorage = exports.Storage = void 0;
const Log_1 = __webpack_require__(14);
const SafeJs_1 = __webpack_require__(21);
const inMemoryStore = {};
const _inMemoryProvider = {
    isReady: () => true,
    isReadyResolver: () => null,
    getProviderName: () => 'InMemory',
    getItem: (key) => inMemoryStore[key] ? inMemoryStore[key] : null,
    setItem: (key, value) => {
        inMemoryStore[key] = value;
    },
    removeItem: (key) => {
        delete inMemoryStore[key];
    },
    getAllKeys: () => Object.keys(inMemoryStore),
};
let _localStorageProvider = null;
try {
    const win = (0, SafeJs_1._getWindowSafe)();
    if (win &&
        win.localStorage &&
        typeof win.localStorage.getItem === 'function') {
        _localStorageProvider = {
            isReady: () => true,
            isReadyResolver: () => null,
            getProviderName: () => 'LocalStorage',
            getItem: (key) => win.localStorage.getItem(key),
            setItem: (key, value) => win.localStorage.setItem(key, value),
            removeItem: (key) => win.localStorage.removeItem(key),
            getAllKeys: () => Object.keys(win.localStorage),
        };
    }
}
catch (error) {
    Log_1.Log.warn('Failed to setup localStorageProvider.');
}
let _main = _localStorageProvider !== null && _localStorageProvider !== void 0 ? _localStorageProvider : _inMemoryProvider;
let _current = _main;
function _inMemoryBreaker(get) {
    try {
        return get();
    }
    catch (error) {
        if (error instanceof Error && error.name === 'SecurityError') {
            exports.Storage._setProvider(_inMemoryProvider);
            return null;
        }
        throw error;
    }
}
exports.Storage = {
    isReady: () => _current.isReady(),
    isReadyResolver: () => _current.isReadyResolver(),
    getProviderName: () => _current.getProviderName(),
    getItem: (key) => _inMemoryBreaker(() => _current.getItem(key)),
    setItem: (key, value) => _current.setItem(key, value),
    removeItem: (key) => _current.removeItem(key),
    getAllKeys: () => _current.getAllKeys(),
    // StorageProviderManagment
    _setProvider: (newProvider) => {
        _main = newProvider;
        _current = newProvider;
    },
    _setDisabled: (isDisabled) => {
        if (isDisabled) {
            _current = _inMemoryProvider;
        }
        else {
            _current = _main;
        }
    },
};
function _getObjectFromStorage(key) {
    const value = exports.Storage.getItem(key);
    return JSON.parse(value !== null && value !== void 0 ? value : 'null');
}
exports._getObjectFromStorage = _getObjectFromStorage;
function _setObjectInStorage(key, obj) {
    exports.Storage.setItem(key, JSON.stringify(obj));
}
exports._setObjectInStorage = _setObjectInStorage;


/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.UrlConfiguration = void 0;
const NetworkConfig_1 = __webpack_require__(20);
const ENDPOINT_DNS_KEY_MAP = {
    [NetworkConfig_1.Endpoint._initialize]: 'i',
    [NetworkConfig_1.Endpoint._rgstr]: 'e',
    [NetworkConfig_1.Endpoint._download_config_specs]: 'd',
};
class UrlConfiguration {
    constructor(endpoint, customUrl, customApi, fallbackUrls) {
        this.customUrl = null;
        this.fallbackUrls = null;
        this.endpoint = endpoint;
        this.endpointDnsKey = ENDPOINT_DNS_KEY_MAP[endpoint];
        if (customUrl) {
            this.customUrl = customUrl;
        }
        if (!customUrl && customApi) {
            this.customUrl = customApi.endsWith('/')
                ? `${customApi}${endpoint}`
                : `${customApi}/${endpoint}`;
        }
        if (fallbackUrls) {
            this.fallbackUrls = fallbackUrls;
        }
        const defaultApi = NetworkConfig_1.NetworkDefault[endpoint];
        this.defaultUrl = `${defaultApi}/${endpoint}`;
    }
    getUrl() {
        var _a;
        return (_a = this.customUrl) !== null && _a !== void 0 ? _a : this.defaultUrl;
    }
}
exports.UrlConfiguration = UrlConfiguration;


/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports._notifyVisibilityChanged = exports._subscribeToVisiblityChanged = exports._isUnloading = exports._isCurrentlyVisible = void 0;
const SafeJs_1 = __webpack_require__(21);
const FOREGROUND = 'foreground';
const BACKGROUND = 'background';
const LISTENERS = [];
let current = FOREGROUND;
let isUnloading = false;
const _isCurrentlyVisible = () => {
    return current === FOREGROUND;
};
exports._isCurrentlyVisible = _isCurrentlyVisible;
const _isUnloading = () => isUnloading;
exports._isUnloading = _isUnloading;
const _subscribeToVisiblityChanged = (listener) => {
    LISTENERS.unshift(listener);
};
exports._subscribeToVisiblityChanged = _subscribeToVisiblityChanged;
const _notifyVisibilityChanged = (visibility) => {
    if (visibility === current) {
        return;
    }
    current = visibility;
    LISTENERS.forEach((l) => l(visibility));
};
exports._notifyVisibilityChanged = _notifyVisibilityChanged;
(0, SafeJs_1._addWindowEventListenerSafe)('focus', () => {
    isUnloading = false;
    (0, exports._notifyVisibilityChanged)(FOREGROUND);
});
(0, SafeJs_1._addWindowEventListenerSafe)('blur', () => (0, exports._notifyVisibilityChanged)(BACKGROUND));
(0, SafeJs_1._addWindowEventListenerSafe)('beforeunload', () => {
    isUnloading = true;
    (0, exports._notifyVisibilityChanged)(BACKGROUND);
});
(0, SafeJs_1._addDocumentEventListenerSafe)('visibilitychange', () => {
    (0, exports._notifyVisibilityChanged)(document.visibilityState === 'visible' ? FOREGROUND : BACKGROUND);
});


/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.StatsigMetadataProvider = exports.SDK_VERSION = void 0;
exports.SDK_VERSION = '3.12.0';
let metadata = {
    sdkVersion: exports.SDK_VERSION,
    sdkType: 'js-mono', // js-mono is overwritten by Precomp and OnDevice clients
};
exports.StatsigMetadataProvider = {
    get: () => metadata,
    add: (additions) => {
        metadata = Object.assign(Object.assign({}, metadata), additions);
    },
};


/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });


/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports._makeDataAdapterResult = exports.DataAdapterCore = void 0;
const Log_1 = __webpack_require__(14);
const StableID_1 = __webpack_require__(30);
const StatsigUser_1 = __webpack_require__(32);
const StorageProvider_1 = __webpack_require__(24);
const TypedJsonParse_1 = __webpack_require__(33);
const CACHE_LIMIT = 10;
class DataAdapterCore {
    constructor(_adapterName, _cacheSuffix) {
        this._adapterName = _adapterName;
        this._cacheSuffix = _cacheSuffix;
        this._options = null;
        this._sdkKey = null;
        this._lastModifiedStoreKey = `statsig.last_modified_time.${_cacheSuffix}`;
        this._inMemoryCache = new InMemoryCache();
    }
    attach(sdkKey, options) {
        this._sdkKey = sdkKey;
        this._options = options;
    }
    getDataSync(user) {
        const normalized = user && (0, StatsigUser_1._normalizeUser)(user, this._options);
        const cacheKey = this._getCacheKey(normalized);
        const inMem = this._inMemoryCache.get(cacheKey, normalized);
        if (inMem) {
            return inMem;
        }
        const cache = this._loadFromCache(cacheKey);
        if (cache) {
            this._inMemoryCache.add(cacheKey, cache);
            return this._inMemoryCache.get(cacheKey, normalized);
        }
        return null;
    }
    setData(data, user) {
        const normalized = user && (0, StatsigUser_1._normalizeUser)(user, this._options);
        const cacheKey = this._getCacheKey(normalized);
        this._inMemoryCache.add(cacheKey, _makeDataAdapterResult('Bootstrap', data, null, normalized));
    }
    _getDataAsyncImpl(current, user, options) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!StorageProvider_1.Storage.isReady()) {
                yield StorageProvider_1.Storage.isReadyResolver();
            }
            const cache = current !== null && current !== void 0 ? current : this.getDataSync(user);
            const ops = [this._fetchAndPrepFromNetwork(cache, user, options)];
            if (options === null || options === void 0 ? void 0 : options.timeoutMs) {
                ops.push(new Promise((r) => setTimeout(r, options.timeoutMs)).then(() => {
                    Log_1.Log.debug('Fetching latest value timed out');
                    return null;
                }));
            }
            return yield Promise.race(ops);
        });
    }
    _prefetchDataImpl(user, options) {
        return __awaiter(this, void 0, void 0, function* () {
            const normalized = user && (0, StatsigUser_1._normalizeUser)(user, this._options);
            const cacheKey = this._getCacheKey(normalized);
            const result = yield this._getDataAsyncImpl(null, normalized, options);
            if (result) {
                this._inMemoryCache.add(cacheKey, Object.assign(Object.assign({}, result), { source: 'Prefetch' }));
            }
        });
    }
    _fetchAndPrepFromNetwork(cachedResult, user, options) {
        return __awaiter(this, void 0, void 0, function* () {
            let cachedData = null;
            if (cachedResult && this._isCachedResultValidFor204(cachedResult, user)) {
                cachedData = cachedResult.data;
            }
            const latest = yield this._fetchFromNetwork(cachedData, user, options);
            if (!latest) {
                Log_1.Log.debug('No response returned for latest value');
                return null;
            }
            const response = (0, TypedJsonParse_1._typedJsonParse)(latest, 'has_updates', 'Response');
            const sdkKey = this._getSdkKey();
            const stableID = StableID_1.StableID.get(sdkKey);
            let result = null;
            if ((response === null || response === void 0 ? void 0 : response.has_updates) === true) {
                result = _makeDataAdapterResult('Network', latest, stableID, user);
            }
            else if (cachedData && (response === null || response === void 0 ? void 0 : response.has_updates) === false) {
                result = _makeDataAdapterResult('NetworkNotModified', cachedData, stableID, user);
            }
            else {
                return null;
            }
            const cacheKey = this._getCacheKey(user);
            this._inMemoryCache.add(cacheKey, result);
            this._writeToCache(cacheKey, result);
            return result;
        });
    }
    _getSdkKey() {
        if (this._sdkKey != null) {
            return this._sdkKey;
        }
        Log_1.Log.error(`${this._adapterName} is not attached to a Client`);
        return '';
    }
    _loadFromCache(cacheKey) {
        var _a;
        const cache = (_a = StorageProvider_1.Storage.getItem) === null || _a === void 0 ? void 0 : _a.call(StorageProvider_1.Storage, cacheKey);
        if (cache == null) {
            return null;
        }
        const result = (0, TypedJsonParse_1._typedJsonParse)(cache, 'source', 'Cached Result');
        return result ? Object.assign(Object.assign({}, result), { source: 'Cache' }) : null;
    }
    _writeToCache(cacheKey, result) {
        StorageProvider_1.Storage.setItem(cacheKey, JSON.stringify(result));
        this._runLocalStorageCacheEviction(cacheKey);
    }
    _runLocalStorageCacheEviction(cacheKey) {
        var _a;
        const lastModifiedTimeMap = (_a = (0, StorageProvider_1._getObjectFromStorage)(this._lastModifiedStoreKey)) !== null && _a !== void 0 ? _a : {};
        lastModifiedTimeMap[cacheKey] = Date.now();
        const evictable = _getEvictableKey(lastModifiedTimeMap, CACHE_LIMIT);
        if (evictable) {
            delete lastModifiedTimeMap[evictable];
            StorageProvider_1.Storage.removeItem(evictable);
        }
        (0, StorageProvider_1._setObjectInStorage)(this._lastModifiedStoreKey, lastModifiedTimeMap);
    }
}
exports.DataAdapterCore = DataAdapterCore;
function _makeDataAdapterResult(source, data, stableID, user) {
    return {
        source,
        data,
        receivedAt: Date.now(),
        stableID,
        fullUserHash: (0, StatsigUser_1._getFullUserHash)(user),
    };
}
exports._makeDataAdapterResult = _makeDataAdapterResult;
class InMemoryCache {
    constructor() {
        this._data = {};
    }
    get(cacheKey, user) {
        var _a;
        const result = this._data[cacheKey];
        const cached = result === null || result === void 0 ? void 0 : result.stableID;
        const provided = (_a = user === null || user === void 0 ? void 0 : user.customIDs) === null || _a === void 0 ? void 0 : _a.stableID;
        if (provided && cached && provided !== cached) {
            Log_1.Log.warn("'StatsigUser.customIDs.stableID' mismatch");
            return null;
        }
        return result;
    }
    add(cacheKey, value) {
        const oldest = _getEvictableKey(this._data, CACHE_LIMIT - 1);
        if (oldest) {
            delete this._data[oldest];
        }
        this._data[cacheKey] = value;
    }
    merge(values) {
        this._data = Object.assign(Object.assign({}, this._data), values);
    }
}
function _getEvictableKey(data, limit) {
    const keys = Object.keys(data);
    if (keys.length <= limit) {
        return null;
    }
    return keys.reduce((prevKey, currKey) => {
        const prev = data[prevKey];
        const current = data[currKey];
        if (typeof prev === 'object' && typeof current === 'object') {
            return current.receivedAt < prev.receivedAt ? currKey : prevKey;
        }
        return current < prev ? currKey : prevKey;
    });
}


/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.StableID = void 0;
const CacheKey_1 = __webpack_require__(17);
const Log_1 = __webpack_require__(14);
const StorageProvider_1 = __webpack_require__(24);
const UUID_1 = __webpack_require__(31);
const PROMISE_MAP = {};
exports.StableID = {
    get: (sdkKey) => {
        if (PROMISE_MAP[sdkKey] == null) {
            let stableID = _loadFromStorage(sdkKey);
            if (stableID == null) {
                stableID = (0, UUID_1.getUUID)();
                _persistToStorage(stableID, sdkKey);
            }
            PROMISE_MAP[sdkKey] = stableID;
        }
        return PROMISE_MAP[sdkKey];
    },
    setOverride: (override, sdkKey) => {
        PROMISE_MAP[sdkKey] = override;
        _persistToStorage(override, sdkKey);
    },
};
function _getStableIDStorageKey(sdkKey) {
    return `statsig.stable_id.${(0, CacheKey_1._getStorageKey)(sdkKey)}`;
}
function _persistToStorage(stableID, sdkKey) {
    const storageKey = _getStableIDStorageKey(sdkKey);
    try {
        (0, StorageProvider_1._setObjectInStorage)(storageKey, stableID);
    }
    catch (e) {
        Log_1.Log.warn('Failed to save StableID');
    }
}
function _loadFromStorage(sdkKey) {
    const storageKey = _getStableIDStorageKey(sdkKey);
    return (0, StorageProvider_1._getObjectFromStorage)(storageKey);
}


/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getUUID = void 0;
function getUUID() {
    if (typeof crypto !== 'undefined' &&
        typeof crypto.randomUUID === 'function') {
        return crypto.randomUUID();
    }
    let d = new Date().getTime();
    let d2 = (typeof performance !== 'undefined' &&
        performance.now &&
        performance.now() * 1000) ||
        0;
    const y = '89ab'[Math.floor(Math.random() * 4)];
    return `xxxxxxxx-xxxx-4xxx-${y}xxx-xxxxxxxxxxxx`.replace(/[xy]/g, (c) => {
        let r = Math.random() * 16;
        if (d > 0) {
            r = (d + r) % 16 | 0;
            d = Math.floor(d / 16);
        }
        else {
            r = (d2 + r) % 16 | 0;
            d2 = Math.floor(d2 / 16);
        }
        return (c === 'x' ? r : (r & 0x7) | 0x8).toString(16);
    });
}
exports.getUUID = getUUID;


/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports._getFullUserHash = exports._normalizeUser = void 0;
const Hashing_1 = __webpack_require__(18);
const Log_1 = __webpack_require__(14);
function _normalizeUser(original, options, fallbackEnvironment) {
    try {
        const copy = JSON.parse(JSON.stringify(original));
        if (options != null && options.environment != null) {
            copy.statsigEnvironment = options.environment;
        }
        else if (fallbackEnvironment != null) {
            copy.statsigEnvironment = { tier: fallbackEnvironment };
        }
        return copy;
    }
    catch (error) {
        Log_1.Log.error('Failed to JSON.stringify user');
        return { statsigEnvironment: undefined };
    }
}
exports._normalizeUser = _normalizeUser;
function _getFullUserHash(user) {
    return user ? (0, Hashing_1._DJB2Object)(user) : null;
}
exports._getFullUserHash = _getFullUserHash;


/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports._typedJsonParse = void 0;
const Log_1 = __webpack_require__(14);
/**
 *
 * @param {string} data The values to parse into T
 * @param {string} guard A field that must exists on the parsed object for the parse to be valid
 * @param {string} error An error to print via Log.error() when parsing fails
 * @returns {T | null} The parse object T or null if it failed
 */
function _typedJsonParse(data, guard, typeName) {
    try {
        const result = JSON.parse(data);
        if (result &&
            typeof result === 'object' &&
            guard in result) {
            return result;
        }
    }
    catch (_a) {
        // noop
    }
    Log_1.Log.error(`Failed to parse ${typeName}`);
    return null;
}
exports._typedJsonParse = _typedJsonParse;


/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });


/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ErrorBoundary = exports.EXCEPTION_ENDPOINT = void 0;
const Log_1 = __webpack_require__(14);
const SDKType_1 = __webpack_require__(36);
const StatsigMetadata_1 = __webpack_require__(27);
exports.EXCEPTION_ENDPOINT = 'https://statsigapi.net/v1/sdk_exception';
const UNKNOWN_ERROR = '[Statsig] UnknownError';
class ErrorBoundary {
    constructor(_sdkKey, _options, _emitter, _lastSeenError) {
        this._sdkKey = _sdkKey;
        this._options = _options;
        this._emitter = _emitter;
        this._lastSeenError = _lastSeenError;
        this._seen = new Set();
    }
    wrap(instance) {
        try {
            const obj = instance;
            _getAllInstanceMethodNames(obj).forEach((name) => {
                const original = obj[name];
                if ('$EB' in original) {
                    return;
                }
                obj[name] = (...args) => {
                    return this._capture(name, () => original.apply(instance, args));
                };
                obj[name].$EB = true;
            });
        }
        catch (err) {
            this._onError('eb:wrap', err);
        }
    }
    logError(tag, error) {
        this._onError(tag, error);
    }
    getLastSeenErrorAndReset() {
        const tempError = this._lastSeenError;
        this._lastSeenError = undefined;
        return tempError !== null && tempError !== void 0 ? tempError : null;
    }
    attachErrorIfNoneExists(error) {
        if (this._lastSeenError) {
            return;
        }
        this._lastSeenError = _resolveError(error);
    }
    _capture(tag, task) {
        try {
            const res = task();
            if (res && res instanceof Promise) {
                return res.catch((err) => this._onError(tag, err));
            }
            return res;
        }
        catch (error) {
            this._onError(tag, error);
            return null;
        }
    }
    _onError(tag, error) {
        try {
            Log_1.Log.warn(`Caught error in ${tag}`, { error });
            const impl = () => __awaiter(this, void 0, void 0, function* () {
                var _a, _b, _c, _d, _e, _f, _g;
                const unwrapped = (error ? error : Error(UNKNOWN_ERROR));
                const isError = unwrapped instanceof Error;
                const name = isError ? unwrapped.name : 'No Name';
                const resolvedError = _resolveError(unwrapped);
                this._lastSeenError = resolvedError;
                if (this._seen.has(name)) {
                    return;
                }
                this._seen.add(name);
                if ((_b = (_a = this._options) === null || _a === void 0 ? void 0 : _a.networkConfig) === null || _b === void 0 ? void 0 : _b.preventAllNetworkTraffic) {
                    (_c = this._emitter) === null || _c === void 0 ? void 0 : _c.call(this, {
                        name: 'error',
                        error,
                        tag,
                    });
                    return;
                }
                const sdkType = SDKType_1.SDKType._get(this._sdkKey);
                const statsigMetadata = StatsigMetadata_1.StatsigMetadataProvider.get();
                const info = isError ? unwrapped.stack : _getDescription(unwrapped);
                const body = JSON.stringify(Object.assign({ tag, exception: name, info }, Object.assign(Object.assign({}, statsigMetadata), { sdkType })));
                const func = (_f = (_e = (_d = this._options) === null || _d === void 0 ? void 0 : _d.networkConfig) === null || _e === void 0 ? void 0 : _e.networkOverrideFunc) !== null && _f !== void 0 ? _f : fetch;
                yield func(exports.EXCEPTION_ENDPOINT, {
                    method: 'POST',
                    headers: {
                        'STATSIG-API-KEY': this._sdkKey,
                        'STATSIG-SDK-TYPE': String(sdkType),
                        'STATSIG-SDK-VERSION': String(statsigMetadata.sdkVersion),
                        'Content-Type': 'application/json',
                    },
                    body,
                });
                (_g = this._emitter) === null || _g === void 0 ? void 0 : _g.call(this, {
                    name: 'error',
                    error,
                    tag,
                });
            });
            impl()
                .then(() => {
                /* noop */
            })
                .catch(() => {
                /* noop */
            });
        }
        catch (_error) {
            /* noop */
        }
    }
}
exports.ErrorBoundary = ErrorBoundary;
function _resolveError(error) {
    if (error instanceof Error) {
        return error;
    }
    else if (typeof error === 'string') {
        return new Error(error);
    }
    else {
        return new Error('An unknown error occurred.');
    }
}
function _getDescription(obj) {
    try {
        return JSON.stringify(obj);
    }
    catch (_a) {
        return UNKNOWN_ERROR;
    }
}
function _getAllInstanceMethodNames(instance) {
    const names = new Set();
    let proto = Object.getPrototypeOf(instance);
    while (proto && proto !== Object.prototype) {
        Object.getOwnPropertyNames(proto)
            .filter((prop) => typeof (proto === null || proto === void 0 ? void 0 : proto[prop]) === 'function')
            .forEach((name) => names.add(name));
        proto = Object.getPrototypeOf(proto);
    }
    return Array.from(names);
}


/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.SDKType = void 0;
const SDK_CLIENT = {};
let suffix;
exports.SDKType = {
    _get: (sdkKey) => {
        var _a;
        return ((_a = SDK_CLIENT[sdkKey]) !== null && _a !== void 0 ? _a : 'js-mono') + (suffix !== null && suffix !== void 0 ? suffix : '');
    },
    _setClientType(sdkKey, client) {
        SDK_CLIENT[sdkKey] = client;
    },
    _setBindingType(binding) {
        if (!suffix || suffix === '-react') {
            suffix = '-' + binding;
        }
    },
};


/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });


/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });


/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });


/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.createMemoKey = exports.MemoPrefix = void 0;
exports.MemoPrefix = {
    _gate: 'g',
    _dynamicConfig: 'c',
    _experiment: 'e',
    _layer: 'l',
    _paramStore: 'p',
};
const EXIST_KEYS = new Set([
// Add keys that should be memoized based only on their existence, not their value
]);
const DO_NOT_MEMO_KEYS = new Set([
    // Add keys that if exist, should not be memoized
    'userPersistedValues',
]);
function createMemoKey(prefix, name, options) {
    let cacheKey = `${prefix}|${name}`;
    if (!options) {
        return cacheKey;
    }
    for (const key of Object.keys(options)) {
        if (DO_NOT_MEMO_KEYS.has(key)) {
            return undefined;
        }
        if (EXIST_KEYS.has(key)) {
            cacheKey += `|${key}=true`;
        }
        else {
            cacheKey += `|${key}=${options[key]}`;
        }
    }
    return cacheKey;
}
exports.createMemoKey = createMemoKey;


/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkCore = void 0;
__webpack_require__(12);
const __StatsigGlobal_1 = __webpack_require__(12);
const Diagnostics_1 = __webpack_require__(15);
const Log_1 = __webpack_require__(14);
const NetworkConfig_1 = __webpack_require__(20);
const NetworkFallbackResolver_1 = __webpack_require__(42);
const SDKType_1 = __webpack_require__(36);
const SafeJs_1 = __webpack_require__(21);
const SessionID_1 = __webpack_require__(44);
const StableID_1 = __webpack_require__(30);
const StatsigClientEventEmitter_1 = __webpack_require__(45);
const StatsigMetadata_1 = __webpack_require__(27);
const VisibilityObserving_1 = __webpack_require__(26);
const DEFAULT_TIMEOUT_MS = 10000;
const BACKOFF_BASE_MS = 500;
const BACKOFF_MAX_MS = 30000;
const RATE_LIMIT_WINDOW_MS = 1000;
const RATE_LIMIT_MAX_REQ_COUNT = 50;
const LEAK_RATE = RATE_LIMIT_MAX_REQ_COUNT / RATE_LIMIT_WINDOW_MS;
const RETRYABLE_CODES = new Set([408, 500, 502, 503, 504, 522, 524, 599]);
class NetworkCore {
    constructor(options, _emitter) {
        this._emitter = _emitter;
        this._errorBoundary = null;
        this._timeout = DEFAULT_TIMEOUT_MS;
        this._netConfig = {};
        this._options = {};
        this._leakyBucket = {};
        this._lastUsedInitUrl = null;
        if (options) {
            this._options = options;
        }
        if (this._options.networkConfig) {
            this._netConfig = this._options.networkConfig;
        }
        if (this._netConfig.networkTimeoutMs) {
            this._timeout = this._netConfig.networkTimeoutMs;
        }
        this._fallbackResolver = new NetworkFallbackResolver_1.NetworkFallbackResolver(this._options);
    }
    setErrorBoundary(errorBoundary) {
        this._errorBoundary = errorBoundary;
        this._errorBoundary.wrap(this);
        this._errorBoundary.wrap(this._fallbackResolver);
        this._fallbackResolver.setErrorBoundary(errorBoundary);
    }
    isBeaconSupported() {
        return (typeof navigator !== 'undefined' &&
            typeof navigator.sendBeacon === 'function');
    }
    getLastUsedInitUrlAndReset() {
        const tempUrl = this._lastUsedInitUrl;
        this._lastUsedInitUrl = null;
        return tempUrl;
    }
    beacon(args) {
        return __awaiter(this, void 0, void 0, function* () {
            if (!_ensureValidSdkKey(args)) {
                return false;
            }
            const argsInternal = this._getInternalRequestArgs('POST', args);
            const body = yield this._getPopulatedBody(argsInternal, args.data);
            const url = yield this._getPopulatedURL(argsInternal);
            const nav = navigator;
            return nav.sendBeacon.bind(nav)(url, body);
        });
    }
    post(args) {
        return __awaiter(this, void 0, void 0, function* () {
            const argsInternal = this._getInternalRequestArgs('POST', args);
            argsInternal.body = yield this._getPopulatedBody(argsInternal, args.data);
            if (args.isStatsigEncodable) {
                argsInternal.body = this._attemptToEncodeString(argsInternal, argsInternal.body);
            }
            return this._sendRequest(argsInternal);
        });
    }
    get(args) {
        const argsInternal = this._getInternalRequestArgs('GET', args);
        return this._sendRequest(argsInternal);
    }
    _sendRequest(args) {
        var _a, _b, _c, _d;
        return __awaiter(this, void 0, void 0, function* () {
            if (!_ensureValidSdkKey(args)) {
                return null;
            }
            if (this._netConfig.preventAllNetworkTraffic) {
                return null;
            }
            const { method, body, retries, attempt } = args;
            const endpoint = args.urlConfig.endpoint;
            if (this._isRateLimited(endpoint)) {
                Log_1.Log.warn(`Request to ${endpoint} was blocked because you are making requests too frequently.`);
                return null;
            }
            const currentAttempt = attempt !== null && attempt !== void 0 ? attempt : 1;
            const abortController = typeof AbortController !== 'undefined' ? new AbortController() : null;
            const timeoutHandle = setTimeout(() => {
                abortController === null || abortController === void 0 ? void 0 : abortController.abort(`Timeout of ${this._timeout}ms expired.`);
            }, this._timeout);
            const populatedUrl = yield this._getPopulatedURL(args);
            let response = null;
            const keepalive = (0, VisibilityObserving_1._isUnloading)();
            try {
                const config = {
                    method,
                    body,
                    headers: Object.assign({}, args.headers),
                    signal: abortController === null || abortController === void 0 ? void 0 : abortController.signal,
                    priority: args.priority,
                    keepalive,
                };
                _tryMarkInitStart(args, currentAttempt);
                const bucket = this._leakyBucket[endpoint];
                if (bucket) {
                    bucket.lastRequestTime = Date.now();
                    this._leakyBucket[endpoint] = bucket;
                }
                const func = (_a = this._netConfig.networkOverrideFunc) !== null && _a !== void 0 ? _a : fetch;
                response = yield func(populatedUrl, config);
                clearTimeout(timeoutHandle);
                if (!response.ok) {
                    const text = yield response.text().catch(() => 'No Text');
                    const err = new Error(`NetworkError: ${populatedUrl} ${text}`);
                    err.name = 'NetworkError';
                    throw err;
                }
                const text = yield response.text();
                _tryMarkInitEnd(args, response, currentAttempt, text);
                this._fallbackResolver.tryBumpExpiryTime(args.sdkKey, args.urlConfig);
                return {
                    body: text,
                    code: response.status,
                };
            }
            catch (error) {
                const errorMessage = _getErrorMessage(abortController, error);
                const timedOut = _didTimeout(abortController);
                _tryMarkInitEnd(args, response, currentAttempt, '', error);
                const fallbackUpdated = yield this._fallbackResolver.tryFetchUpdatedFallbackInfo(args.sdkKey, args.urlConfig, errorMessage, timedOut);
                if (fallbackUpdated) {
                    args.fallbackUrl = this._fallbackResolver.getActiveFallbackUrl(args.sdkKey, args.urlConfig);
                }
                if (!retries ||
                    currentAttempt > retries ||
                    !RETRYABLE_CODES.has((_b = response === null || response === void 0 ? void 0 : response.status) !== null && _b !== void 0 ? _b : 500)) {
                    (_c = this._emitter) === null || _c === void 0 ? void 0 : _c.call(this, {
                        name: 'error',
                        error,
                        tag: StatsigClientEventEmitter_1.ErrorTag.NetworkError,
                        requestArgs: args,
                    });
                    const formattedErrorMsg = `A networking error occurred during ${method} request to ${populatedUrl}.`;
                    Log_1.Log.error(formattedErrorMsg, errorMessage, error);
                    (_d = this._errorBoundary) === null || _d === void 0 ? void 0 : _d.attachErrorIfNoneExists(formattedErrorMsg);
                    return null;
                }
                yield _exponentialBackoff(currentAttempt);
                return this._sendRequest(Object.assign(Object.assign({}, args), { retries, attempt: currentAttempt + 1 }));
            }
        });
    }
    _isRateLimited(endpoint) {
        var _a;
        const now = Date.now();
        const bucket = (_a = this._leakyBucket[endpoint]) !== null && _a !== void 0 ? _a : {
            count: 0,
            lastRequestTime: now,
        };
        const elapsed = now - bucket.lastRequestTime;
        const leakedRequests = Math.floor(elapsed * LEAK_RATE);
        bucket.count = Math.max(0, bucket.count - leakedRequests);
        if (bucket.count >= RATE_LIMIT_MAX_REQ_COUNT) {
            return true;
        }
        bucket.count += 1;
        bucket.lastRequestTime = now;
        this._leakyBucket[endpoint] = bucket;
        return false;
    }
    _getPopulatedURL(args) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const url = (_a = args.fallbackUrl) !== null && _a !== void 0 ? _a : args.urlConfig.getUrl();
            if (args.urlConfig.endpoint === NetworkConfig_1.Endpoint._initialize ||
                args.urlConfig.endpoint === NetworkConfig_1.Endpoint._download_config_specs) {
                this._lastUsedInitUrl = url;
            }
            const params = Object.assign({ [NetworkConfig_1.NetworkParam.SdkKey]: args.sdkKey, [NetworkConfig_1.NetworkParam.SdkType]: SDKType_1.SDKType._get(args.sdkKey), [NetworkConfig_1.NetworkParam.SdkVersion]: StatsigMetadata_1.SDK_VERSION, [NetworkConfig_1.NetworkParam.Time]: String(Date.now()), [NetworkConfig_1.NetworkParam.SessionID]: SessionID_1.SessionID.get(args.sdkKey) }, args.params);
            const query = Object.keys(params)
                .map((key) => {
                return `${encodeURIComponent(key)}=${encodeURIComponent(params[key])}`;
            })
                .join('&');
            return `${url}${query ? `?${query}` : ''}`;
        });
    }
    _getPopulatedBody(args, data) {
        return __awaiter(this, void 0, void 0, function* () {
            const { sdkKey, fallbackUrl } = args;
            const stableID = StableID_1.StableID.get(sdkKey);
            const sessionID = SessionID_1.SessionID.get(sdkKey);
            const sdkType = SDKType_1.SDKType._get(sdkKey);
            return JSON.stringify(Object.assign(Object.assign({}, data), { statsigMetadata: Object.assign(Object.assign({}, StatsigMetadata_1.StatsigMetadataProvider.get()), { stableID,
                    sessionID,
                    sdkType,
                    fallbackUrl }) }));
        });
    }
    _attemptToEncodeString(args, input) {
        var _a, _b;
        const win = (0, SafeJs_1._getWindowSafe)();
        if (this._options.disableStatsigEncoding ||
            (0, __StatsigGlobal_1._getStatsigGlobalFlag)('no-encode') != null ||
            !(win === null || win === void 0 ? void 0 : win.btoa)) {
            return input;
        }
        try {
            const result = (_a = win.btoa(input).split('').reverse().join('')) !== null && _a !== void 0 ? _a : input;
            args.params = Object.assign(Object.assign({}, ((_b = args.params) !== null && _b !== void 0 ? _b : {})), { [NetworkConfig_1.NetworkParam.StatsigEncoded]: '1' });
            return result;
        }
        catch (_c) {
            Log_1.Log.warn(`Request encoding failed for ${args.urlConfig.getUrl()}`);
            return input;
        }
    }
    _getInternalRequestArgs(method, args) {
        const fallbackUrl = this._fallbackResolver.getActiveFallbackUrl(args.sdkKey, args.urlConfig);
        return Object.assign(Object.assign({}, args), { method,
            fallbackUrl });
    }
}
exports.NetworkCore = NetworkCore;
const _ensureValidSdkKey = (args) => {
    if (!args.sdkKey) {
        Log_1.Log.warn('Unable to make request without an SDK key');
        return false;
    }
    return true;
};
function _getErrorMessage(controller, error) {
    if ((controller === null || controller === void 0 ? void 0 : controller.signal.aborted) &&
        typeof controller.signal.reason === 'string') {
        return controller.signal.reason;
    }
    if (typeof error === 'string') {
        return error;
    }
    if (error instanceof Error) {
        return `${error.name}: ${error.message}`;
    }
    return 'Unknown Error';
}
function _didTimeout(controller) {
    const timeout = (controller === null || controller === void 0 ? void 0 : controller.signal.aborted) &&
        typeof controller.signal.reason === 'string' &&
        controller.signal.reason.includes('Timeout');
    return timeout || false;
}
function _tryMarkInitStart(args, attempt) {
    if (args.urlConfig.endpoint !== NetworkConfig_1.Endpoint._initialize) {
        return;
    }
    Diagnostics_1.Diagnostics._markInitNetworkReqStart(args.sdkKey, {
        attempt,
    });
}
function _tryMarkInitEnd(args, response, attempt, body, err) {
    if (args.urlConfig.endpoint !== NetworkConfig_1.Endpoint._initialize) {
        return;
    }
    Diagnostics_1.Diagnostics._markInitNetworkReqEnd(args.sdkKey, Diagnostics_1.Diagnostics._getDiagnosticsData(response, attempt, body, err));
}
function _exponentialBackoff(attempt) {
    return __awaiter(this, void 0, void 0, function* () {
        // 1*1*1000 1s
        // 2*2*1000 4s
        // 3*3*1000 9s
        // 4*4*1000 16s
        // 5*5*1000 25s
        yield new Promise((r) => setTimeout(r, Math.min(BACKOFF_BASE_MS * (attempt * attempt), BACKOFF_MAX_MS)));
    });
}


/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports._isDomainFailure = exports.NetworkFallbackResolver = void 0;
const DnsTxtQuery_1 = __webpack_require__(43);
const Hashing_1 = __webpack_require__(18);
const Log_1 = __webpack_require__(14);
const StorageProvider_1 = __webpack_require__(24);
const DEFAULT_TTL_MS = 7 * 24 * 60 * 60 * 1000; // 7 days
const COOLDOWN_TIME_MS = 4 * 60 * 60 * 1000; // 4 hours
class NetworkFallbackResolver {
    constructor(options) {
        var _a;
        this._fallbackInfo = null;
        this._errorBoundary = null;
        this._dnsQueryCooldowns = {};
        this._networkOverrideFunc = (_a = options.networkConfig) === null || _a === void 0 ? void 0 : _a.networkOverrideFunc;
    }
    setErrorBoundary(errorBoundary) {
        this._errorBoundary = errorBoundary;
    }
    tryBumpExpiryTime(sdkKey, urlConfig) {
        var _a;
        const info = (_a = this._fallbackInfo) === null || _a === void 0 ? void 0 : _a[urlConfig.endpoint];
        if (!info) {
            return;
        }
        info.expiryTime = Date.now() + DEFAULT_TTL_MS;
        _tryWriteFallbackInfoToCache(sdkKey, Object.assign(Object.assign({}, this._fallbackInfo), { [urlConfig.endpoint]: info }));
    }
    getActiveFallbackUrl(sdkKey, urlConfig) {
        var _a, _b;
        let info = this._fallbackInfo;
        if (info == null) {
            info = (_a = _readFallbackInfoFromCache(sdkKey)) !== null && _a !== void 0 ? _a : {};
            this._fallbackInfo = info;
        }
        const entry = info[urlConfig.endpoint];
        if (!entry || Date.now() > ((_b = entry.expiryTime) !== null && _b !== void 0 ? _b : 0)) {
            delete info[urlConfig.endpoint];
            this._fallbackInfo = info;
            _tryWriteFallbackInfoToCache(sdkKey, this._fallbackInfo);
            return null;
        }
        if (entry.url) {
            return entry.url;
        }
        return null;
    }
    getFallbackFromProvided(url) {
        const path = _extractPathFromUrl(url);
        if (path) {
            return url.replace(path, '');
        }
        return null;
    }
    tryFetchUpdatedFallbackInfo(sdkKey, urlConfig, errorMessage, timedOut) {
        var _a, _b;
        return __awaiter(this, void 0, void 0, function* () {
            try {
                if (!_isDomainFailure(errorMessage, timedOut)) {
                    return false;
                }
                const canUseNetworkFallbacks = urlConfig.customUrl == null && urlConfig.fallbackUrls == null;
                const urls = canUseNetworkFallbacks
                    ? yield this._tryFetchFallbackUrlsFromNetwork(urlConfig)
                    : urlConfig.fallbackUrls;
                const newUrl = this._pickNewFallbackUrl((_a = this._fallbackInfo) === null || _a === void 0 ? void 0 : _a[urlConfig.endpoint], urls);
                if (!newUrl) {
                    return false;
                }
                this._updateFallbackInfoWithNewUrl(sdkKey, urlConfig.endpoint, newUrl);
                return true;
            }
            catch (error) {
                (_b = this._errorBoundary) === null || _b === void 0 ? void 0 : _b.logError('tryFetchUpdatedFallbackInfo', error);
                return false;
            }
        });
    }
    _updateFallbackInfoWithNewUrl(sdkKey, endpoint, newUrl) {
        var _a, _b, _c;
        const newFallbackInfo = {
            url: newUrl,
            expiryTime: Date.now() + DEFAULT_TTL_MS,
            previous: [],
        };
        const previousInfo = (_a = this._fallbackInfo) === null || _a === void 0 ? void 0 : _a[endpoint];
        if (previousInfo) {
            newFallbackInfo.previous.push(...previousInfo.previous);
        }
        if (newFallbackInfo.previous.length > 10) {
            newFallbackInfo.previous = [];
        }
        const previousUrl = (_c = (_b = this._fallbackInfo) === null || _b === void 0 ? void 0 : _b[endpoint]) === null || _c === void 0 ? void 0 : _c.url;
        if (previousUrl != null) {
            newFallbackInfo.previous.push(previousUrl);
        }
        this._fallbackInfo = Object.assign(Object.assign({}, this._fallbackInfo), { [endpoint]: newFallbackInfo });
        _tryWriteFallbackInfoToCache(sdkKey, this._fallbackInfo);
    }
    _tryFetchFallbackUrlsFromNetwork(urlConfig) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const cooldown = this._dnsQueryCooldowns[urlConfig.endpoint];
            if (cooldown && Date.now() < cooldown) {
                return null;
            }
            this._dnsQueryCooldowns[urlConfig.endpoint] = Date.now() + COOLDOWN_TIME_MS;
            const result = [];
            const records = yield (0, DnsTxtQuery_1._fetchTxtRecords)((_a = this._networkOverrideFunc) !== null && _a !== void 0 ? _a : fetch);
            const path = _extractPathFromUrl(urlConfig.defaultUrl);
            for (const record of records) {
                if (!record.startsWith(urlConfig.endpointDnsKey + '=')) {
                    continue;
                }
                const parts = record.split('=');
                if (parts.length > 1) {
                    let baseUrl = parts[1];
                    if (baseUrl.endsWith('/')) {
                        baseUrl = baseUrl.slice(0, -1);
                    }
                    result.push(`https://${baseUrl}${path}`);
                }
            }
            return result;
        });
    }
    _pickNewFallbackUrl(currentFallbackInfo, urls) {
        var _a;
        if (urls == null) {
            return null;
        }
        const previouslyUsed = new Set((_a = currentFallbackInfo === null || currentFallbackInfo === void 0 ? void 0 : currentFallbackInfo.previous) !== null && _a !== void 0 ? _a : []);
        const currentFallbackUrl = currentFallbackInfo === null || currentFallbackInfo === void 0 ? void 0 : currentFallbackInfo.url;
        let found = null;
        for (const loopUrl of urls) {
            const url = loopUrl.endsWith('/') ? loopUrl.slice(0, -1) : loopUrl;
            if (!previouslyUsed.has(loopUrl) && url !== currentFallbackUrl) {
                found = url;
                break;
            }
        }
        return found;
    }
}
exports.NetworkFallbackResolver = NetworkFallbackResolver;
function _isDomainFailure(errorMsg, timedOut) {
    var _a;
    const lowerErrorMsg = (_a = errorMsg === null || errorMsg === void 0 ? void 0 : errorMsg.toLowerCase()) !== null && _a !== void 0 ? _a : '';
    return (timedOut ||
        lowerErrorMsg.includes('uncaught exception') ||
        lowerErrorMsg.includes('failed to fetch') ||
        lowerErrorMsg.includes('networkerror when attempting to fetch resource'));
}
exports._isDomainFailure = _isDomainFailure;
function _getFallbackInfoStorageKey(sdkKey) {
    return `statsig.network_fallback.${(0, Hashing_1._DJB2)(sdkKey)}`;
}
function _tryWriteFallbackInfoToCache(sdkKey, info) {
    const hashKey = _getFallbackInfoStorageKey(sdkKey);
    if (!info || Object.keys(info).length === 0) {
        StorageProvider_1.Storage.removeItem(hashKey);
        return;
    }
    StorageProvider_1.Storage.setItem(hashKey, JSON.stringify(info));
}
function _readFallbackInfoFromCache(sdkKey) {
    const hashKey = _getFallbackInfoStorageKey(sdkKey);
    const data = StorageProvider_1.Storage.getItem(hashKey);
    if (!data) {
        return null;
    }
    try {
        return JSON.parse(data);
    }
    catch (_a) {
        Log_1.Log.error('Failed to parse FallbackInfo');
        return null;
    }
}
function _extractPathFromUrl(urlString) {
    try {
        const url = new URL(urlString);
        return url.pathname;
    }
    catch (error) {
        return null;
    }
}


/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports._fetchTxtRecords = void 0;
// See example: https://github.com/statsig-io/private-js-client-monorepo/pull/340
const FEATURE_ASSETS_DNS_QUERY = new Uint8Array([
    0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d,
    0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73,
    0x03, 0x6f, 0x72, 0x67, 0x00, 0x00, 0x10, 0x00, 0x01,
]);
const DNS_QUERY_ENDPOINT = 'https://cloudflare-dns.com/dns-query';
const DOMAIN_CHARS = [
    'i', // initialize
    'e', // events
    'd', // dcs
];
const MAX_START_LOOKUP = 200;
function _fetchTxtRecords(networkFunc) {
    return __awaiter(this, void 0, void 0, function* () {
        const response = yield networkFunc(DNS_QUERY_ENDPOINT, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/dns-message',
                Accept: 'application/dns-message',
            },
            body: FEATURE_ASSETS_DNS_QUERY,
        });
        if (!response.ok) {
            const err = new Error('Failed to fetch TXT records from DNS');
            err.name = 'DnsTxtFetchError';
            throw err;
        }
        const data = yield response.arrayBuffer();
        const bytes = new Uint8Array(data);
        return _parseDnsResponse(bytes);
    });
}
exports._fetchTxtRecords = _fetchTxtRecords;
function _parseDnsResponse(input) {
    // loop until we find the first valid domain char. One of [i=, e=, d=]
    const start = input.findIndex((byte, index) => index < MAX_START_LOOKUP &&
        String.fromCharCode(byte) === '=' &&
        DOMAIN_CHARS.includes(String.fromCharCode(input[index - 1])));
    if (start === -1) {
        const err = new Error('Failed to parse TXT records from DNS');
        err.name = 'DnsTxtParseError';
        throw err;
    }
    // decode the remaining bytes as a string
    let result = '';
    for (let i = start - 1; i < input.length; i++) {
        result += String.fromCharCode(input[i]);
    }
    return result.split(',');
}


/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.StatsigSession = exports.SessionID = void 0;
const CacheKey_1 = __webpack_require__(17);
const Log_1 = __webpack_require__(14);
const StorageProvider_1 = __webpack_require__(24);
const UUID_1 = __webpack_require__(31);
const MAX_SESSION_IDLE_TIME = 30 * 60 * 1000; // 30 minutes
const MAX_SESSION_AGE = 4 * 60 * 60 * 1000; // 4 hours
const PROMISE_MAP = {};
exports.SessionID = {
    get: (sdkKey) => {
        return exports.StatsigSession.get(sdkKey).data.sessionID;
    },
};
exports.StatsigSession = {
    get: (sdkKey) => {
        if (PROMISE_MAP[sdkKey] == null) {
            PROMISE_MAP[sdkKey] = _loadSession(sdkKey);
        }
        const session = PROMISE_MAP[sdkKey];
        return _bumpSession(session);
    },
    overrideInitialSessionID: (override, sdkKey) => {
        PROMISE_MAP[sdkKey] = _overrideSessionId(override, sdkKey);
    },
};
function _loadSession(sdkKey) {
    let data = _loadFromStorage(sdkKey);
    const now = Date.now();
    if (!data) {
        data = {
            sessionID: (0, UUID_1.getUUID)(),
            startTime: now,
            lastUpdate: now,
        };
    }
    return {
        data,
        sdkKey,
    };
}
function _overrideSessionId(override, sdkKey) {
    const now = Date.now();
    return {
        data: {
            sessionID: override,
            startTime: now,
            lastUpdate: now,
        },
        sdkKey,
    };
}
function _bumpSession(session) {
    const now = Date.now();
    const data = session.data;
    if (_isIdle(data) || _hasRunTooLong(data)) {
        data.sessionID = (0, UUID_1.getUUID)();
        data.startTime = now;
    }
    data.lastUpdate = now;
    _persistToStorage(data, session.sdkKey);
    clearTimeout(session.idleTimeoutID);
    clearTimeout(session.ageTimeoutID);
    const lifetime = now - data.startTime;
    const sdkKey = session.sdkKey;
    session.idleTimeoutID = _createSessionTimeout(sdkKey, MAX_SESSION_IDLE_TIME);
    session.ageTimeoutID = _createSessionTimeout(sdkKey, MAX_SESSION_AGE - lifetime);
    return session;
}
function _createSessionTimeout(sdkKey, duration) {
    return setTimeout(() => {
        const client = __STATSIG__ === null || __STATSIG__ === void 0 ? void 0 : __STATSIG__.instance(sdkKey);
        if (client) {
            client.$emt({ name: 'session_expired' });
        }
    }, duration);
}
function _isIdle({ lastUpdate }) {
    return Date.now() - lastUpdate > MAX_SESSION_IDLE_TIME;
}
function _hasRunTooLong({ startTime }) {
    return Date.now() - startTime > MAX_SESSION_AGE;
}
function _getSessionIDStorageKey(sdkKey) {
    return `statsig.session_id.${(0, CacheKey_1._getStorageKey)(sdkKey)}`;
}
function _persistToStorage(session, sdkKey) {
    const storageKey = _getSessionIDStorageKey(sdkKey);
    try {
        (0, StorageProvider_1._setObjectInStorage)(storageKey, session);
    }
    catch (e) {
        Log_1.Log.warn('Failed to save SessionID');
    }
}
function _loadFromStorage(sdkKey) {
    const storageKey = _getSessionIDStorageKey(sdkKey);
    return (0, StorageProvider_1._getObjectFromStorage)(storageKey);
}


/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ErrorTag = void 0;
exports.ErrorTag = {
    NetworkError: 'NetworkError',
};


/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });


/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });


/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StatsigClientBase = void 0;
__webpack_require__(12);
const __StatsigGlobal_1 = __webpack_require__(12);
const ErrorBoundary_1 = __webpack_require__(35);
const EventLogger_1 = __webpack_require__(16);
const Log_1 = __webpack_require__(14);
const MemoKey_1 = __webpack_require__(40);
const SafeJs_1 = __webpack_require__(21);
const SessionID_1 = __webpack_require__(44);
const StorageProvider_1 = __webpack_require__(24);
const MAX_MEMO_CACHE_SIZE = 3000;
class StatsigClientBase {
    constructor(sdkKey, adapter, network, options) {
        var _a;
        this.loadingStatus = 'Uninitialized';
        this._initializePromise = null;
        this._listeners = {};
        const emitter = this.$emt.bind(this);
        (options === null || options === void 0 ? void 0 : options.logLevel) != null && (Log_1.Log.level = options.logLevel);
        (options === null || options === void 0 ? void 0 : options.disableStorage) && StorageProvider_1.Storage._setDisabled(true);
        (options === null || options === void 0 ? void 0 : options.initialSessionID) &&
            SessionID_1.StatsigSession.overrideInitialSessionID(options.initialSessionID, sdkKey);
        (options === null || options === void 0 ? void 0 : options.storageProvider) && StorageProvider_1.Storage._setProvider(options.storageProvider);
        this._sdkKey = sdkKey;
        this._options = options !== null && options !== void 0 ? options : {};
        this._memoCache = {};
        this.overrideAdapter = (_a = options === null || options === void 0 ? void 0 : options.overrideAdapter) !== null && _a !== void 0 ? _a : null;
        this._logger = new EventLogger_1.EventLogger(sdkKey, emitter, network, options);
        this._errorBoundary = new ErrorBoundary_1.ErrorBoundary(sdkKey, options, emitter);
        this._errorBoundary.wrap(this);
        this._errorBoundary.wrap(adapter);
        this._errorBoundary.wrap(this._logger);
        network.setErrorBoundary(this._errorBoundary);
        this.dataAdapter = adapter;
        this.dataAdapter.attach(sdkKey, options);
        this.storageProvider = StorageProvider_1.Storage;
        this._primeReadyRipcord();
        _assignGlobalInstance(sdkKey, this);
    }
    /**
     * Updates runtime configuration options for the SDK, allowing toggling of certain behaviors such as logging and storage to comply with user preferences or regulations such as GDPR.
     *
     * @param {StatsigRuntimeMutableOptions} options - The configuration options that dictate the runtime behavior of the SDK.
     */
    updateRuntimeOptions(options) {
        if (options.disableLogging != null) {
            this._options.disableLogging = options.disableLogging;
            this._logger.setLoggingDisabled(options.disableLogging);
        }
        if (options.disableStorage != null) {
            this._options.disableStorage = options.disableStorage;
            StorageProvider_1.Storage._setDisabled(options.disableStorage);
        }
    }
    /**
     * Flushes any currently queued events.
     */
    flush() {
        return this._logger.flush();
    }
    /**
     * Gracefully shuts down the SDK, ensuring that all pending events are send before the SDK stops.
     * This function emits a 'pre_shutdown' event and then waits for the logger to complete its shutdown process.
     *
     * @returns {Promise<void>} A promise that resolves when all shutdown procedures, including logging shutdown, have been completed.
     */
    shutdown() {
        return __awaiter(this, void 0, void 0, function* () {
            this.$emt({ name: 'pre_shutdown' });
            this._setStatus('Uninitialized', null);
            this._initializePromise = null;
            yield this._logger.stop();
        });
    }
    /**
     * Subscribes a callback function to a specific {@link StatsigClientEvent} or all StatsigClientEvents if the wildcard '*' is used.
     * Once subscribed, the listener callback will be invoked whenever the specified event is emitted.
     *
     * @param {StatsigClientEventName} event - The name of the event to subscribe to, or '*' to subscribe to all events.
     * @param {StatsigClientEventCallback<T>} listener - The callback function to execute when the event occurs. The function receives event-specific data as its parameter.
     * @see {@link off} for unsubscribing from events.
     */
    on(event, listener) {
        if (!this._listeners[event]) {
            this._listeners[event] = [];
        }
        this._listeners[event].push(listener);
    }
    /**
     * Unsubscribes a previously registered callback function from a specific {@link StatsigClientEvent} or all StatsigClientEvents if the wildcard '*' is used.
     *
     * @param {StatsigClientEventName} event - The name of the event from which to unsubscribe, or '*' to unsubscribe from all events.
     * @param {StatsigClientEventCallback<T>} listener - The callback function to remove from the event's notification list.
     * @see {@link on} for subscribing to events.
     */
    off(event, listener) {
        if (this._listeners[event]) {
            const index = this._listeners[event].indexOf(listener);
            if (index !== -1) {
                this._listeners[event].splice(index, 1);
            }
        }
    }
    $on(event, listener) {
        listener.__isInternal = true;
        this.on(event, listener);
    }
    $emt(event) {
        var _a;
        const barrier = (listener) => {
            try {
                listener(event);
            }
            catch (error) {
                if (listener.__isInternal === true) {
                    this._errorBoundary.logError(`__emit:${event.name}`, error);
                    return;
                }
                Log_1.Log.error(`An error occurred in a StatsigClientEvent listener. This is not an issue with Statsig.`, event);
            }
        };
        if (this._listeners[event.name]) {
            this._listeners[event.name].forEach((l) => barrier(l));
        }
        (_a = this._listeners['*']) === null || _a === void 0 ? void 0 : _a.forEach(barrier);
    }
    _setStatus(newStatus, values) {
        this.loadingStatus = newStatus;
        this._memoCache = {};
        this.$emt({ name: 'values_updated', status: newStatus, values });
    }
    _enqueueExposure(name, exposure, options) {
        if ((options === null || options === void 0 ? void 0 : options.disableExposureLog) === true) {
            this._logger.incrementNonExposureCount(name);
            return;
        }
        this._logger.enqueue(exposure);
    }
    _memoize(prefix, fn) {
        return (name, options) => {
            if (this._options.disableEvaluationMemoization) {
                return fn(name, options);
            }
            const memoKey = (0, MemoKey_1.createMemoKey)(prefix, name, options);
            if (!memoKey) {
                return fn(name, options);
            }
            if (!(memoKey in this._memoCache)) {
                if (Object.keys(this._memoCache).length >= MAX_MEMO_CACHE_SIZE) {
                    this._memoCache = {};
                }
                this._memoCache[memoKey] = fn(name, options);
            }
            return this._memoCache[memoKey];
        };
    }
}
exports.StatsigClientBase = StatsigClientBase;
function _assignGlobalInstance(sdkKey, client) {
    var _a;
    if ((0, SafeJs_1._isServerEnv)()) {
        return;
    }
    const statsigGlobal = (0, __StatsigGlobal_1._getStatsigGlobal)();
    const instances = (_a = statsigGlobal.instances) !== null && _a !== void 0 ? _a : {};
    const inst = client;
    if (instances[sdkKey] != null) {
        Log_1.Log.warn('Creating multiple Statsig clients with the same SDK key can lead to unexpected behavior. Multi-instance support requires different SDK keys.');
    }
    instances[sdkKey] = inst;
    if (!statsigGlobal.firstInstance) {
        statsigGlobal.firstInstance = inst;
    }
    statsigGlobal.instances = instances;
    __STATSIG__ = statsigGlobal;
}


/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.DataAdapterCachePrefix = void 0;
exports.DataAdapterCachePrefix = 'statsig.cached';


/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });


/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });


/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports._makeTypedGet = exports._mergeOverride = exports._makeLayer = exports._makeExperiment = exports._makeDynamicConfig = exports._makeFeatureGate = void 0;
const Log_1 = __webpack_require__(14);
const TypingUtils_1 = __webpack_require__(19);
const DEFAULT_RULE = 'default';
function _makeEvaluation(name, details, evaluation, value) {
    var _a;
    return {
        name,
        details,
        ruleID: (_a = evaluation === null || evaluation === void 0 ? void 0 : evaluation.rule_id) !== null && _a !== void 0 ? _a : DEFAULT_RULE,
        __evaluation: evaluation,
        value,
    };
}
function _makeFeatureGate(name, details, evaluation) {
    return _makeEvaluation(name, details, evaluation, (evaluation === null || evaluation === void 0 ? void 0 : evaluation.value) === true);
}
exports._makeFeatureGate = _makeFeatureGate;
function _makeDynamicConfig(name, details, evaluation) {
    var _a;
    const value = (_a = evaluation === null || evaluation === void 0 ? void 0 : evaluation.value) !== null && _a !== void 0 ? _a : {};
    return Object.assign(Object.assign({}, _makeEvaluation(name, details, evaluation, value)), { get: _makeTypedGet(name, evaluation === null || evaluation === void 0 ? void 0 : evaluation.value) });
}
exports._makeDynamicConfig = _makeDynamicConfig;
function _makeExperiment(name, details, evaluation) {
    var _a;
    const result = _makeDynamicConfig(name, details, evaluation);
    return Object.assign(Object.assign({}, result), { groupName: (_a = evaluation === null || evaluation === void 0 ? void 0 : evaluation.group_name) !== null && _a !== void 0 ? _a : null });
}
exports._makeExperiment = _makeExperiment;
function _makeLayer(name, details, evaluation, exposeFunc) {
    var _a, _b;
    return Object.assign(Object.assign({}, _makeEvaluation(name, details, evaluation, undefined)), { get: _makeTypedGet(name, evaluation === null || evaluation === void 0 ? void 0 : evaluation.value, exposeFunc), groupName: (_a = evaluation === null || evaluation === void 0 ? void 0 : evaluation.group_name) !== null && _a !== void 0 ? _a : null, __value: (_b = evaluation === null || evaluation === void 0 ? void 0 : evaluation.value) !== null && _b !== void 0 ? _b : {} });
}
exports._makeLayer = _makeLayer;
function _mergeOverride(original, overridden, value, exposeFunc) {
    return Object.assign(Object.assign(Object.assign({}, original), overridden), { get: _makeTypedGet(original.name, value, exposeFunc) });
}
exports._mergeOverride = _mergeOverride;
function _makeTypedGet(name, value, exposeFunc) {
    return (param, fallback) => {
        var _a;
        const found = (_a = value === null || value === void 0 ? void 0 : value[param]) !== null && _a !== void 0 ? _a : null;
        if (found == null) {
            return (fallback !== null && fallback !== void 0 ? fallback : null);
        }
        if (fallback != null && !(0, TypingUtils_1._isTypeMatch)(found, fallback)) {
            Log_1.Log.warn(`Parameter type mismatch. '${name}.${param}' was found to be type '${typeof found}' but fallback/return type is '${typeof fallback}'. See https://docs.statsig.com/client/javascript-sdk/#typed-getters`);
            return (fallback !== null && fallback !== void 0 ? fallback : null);
        }
        exposeFunc === null || exposeFunc === void 0 ? void 0 : exposeFunc(param);
        return found;
    };
}
exports._makeTypedGet = _makeTypedGet;


/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });


/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.UPDATE_DETAIL_ERROR_MESSAGES = exports.createUpdateDetails = void 0;
const createUpdateDetails = (success, source, initDuration, error, sourceUrl, warnings) => {
    return {
        duration: initDuration,
        source,
        success,
        error,
        sourceUrl,
        warnings,
    };
};
exports.createUpdateDetails = createUpdateDetails;
exports.UPDATE_DETAIL_ERROR_MESSAGES = {
    NO_NETWORK_DATA: 'No data was returned from the network. This may be due to a network timeout if a timeout value was specified in the options or ad blocker error.',
};


/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.SDKFlags = void 0;
const FLAGMAP = {};
exports.SDKFlags = {
    setFlags: (sdkKey, flags) => {
        FLAGMAP[sdkKey] = flags;
    },
    get: (sdkKey, flagKey) => {
        var _a, _b;
        return (_b = (_a = FLAGMAP[sdkKey]) === null || _a === void 0 ? void 0 : _a[flagKey]) !== null && _b !== void 0 ? _b : false;
    },
};


/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
const client_core_1 = __webpack_require__(11);
class EvaluationStore {
    constructor(_sdkKey) {
        this._sdkKey = _sdkKey;
        this._rawValues = null;
        this._values = null;
        this._source = 'Uninitialized';
        this._lcut = 0;
        this._receivedAt = 0;
        this._bootstrapMetadata = null;
        this._warnings = new Set();
    }
    reset() {
        this._values = null;
        this._rawValues = null;
        this._source = 'Loading';
        this._lcut = 0;
        this._receivedAt = 0;
        this._bootstrapMetadata = null;
    }
    finalize() {
        if (this._values) {
            return;
        }
        this._source = 'NoValues';
    }
    getValues() {
        return this._rawValues
            ? (0, client_core_1._typedJsonParse)(this._rawValues, 'has_updates', 'EvaluationStoreValues')
            : null;
    }
    setValues(result, user) {
        if (!result) {
            return false;
        }
        const values = (0, client_core_1._typedJsonParse)(result.data, 'has_updates', 'EvaluationResponse');
        if (values == null) {
            return false;
        }
        this._source = result.source;
        if ((values === null || values === void 0 ? void 0 : values.has_updates) !== true) {
            return true;
        }
        this._rawValues = result.data;
        this._lcut = values.time;
        this._receivedAt = result.receivedAt;
        this._values = values;
        this._bootstrapMetadata = this._extractBootstrapMetadata(result.source, values);
        if (result.source && values.user) {
            this._setWarningState(user, values);
        }
        if (values.sdk_flags) {
            client_core_1.SDKFlags.setFlags(this._sdkKey, values.sdk_flags);
        }
        else {
            client_core_1.SDKFlags.setFlags(this._sdkKey, {});
        }
        return true;
    }
    getWarnings() {
        if (this._warnings.size === 0) {
            return undefined;
        }
        return Array.from(this._warnings);
    }
    getGate(name) {
        var _a;
        return this._getDetailedStoreResult((_a = this._values) === null || _a === void 0 ? void 0 : _a.feature_gates, name);
    }
    getConfig(name) {
        var _a;
        return this._getDetailedStoreResult((_a = this._values) === null || _a === void 0 ? void 0 : _a.dynamic_configs, name);
    }
    getLayer(name) {
        var _a;
        return this._getDetailedStoreResult((_a = this._values) === null || _a === void 0 ? void 0 : _a.layer_configs, name);
    }
    getParamStore(name) {
        var _a;
        return this._getDetailedStoreResult((_a = this._values) === null || _a === void 0 ? void 0 : _a.param_stores, name);
    }
    getSource() {
        return this._source;
    }
    _extractBootstrapMetadata(source, values) {
        if (source !== 'Bootstrap') {
            return null;
        }
        const bootstrapMetadata = {};
        if (values.user) {
            bootstrapMetadata.user = values.user;
        }
        if (values.sdkInfo) {
            bootstrapMetadata.generatorSDKInfo = values.sdkInfo;
        }
        bootstrapMetadata.lcut = values.time;
        return bootstrapMetadata;
    }
    _getDetailedStoreResult(lookup, name) {
        let result = null;
        if (lookup) {
            result = lookup[name] ? lookup[name] : lookup[(0, client_core_1._DJB2)(name)];
        }
        return {
            result,
            details: this._getDetails(result == null),
        };
    }
    _setWarningState(user, values) {
        var _a;
        const stableID = client_core_1.StableID.get(this._sdkKey);
        if (((_a = user.customIDs) === null || _a === void 0 ? void 0 : _a.stableID) !== stableID) {
            this._warnings.add('StableIDMismatch');
            return;
        }
        if ('user' in values) {
            const bootstrapUser = values['user'];
            if ((0, client_core_1._getFullUserHash)(user) !== (0, client_core_1._getFullUserHash)(bootstrapUser)) {
                this._warnings.add('PartialUserMatch');
            }
        }
    }
    getCurrentSourceDetails() {
        if (this._source === 'Uninitialized' || this._source === 'NoValues') {
            return { reason: this._source };
        }
        const sourceDetails = {
            reason: this._source,
            lcut: this._lcut,
            receivedAt: this._receivedAt,
        };
        if (this._warnings.size > 0) {
            sourceDetails.warnings = Array.from(this._warnings);
        }
        return sourceDetails;
    }
    _getDetails(isUnrecognized) {
        var _a, _b;
        const sourceDetails = this.getCurrentSourceDetails();
        let reason = sourceDetails.reason;
        const warnings = (_a = sourceDetails.warnings) !== null && _a !== void 0 ? _a : [];
        if (this._source === 'Bootstrap' && warnings.length > 0) {
            reason = reason + warnings[0];
        }
        if (reason !== 'Uninitialized' && reason !== 'NoValues') {
            const subreason = isUnrecognized ? 'Unrecognized' : 'Recognized';
            reason = `${reason}:${subreason}`;
        }
        const bootstrapMetadata = this._source === 'Bootstrap'
            ? (_b = this._bootstrapMetadata) !== null && _b !== void 0 ? _b : undefined
            : undefined;
        if (bootstrapMetadata) {
            sourceDetails.bootstrapMetadata = bootstrapMetadata;
        }
        return Object.assign(Object.assign({}, sourceDetails), { reason });
    }
}
exports.default = EvaluationStore;


/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const client_core_1 = __webpack_require__(11);
const EvaluationResponseDeltas_1 = __webpack_require__(58);
class StatsigNetwork extends client_core_1.NetworkCore {
    constructor(options, emitter) {
        super(options, emitter);
        const config = options === null || options === void 0 ? void 0 : options.networkConfig;
        this._initializeUrlConfig = new client_core_1.UrlConfiguration(client_core_1.Endpoint._initialize, config === null || config === void 0 ? void 0 : config.initializeUrl, config === null || config === void 0 ? void 0 : config.api, config === null || config === void 0 ? void 0 : config.initializeFallbackUrls);
    }
    fetchEvaluations(sdkKey, current, priority, user) {
        return __awaiter(this, void 0, void 0, function* () {
            const cache = current
                ? (0, client_core_1._typedJsonParse)(current, 'has_updates', 'InitializeResponse')
                : null;
            let data = {
                user,
                hash: 'djb2',
                deltasResponseRequested: false,
                full_checksum: null,
            };
            if (cache === null || cache === void 0 ? void 0 : cache.has_updates) {
                data = Object.assign(Object.assign({}, data), { sinceTime: cache.time, previousDerivedFields: 'derived_fields' in cache ? cache.derived_fields : {}, deltasResponseRequested: true, full_checksum: cache.full_checksum });
            }
            return this._fetchEvaluations(sdkKey, cache, data, priority);
        });
    }
    _fetchEvaluations(sdkKey, cache, data, priority) {
        var _a, _b;
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.post({
                sdkKey,
                urlConfig: this._initializeUrlConfig,
                data,
                retries: 2,
                isStatsigEncodable: true,
                priority,
            });
            if ((response === null || response === void 0 ? void 0 : response.code) === 204) {
                return '{"has_updates": false}';
            }
            if ((response === null || response === void 0 ? void 0 : response.code) !== 200) {
                return (_a = response === null || response === void 0 ? void 0 : response.body) !== null && _a !== void 0 ? _a : null;
            }
            if ((cache === null || cache === void 0 ? void 0 : cache.has_updates) !== true ||
                ((_b = response.body) === null || _b === void 0 ? void 0 : _b.includes('"is_delta":true')) !== true ||
                data.deltasResponseRequested !== true) {
                return response.body;
            }
            const result = (0, EvaluationResponseDeltas_1._resolveDeltasResponse)(cache, response.body);
            if (typeof result === 'string') {
                return result;
            }
            // retry without deltas
            return this._fetchEvaluations(sdkKey, cache, Object.assign(Object.assign(Object.assign({}, data), result), { deltasResponseRequested: false }), priority);
        });
    }
}
exports.default = StatsigNetwork;


/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports._resolveDeltasResponse = void 0;
const client_core_1 = __webpack_require__(11);
const MAX_DELTAS_SORT_DEPTH = 2;
function _resolveDeltasResponse(cache, deltasString) {
    const deltas = (0, client_core_1._typedJsonParse)(deltasString, 'checksum', 'DeltasEvaluationResponse');
    if (!deltas) {
        return {
            hadBadDeltaChecksum: true,
        };
    }
    const merged = _mergeDeltasIntoCache(cache, deltas);
    const resolved = _handleDeletedEntries(merged);
    const actualChecksum = (0, client_core_1._DJB2Object)({
        feature_gates: resolved.feature_gates,
        dynamic_configs: resolved.dynamic_configs,
        layer_configs: resolved.layer_configs,
    }, MAX_DELTAS_SORT_DEPTH);
    const isMatch = actualChecksum === deltas.checksumV2;
    if (!isMatch) {
        return {
            hadBadDeltaChecksum: true,
            badChecksum: actualChecksum,
            badMergedConfigs: resolved,
            badFullResponse: deltas.deltas_full_response,
        };
    }
    return JSON.stringify(resolved);
}
exports._resolveDeltasResponse = _resolveDeltasResponse;
function _mergeDeltasIntoCache(cache, deltas) {
    return Object.assign(Object.assign(Object.assign({}, cache), deltas), { feature_gates: Object.assign(Object.assign({}, cache.feature_gates), deltas.feature_gates), layer_configs: Object.assign(Object.assign({}, cache.layer_configs), deltas.layer_configs), dynamic_configs: Object.assign(Object.assign({}, cache.dynamic_configs), deltas.dynamic_configs) });
}
function _handleDeletedEntries(deltas) {
    const result = deltas;
    _deleteEntriesInRecord(deltas.deleted_gates, result.feature_gates);
    delete result.deleted_gates;
    _deleteEntriesInRecord(deltas.deleted_configs, result.dynamic_configs);
    delete result.deleted_configs;
    _deleteEntriesInRecord(deltas.deleted_layers, result.layer_configs);
    delete result.deleted_layers;
    return result;
}
function _deleteEntriesInRecord(keys, values) {
    keys === null || keys === void 0 ? void 0 : keys.forEach((key) => {
        delete values[key];
    });
}


/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports._makeParamStoreGetter = void 0;
const client_core_1 = __webpack_require__(11);
const NO_EXPOSURE_OPT = {
    disableExposureLog: true,
};
function _shouldLogExposure(options) {
    return options == null || options.disableExposureLog === false;
}
function _shouldReturnFallback(value, fallback) {
    return fallback != null && !(0, client_core_1._isTypeMatch)(value, fallback);
}
function _getMappedStaticValue(param, _options) {
    return param.value;
}
function _getMappedGateValue(client, param, options) {
    const gate = client.getFeatureGate(param.gate_name, _shouldLogExposure(options) ? undefined : NO_EXPOSURE_OPT);
    if (gate.value) {
        return param.pass_value;
    }
    return param.fail_value;
}
function _getMappedDynamicConfigValue(client, param, fallback, options) {
    const config = client.getDynamicConfig(param.config_name, NO_EXPOSURE_OPT);
    const value = config.get(param.param_name);
    if (_shouldReturnFallback(value, fallback)) {
        return fallback;
    }
    if (_shouldLogExposure(options)) {
        client.getDynamicConfig(param.config_name);
    }
    return value;
}
function _getMappedExperimentValue(client, param, fallback, options) {
    const experiment = client.getExperiment(param.experiment_name, NO_EXPOSURE_OPT);
    const value = experiment.get(param.param_name);
    if (_shouldReturnFallback(value, fallback)) {
        return fallback;
    }
    if (_shouldLogExposure(options)) {
        client.getExperiment(param.experiment_name);
    }
    return value;
}
function _getMappedLayerValue(client, param, fallback, options) {
    const layer = client.getLayer(param.layer_name, NO_EXPOSURE_OPT);
    const value = layer.get(param.param_name);
    if (_shouldReturnFallback(value, fallback)) {
        return fallback;
    }
    if (_shouldLogExposure(options)) {
        client.getLayer(param.layer_name).get(param.param_name);
    }
    return value;
}
function _makeParamStoreGetter(client, config, options) {
    return (paramName, fallback) => {
        if (config == null) {
            return fallback;
        }
        const param = config[paramName];
        if (param == null ||
            (fallback != null && (0, client_core_1._typeOf)(fallback) !== param.param_type)) {
            return fallback;
        }
        switch (param.ref_type) {
            case 'static':
                return _getMappedStaticValue(param, options);
            case 'gate':
                return _getMappedGateValue(client, param, options);
            case 'dynamic_config':
                return _getMappedDynamicConfigValue(client, param, fallback, options);
            case 'experiment':
                return _getMappedExperimentValue(client, param, fallback, options);
            case 'layer':
                return _getMappedLayerValue(client, param, fallback, options);
            default:
                return fallback;
        }
    };
}
exports._makeParamStoreGetter = _makeParamStoreGetter;


/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StatsigEvaluationsDataAdapter = void 0;
const client_core_1 = __webpack_require__(11);
const Network_1 = __webpack_require__(57);
class StatsigEvaluationsDataAdapter extends client_core_1.DataAdapterCore {
    constructor() {
        super('EvaluationsDataAdapter', 'evaluations');
        this._network = null;
        this._options = null;
    }
    attach(sdkKey, options) {
        super.attach(sdkKey, options);
        this._network = new Network_1.default(options !== null && options !== void 0 ? options : {});
    }
    getDataAsync(current, user, options) {
        return this._getDataAsyncImpl(current, (0, client_core_1._normalizeUser)(user, this._options), options);
    }
    prefetchData(user, options) {
        return this._prefetchDataImpl(user, options);
    }
    setData(data) {
        const values = (0, client_core_1._typedJsonParse)(data, 'has_updates', 'data');
        if (values && 'user' in values) {
            super.setData(data, values.user);
        }
        else {
            client_core_1.Log.error('StatsigUser not found. You may be using an older server SDK version. Please upgrade your SDK or use setDataLegacy.');
        }
    }
    setDataLegacy(data, user) {
        super.setData(data, user);
    }
    _fetchFromNetwork(current, user, options) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const result = yield ((_a = this._network) === null || _a === void 0 ? void 0 : _a.fetchEvaluations(this._getSdkKey(), current, options === null || options === void 0 ? void 0 : options.priority, user));
            return result !== null && result !== void 0 ? result : null;
        });
    }
    _getCacheKey(user) {
        var _a;
        const key = (0, client_core_1._getStorageKey)(this._getSdkKey(), user, (_a = this._options) === null || _a === void 0 ? void 0 : _a.customUserCacheKeyFunc);
        return `${client_core_1.DataAdapterCachePrefix}.${this._cacheSuffix}.${key}`;
    }
    _isCachedResultValidFor204(result, user) {
        return (result.fullUserHash != null &&
            result.fullUserHash === (0, client_core_1._getFullUserHash)(user));
    }
}
exports.StatsigEvaluationsDataAdapter = StatsigEvaluationsDataAdapter;


/***/ }),
/* 61 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Subscriptions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(62);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _Subscriptions__WEBPACK_IMPORTED_MODULE_0__["default"]; });



/***/ }),
/* 62 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ALL_FEATURE_VALUES", function() { return ALL_FEATURE_VALUES; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Subscriptions; });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var eventemitter2__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(63);
/* harmony import */ var eventemitter2__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(eventemitter2__WEBPACK_IMPORTED_MODULE_1__);

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }

const ALL_FEATURE_VALUES = '@all-features';
class Subscriptions {
  constructor() {
    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(this, "eventToValue", new Map());
    this.emitter = new eventemitter2__WEBPACK_IMPORTED_MODULE_1__["EventEmitter2"]();
  }
  onGateUpdated(gateName, callback, checkGate, options) {
    const value = checkGate(gateName, _objectSpread(_objectSpread({}, options), {}, {
      fireGateExposure: false
    }));
    if (this.eventToValue.get(callback) === undefined) {
      this.eventToValue.set(callback, value);
    }
    const wrapCallback = () => {
      const value = checkGate(gateName, _objectSpread(_objectSpread({}, options), {}, {
        fireGateExposure: false
      }));
      const existingValue = this.eventToValue.get(callback);
      if (existingValue !== value) {
        this.eventToValue.set(callback, value);
        callback(value);
      }
    };
    this.emitter.on(gateName, wrapCallback);
    return () => {
      this.emitter.off(gateName, wrapCallback);
    };
  }
  onExperimentValueUpdated(experimentName, parameterName, defaultValue, callback, getExperimentValue, options) {
    const experimentEventName = `${experimentName}.${parameterName}`;
    const value = getExperimentValue(experimentName, parameterName, defaultValue, _objectSpread(_objectSpread({}, options), {}, {
      fireExperimentExposure: false
    }));
    if (this.eventToValue.get(callback) === undefined) {
      this.eventToValue.set(callback, value);
    }
    const wrapCallback = () => {
      const value = getExperimentValue(experimentName, parameterName, defaultValue, _objectSpread(_objectSpread({}, options), {}, {
        fireExperimentExposure: false
      }));
      const existingValue = this.eventToValue.get(callback);
      if (existingValue !== value) {
        this.eventToValue.set(callback, value);
        callback(value);
      }
    };
    this.emitter.on(experimentEventName, wrapCallback);
    return () => {
      this.emitter.off(experimentEventName, wrapCallback);
    };
  }
  onAnyUpdated(callback) {
    this.emitter.on(ALL_FEATURE_VALUES, callback);
    return () => {
      this.emitter.off(ALL_FEATURE_VALUES, callback);
    };
  }
  anyUpdated() {
    this.emitter.emit(ALL_FEATURE_VALUES);
    this.emitter.eventNames().filter(name => name !== ALL_FEATURE_VALUES).forEach(event => {
      this.emitter.emit(event);
    });
  }
}

/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(process) {var __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * EventEmitter2
 * https://github.com/hij1nx/EventEmitter2
 *
 * Copyright (c) 2013 hij1nx
 * Licensed under the MIT license.
 */
;!function(undefined) {

  var isArray = Array.isArray ? Array.isArray : function _isArray(obj) {
    return Object.prototype.toString.call(obj) === "[object Array]";
  };
  var defaultMaxListeners = 10;

  function init() {
    this._events = {};
    if (this._conf) {
      configure.call(this, this._conf);
    }
  }

  function configure(conf) {
    if (conf) {
      this._conf = conf;

      conf.delimiter && (this.delimiter = conf.delimiter);
      this._maxListeners = conf.maxListeners !== undefined ? conf.maxListeners : defaultMaxListeners;

      conf.wildcard && (this.wildcard = conf.wildcard);
      conf.newListener && (this.newListener = conf.newListener);
      conf.verboseMemoryLeak && (this.verboseMemoryLeak = conf.verboseMemoryLeak);

      if (this.wildcard) {
        this.listenerTree = {};
      }
    } else {
      this._maxListeners = defaultMaxListeners;
    }
  }

  function logPossibleMemoryLeak(count, eventName) {
    var errorMsg = '(node) warning: possible EventEmitter memory ' +
        'leak detected. ' + count + ' listeners added. ' +
        'Use emitter.setMaxListeners() to increase limit.';

    if(this.verboseMemoryLeak){
      errorMsg += ' Event name: ' + eventName + '.';
    }

    if(typeof process !== 'undefined' && process.emitWarning){
      var e = new Error(errorMsg);
      e.name = 'MaxListenersExceededWarning';
      e.emitter = this;
      e.count = count;
      process.emitWarning(e);
    } else {
      console.error(errorMsg);

      if (console.trace){
        console.trace();
      }
    }
  }

  function EventEmitter(conf) {
    this._events = {};
    this.newListener = false;
    this.verboseMemoryLeak = false;
    configure.call(this, conf);
  }
  EventEmitter.EventEmitter2 = EventEmitter; // backwards compatibility for exporting EventEmitter property

  //
  // Attention, function return type now is array, always !
  // It has zero elements if no any matches found and one or more
  // elements (leafs) if there are matches
  //
  function searchListenerTree(handlers, type, tree, i) {
    if (!tree) {
      return [];
    }
    var listeners=[], leaf, len, branch, xTree, xxTree, isolatedBranch, endReached,
        typeLength = type.length, currentType = type[i], nextType = type[i+1];
    if (i === typeLength && tree._listeners) {
      //
      // If at the end of the event(s) list and the tree has listeners
      // invoke those listeners.
      //
      if (typeof tree._listeners === 'function') {
        handlers && handlers.push(tree._listeners);
        return [tree];
      } else {
        for (leaf = 0, len = tree._listeners.length; leaf < len; leaf++) {
          handlers && handlers.push(tree._listeners[leaf]);
        }
        return [tree];
      }
    }

    if ((currentType === '*' || currentType === '**') || tree[currentType]) {
      //
      // If the event emitted is '*' at this part
      // or there is a concrete match at this patch
      //
      if (currentType === '*') {
        for (branch in tree) {
          if (branch !== '_listeners' && tree.hasOwnProperty(branch)) {
            listeners = listeners.concat(searchListenerTree(handlers, type, tree[branch], i+1));
          }
        }
        return listeners;
      } else if(currentType === '**') {
        endReached = (i+1 === typeLength || (i+2 === typeLength && nextType === '*'));
        if(endReached && tree._listeners) {
          // The next element has a _listeners, add it to the handlers.
          listeners = listeners.concat(searchListenerTree(handlers, type, tree, typeLength));
        }

        for (branch in tree) {
          if (branch !== '_listeners' && tree.hasOwnProperty(branch)) {
            if(branch === '*' || branch === '**') {
              if(tree[branch]._listeners && !endReached) {
                listeners = listeners.concat(searchListenerTree(handlers, type, tree[branch], typeLength));
              }
              listeners = listeners.concat(searchListenerTree(handlers, type, tree[branch], i));
            } else if(branch === nextType) {
              listeners = listeners.concat(searchListenerTree(handlers, type, tree[branch], i+2));
            } else {
              // No match on this one, shift into the tree but not in the type array.
              listeners = listeners.concat(searchListenerTree(handlers, type, tree[branch], i));
            }
          }
        }
        return listeners;
      }

      listeners = listeners.concat(searchListenerTree(handlers, type, tree[currentType], i+1));
    }

    xTree = tree['*'];
    if (xTree) {
      //
      // If the listener tree will allow any match for this part,
      // then recursively explore all branches of the tree
      //
      searchListenerTree(handlers, type, xTree, i+1);
    }

    xxTree = tree['**'];
    if(xxTree) {
      if(i < typeLength) {
        if(xxTree._listeners) {
          // If we have a listener on a '**', it will catch all, so add its handler.
          searchListenerTree(handlers, type, xxTree, typeLength);
        }

        // Build arrays of matching next branches and others.
        for(branch in xxTree) {
          if(branch !== '_listeners' && xxTree.hasOwnProperty(branch)) {
            if(branch === nextType) {
              // We know the next element will match, so jump twice.
              searchListenerTree(handlers, type, xxTree[branch], i+2);
            } else if(branch === currentType) {
              // Current node matches, move into the tree.
              searchListenerTree(handlers, type, xxTree[branch], i+1);
            } else {
              isolatedBranch = {};
              isolatedBranch[branch] = xxTree[branch];
              searchListenerTree(handlers, type, { '**': isolatedBranch }, i+1);
            }
          }
        }
      } else if(xxTree._listeners) {
        // We have reached the end and still on a '**'
        searchListenerTree(handlers, type, xxTree, typeLength);
      } else if(xxTree['*'] && xxTree['*']._listeners) {
        searchListenerTree(handlers, type, xxTree['*'], typeLength);
      }
    }

    return listeners;
  }

  function growListenerTree(type, listener) {

    type = typeof type === 'string' ? type.split(this.delimiter) : type.slice();

    //
    // Looks for two consecutive '**', if so, don't add the event at all.
    //
    for(var i = 0, len = type.length; i+1 < len; i++) {
      if(type[i] === '**' && type[i+1] === '**') {
        return;
      }
    }

    var tree = this.listenerTree;
    var name = type.shift();

    while (name !== undefined) {

      if (!tree[name]) {
        tree[name] = {};
      }

      tree = tree[name];

      if (type.length === 0) {

        if (!tree._listeners) {
          tree._listeners = listener;
        }
        else {
          if (typeof tree._listeners === 'function') {
            tree._listeners = [tree._listeners];
          }

          tree._listeners.push(listener);

          if (
            !tree._listeners.warned &&
            this._maxListeners > 0 &&
            tree._listeners.length > this._maxListeners
          ) {
            tree._listeners.warned = true;
            logPossibleMemoryLeak.call(this, tree._listeners.length, name);
          }
        }
        return true;
      }
      name = type.shift();
    }
    return true;
  }

  // By default EventEmitters will print a warning if more than
  // 10 listeners are added to it. This is a useful default which
  // helps finding memory leaks.
  //
  // Obviously not all Emitters should be limited to 10. This function allows
  // that to be increased. Set to zero for unlimited.

  EventEmitter.prototype.delimiter = '.';

  EventEmitter.prototype.setMaxListeners = function(n) {
    if (n !== undefined) {
      this._maxListeners = n;
      if (!this._conf) this._conf = {};
      this._conf.maxListeners = n;
    }
  };

  EventEmitter.prototype.event = '';


  EventEmitter.prototype.once = function(event, fn) {
    return this._once(event, fn, false);
  };

  EventEmitter.prototype.prependOnceListener = function(event, fn) {
    return this._once(event, fn, true);
  };

  EventEmitter.prototype._once = function(event, fn, prepend) {
    this._many(event, 1, fn, prepend);
    return this;
  };

  EventEmitter.prototype.many = function(event, ttl, fn) {
    return this._many(event, ttl, fn, false);
  }

  EventEmitter.prototype.prependMany = function(event, ttl, fn) {
    return this._many(event, ttl, fn, true);
  }

  EventEmitter.prototype._many = function(event, ttl, fn, prepend) {
    var self = this;

    if (typeof fn !== 'function') {
      throw new Error('many only accepts instances of Function');
    }

    function listener() {
      if (--ttl === 0) {
        self.off(event, listener);
      }
      return fn.apply(this, arguments);
    }

    listener._origin = fn;

    this._on(event, listener, prepend);

    return self;
  };

  EventEmitter.prototype.emit = function() {

    this._events || init.call(this);

    var type = arguments[0];

    if (type === 'newListener' && !this.newListener) {
      if (!this._events.newListener) {
        return false;
      }
    }

    var al = arguments.length;
    var args,l,i,j;
    var handler;

    if (this._all && this._all.length) {
      handler = this._all.slice();
      if (al > 3) {
        args = new Array(al);
        for (j = 0; j < al; j++) args[j] = arguments[j];
      }

      for (i = 0, l = handler.length; i < l; i++) {
        this.event = type;
        switch (al) {
        case 1:
          handler[i].call(this, type);
          break;
        case 2:
          handler[i].call(this, type, arguments[1]);
          break;
        case 3:
          handler[i].call(this, type, arguments[1], arguments[2]);
          break;
        default:
          handler[i].apply(this, args);
        }
      }
    }

    if (this.wildcard) {
      handler = [];
      var ns = typeof type === 'string' ? type.split(this.delimiter) : type.slice();
      searchListenerTree.call(this, handler, ns, this.listenerTree, 0);
    } else {
      handler = this._events[type];
      if (typeof handler === 'function') {
        this.event = type;
        switch (al) {
        case 1:
          handler.call(this);
          break;
        case 2:
          handler.call(this, arguments[1]);
          break;
        case 3:
          handler.call(this, arguments[1], arguments[2]);
          break;
        default:
          args = new Array(al - 1);
          for (j = 1; j < al; j++) args[j - 1] = arguments[j];
          handler.apply(this, args);
        }
        return true;
      } else if (handler) {
        // need to make copy of handlers because list can change in the middle
        // of emit call
        handler = handler.slice();
      }
    }

    if (handler && handler.length) {
      if (al > 3) {
        args = new Array(al - 1);
        for (j = 1; j < al; j++) args[j - 1] = arguments[j];
      }
      for (i = 0, l = handler.length; i < l; i++) {
        this.event = type;
        switch (al) {
        case 1:
          handler[i].call(this);
          break;
        case 2:
          handler[i].call(this, arguments[1]);
          break;
        case 3:
          handler[i].call(this, arguments[1], arguments[2]);
          break;
        default:
          handler[i].apply(this, args);
        }
      }
      return true;
    } else if (!this._all && type === 'error') {
      if (arguments[1] instanceof Error) {
        throw arguments[1]; // Unhandled 'error' event
      } else {
        throw new Error("Uncaught, unspecified 'error' event.");
      }
      return false;
    }

    return !!this._all;
  };

  EventEmitter.prototype.emitAsync = function() {

    this._events || init.call(this);

    var type = arguments[0];

    if (type === 'newListener' && !this.newListener) {
        if (!this._events.newListener) { return Promise.resolve([false]); }
    }

    var promises= [];

    var al = arguments.length;
    var args,l,i,j;
    var handler;

    if (this._all) {
      if (al > 3) {
        args = new Array(al);
        for (j = 1; j < al; j++) args[j] = arguments[j];
      }
      for (i = 0, l = this._all.length; i < l; i++) {
        this.event = type;
        switch (al) {
        case 1:
          promises.push(this._all[i].call(this, type));
          break;
        case 2:
          promises.push(this._all[i].call(this, type, arguments[1]));
          break;
        case 3:
          promises.push(this._all[i].call(this, type, arguments[1], arguments[2]));
          break;
        default:
          promises.push(this._all[i].apply(this, args));
        }
      }
    }

    if (this.wildcard) {
      handler = [];
      var ns = typeof type === 'string' ? type.split(this.delimiter) : type.slice();
      searchListenerTree.call(this, handler, ns, this.listenerTree, 0);
    } else {
      handler = this._events[type];
    }

    if (typeof handler === 'function') {
      this.event = type;
      switch (al) {
      case 1:
        promises.push(handler.call(this));
        break;
      case 2:
        promises.push(handler.call(this, arguments[1]));
        break;
      case 3:
        promises.push(handler.call(this, arguments[1], arguments[2]));
        break;
      default:
        args = new Array(al - 1);
        for (j = 1; j < al; j++) args[j - 1] = arguments[j];
        promises.push(handler.apply(this, args));
      }
    } else if (handler && handler.length) {
      handler = handler.slice();
      if (al > 3) {
        args = new Array(al - 1);
        for (j = 1; j < al; j++) args[j - 1] = arguments[j];
      }
      for (i = 0, l = handler.length; i < l; i++) {
        this.event = type;
        switch (al) {
        case 1:
          promises.push(handler[i].call(this));
          break;
        case 2:
          promises.push(handler[i].call(this, arguments[1]));
          break;
        case 3:
          promises.push(handler[i].call(this, arguments[1], arguments[2]));
          break;
        default:
          promises.push(handler[i].apply(this, args));
        }
      }
    } else if (!this._all && type === 'error') {
      if (arguments[1] instanceof Error) {
        return Promise.reject(arguments[1]); // Unhandled 'error' event
      } else {
        return Promise.reject("Uncaught, unspecified 'error' event.");
      }
    }

    return Promise.all(promises);
  };

  EventEmitter.prototype.on = function(type, listener) {
    return this._on(type, listener, false);
  };

  EventEmitter.prototype.prependListener = function(type, listener) {
    return this._on(type, listener, true);
  };

  EventEmitter.prototype.onAny = function(fn) {
    return this._onAny(fn, false);
  };

  EventEmitter.prototype.prependAny = function(fn) {
    return this._onAny(fn, true);
  };

  EventEmitter.prototype.addListener = EventEmitter.prototype.on;

  EventEmitter.prototype._onAny = function(fn, prepend){
    if (typeof fn !== 'function') {
      throw new Error('onAny only accepts instances of Function');
    }

    if (!this._all) {
      this._all = [];
    }

    // Add the function to the event listener collection.
    if(prepend){
      this._all.unshift(fn);
    }else{
      this._all.push(fn);
    }

    return this;
  }

  EventEmitter.prototype._on = function(type, listener, prepend) {
    if (typeof type === 'function') {
      this._onAny(type, listener);
      return this;
    }

    if (typeof listener !== 'function') {
      throw new Error('on only accepts instances of Function');
    }
    this._events || init.call(this);

    // To avoid recursion in the case that type == "newListeners"! Before
    // adding it to the listeners, first emit "newListeners".
    this.emit('newListener', type, listener);

    if (this.wildcard) {
      growListenerTree.call(this, type, listener);
      return this;
    }

    if (!this._events[type]) {
      // Optimize the case of one listener. Don't need the extra array object.
      this._events[type] = listener;
    }
    else {
      if (typeof this._events[type] === 'function') {
        // Change to array.
        this._events[type] = [this._events[type]];
      }

      // If we've already got an array, just add
      if(prepend){
        this._events[type].unshift(listener);
      }else{
        this._events[type].push(listener);
      }

      // Check for listener leak
      if (
        !this._events[type].warned &&
        this._maxListeners > 0 &&
        this._events[type].length > this._maxListeners
      ) {
        this._events[type].warned = true;
        logPossibleMemoryLeak.call(this, this._events[type].length, type);
      }
    }

    return this;
  }

  EventEmitter.prototype.off = function(type, listener) {
    if (typeof listener !== 'function') {
      throw new Error('removeListener only takes instances of Function');
    }

    var handlers,leafs=[];

    if(this.wildcard) {
      var ns = typeof type === 'string' ? type.split(this.delimiter) : type.slice();
      leafs = searchListenerTree.call(this, null, ns, this.listenerTree, 0);
    }
    else {
      // does not use listeners(), so no side effect of creating _events[type]
      if (!this._events[type]) return this;
      handlers = this._events[type];
      leafs.push({_listeners:handlers});
    }

    for (var iLeaf=0; iLeaf<leafs.length; iLeaf++) {
      var leaf = leafs[iLeaf];
      handlers = leaf._listeners;
      if (isArray(handlers)) {

        var position = -1;

        for (var i = 0, length = handlers.length; i < length; i++) {
          if (handlers[i] === listener ||
            (handlers[i].listener && handlers[i].listener === listener) ||
            (handlers[i]._origin && handlers[i]._origin === listener)) {
            position = i;
            break;
          }
        }

        if (position < 0) {
          continue;
        }

        if(this.wildcard) {
          leaf._listeners.splice(position, 1);
        }
        else {
          this._events[type].splice(position, 1);
        }

        if (handlers.length === 0) {
          if(this.wildcard) {
            delete leaf._listeners;
          }
          else {
            delete this._events[type];
          }
        }

        this.emit("removeListener", type, listener);

        return this;
      }
      else if (handlers === listener ||
        (handlers.listener && handlers.listener === listener) ||
        (handlers._origin && handlers._origin === listener)) {
        if(this.wildcard) {
          delete leaf._listeners;
        }
        else {
          delete this._events[type];
        }

        this.emit("removeListener", type, listener);
      }
    }

    function recursivelyGarbageCollect(root) {
      if (root === undefined) {
        return;
      }
      var keys = Object.keys(root);
      for (var i in keys) {
        var key = keys[i];
        var obj = root[key];
        if ((obj instanceof Function) || (typeof obj !== "object") || (obj === null))
          continue;
        if (Object.keys(obj).length > 0) {
          recursivelyGarbageCollect(root[key]);
        }
        if (Object.keys(obj).length === 0) {
          delete root[key];
        }
      }
    }
    recursivelyGarbageCollect(this.listenerTree);

    return this;
  };

  EventEmitter.prototype.offAny = function(fn) {
    var i = 0, l = 0, fns;
    if (fn && this._all && this._all.length > 0) {
      fns = this._all;
      for(i = 0, l = fns.length; i < l; i++) {
        if(fn === fns[i]) {
          fns.splice(i, 1);
          this.emit("removeListenerAny", fn);
          return this;
        }
      }
    } else {
      fns = this._all;
      for(i = 0, l = fns.length; i < l; i++)
        this.emit("removeListenerAny", fns[i]);
      this._all = [];
    }
    return this;
  };

  EventEmitter.prototype.removeListener = EventEmitter.prototype.off;

  EventEmitter.prototype.removeAllListeners = function(type) {
    if (arguments.length === 0) {
      !this._events || init.call(this);
      return this;
    }

    if (this.wildcard) {
      var ns = typeof type === 'string' ? type.split(this.delimiter) : type.slice();
      var leafs = searchListenerTree.call(this, null, ns, this.listenerTree, 0);

      for (var iLeaf=0; iLeaf<leafs.length; iLeaf++) {
        var leaf = leafs[iLeaf];
        leaf._listeners = null;
      }
    }
    else if (this._events) {
      this._events[type] = null;
    }
    return this;
  };

  EventEmitter.prototype.listeners = function(type) {
    if (this.wildcard) {
      var handlers = [];
      var ns = typeof type === 'string' ? type.split(this.delimiter) : type.slice();
      searchListenerTree.call(this, handlers, ns, this.listenerTree, 0);
      return handlers;
    }

    this._events || init.call(this);

    if (!this._events[type]) this._events[type] = [];
    if (!isArray(this._events[type])) {
      this._events[type] = [this._events[type]];
    }
    return this._events[type];
  };

  EventEmitter.prototype.eventNames = function(){
    return Object.keys(this._events);
  }

  EventEmitter.prototype.listenerCount = function(type) {
    return this.listeners(type).length;
  };

  EventEmitter.prototype.listenersAny = function() {

    if(this._all) {
      return this._all;
    }
    else {
      return [];
    }

  };

  if (true) {
     // AMD. Register as an anonymous module.
    !(__WEBPACK_AMD_DEFINE_RESULT__ = (function() {
      return EventEmitter;
    }).call(exports, __webpack_require__, exports, module),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else {}
}();

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(22)))

/***/ }),
/* 64 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DynamicConfig", function() { return DynamicConfig; });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65);

// Reference: https://github.com/statsig-io/js-lite/blob/main/src/DynamicConfig.ts
class DynamicConfig {
  static fromExperiment(experiment) {
    var _experiment$__evaluat, _experiment$groupName;
    const config = new DynamicConfig(experiment.name, experiment.value, experiment.ruleID, Object(_utils__WEBPACK_IMPORTED_MODULE_0__["migrateEvaluationDetails"])(experiment.details), (_experiment$__evaluat = experiment.__evaluation) === null || _experiment$__evaluat === void 0 ? void 0 : _experiment$__evaluat.secondary_exposures, (_experiment$groupName = experiment.groupName) !== null && _experiment$groupName !== void 0 ? _experiment$groupName : undefined);
    config.experiment = experiment;
    return config;
  }
  constructor(configName, configValue, ruleID, evaluationDetails, secondaryExposures = [], allocatedExperimentName = '', onDefaultValueFallback = null) {
    this.value = configValue;
    this._name = configName;
    this._ruleID = ruleID;
    this._secondaryExposures = secondaryExposures;
    this._allocatedExperimentName = allocatedExperimentName;
    this._evaluationDetails = evaluationDetails;
    this._onDefaultValueFallback = onDefaultValueFallback;
  }
  get(key, defaultValue, typeGuard) {
    var _this$_onDefaultValue2;
    const val = this.getValue(key, defaultValue);
    if (val == null) {
      return defaultValue;
    }
    const expectedType = Array.isArray(defaultValue) ? 'array' : typeof defaultValue;
    const actualType = Array.isArray(val) ? 'array' : typeof val;
    if (typeGuard) {
      var _this$_onDefaultValue;
      if (typeGuard(val)) {
        this.fireExposure(key);
        return val;
      }
      (_this$_onDefaultValue = this._onDefaultValueFallback) === null || _this$_onDefaultValue === void 0 ? void 0 : _this$_onDefaultValue.call(this, this, key, expectedType, actualType);
      return defaultValue;
    }
    if (defaultValue == null || expectedType === actualType) {
      this.fireExposure(key);
      return val;
    }
    (_this$_onDefaultValue2 = this._onDefaultValueFallback) === null || _this$_onDefaultValue2 === void 0 ? void 0 : _this$_onDefaultValue2.call(this, this, key, expectedType, actualType);
    return defaultValue;
  }
  getValue(key, defaultValue) {
    if (key == null) {
      return this.value;
    }
    if (defaultValue == null) {
      defaultValue = null;
    }
    if (this.value[key] == null) {
      return defaultValue;
    }
    this.fireExposure(key);
    return this.value[key];
  }
  fireExposure(key) {
    // Call the wrapped experiment's get method to fire exposure
    if (this.experiment) {
      this.experiment.get(key);
    }
  }
}

/***/ }),
/* 65 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getOptionsWithDefaults", function() { return getOptionsWithDefaults; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "shallowEquals", function() { return shallowEquals; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "toStatsigUser", function() { return toStatsigUser; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "migrateInitializationOptions", function() { return migrateInitializationOptions; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "migrateEvaluationDetails", function() { return migrateEvaluationDetails; });
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7);
/* harmony import */ var _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _statsig_js_client__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9);
/* harmony import */ var _statsig_js_client__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_statsig_js_client__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _atlaskit_atlassian_context__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(66);
/* harmony import */ var _compat_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(78);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(79);


const _excluded = ["api", "disableCurrentPageLogging", "loggingIntervalMillis", "loggingBufferMaxSize", "localMode", "eventLoggingApi", "eventLoggingApiForRetries", "disableLocalStorage", "ignoreWindowUndefined", "disableAllLogging", "initTimeoutMs", "disableNetworkKeepalive", "overrideStableID", "disableErrorLogging", "disableAutoMetricsLogging"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_1___default()(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }




const getOptionsWithDefaults = options => _objectSpread({
  /**
   * If more federal PerimeterTypes are added in the future, this should be updated so
   * that isFedRamp() === true always returns the strictest perimeter.
   */
  perimeter: Object(_atlaskit_atlassian_context__WEBPACK_IMPORTED_MODULE_3__["isFedRamp"])() ? _types__WEBPACK_IMPORTED_MODULE_5__["PerimeterType"].FEDRAMP_MODERATE : _types__WEBPACK_IMPORTED_MODULE_5__["PerimeterType"].COMMERCIAL
}, options);
const shallowEquals = (objectA, objectB) => {
  if (!objectA && !objectB) {
    return true;
  }
  if (!objectA || !objectB) {
    return false;
  }
  const aEntries = Object.entries(objectA);
  const bEntries = Object.entries(objectB);
  if (aEntries.length !== bEntries.length) {
    return false;
  }
  const ascendingKeyOrder = ([key1], [key2]) => key1.localeCompare(key2);
  aEntries.sort(ascendingKeyOrder);
  bEntries.sort(ascendingKeyOrder);
  for (let i = 0; i < aEntries.length; i++) {
    const [, aValue] = aEntries[i];
    const [, bValue] = bEntries[i];
    if (aValue !== bValue) {
      return false;
    }
  }
  return true;
};

/**
 * This method creates an instance of StatsigUser from the given set of identifiers and
 * attributes.
 */
const toStatsigUser = (identifiers, customAttributes, sdkKey) => {
  const user = {
    customIDs: !(customAttributes !== null && customAttributes !== void 0 && customAttributes.stableID) && sdkKey ? _objectSpread({
      stableID: _statsig_js_client__WEBPACK_IMPORTED_MODULE_2__["StableID"].get(sdkKey)
    }, identifiers) : identifiers,
    custom: customAttributes
  };
  if (identifiers.atlassianAccountId) {
    user.userID = identifiers.atlassianAccountId;
  }
  return user;
};
const migrateInitializationOptions = options => {
  const {
      api,
      disableCurrentPageLogging,
      loggingIntervalMillis,
      loggingBufferMaxSize,
      localMode,
      eventLoggingApi,
      eventLoggingApiForRetries,
      disableLocalStorage,
      ignoreWindowUndefined,
      disableAllLogging,
      // No equivalent but is pointless anyway since our Statsig init is synchronous
      initTimeoutMs: _initTimeoutMs,
      // No equivalent in new client but probably not important?
      disableNetworkKeepalive: _disableNetworkKeepalive,
      // Needs to be implemented manually but unused according to zoekt
      overrideStableID: _overrideStableID,
      // No equivalent for these but can't see them actually used anywhere in old client?
      disableErrorLogging: _disableErrorLogging,
      disableAutoMetricsLogging: _disableAutoMetricsLogging
    } = options,
    rest = _babel_runtime_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_0___default()(options, _excluded);
  return _objectSpread(_objectSpread({}, rest), {}, {
    networkConfig: {
      api,
      logEventUrl: eventLoggingApi ? eventLoggingApi + 'rgstr' : undefined,
      logEventFallbackUrls: eventLoggingApiForRetries ? [eventLoggingApiForRetries] : undefined,
      preventAllNetworkTraffic: localMode || !ignoreWindowUndefined && typeof window === 'undefined'
    },
    includeCurrentPageUrlWithEvents: !disableCurrentPageLogging,
    loggingIntervalMs: loggingIntervalMillis,
    loggingBufferMaxSize,
    disableStorage: disableLocalStorage === undefined ? localMode : disableLocalStorage,
    disableLogging: disableAllLogging === undefined ? localMode : disableAllLogging
  });
};
const evaluationReasonMappings = Object.entries(_compat_types__WEBPACK_IMPORTED_MODULE_4__["EvaluationReason"]).map(([key, value]) => [key.toLowerCase(), value]);
const migrateEvaluationDetails = details => {
  var _evaluationReasonMapp, _evaluationReasonMapp2, _details$receivedAt;
  const reasonLower = details.reason.toLowerCase();
  return {
    reason: (_evaluationReasonMapp = (_evaluationReasonMapp2 = evaluationReasonMappings.find(([key]) => reasonLower.includes(key))) === null || _evaluationReasonMapp2 === void 0 ? void 0 : _evaluationReasonMapp2[1]) !== null && _evaluationReasonMapp !== void 0 ? _evaluationReasonMapp : _compat_types__WEBPACK_IMPORTED_MODULE_4__["EvaluationReason"].Unknown,
    time: (_details$receivedAt = details.receivedAt) !== null && _details$receivedAt !== void 0 ? _details$receivedAt : Date.now()
  };
};

/***/ }),
/* 66 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _services_is_fedramp__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isFedRamp", function() { return _services_is_fedramp__WEBPACK_IMPORTED_MODULE_0__["isFedRamp"]; });

/* harmony import */ var _services_domain_lookup__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(69);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getATLContextUrl", function() { return _services_domain_lookup__WEBPACK_IMPORTED_MODULE_1__["getATLContextUrl"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getATLContextDomain", function() { return _services_domain_lookup__WEBPACK_IMPORTED_MODULE_1__["getATLContextDomain"]; });




/***/ }),
/* 67 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isFedRamp", function() { return isFedRamp; });
/* harmony import */ var _common_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(68);


/**
 * Caution: Consider Alternatives Use of this function is not recommended as a long term solution, as it creates an assumption
 * there are no other isolated environments than just FedRAMP Moderate. You are encouraged to consider alternate solutions,
 * such as Statsig or environment configuration, that don’t require creating a hard dependency between your code features
 * and the FedRAMP environment.
 * See [go-is-fedramp](https://go.atlassian.com/is-fedramp)
 */
function isFedRamp() {
  var _global$location;
  var global = globalThis;
  // MICROS_PERIMETER is already used by few products, so we need to keep it for backward compatibility
  var env = global.MICROS_PERIMETER || global.UNSAFE_ATL_CONTEXT_BOUNDARY;
  if (env) {
    return env === _common_constants__WEBPACK_IMPORTED_MODULE_0__["FEDRAMP_MODERATE"];
  }
  var matches = (_global$location = global.location) === null || _global$location === void 0 || (_global$location = _global$location.hostname) === null || _global$location === void 0 ? void 0 : _global$location.match(/atlassian-us-gov-mod\.(com|net)|atlassian-us-gov\.(com|net)|atlassian-fex\.(com|net)|atlassian-stg-fedm\.(com|net)/);
  return matches ? matches.length > 0 : false;
}

/***/ }),
/* 68 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FEDRAMP_MODERATE", function() { return FEDRAMP_MODERATE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "COMMERCIAL", function() { return COMMERCIAL; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FEDRAMP_FEDEX", function() { return FEDRAMP_FEDEX; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "STAGING", function() { return STAGING; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PRODUCTION", function() { return PRODUCTION; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DEV", function() { return DEV; });
var FEDRAMP_MODERATE = 'fedramp-moderate';
var COMMERCIAL = 'commercial';
var FEDRAMP_FEDEX = 'fedramp-fedex';
var STAGING = 'stg';
var PRODUCTION = 'prod';
var DEV = 'dev';

/***/ }),
/* 69 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "configure", function() { return configure; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getATLContextDomain", function() { return getATLContextDomain; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getATLContextUrl", function() { return getATLContextUrl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_getEnvironmentFromDomain", function() { return _getEnvironmentFromDomain; });
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(70);
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _common_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(68);
/* harmony import */ var _common_constants_domains__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(76);
/* harmony import */ var _common_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(77);




function configure(data) {
  if (!data || Object.keys(data).length < 1) {
    throw new Error('Data are not available');
  }

  // @ts-ignore - This is causing ts errors when this package is being enrolled into jira local consumption so temporarily ts ignoring this line for now
  globalThis.ATL_CONTEXT_DOMAIN = data;
}
function isValidDomainKey(domainKey) {
  if (!_common_types__WEBPACK_IMPORTED_MODULE_3__["AllowedDomains"].includes(domainKey)) {
    return false;
  }
  return true;
}
function getATLContextDomain(domain, environment) {
  var _domainMap$perimeter$, _domainMap$perimeter, _subdomainOverride$do;
  // Validate this is a valid domain
  if (!isValidDomainKey(domain)) {
    throw new Error("Domain ".concat(domain, " is not supported.\n      Supported domains: ").concat(_common_types__WEBPACK_IMPORTED_MODULE_3__["AllowedDomains"].join(', ')));
  }

  // First priority, always return the global context if the product has onboarded
  // @ts-ignore - This is causing ts errors when this package is being enrolled into jira local consumption so temporarily ts ignoring this line for now
  var data = globalThis.ATL_CONTEXT_DOMAIN;
  if (data) {
    return data[domain];
  }
  var _ref = environment !== null && environment !== void 0 ? environment : _getEnvironmentFromDomain(),
    _ref2 = _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0___default()(_ref, 2),
    env = _ref2[0],
    perimeter = _ref2[1];

  // Second priority, return if there is a full domain override
  var override = _common_constants_domains__WEBPACK_IMPORTED_MODULE_2__["fullDomainOverride"][domain];
  if (override) {
    var _override$perimeter$e, _override$perimeter;
    return (
      // Exact match preferred
      (_override$perimeter$e = (_override$perimeter = override[perimeter]) === null || _override$perimeter === void 0 ? void 0 : _override$perimeter[env]) !== null && _override$perimeter$e !== void 0 ? _override$perimeter$e :
      // Fallback to mandatory commercial production
      override[_common_constants__WEBPACK_IMPORTED_MODULE_1__["COMMERCIAL"]][_common_constants__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"]]
    );
  }

  // Third priority, join the subdomain
  var tld = (_domainMap$perimeter$ = (_domainMap$perimeter = _common_constants_domains__WEBPACK_IMPORTED_MODULE_2__["domainMap"][perimeter]) === null || _domainMap$perimeter === void 0 ? void 0 : _domainMap$perimeter[env]) !== null && _domainMap$perimeter$ !== void 0 ? _domainMap$perimeter$ : _common_constants_domains__WEBPACK_IMPORTED_MODULE_2__["domainMap"][_common_constants__WEBPACK_IMPORTED_MODULE_1__["COMMERCIAL"]][_common_constants__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"]];
  var subdomain = (_subdomainOverride$do = _common_constants_domains__WEBPACK_IMPORTED_MODULE_2__["subdomainOverride"][domain]) !== null && _subdomainOverride$do !== void 0 ? _subdomainOverride$do : domain;
  return "".concat(subdomain, ".").concat(tld);
}
function getATLContextUrl(domain) {
  return "".concat(globalThis.location.protocol, "//").concat(getATLContextDomain(domain));
}
function _getEnvironmentFromDomain() {
  var _globalThis$location;
  var hostname = (_globalThis$location = globalThis.location) === null || _globalThis$location === void 0 ? void 0 : _globalThis$location.hostname;
  if (!hostname) {
    // default if no location available
    return [_common_constants__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"], _common_constants__WEBPACK_IMPORTED_MODULE_1__["COMMERCIAL"]];
  }

  // *.atlassian-fex.com
  if (hostname.match(/atlassian-fex\.com/)) {
    return [_common_constants__WEBPACK_IMPORTED_MODULE_1__["STAGING"], _common_constants__WEBPACK_IMPORTED_MODULE_1__["FEDRAMP_FEDEX"]];
  }

  // *.stg.atlassian-us-gov-mod.com OR *.stg.atlassian-us-gov-mod.net
  if (hostname.match(/stg\.atlassian-us-gov-mod\.(com|net)/)) {
    return [_common_constants__WEBPACK_IMPORTED_MODULE_1__["STAGING"], _common_constants__WEBPACK_IMPORTED_MODULE_1__["FEDRAMP_MODERATE"]];
  }

  // *.atlassian-stg-fedm.net
  if (hostname.match(/atlassian-stg-fedm\.net/)) {
    return [_common_constants__WEBPACK_IMPORTED_MODULE_1__["STAGING"], _common_constants__WEBPACK_IMPORTED_MODULE_1__["FEDRAMP_MODERATE"]];
  }

  // *.atlassian-us-gov-mod.com OR *.atlassian-us-gov-mod.net
  if (hostname.match(/atlassian-us-gov-mod\.(com|net)/)) {
    return [_common_constants__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"], _common_constants__WEBPACK_IMPORTED_MODULE_1__["FEDRAMP_MODERATE"]];
  }

  // *.stg.atlassian.com OR *.stg.internal.atlassian.com
  if (hostname.match(/stg(\.internal)?\.atlassian\.com/)) {
    return [_common_constants__WEBPACK_IMPORTED_MODULE_1__["STAGING"], _common_constants__WEBPACK_IMPORTED_MODULE_1__["COMMERCIAL"]];
  }

  // *.jira-dev.com
  if (hostname.match(/jira-dev\.com/)) {
    return [_common_constants__WEBPACK_IMPORTED_MODULE_1__["STAGING"], _common_constants__WEBPACK_IMPORTED_MODULE_1__["COMMERCIAL"]];
  }

  // default fallthrough
  return [_common_constants__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"], _common_constants__WEBPACK_IMPORTED_MODULE_1__["COMMERCIAL"]];
}

/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

var arrayWithHoles = __webpack_require__(71);
var iterableToArrayLimit = __webpack_require__(72);
var unsupportedIterableToArray = __webpack_require__(73);
var nonIterableRest = __webpack_require__(75);
function _slicedToArray(r, e) {
  return arrayWithHoles(r) || iterableToArrayLimit(r, e) || unsupportedIterableToArray(r, e) || nonIterableRest();
}
module.exports = _slicedToArray, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),
/* 71 */
/***/ (function(module, exports) {

function _arrayWithHoles(r) {
  if (Array.isArray(r)) return r;
}
module.exports = _arrayWithHoles, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),
/* 72 */
/***/ (function(module, exports) {

function _iterableToArrayLimit(r, l) {
  var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"];
  if (null != t) {
    var e,
      n,
      i,
      u,
      a = [],
      f = !0,
      o = !1;
    try {
      if (i = (t = t.call(r)).next, 0 === l) {
        if (Object(t) !== t) return;
        f = !1;
      } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0);
    } catch (r) {
      o = !0, n = r;
    } finally {
      try {
        if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return;
      } finally {
        if (o) throw n;
      }
    }
    return a;
  }
}
module.exports = _iterableToArrayLimit, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

var arrayLikeToArray = __webpack_require__(74);
function _unsupportedIterableToArray(r, a) {
  if (r) {
    if ("string" == typeof r) return arrayLikeToArray(r, a);
    var t = {}.toString.call(r).slice(8, -1);
    return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? arrayLikeToArray(r, a) : void 0;
  }
}
module.exports = _unsupportedIterableToArray, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),
/* 74 */
/***/ (function(module, exports) {

function _arrayLikeToArray(r, a) {
  (null == a || a > r.length) && (a = r.length);
  for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
  return n;
}
module.exports = _arrayLikeToArray, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),
/* 75 */
/***/ (function(module, exports) {

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
module.exports = _nonIterableRest, module.exports.__esModule = true, module.exports["default"] = module.exports;

/***/ }),
/* 76 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "domainMap", function() { return domainMap; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "subdomainOverride", function() { return subdomainOverride; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fullDomainOverride", function() { return fullDomainOverride; });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _index__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(68);


/**
 * Creates a mapping from perimeter to environment to domain, allowing simply substitutions
 * to minimize the amount of data we have to ship to the browser.
 */
var domainMap = _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["COMMERCIAL"], _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["STAGING"], 'stg.atlassian.com'), _index__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"], 'atlassian.com')), _index__WEBPACK_IMPORTED_MODULE_1__["FEDRAMP_FEDEX"], _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["STAGING"], 'atlassian-fex.com')), _index__WEBPACK_IMPORTED_MODULE_1__["FEDRAMP_MODERATE"], _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["STAGING"], 'stg.atlassian-us-gov-mod.com'), _index__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"], 'atlassian-us-gov-mod.com'));

// Contains overrides for subdomains where the DomainKey is different from the subdomain
var subdomainOverride = {};

/**
 * Contains overrides for domains where the pattern of subdomain only doesn't work.
 * Useful in situations where this is a global domain that won't vary per environment.
 * Priority is exact match > fallback to commercial production
 *
 * IF YOU ADD SOMETHING HERE YOU MUST EXPLICITLY ADD EVERY PERIMETER AND EVERY ENVIRONMENT
 * ANYTHING NOT SET EXPLICITLY WILL DEFEAULT TO COMMERCIAL/PRODUCTION
 */
var fullDomainOverride = {
  analytics: _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["COMMERCIAL"], _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"], 'analytics.atlassian.com')),
  // Marketing site
  confluence: _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["COMMERCIAL"], _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"], 'confluence.atlassian.com')),
  // Atlassian design system documentation
  design: _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["COMMERCIAL"], _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"], 'design.atlassian.com')),
  // Old staff intranet (now hello.atlassian.net)
  extranet: _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["COMMERCIAL"], _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"], 'extranet.atlassian.com')),
  // Go links
  go: _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["COMMERCIAL"], _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"], 'go.atlassian.com')),
  my: _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["COMMERCIAL"], _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"], 'my.atlassian.com')),
  schema: _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["COMMERCIAL"], _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"], 'schema.atlassian.com')),
  start: _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["COMMERCIAL"], _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"], 'start.atlassian.com'), _index__WEBPACK_IMPORTED_MODULE_1__["STAGING"], 'start.stg.atlassian.com')), _index__WEBPACK_IMPORTED_MODULE_1__["FEDRAMP_MODERATE"], _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"], 'start.atlassian-us-gov-mod.com'), _index__WEBPACK_IMPORTED_MODULE_1__["STAGING"], 'start.stg.atlassian-us-gov-mod.com')),
  surveys: _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["COMMERCIAL"], _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"], 'surveys.atlassian.com')),
  'wac-cdn': _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["COMMERCIAL"], _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"], 'wac-cdn.atlassian.com')),
  integrations: _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["COMMERCIAL"], _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"], 'integrations.atlassian.com')),
  permalink: _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["COMMERCIAL"], _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"], 'permalink.atlassian.com')),
  id: _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["COMMERCIAL"], _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"], 'id.atlassian.com'), _index__WEBPACK_IMPORTED_MODULE_1__["STAGING"], 'id.stg.internal.atlassian.com'), _index__WEBPACK_IMPORTED_MODULE_1__["DEV"], 'id.dev.internal.atlassian.com')), _index__WEBPACK_IMPORTED_MODULE_1__["FEDRAMP_MODERATE"], _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"], 'id.atlassian-us-gov-mod.com'), _index__WEBPACK_IMPORTED_MODULE_1__["STAGING"], 'id.stg.atlassian-us-gov-mod.com')),
  support: _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["COMMERCIAL"], _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()({}, _index__WEBPACK_IMPORTED_MODULE_1__["PRODUCTION"], 'support.atlassian.com'))
};

/***/ }),
/* 77 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AllowedDomains", function() { return AllowedDomains; });
/* *NOTE*: please ensure any changes made to Perimeter and DomainKey type is copied in typings/atl-context.globals.d.ts */

var AllowedDomains = ['admin', 'analytics', 'api', 'api.media', 'api-private', 'as', 'atl-global', 'atlaskit', 'auth', 'automation', 'cassi.internal', 'cc-import-sources.services', 'confluence', 'confluence-chats-integr.services', 'confluence-cloud-bamboo.internal', 'confluence-questions.services', 'data-portal.internal', 'design', 'developer', 'extranet', 'go', 'id', 'id-mail-assets', 'integrations', 'ja', 'jira', 'jsd-widget', 'jsd-widget-staging', 'marketplace', 'my', 'my-reminders.services', 'partners', 'permalink', 'permalink.stg', 'schema', 'start', 'support', 'surveys', 'team', 'wac-cdn', 'xxid', 'home'];
// List of SubDomains: https://hello.atlassian.net/wiki/spaces/FEDRAMP/pages/2567950844/List+of+SubDomains

/***/ }),
/* 78 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EvaluationReason", function() { return EvaluationReason; });
// Reference: https://github.com/statsig-io/js-lite/blob/main/src/StatsigStore.ts

let EvaluationReason = /*#__PURE__*/function (EvaluationReason) {
  EvaluationReason["Error"] = "Error";
  EvaluationReason["LocalOverride"] = "LocalOverride";
  EvaluationReason["Unrecognized"] = "Unrecognized";
  EvaluationReason["Uninitialized"] = "Uninitialized";
  EvaluationReason["NetworkNotModified"] = "NetworkNotModified";
  EvaluationReason["Network"] = "Network";
  EvaluationReason["InvalidBootstrap"] = "InvalidBootstrap";
  EvaluationReason["Bootstrap"] = "Bootstrap";
  EvaluationReason["Cache"] = "Cache";
  EvaluationReason["Unknown"] = "Unknown";
  return EvaluationReason;
}({});

// Reference: https://github.com/statsig-io/js-lite/blob/main/src/StatsigSDKOptions.ts

/***/ }),
/* 79 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FeatureGateEnvironment", function() { return FeatureGateEnvironment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PerimeterType", function() { return PerimeterType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "NON_BOOLEAN_VALUE", function() { return NON_BOOLEAN_VALUE; });
/**
 * The identifiers for the user. Options are restricted to the set that is currently supported.
 */

/**
 * Base client options. Does not include any options specific to providers
 * @interface BaseClientOptions
 * @property {FeatureGateEnvironment} environment - The environment for the client.
 * @property {string} targetApp - The target app for the client.
 * @property {AnalyticsWebClient} analyticsWebClient - The analytics web client.
 * @property {PerimeterType} perimeter - The perimeter for the client.
 */

/**
 * The options for the client.
 * @interface ClientOptions
 * @extends {BaseClientOptions}
 * @property {string} apiKey - The API key for the client.
 * @property {fetchTimeoutMs} fetchTimeoutMs - The timeout for the fetch request in milliseconds. Defaults to 5000.
 * @property {boolean} useGatewayURL - Whether to use the gateway URL. Defaults to false.
 */

/**
 * The custom attributes for the user.
 */

let FeatureGateEnvironment = /*#__PURE__*/function (FeatureGateEnvironment) {
  FeatureGateEnvironment["Development"] = "development";
  FeatureGateEnvironment["Staging"] = "staging";
  FeatureGateEnvironment["Production"] = "production";
  return FeatureGateEnvironment;
}({});

// If adding new values here, please check FeatureGates.getDefaultPerimeter to make sure it still returns something sensible.
let PerimeterType = /*#__PURE__*/function (PerimeterType) {
  PerimeterType["COMMERCIAL"] = "commercial";
  PerimeterType["FEDRAMP_MODERATE"] = "fedramp-moderate";
  return PerimeterType;
}({});
const NON_BOOLEAN_VALUE = 'non_boolean';

// Type magic to get the JSDoc comments from the Client class methods to appear on the static
// methods in FeatureGates where the property name and function type are identical

/***/ }),
/* 80 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Layer", function() { return Layer; });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65);

// Reference: https://github.com/statsig-io/js-lite/blob/main/src/Layer.ts
class Layer {
  static fromLayer(layer) {
    var _layer$__evaluation, _layer$__evaluation2, _layer$__evaluation3, _layer$__evaluation4;
    const value = new Layer(layer.name, layer.__value, layer.ruleID, Object(_utils__WEBPACK_IMPORTED_MODULE_0__["migrateEvaluationDetails"])(layer.details), (_layer, parameterName) => layer.get(parameterName), (_layer$__evaluation = layer.__evaluation) === null || _layer$__evaluation === void 0 ? void 0 : _layer$__evaluation.secondary_exposures, (_layer$__evaluation2 = layer.__evaluation) === null || _layer$__evaluation2 === void 0 ? void 0 : _layer$__evaluation2.undelegated_secondary_exposures, (_layer$__evaluation3 = layer.__evaluation) === null || _layer$__evaluation3 === void 0 ? void 0 : _layer$__evaluation3.allocated_experiment_name, (_layer$__evaluation4 = layer.__evaluation) === null || _layer$__evaluation4 === void 0 ? void 0 : _layer$__evaluation4.explicit_parameters);
    return value;
  }
  constructor(name, layerValue, ruleID, evaluationDetails, logParameterFunction = null, secondaryExposures = [], undelegatedSecondaryExposures = [], allocatedExperimentName = '', explicitParameters = []) {
    this._logParameterFunction = logParameterFunction;
    this._name = name;
    this._value = JSON.parse(JSON.stringify(layerValue !== null && layerValue !== void 0 ? layerValue : {}));
    this._ruleID = ruleID !== null && ruleID !== void 0 ? ruleID : '';
    this._evaluationDetails = evaluationDetails;
    this._secondaryExposures = secondaryExposures;
    this._undelegatedSecondaryExposures = undelegatedSecondaryExposures;
    this._allocatedExperimentName = allocatedExperimentName;
    this._explicitParameters = explicitParameters;
  }
  get(key, defaultValue, typeGuard) {
    const val = this._value[key];
    if (val == null) {
      return defaultValue;
    }
    const logAndReturn = () => {
      this._logLayerParameterExposure(key);
      return val;
    };
    if (typeGuard) {
      return typeGuard(val) ? logAndReturn() : defaultValue;
    }
    if (defaultValue == null) {
      return logAndReturn();
    }
    if (typeof val === typeof defaultValue && Array.isArray(defaultValue) === Array.isArray(val)) {
      return logAndReturn();
    }
    return defaultValue;
  }
  getValue(key, defaultValue) {
    // eslint-disable-next-line eqeqeq
    if (defaultValue == undefined) {
      defaultValue = null;
    }
    const val = this._value[key];
    if (val != null) {
      this._logLayerParameterExposure(key);
    }
    return val !== null && val !== void 0 ? val : defaultValue;
  }
  _logLayerParameterExposure(parameterName) {
    var _this$_logParameterFu;
    (_this$_logParameterFu = this._logParameterFunction) === null || _this$_logParameterFu === void 0 ? void 0 : _this$_logParameterFu.call(this, this, parameterName);
  }
}

/***/ }),
/* 81 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Fetcher__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82);
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "default", function() { return _Fetcher__WEBPACK_IMPORTED_MODULE_0__["default"]; });



/***/ }),
/* 82 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PROD_BASE_URL", function() { return PROD_BASE_URL; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "STAGING_BASE_URL", function() { return STAGING_BASE_URL; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DEV_BASE_URL", function() { return DEV_BASE_URL; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FEDM_STAGING_BASE_URL", function() { return FEDM_STAGING_BASE_URL; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FEDM_PROD_BASE_URL", function() { return FEDM_PROD_BASE_URL; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GATEWAY_BASE_URL", function() { return GATEWAY_BASE_URL; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return Fetcher; });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(79);
/* harmony import */ var _version__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(83);
/* harmony import */ var _errors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(84);

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }



const DEFAULT_REQUEST_TIMEOUT_MS = 5000;
const PROD_BASE_URL = 'https://api.atlassian.com/flags';
const STAGING_BASE_URL = 'https://api.stg.atlassian.com/flags';
const DEV_BASE_URL = 'https://api.dev.atlassian.com/flags';
const FEDM_STAGING_BASE_URL = 'https://api.stg.atlassian-us-gov-mod.com/flags';
const FEDM_PROD_BASE_URL = 'https://api.atlassian-us-gov-mod.com/flags';
const GATEWAY_BASE_URL = '/gateway/api/flags';
class Fetcher {
  static async fetchClientSdk(fetcherOptions) {
    const {
      targetApp
    } = fetcherOptions;
    const url = `/api/v2/frontend/clientSdkKey/${targetApp}`;
    try {
      return await this.fetchRequest(url, 'GET', fetcherOptions);
    } catch (error) {
      if (error instanceof Error) {
        throw error;
      }
      throw Error('Failed to retrieve client sdk key');
    }
  }
  static async fetchExperimentValues(fetcherOptions, identifiers, customAttributes) {
    const requestBody = {
      identifiers,
      customAttributes,
      targetApp: fetcherOptions.targetApp
    };
    try {
      return await this.fetchRequest('/api/v2/frontend/experimentValues', 'POST', fetcherOptions, requestBody);
    } catch (error) {
      if (error instanceof Error) {
        throw error;
      }
      throw Error('Failed to retrieve experiment values');
    }
  }
  static async handleResponseError(response) {
    if (!response.ok) {
      // Use text() instead of json() as the error body might not be json data
      const body = await response.text();
      throw new _errors__WEBPACK_IMPORTED_MODULE_3__["ResponseError"](`Non 2xx response status received, status: ${response.status}, body: ${JSON.stringify(body)}`);
    }
    if (response.status === 204) {
      throw new _errors__WEBPACK_IMPORTED_MODULE_3__["ResponseError"]('Unexpected 204 response');
    }
  }
  static async extractResponseBody(response) {
    const value = await response.text();
    return JSON.parse(value);
  }
  static getBaseUrl(serviceEnv, useGatewayUrl = false, perimeter) {
    if (useGatewayUrl) {
      return GATEWAY_BASE_URL;
    }
    if (perimeter === _types__WEBPACK_IMPORTED_MODULE_1__["PerimeterType"].FEDRAMP_MODERATE) {
      switch (serviceEnv) {
        case _types__WEBPACK_IMPORTED_MODULE_1__["FeatureGateEnvironment"].Production:
          return FEDM_PROD_BASE_URL;
        case _types__WEBPACK_IMPORTED_MODULE_1__["FeatureGateEnvironment"].Staging:
          return FEDM_STAGING_BASE_URL;
        default:
          throw new Error(`Invalid environment "${serviceEnv}" for "${perimeter}" perimeter`);
      }
    } else if (perimeter === _types__WEBPACK_IMPORTED_MODULE_1__["PerimeterType"].COMMERCIAL) {
      switch (serviceEnv) {
        case _types__WEBPACK_IMPORTED_MODULE_1__["FeatureGateEnvironment"].Development:
          return DEV_BASE_URL;
        case _types__WEBPACK_IMPORTED_MODULE_1__["FeatureGateEnvironment"].Staging:
          return STAGING_BASE_URL;
        default:
          return PROD_BASE_URL;
      }
    } else {
      throw new Error(`Invalid perimeter "${perimeter}"`);
    }
  }
  static async fetchRequest(path, method, fetcherOptions, body) {
    const baseUrl = Fetcher.getBaseUrl(fetcherOptions.environment, fetcherOptions.useGatewayURL, fetcherOptions.perimeter);
    const fetchTimeout = fetcherOptions.fetchTimeoutMs || DEFAULT_REQUEST_TIMEOUT_MS;
    let abortSignal;
    if (AbortSignal.timeout) {
      abortSignal = AbortSignal.timeout(fetchTimeout);
    } else if (AbortController) {
      const abortController = new AbortController();
      abortSignal = abortController.signal;
      setTimeout(() => abortController.abort(), fetchTimeout);
    }
    const response = await fetch(`${baseUrl}${path}`, _objectSpread({
      method,
      headers: {
        'Content-Type': 'application/json',
        'X-Client-Name': 'feature-gate-js-client',
        'X-Client-Version': _version__WEBPACK_IMPORTED_MODULE_2__["CLIENT_VERSION"],
        'X-API-KEY': fetcherOptions.apiKey
      },
      signal: abortSignal
    }, body && {
      body: JSON.stringify(body)
    }));
    await this.handleResponseError(response);
    return await this.extractResponseBody(response);
  }
}

/***/ }),
/* 83 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CLIENT_VERSION", function() { return CLIENT_VERSION; });
/// <reference types="node" />
const CLIENT_VERSION = "4.26.5";

/***/ }),
/* 84 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ResponseError", function() { return ResponseError; });
class ResponseError extends Error {
  constructor(message) {
    super(message);
  }
}

/***/ }),
/* 85 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "NoFetchDataAdapter", function() { return NoFetchDataAdapter; });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _statsig_js_client__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9);
/* harmony import */ var _statsig_js_client__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_statsig_js_client__WEBPACK_IMPORTED_MODULE_1__);

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }


/**
 * Data adapter which only uses bootstrap data and will never fetch from network or cache.
 * We do this because we control the fetching of bootstrap data from FFS in Client.ts whereas the
 * default data adapter fetches from Statsig servers.
 */
class NoFetchDataAdapter extends _statsig_js_client__WEBPACK_IMPORTED_MODULE_1__["DataAdapterCore"] {
  constructor() {
    super('NoFetchDataAdapter', 'nofetch');
    _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(this, "bootstrapResult", null);
  }

  /**
   * Make sure to call this **before** calling `initializeAsync` or `updateUserAsync` but
   * after the Statsig client has been created!
   */
  setBootstrapData(data) {
    this.bootstrapResult = data ? {
      source: 'Bootstrap',
      data: JSON.stringify(data),
      receivedAt: Date.now(),
      stableID: _statsig_js_client__WEBPACK_IMPORTED_MODULE_1__["StableID"].get(this._getSdkKey()),
      fullUserHash: null
    } : null;
  }
  async prefetchData(_user, _options) {}
  async getDataAsync(_current, user, _options) {
    return this.bootstrapResult && _objectSpread(_objectSpread({}, this.bootstrapResult), {}, {
      fullUserHash: Object(_statsig_js_client__WEBPACK_IMPORTED_MODULE_1__["_getFullUserHash"])(user)
    });
  }
  getDataSync(user) {
    return this.bootstrapResult && _objectSpread(_objectSpread({}, this.bootstrapResult), {}, {
      fullUserHash: Object(_statsig_js_client__WEBPACK_IMPORTED_MODULE_1__["_getFullUserHash"])(user)
    });
  }
  async _fetchFromNetwork(_current, _user, _options) {
    return null;
  }
  _getCacheKey(user) {
    // Same logic as default data adapter
    // https://github.com/statsig-io/js-client-monorepo/blob/main/packages/js-client/src/StatsigEvaluationsDataAdapter.ts
    const key = Object(_statsig_js_client__WEBPACK_IMPORTED_MODULE_1__["_getStorageKey"])(this._getSdkKey(), user);
    return `${_statsig_js_client__WEBPACK_IMPORTED_MODULE_1__["DataAdapterCachePrefix"]}.${this._cacheSuffix}.${key}`;
  }
  _isCachedResultValidFor204(_result, _user) {
    return false;
  }
  setDataLegacy(data, user) {
    super.setData(data, user);
  }

  // Do not stringify options property since that includes this adapter and will
  // cause a circular reference when Statsig sends diagnostic events and including
  // values is not necessary and makes the result huge
  toJSON() {
    const result = _objectSpread({}, this);
    delete result._options;
    delete result._inMemoryCache;
    delete result.bootstrapResult;
    return result;
  }
}

/***/ }),
/* 86 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LOCAL_STORAGE_KEY", function() { return LOCAL_STORAGE_KEY; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PersistentOverrideAdapter", function() { return PersistentOverrideAdapter; });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2);
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _statsig_client_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11);
/* harmony import */ var _statsig_client_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_statsig_client_core__WEBPACK_IMPORTED_MODULE_1__);

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }

const LOCAL_OVERRIDE_REASON = 'LocalOverride:Recognized';
const LOCAL_STORAGE_KEY = 'STATSIG_OVERRIDES';
const LEGACY_LOCAL_STORAGE_KEY = 'STATSIG_JS_LITE_LOCAL_OVERRIDES';
const makeEmptyStore = () => ({
  gates: {},
  configs: {},
  layers: {}
});
const djb2MapKey = (hash, kind) => kind + ':' + hash;

/**
 * Custom implementation of `@statsig/js-local-overrides` package with support for local storage
 * so we can keep the existing behavior where overrides are cached locally. Also designed for
 * compatibility with the old override system (eg. no `experiments` field, `configs` is used
 * instead).
 *
 * [Reference](https://github.com/statsig-io/js-client-monorepo/blob/main/packages/js-local-overrides/src/LocalOverrideAdapter.ts)
 */
class PersistentOverrideAdapter {
  constructor(localStorageKey) {
    this._overrides = makeEmptyStore();
    this._djb2Map = new Map();
    this._localStorageKey = localStorageKey;
  }
  parseStoredOverrides(localStorageKey) {
    try {
      const json = window.localStorage.getItem(localStorageKey);
      if (!json) {
        return makeEmptyStore();
      }
      return JSON.parse(json);
    } catch (_unused) {
      return makeEmptyStore();
    }
  }
  mergeOverrides(...allOverrides) {
    const merged = makeEmptyStore();
    for (const overrides of allOverrides) {
      for (const [name, value] of Object.entries((_overrides$gates = overrides.gates) !== null && _overrides$gates !== void 0 ? _overrides$gates : {})) {
        var _overrides$gates;
        merged.gates[name] = value;
      }
      for (const [name, value] of Object.entries((_overrides$configs = overrides.configs) !== null && _overrides$configs !== void 0 ? _overrides$configs : {})) {
        var _overrides$configs;
        merged.configs[name] = value;
      }
      for (const [name, value] of Object.entries((_overrides$layers = overrides.layers) !== null && _overrides$layers !== void 0 ? _overrides$layers : {})) {
        var _overrides$layers;
        merged.layers[name] = value;
      }
    }
    return merged;
  }
  initFromStoredOverrides() {
    const storedOverrides = this.mergeOverrides(this._overrides, this.parseStoredOverrides(LEGACY_LOCAL_STORAGE_KEY), this.parseStoredOverrides(this._localStorageKey));

    // Clear data from legacy local storage key now we've read from it.
    // This prevents things being stuck in there that are always read but never written to.
    try {
      window.localStorage.removeItem(LEGACY_LOCAL_STORAGE_KEY);
    } catch (_unused2) {
      // ignored - window is not defined in non-browser environments, and we don't save things there
      // (things like SSR, etc)
    }

    // In version 4.24.0 we introduced hashes in this override adapter, but had a bug which would cause
    // multiple hashes to continue being created. This code here removes these hashes since we've moved
    // to using a more reliable and easier to maintain map in `_djb2Map`.
    for (const container of Object.values(storedOverrides)) {
      const allKeys = new Set(Object.keys(container));
      for (const name of allKeys) {
        const hash = Object(_statsig_client_core__WEBPACK_IMPORTED_MODULE_1__["_DJB2"])(name);
        if (allKeys.has(hash)) {
          delete container[hash];
        }
      }
    }
    this.applyOverrides(storedOverrides);
  }
  saveOverrides() {
    try {
      window.localStorage.setItem(this._localStorageKey, JSON.stringify(this._overrides));
    } catch (_unused3) {
      // ignored - window is not defined in non-browser environments, and we don't save things there
      // (things like SSR, etc)
    }
  }
  getOverrides() {
    return this.mergeOverrides(this._overrides);
  }
  applyOverrides(overrides) {
    const newOverrides = _objectSpread(_objectSpread({}, makeEmptyStore()), overrides);
    this._djb2Map.clear();
    for (const [containerName, container] of Object.entries(newOverrides)) {
      for (const [name, value] of Object.entries(container)) {
        this._djb2Map.set(djb2MapKey(Object(_statsig_client_core__WEBPACK_IMPORTED_MODULE_1__["_DJB2"])(name), containerName), value);
      }
    }
    this._overrides = newOverrides;
  }
  setOverrides(overrides) {
    this.applyOverrides(overrides);
    this.saveOverrides();
  }
  overrideGate(name, value) {
    this._overrides.gates[name] = value;
    this._djb2Map.set(djb2MapKey(Object(_statsig_client_core__WEBPACK_IMPORTED_MODULE_1__["_DJB2"])(name), 'gates'), value);
    this.saveOverrides();
  }
  removeGateOverride(name) {
    delete this._overrides.gates[name];
    this._djb2Map.delete(djb2MapKey(Object(_statsig_client_core__WEBPACK_IMPORTED_MODULE_1__["_DJB2"])(name), 'gates'));
    this.saveOverrides();
  }
  getGateOverride(current, _user) {
    var _this$_overrides$gate;
    const overridden = (_this$_overrides$gate = this._overrides.gates[current.name]) !== null && _this$_overrides$gate !== void 0 ? _this$_overrides$gate : this._djb2Map.get(djb2MapKey(current.name, 'gates'));
    if (overridden == null) {
      return null;
    }
    return _objectSpread(_objectSpread({}, current), {}, {
      value: overridden,
      details: _objectSpread(_objectSpread({}, current.details), {}, {
        reason: LOCAL_OVERRIDE_REASON
      })
    });
  }
  overrideDynamicConfig(name, value) {
    this._overrides.configs[name] = value;
    this._djb2Map.set(djb2MapKey(Object(_statsig_client_core__WEBPACK_IMPORTED_MODULE_1__["_DJB2"])(name), 'configs'), value);
    this.saveOverrides();
  }
  removeDynamicConfigOverride(name) {
    delete this._overrides.configs[name];
    this._djb2Map.delete(djb2MapKey(Object(_statsig_client_core__WEBPACK_IMPORTED_MODULE_1__["_DJB2"])(name), 'configs'));
    this.saveOverrides();
  }
  getDynamicConfigOverride(current, _user) {
    return this._getConfigOverride(current, this._overrides.configs);
  }
  overrideExperiment(name, value) {
    this._overrides.configs[name] = value;
    this._djb2Map.set(djb2MapKey(Object(_statsig_client_core__WEBPACK_IMPORTED_MODULE_1__["_DJB2"])(name), 'configs'), value);
    this.saveOverrides();
  }
  removeExperimentOverride(name) {
    delete this._overrides.configs[name];
    this._djb2Map.delete(djb2MapKey(Object(_statsig_client_core__WEBPACK_IMPORTED_MODULE_1__["_DJB2"])(name), 'configs'));
    this.saveOverrides();
  }
  getExperimentOverride(current, _user) {
    return this._getConfigOverride(current, this._overrides.configs);
  }
  overrideLayer(name, value) {
    this._overrides.layers[name] = value;
    this._djb2Map.set(djb2MapKey(Object(_statsig_client_core__WEBPACK_IMPORTED_MODULE_1__["_DJB2"])(name), 'layers'), value);
    this.saveOverrides();
  }
  removeLayerOverride(name) {
    delete this._overrides.layers[name];
    this._djb2Map.delete(djb2MapKey(Object(_statsig_client_core__WEBPACK_IMPORTED_MODULE_1__["_DJB2"])(name), 'layers'));
    this.saveOverrides();
  }
  removeAllOverrides() {
    this._overrides = makeEmptyStore();
    try {
      window.localStorage.removeItem(this._localStorageKey);
    } catch (_unused4) {
      // ignored - window is not defined in non-browser environments, and we don't save things there
      // (things like SSR, etc)
    }
  }
  getLayerOverride(current, _user) {
    var _this$_overrides$laye;
    const overridden = (_this$_overrides$laye = this._overrides.layers[current.name]) !== null && _this$_overrides$laye !== void 0 ? _this$_overrides$laye : this._djb2Map.get(djb2MapKey(current.name, 'layers'));
    if (overridden == null) {
      return null;
    }
    return _objectSpread(_objectSpread({}, current), {}, {
      __value: overridden,
      get: Object(_statsig_client_core__WEBPACK_IMPORTED_MODULE_1__["_makeTypedGet"])(current.name, overridden),
      details: _objectSpread(_objectSpread({}, current.details), {}, {
        reason: LOCAL_OVERRIDE_REASON
      })
    });
  }
  _getConfigOverride(current, lookup) {
    var _lookup$current$name;
    const overridden = (_lookup$current$name = lookup[current.name]) !== null && _lookup$current$name !== void 0 ? _lookup$current$name : this._djb2Map.get(djb2MapKey(current.name, 'configs'));
    if (overridden == null) {
      return null;
    }
    return _objectSpread(_objectSpread({}, current), {}, {
      value: overridden,
      get: Object(_statsig_client_core__WEBPACK_IMPORTED_MODULE_1__["_makeTypedGet"])(current.name, overridden),
      details: _objectSpread(_objectSpread({}, current.details), {}, {
        reason: LOCAL_OVERRIDE_REASON
      })
    });
  }
}

/***/ })
/******/ ])});;