/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryHttpClient;
import org.jfrog.build.client.ArtifactoryVersion;
import org.jfrog.build.client.ProxyConfiguration;

public abstract class ArtifactoryBaseClient
implements AutoCloseable {
    private static final String API_REPOSITORIES = "/api/repositories";
    protected String artifactoryUrl;
    protected ArtifactoryHttpClient httpClient;
    protected final Log log;
    private ArtifactoryVersion artifactoryVersion;

    public ArtifactoryBaseClient(String artifactoryUrl, String username, String password, String accessToken, Log logger) {
        this.artifactoryUrl = StringUtils.stripEnd(artifactoryUrl, "/");
        this.httpClient = StringUtils.isNotEmpty(accessToken) ? new ArtifactoryHttpClient(this.artifactoryUrl, accessToken, logger) : new ArtifactoryHttpClient(this.artifactoryUrl, username, password, logger);
        this.log = logger;
    }

    public ArtifactoryBaseClient(String artifactoryUrl, ArtifactoryHttpClient httpClient, Log logger) {
        this.artifactoryUrl = StringUtils.stripEnd(artifactoryUrl, "/");
        this.httpClient = httpClient;
        this.log = logger;
    }

    @Override
    public void close() {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.httpClient.setConnectionTimeout(connectionTimeout);
    }

    public void setConnectionRetries(int connectionRetries) {
        this.httpClient.setConnectionRetries(connectionRetries);
    }

    public void setProxyConfiguration(String host, int port) {
        this.httpClient.setProxyConfiguration(host, port, null, null);
    }

    public void setProxyConfiguration(String host, int port, String username, String password) {
        this.httpClient.setProxyConfiguration(host, port, username, password);
    }

    public void setProxyConfiguration(ProxyConfiguration proxy) {
        this.httpClient.setProxyConfiguration(proxy.host, proxy.port, proxy.username, proxy.password);
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.httpClient.getProxyConfiguration();
    }

    public void setLog(Log log) {
        this.httpClient.getHttpClient().setLog(log);
    }

    public void setInsecureTls(boolean insecureTls) {
        this.httpClient.setInsecureTls(insecureTls);
    }

    public String getArtifactoryUrl() {
        return this.artifactoryUrl;
    }

    public ArtifactoryVersion getArtifactoryVersion() {
        if (this.artifactoryVersion == null) {
            try {
                this.artifactoryVersion = this.httpClient.getVersion();
            }
            catch (IOException e) {
                this.artifactoryVersion = ArtifactoryVersion.NOT_FOUND;
            }
        }
        return this.artifactoryVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRepoExist(String repo) throws IOException {
        String fullItemUrl = this.artifactoryUrl + API_REPOSITORIES + "/" + repo;
        String encodedUrl = ArtifactoryHttpClient.encodeUrl(fullItemUrl);
        HttpGet httpRequest = new HttpGet(encodedUrl);
        HttpResponse httpResponse = null;
        try {
            httpResponse = this.httpClient.getHttpClient().execute(httpRequest);
            StatusLine statusLine = httpResponse.getStatusLine();
            if (statusLine.getStatusCode() == 400) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (httpResponse != null) {
                EntityUtils.consumeQuietly(httpResponse.getEntity());
            }
        }
        return true;
    }
}

