/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.config.spring;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ftpserver.FtpServerConfigurationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpringUtil {
    private SpringUtil() {
    }

    public static List<Element> getChildElements(Element elm) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList childs = elm.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = childs.item(i);
            if (!(child instanceof Element)) continue;
            elements.add((Element)child);
        }
        return elements;
    }

    public static Element getChildElement(Element parent, String ns, String localName) {
        List<Element> elements = SpringUtil.getChildElements(parent);
        for (Element element : elements) {
            if (ns != null && (!ns.equals(element.getNamespaceURI()) || localName != null && !localName.equals(element.getLocalName()))) continue;
            return element;
        }
        return null;
    }

    public static String getChildElementText(Element parent, String ns, String localName) {
        List<Element> elements = SpringUtil.getChildElements(parent);
        for (Element element : elements) {
            if (ns != null && (!ns.equals(element.getNamespaceURI()) || localName != null && !localName.equals(element.getLocalName()))) continue;
            return DomUtils.getTextValue((Element)element);
        }
        return null;
    }

    public static Object parseSpringChildElement(Element parent, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element springElm = SpringUtil.getChildElement(parent, null, null);
        String ln = springElm.getLocalName();
        if ("bean".equals(ln)) {
            return parserContext.getDelegate().parseBeanDefinitionElement(springElm, (BeanDefinition)builder.getBeanDefinition());
        }
        if ("ref".equals(ln)) {
            return parserContext.getDelegate().parsePropertySubElement(springElm, (BeanDefinition)builder.getBeanDefinition());
        }
        throw new FtpServerConfigurationException("Unknown spring element " + ln);
    }

    public static boolean parseBoolean(Element parent, String attrName, boolean defaultValue) {
        if (StringUtils.hasText((String)parent.getAttribute(attrName))) {
            return Boolean.parseBoolean(parent.getAttribute(attrName));
        }
        return defaultValue;
    }

    public static int parseInt(Element parent, String attrName) {
        return Integer.parseInt(parent.getAttribute(attrName));
    }

    public static int parseInt(Element parent, String attrName, int defaultValue) {
        if (StringUtils.hasText((String)parent.getAttribute(attrName))) {
            return Integer.parseInt(parent.getAttribute(attrName));
        }
        return defaultValue;
    }

    public static String parseString(Element parent, String attrName) {
        if (parent.hasAttribute(attrName)) {
            return parent.getAttribute(attrName);
        }
        return null;
    }

    public static File parseFile(Element parent, String attrName) {
        if (StringUtils.hasText((String)parent.getAttribute(attrName))) {
            return new File(parent.getAttribute(attrName));
        }
        return null;
    }

    public static InetAddress parseInetAddress(Element parent, String attrName) {
        if (StringUtils.hasText((String)parent.getAttribute(attrName))) {
            try {
                return InetAddress.getByName(parent.getAttribute(attrName));
            }
            catch (UnknownHostException e) {
                throw new FtpServerConfigurationException("Unknown host", e);
            }
        }
        return null;
    }

    public static String parseStringFromInetAddress(Element parent, String attrName) {
        if (SpringUtil.parseInetAddress(parent, attrName) != null) {
            return parent.getAttribute(attrName);
        }
        return null;
    }
}

