/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalLeeMoore2;

import com.sun.electric.tool.routing.experimentalLeeMoore2.BacktraceState;
import com.sun.electric.tool.routing.experimentalLeeMoore2.GlobalRouterV3;
import com.sun.electric.tool.routing.experimentalLeeMoore2.Vector2i;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

class GCanvas
extends Canvas {
    GlobalRouterV3 router;
    double scale = 0.5;
    public int seg_id;
    Vector2i cur_pos = new Vector2i(-1, -1);

    public GCanvas(GlobalRouterV3 router) {
        this.router = router;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int x = 0; x < this.router.regions_x; ++x) {
            for (int y = 0; y < this.router.regions_y; ++y) {
                Rectangle2D.Double rect = new Rectangle2D.Double();
                rect.setFrameFromDiagonal((double)x * this.router.region_width * this.scale, (double)y * this.router.region_height * this.scale, (double)(x + 1) * this.router.region_width * this.scale, (double)(y + 1) * this.router.region_height * this.scale);
                g2D.draw(rect);
                BacktraceState min2 = this.router.RegionAt((int)x, (int)y).segment_infos[this.seg_id].GetMin(Integer.MAX_VALUE);
                if (min2 == null) continue;
                float was_visited = this.router.RegionAt((int)x, (int)y).segment_infos[this.seg_id].was_part_of_bt ? 0.0f : 0.5f;
                was_visited = this.router.RegionAt((int)x, (int)y).segment_infos[this.seg_id].is_initialized ? was_visited : 0.0f;
                String sdir = "";
                switch (min2.dir) {
                    case rd_down: {
                        sdir = "D";
                        break;
                    }
                    case rd_up: {
                        sdir = "U";
                        break;
                    }
                    case rd_left: {
                        sdir = "L";
                        break;
                    }
                    case rd_right: {
                        sdir = "R";
                        break;
                    }
                    case rd_undefined: {
                        sdir = "nDef";
                    }
                }
                float cheap_path_factor = (float)min2.path_length / 15.0f;
                cheap_path_factor = cheap_path_factor > 1.0f ? 1.0f : cheap_path_factor;
                Color c = g2D.getColor();
                g2D.setColor(new Color(was_visited, 0.0f, cheap_path_factor));
                g2D.fill(rect);
                g2D.setColor(c);
                g2D.drawString(sdir, (int)((double)x * this.router.region_width * this.scale), (int)((double)y * this.router.region_height * this.scale + (double)g2D.getFont().getSize()));
            }
        }
        Rectangle2D.Double r = new Rectangle2D.Double();
        r.setFrameFromDiagonal((double)this.cur_pos.x * this.router.region_width * this.scale, (double)this.cur_pos.y * this.router.region_height * this.scale, (double)(this.cur_pos.x + 1) * this.router.region_width * this.scale, (double)(this.cur_pos.y + 1) * this.router.region_height * this.scale);
        Color tmp_c = g2D.getColor();
        g2D.setColor(Color.BLUE);
        g2D.draw(r);
        g2D.setColor(tmp_c);
    }

    public void drawArc(Graphics2D g2D, int x1, int y1, int x2, int y2, int sd, int rd, int cl) {
        Arc2D.Float arc1 = new Arc2D.Float(x1, y1, x2, y2, sd, rd, cl);
        g2D.fill(arc1);
    }

    public void drawEllipse(Graphics2D g2D, int x1, int y1, int x2, int y2) {
        Ellipse2D.Float oval1 = new Ellipse2D.Float(x1, y1, x2, y2);
        g2D.fill(oval1);
    }
}

