// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vmwareengine/v1/vmwareengine.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VMWAREENGINE_V1_VMWARE_ENGINE_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VMWAREENGINE_V1_VMWARE_ENGINE_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/vmwareengine/v1/vmwareengine.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace vmwareengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class VmwareEngineConnectionIdempotencyPolicy {
 public:
  virtual ~VmwareEngineConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<VmwareEngineConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency ListPrivateClouds(
      google::cloud::vmwareengine::v1::ListPrivateCloudsRequest request);

  virtual google::cloud::Idempotency GetPrivateCloud(
      google::cloud::vmwareengine::v1::GetPrivateCloudRequest const& request);

  virtual google::cloud::Idempotency CreatePrivateCloud(
      google::cloud::vmwareengine::v1::CreatePrivateCloudRequest const&
          request);

  virtual google::cloud::Idempotency UpdatePrivateCloud(
      google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest const&
          request);

  virtual google::cloud::Idempotency DeletePrivateCloud(
      google::cloud::vmwareengine::v1::DeletePrivateCloudRequest const&
          request);

  virtual google::cloud::Idempotency UndeletePrivateCloud(
      google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest const&
          request);

  virtual google::cloud::Idempotency ListClusters(
      google::cloud::vmwareengine::v1::ListClustersRequest request);

  virtual google::cloud::Idempotency GetCluster(
      google::cloud::vmwareengine::v1::GetClusterRequest const& request);

  virtual google::cloud::Idempotency CreateCluster(
      google::cloud::vmwareengine::v1::CreateClusterRequest const& request);

  virtual google::cloud::Idempotency UpdateCluster(
      google::cloud::vmwareengine::v1::UpdateClusterRequest const& request);

  virtual google::cloud::Idempotency DeleteCluster(
      google::cloud::vmwareengine::v1::DeleteClusterRequest const& request);

  virtual google::cloud::Idempotency ListSubnets(
      google::cloud::vmwareengine::v1::ListSubnetsRequest request);

  virtual google::cloud::Idempotency GetSubnet(
      google::cloud::vmwareengine::v1::GetSubnetRequest const& request);

  virtual google::cloud::Idempotency UpdateSubnet(
      google::cloud::vmwareengine::v1::UpdateSubnetRequest const& request);

  virtual google::cloud::Idempotency ListNodeTypes(
      google::cloud::vmwareengine::v1::ListNodeTypesRequest request);

  virtual google::cloud::Idempotency GetNodeType(
      google::cloud::vmwareengine::v1::GetNodeTypeRequest const& request);

  virtual google::cloud::Idempotency ShowNsxCredentials(
      google::cloud::vmwareengine::v1::ShowNsxCredentialsRequest const&
          request);

  virtual google::cloud::Idempotency ShowVcenterCredentials(
      google::cloud::vmwareengine::v1::ShowVcenterCredentialsRequest const&
          request);

  virtual google::cloud::Idempotency ResetNsxCredentials(
      google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest const&
          request);

  virtual google::cloud::Idempotency ResetVcenterCredentials(
      google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest const&
          request);

  virtual google::cloud::Idempotency CreateHcxActivationKey(
      google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest const&
          request);

  virtual google::cloud::Idempotency ListHcxActivationKeys(
      google::cloud::vmwareengine::v1::ListHcxActivationKeysRequest request);

  virtual google::cloud::Idempotency GetHcxActivationKey(
      google::cloud::vmwareengine::v1::GetHcxActivationKeyRequest const&
          request);

  virtual google::cloud::Idempotency GetNetworkPolicy(
      google::cloud::vmwareengine::v1::GetNetworkPolicyRequest const& request);

  virtual google::cloud::Idempotency ListNetworkPolicies(
      google::cloud::vmwareengine::v1::ListNetworkPoliciesRequest request);

  virtual google::cloud::Idempotency CreateNetworkPolicy(
      google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest const&
          request);

  virtual google::cloud::Idempotency UpdateNetworkPolicy(
      google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest const&
          request);

  virtual google::cloud::Idempotency DeleteNetworkPolicy(
      google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest const&
          request);

  virtual google::cloud::Idempotency CreateVmwareEngineNetwork(
      google::cloud::vmwareengine::v1::CreateVmwareEngineNetworkRequest const&
          request);

  virtual google::cloud::Idempotency UpdateVmwareEngineNetwork(
      google::cloud::vmwareengine::v1::UpdateVmwareEngineNetworkRequest const&
          request);

  virtual google::cloud::Idempotency DeleteVmwareEngineNetwork(
      google::cloud::vmwareengine::v1::DeleteVmwareEngineNetworkRequest const&
          request);

  virtual google::cloud::Idempotency GetVmwareEngineNetwork(
      google::cloud::vmwareengine::v1::GetVmwareEngineNetworkRequest const&
          request);

  virtual google::cloud::Idempotency ListVmwareEngineNetworks(
      google::cloud::vmwareengine::v1::ListVmwareEngineNetworksRequest request);

  virtual google::cloud::Idempotency CreatePrivateConnection(
      google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest const&
          request);

  virtual google::cloud::Idempotency GetPrivateConnection(
      google::cloud::vmwareengine::v1::GetPrivateConnectionRequest const&
          request);

  virtual google::cloud::Idempotency ListPrivateConnections(
      google::cloud::vmwareengine::v1::ListPrivateConnectionsRequest request);

  virtual google::cloud::Idempotency UpdatePrivateConnection(
      google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest const&
          request);

  virtual google::cloud::Idempotency DeletePrivateConnection(
      google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest const&
          request);

  virtual google::cloud::Idempotency ListPrivateConnectionPeeringRoutes(
      google::cloud::vmwareengine::v1::ListPrivateConnectionPeeringRoutesRequest
          request);
};

std::unique_ptr<VmwareEngineConnectionIdempotencyPolicy>
MakeDefaultVmwareEngineConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vmwareengine_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VMWAREENGINE_V1_VMWARE_ENGINE_CONNECTION_IDEMPOTENCY_POLICY_H
