// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/translate/v3/translation_service.proto

#include "google/cloud/translate/v3/translation_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace translate_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

TranslationServiceConnectionIdempotencyPolicy::
    ~TranslationServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<TranslationServiceConnectionIdempotencyPolicy>
TranslationServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<TranslationServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency TranslationServiceConnectionIdempotencyPolicy::TranslateText(
    google::cloud::translation::v3::TranslateTextRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TranslationServiceConnectionIdempotencyPolicy::DetectLanguage(
    google::cloud::translation::v3::DetectLanguageRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
TranslationServiceConnectionIdempotencyPolicy::GetSupportedLanguages(
    google::cloud::translation::v3::GetSupportedLanguagesRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TranslationServiceConnectionIdempotencyPolicy::TranslateDocument(
    google::cloud::translation::v3::TranslateDocumentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TranslationServiceConnectionIdempotencyPolicy::BatchTranslateText(
    google::cloud::translation::v3::BatchTranslateTextRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
TranslationServiceConnectionIdempotencyPolicy::BatchTranslateDocument(
    google::cloud::translation::v3::BatchTranslateDocumentRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TranslationServiceConnectionIdempotencyPolicy::CreateGlossary(
    google::cloud::translation::v3::CreateGlossaryRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency TranslationServiceConnectionIdempotencyPolicy::ListGlossaries(
    google::cloud::translation::v3::ListGlossariesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency TranslationServiceConnectionIdempotencyPolicy::GetGlossary(
    google::cloud::translation::v3::GetGlossaryRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency TranslationServiceConnectionIdempotencyPolicy::DeleteGlossary(
    google::cloud::translation::v3::DeleteGlossaryRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<TranslationServiceConnectionIdempotencyPolicy>
MakeDefaultTranslationServiceConnectionIdempotencyPolicy() {
  return std::make_unique<TranslationServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace translate_v3
}  // namespace cloud
}  // namespace google
