// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/run/v2/execution.proto

#include "google/cloud/run/v2/executions_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace run_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ExecutionsClient::ExecutionsClient(
    std::shared_ptr<ExecutionsConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
ExecutionsClient::~ExecutionsClient() = default;

StatusOr<google::cloud::run::v2::Execution> ExecutionsClient::GetExecution(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::run::v2::GetExecutionRequest request;
  request.set_name(name);
  return connection_->GetExecution(request);
}

StatusOr<google::cloud::run::v2::Execution> ExecutionsClient::GetExecution(
    google::cloud::run::v2::GetExecutionRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetExecution(request);
}

StreamRange<google::cloud::run::v2::Execution> ExecutionsClient::ListExecutions(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::run::v2::ListExecutionsRequest request;
  request.set_parent(parent);
  return connection_->ListExecutions(request);
}

StreamRange<google::cloud::run::v2::Execution> ExecutionsClient::ListExecutions(
    google::cloud::run::v2::ListExecutionsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListExecutions(std::move(request));
}

future<StatusOr<google::cloud::run::v2::Execution>>
ExecutionsClient::DeleteExecution(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::run::v2::DeleteExecutionRequest request;
  request.set_name(name);
  return connection_->DeleteExecution(request);
}

future<StatusOr<google::cloud::run::v2::Execution>>
ExecutionsClient::DeleteExecution(
    google::cloud::run::v2::DeleteExecutionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteExecution(request);
}

future<StatusOr<google::cloud::run::v2::Execution>>
ExecutionsClient::CancelExecution(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::run::v2::CancelExecutionRequest request;
  request.set_name(name);
  return connection_->CancelExecution(request);
}

future<StatusOr<google::cloud::run::v2::Execution>>
ExecutionsClient::CancelExecution(
    google::cloud::run::v2::CancelExecutionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CancelExecution(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace run_v2
}  // namespace cloud
}  // namespace google
