// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/tag_holds.proto

#include "google/cloud/resourcemanager/v3/tag_holds_connection.h"
#include "google/cloud/resourcemanager/v3/internal/tag_holds_connection_impl.h"
#include "google/cloud/resourcemanager/v3/internal/tag_holds_option_defaults.h"
#include "google/cloud/resourcemanager/v3/internal/tag_holds_stub_factory.h"
#include "google/cloud/resourcemanager/v3/internal/tag_holds_tracing_connection.h"
#include "google/cloud/resourcemanager/v3/tag_holds_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace resourcemanager_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TagHoldsConnection::~TagHoldsConnection() = default;

future<StatusOr<google::cloud::resourcemanager::v3::TagHold>>
TagHoldsConnection::CreateTagHold(
    google::cloud::resourcemanager::v3::CreateTagHoldRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::TagHold>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::resourcemanager::v3::DeleteTagHoldMetadata>>
TagHoldsConnection::DeleteTagHold(
    google::cloud::resourcemanager::v3::DeleteTagHoldRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::resourcemanager::v3::DeleteTagHoldMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::resourcemanager::v3::TagHold>
TagHoldsConnection::ListTagHolds(
    google::cloud::resourcemanager::v3::
        ListTagHoldsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::resourcemanager::v3::TagHold>>();
}

std::shared_ptr<TagHoldsConnection> MakeTagHoldsConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 TagHoldsPolicyOptionList>(options, __func__);
  options =
      resourcemanager_v3_internal::TagHoldsDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub = resourcemanager_v3_internal::CreateDefaultTagHoldsStub(
      background->cq(), options);
  return resourcemanager_v3_internal::MakeTagHoldsTracingConnection(
      std::make_shared<resourcemanager_v3_internal::TagHoldsConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_v3
}  // namespace cloud
}  // namespace google
