// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/document_service.proto

#include "google/cloud/discoveryengine/v1/internal/document_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace discoveryengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

DocumentServiceTracingConnection::DocumentServiceTracingConnection(
    std::shared_ptr<discoveryengine_v1::DocumentServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::discoveryengine::v1::Document>
DocumentServiceTracingConnection::GetDocument(
    google::cloud::discoveryengine::v1::GetDocumentRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::DocumentServiceConnection::GetDocument");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDocument(request));
}

StreamRange<google::cloud::discoveryengine::v1::Document>
DocumentServiceTracingConnection::ListDocuments(
    google::cloud::discoveryengine::v1::ListDocumentsRequest request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::DocumentServiceConnection::ListDocuments");
  internal::OTelScope scope(span);
  auto sr = child_->ListDocuments(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::discoveryengine::v1::Document>(std::move(span),
                                                    std::move(sr));
}

StatusOr<google::cloud::discoveryengine::v1::Document>
DocumentServiceTracingConnection::CreateDocument(
    google::cloud::discoveryengine::v1::CreateDocumentRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::DocumentServiceConnection::CreateDocument");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateDocument(request));
}

StatusOr<google::cloud::discoveryengine::v1::Document>
DocumentServiceTracingConnection::UpdateDocument(
    google::cloud::discoveryengine::v1::UpdateDocumentRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::DocumentServiceConnection::UpdateDocument");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateDocument(request));
}

Status DocumentServiceTracingConnection::DeleteDocument(
    google::cloud::discoveryengine::v1::DeleteDocumentRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::DocumentServiceConnection::DeleteDocument");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteDocument(request));
}

future<StatusOr<google::cloud::discoveryengine::v1::ImportDocumentsResponse>>
DocumentServiceTracingConnection::ImportDocuments(
    google::cloud::discoveryengine::v1::ImportDocumentsRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::DocumentServiceConnection::ImportDocuments");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ImportDocuments(request));
}

future<StatusOr<google::cloud::discoveryengine::v1::PurgeDocumentsResponse>>
DocumentServiceTracingConnection::PurgeDocuments(
    google::cloud::discoveryengine::v1::PurgeDocumentsRequest const& request) {
  auto span = internal::MakeSpan(
      "discoveryengine_v1::DocumentServiceConnection::PurgeDocuments");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->PurgeDocuments(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<discoveryengine_v1::DocumentServiceConnection>
MakeDocumentServiceTracingConnection(
    std::shared_ptr<discoveryengine_v1::DocumentServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<DocumentServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1_internal
}  // namespace cloud
}  // namespace google
