// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/knowledge_base.proto

#include "google/cloud/dialogflow_es/knowledge_bases_client.h"
#include <memory>

namespace google {
namespace cloud {
namespace dialogflow_es {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

KnowledgeBasesClient::KnowledgeBasesClient(
    std::shared_ptr<KnowledgeBasesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
KnowledgeBasesClient::~KnowledgeBasesClient() = default;

StreamRange<google::cloud::dialogflow::v2::KnowledgeBase>
KnowledgeBasesClient::ListKnowledgeBases(std::string const& parent,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::ListKnowledgeBasesRequest request;
  request.set_parent(parent);
  return connection_->ListKnowledgeBases(request);
}

StreamRange<google::cloud::dialogflow::v2::KnowledgeBase>
KnowledgeBasesClient::ListKnowledgeBases(
    google::cloud::dialogflow::v2::ListKnowledgeBasesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListKnowledgeBases(std::move(request));
}

StatusOr<google::cloud::dialogflow::v2::KnowledgeBase>
KnowledgeBasesClient::GetKnowledgeBase(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::GetKnowledgeBaseRequest request;
  request.set_name(name);
  return connection_->GetKnowledgeBase(request);
}

StatusOr<google::cloud::dialogflow::v2::KnowledgeBase>
KnowledgeBasesClient::GetKnowledgeBase(
    google::cloud::dialogflow::v2::GetKnowledgeBaseRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetKnowledgeBase(request);
}

StatusOr<google::cloud::dialogflow::v2::KnowledgeBase>
KnowledgeBasesClient::CreateKnowledgeBase(
    std::string const& parent,
    google::cloud::dialogflow::v2::KnowledgeBase const& knowledge_base,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::CreateKnowledgeBaseRequest request;
  request.set_parent(parent);
  *request.mutable_knowledge_base() = knowledge_base;
  return connection_->CreateKnowledgeBase(request);
}

StatusOr<google::cloud::dialogflow::v2::KnowledgeBase>
KnowledgeBasesClient::CreateKnowledgeBase(
    google::cloud::dialogflow::v2::CreateKnowledgeBaseRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateKnowledgeBase(request);
}

Status KnowledgeBasesClient::DeleteKnowledgeBase(std::string const& name,
                                                 Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::DeleteKnowledgeBaseRequest request;
  request.set_name(name);
  return connection_->DeleteKnowledgeBase(request);
}

Status KnowledgeBasesClient::DeleteKnowledgeBase(
    google::cloud::dialogflow::v2::DeleteKnowledgeBaseRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteKnowledgeBase(request);
}

StatusOr<google::cloud::dialogflow::v2::KnowledgeBase>
KnowledgeBasesClient::UpdateKnowledgeBase(
    google::cloud::dialogflow::v2::KnowledgeBase const& knowledge_base,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::v2::UpdateKnowledgeBaseRequest request;
  *request.mutable_knowledge_base() = knowledge_base;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateKnowledgeBase(request);
}

StatusOr<google::cloud::dialogflow::v2::KnowledgeBase>
KnowledgeBasesClient::UpdateKnowledgeBase(
    google::cloud::dialogflow::v2::UpdateKnowledgeBaseRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateKnowledgeBase(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es
}  // namespace cloud
}  // namespace google
