// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/region_disk_types/v1/region_disk_types.proto

#include "google/cloud/compute/region_disk_types/v1/internal/region_disk_types_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_region_disk_types_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

RegionDiskTypesTracingConnection::RegionDiskTypesTracingConnection(
    std::shared_ptr<compute_region_disk_types_v1::RegionDiskTypesConnection>
        child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::cpp::compute::v1::DiskType>
RegionDiskTypesTracingConnection::GetDiskType(
    google::cloud::cpp::compute::region_disk_types::v1::
        GetDiskTypeRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_region_disk_types_v1::RegionDiskTypesConnection::GetDiskType");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDiskType(request));
}

StreamRange<google::cloud::cpp::compute::v1::DiskType>
RegionDiskTypesTracingConnection::ListRegionDiskTypes(
    google::cloud::cpp::compute::region_disk_types::v1::
        ListRegionDiskTypesRequest request) {
  auto span = internal::MakeSpan(
      "compute_region_disk_types_v1::RegionDiskTypesConnection::"
      "ListRegionDiskTypes");
  internal::OTelScope scope(span);
  auto sr = child_->ListRegionDiskTypes(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::DiskType>(std::move(span),
                                                 std::move(sr));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_region_disk_types_v1::RegionDiskTypesConnection>
MakeRegionDiskTypesTracingConnection(
    std::shared_ptr<compute_region_disk_types_v1::RegionDiskTypesConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<RegionDiskTypesTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_region_disk_types_v1_internal
}  // namespace cloud
}  // namespace google
