// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/health_checks/v1/health_checks.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_HEALTH_CHECKS_V1_INTERNAL_HEALTH_CHECKS_REST_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_HEALTH_CHECKS_V1_INTERNAL_HEALTH_CHECKS_REST_CONNECTION_IMPL_H

#include "google/cloud/compute/health_checks/v1/health_checks_connection.h"
#include "google/cloud/compute/health_checks/v1/health_checks_connection_idempotency_policy.h"
#include "google/cloud/compute/health_checks/v1/health_checks_options.h"
#include "google/cloud/compute/health_checks/v1/internal/health_checks_rest_stub.h"
#include "google/cloud/compute/health_checks/v1/internal/health_checks_retry_traits.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/compute/global_operations/v1/global_operations.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace compute_health_checks_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class HealthChecksRestConnectionImpl
    : public compute_health_checks_v1::HealthChecksConnection {
 public:
  ~HealthChecksRestConnectionImpl() override = default;

  HealthChecksRestConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<compute_health_checks_v1_internal::HealthChecksRestStub>
          stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<std::pair<
      std::string, google::cloud::cpp::compute::v1::HealthChecksScopedList>>
  AggregatedListHealthChecks(
      google::cloud::cpp::compute::health_checks::v1::
          AggregatedListHealthChecksRequest request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteHealthCheck(google::cloud::cpp::compute::health_checks::v1::
                        DeleteHealthCheckRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::HealthCheck> GetHealthCheck(
      google::cloud::cpp::compute::health_checks::v1::
          GetHealthCheckRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertHealthCheck(google::cloud::cpp::compute::health_checks::v1::
                        InsertHealthCheckRequest const& request) override;

  StreamRange<google::cloud::cpp::compute::v1::HealthCheck> ListHealthChecks(
      google::cloud::cpp::compute::health_checks::v1::ListHealthChecksRequest
          request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> PatchHealthCheck(
      google::cloud::cpp::compute::health_checks::v1::
          PatchHealthCheckRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  UpdateHealthCheck(google::cloud::cpp::compute::health_checks::v1::
                        UpdateHealthCheckRequest const& request) override;

 private:
  static std::unique_ptr<compute_health_checks_v1::HealthChecksRetryPolicy>
  retry_policy(Options const& options) {
    return options
        .get<compute_health_checks_v1::HealthChecksRetryPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
    return options
        .get<compute_health_checks_v1::HealthChecksBackoffPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<
      compute_health_checks_v1::HealthChecksConnectionIdempotencyPolicy>
  idempotency_policy(Options const& options) {
    return options
        .get<compute_health_checks_v1::
                 HealthChecksConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  static std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
    return options
        .get<compute_health_checks_v1::HealthChecksPollingPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<compute_health_checks_v1_internal::HealthChecksRestStub>
      stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_health_checks_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_HEALTH_CHECKS_V1_INTERNAL_HEALTH_CHECKS_REST_CONNECTION_IMPL_H
