// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/global_addresses/v1/global_addresses.proto

#include "google/cloud/compute/global_addresses/v1/internal/global_addresses_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_global_addresses_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

GlobalAddressesTracingConnection::GlobalAddressesTracingConnection(
    std::shared_ptr<compute_global_addresses_v1::GlobalAddressesConnection>
        child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalAddressesTracingConnection::DeleteAddress(
    google::cloud::cpp::compute::global_addresses::v1::
        DeleteAddressRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_global_addresses_v1::GlobalAddressesConnection::DeleteAddress");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteAddress(request));
}

StatusOr<google::cloud::cpp::compute::v1::Address>
GlobalAddressesTracingConnection::GetAddress(
    google::cloud::cpp::compute::global_addresses::v1::GetAddressRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_global_addresses_v1::GlobalAddressesConnection::GetAddress");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetAddress(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalAddressesTracingConnection::InsertAddress(
    google::cloud::cpp::compute::global_addresses::v1::
        InsertAddressRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_global_addresses_v1::GlobalAddressesConnection::InsertAddress");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->InsertAddress(request));
}

StreamRange<google::cloud::cpp::compute::v1::Address>
GlobalAddressesTracingConnection::ListGlobalAddresses(
    google::cloud::cpp::compute::global_addresses::v1::
        ListGlobalAddressesRequest request) {
  auto span = internal::MakeSpan(
      "compute_global_addresses_v1::GlobalAddressesConnection::"
      "ListGlobalAddresses");
  internal::OTelScope scope(span);
  auto sr = child_->ListGlobalAddresses(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::Address>(std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalAddressesTracingConnection::Move(
    google::cloud::cpp::compute::global_addresses::v1::MoveRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_global_addresses_v1::GlobalAddressesConnection::Move");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->Move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
GlobalAddressesTracingConnection::SetLabels(
    google::cloud::cpp::compute::global_addresses::v1::SetLabelsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "compute_global_addresses_v1::GlobalAddressesConnection::SetLabels");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->SetLabels(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_global_addresses_v1::GlobalAddressesConnection>
MakeGlobalAddressesTracingConnection(
    std::shared_ptr<compute_global_addresses_v1::GlobalAddressesConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<GlobalAddressesTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_global_addresses_v1_internal
}  // namespace cloud
}  // namespace google
