// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/automl/v1/prediction_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AUTOML_V1_PREDICTION_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AUTOML_V1_PREDICTION_CLIENT_H

#include "google/cloud/automl/v1/prediction_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace automl_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// AutoML Prediction API.
///
/// On any input that is documented to expect a string parameter in
/// snake_case or dash-case, either of those cases is accepted.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class PredictionServiceClient {
 public:
  explicit PredictionServiceClient(
      std::shared_ptr<PredictionServiceConnection> connection,
      Options opts = {});
  ~PredictionServiceClient();

  ///@{
  /// @name Copy and move support
  PredictionServiceClient(PredictionServiceClient const&) = default;
  PredictionServiceClient& operator=(PredictionServiceClient const&) = default;
  PredictionServiceClient(PredictionServiceClient&&) = default;
  PredictionServiceClient& operator=(PredictionServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(PredictionServiceClient const& a,
                         PredictionServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(PredictionServiceClient const& a,
                         PredictionServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Perform an online prediction. The prediction result is directly
  /// returned in the response.
  /// Available for following ML scenarios, and their expected request payloads:
  ///
  /// AutoML Vision Classification
  ///
  /// * An image in .JPEG, .GIF or .PNG format, image_bytes up to 30MB.
  ///
  /// AutoML Vision Object Detection
  ///
  /// * An image in .JPEG, .GIF or .PNG format, image_bytes up to 30MB.
  ///
  /// AutoML Natural Language Classification
  ///
  /// * A TextSnippet up to 60,000 characters, UTF-8 encoded or a document in
  /// .PDF, .TIF or .TIFF format with size upto 2MB.
  ///
  /// AutoML Natural Language Entity Extraction
  ///
  /// * A TextSnippet up to 10,000 characters, UTF-8 NFC encoded or a document
  ///  in .PDF, .TIF or .TIFF format with size upto 20MB.
  ///
  /// AutoML Natural Language Sentiment Analysis
  ///
  /// * A TextSnippet up to 60,000 characters, UTF-8 encoded or a document in
  /// .PDF, .TIF or .TIFF format with size upto 2MB.
  ///
  /// AutoML Translation
  ///
  /// * A TextSnippet up to 25,000 characters, UTF-8 encoded.
  ///
  /// AutoML Tables
  ///
  /// * A row with column values matching
  ///   the columns of the model, up to 5MB. Not available for FORECASTING
  ///   `prediction_type`.
  ///
  /// @param name  Required. Name of the model requested to serve the prediction.
  /// @param payload  Required. Payload to perform a prediction on. The payload must match the
  ///  problem type that the model was trained to solve.
  /// @param params  Additional domain-specific parameters, any string must be up to 25000
  ///  characters long.
  ///  @n
  ///  For more information, see [PredictRequest][google.cloud.automl.v1.PredictRequest].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.automl.v1.PredictResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.automl.v1.PredictRequest]: @googleapis_reference_link{google/cloud/automl/v1/prediction_service.proto#L117}
  /// [google.cloud.automl.v1.PredictResponse]: @googleapis_reference_link{google/cloud/automl/v1/prediction_service.proto#L164}
  ///
  // clang-format on
  StatusOr<google::cloud::automl::v1::PredictResponse> Predict(
      std::string const& name,
      google::cloud::automl::v1::ExamplePayload const& payload,
      std::map<std::string, std::string> const& params, Options opts = {});

  // clang-format off
  ///
  /// Perform an online prediction. The prediction result is directly
  /// returned in the response.
  /// Available for following ML scenarios, and their expected request payloads:
  ///
  /// AutoML Vision Classification
  ///
  /// * An image in .JPEG, .GIF or .PNG format, image_bytes up to 30MB.
  ///
  /// AutoML Vision Object Detection
  ///
  /// * An image in .JPEG, .GIF or .PNG format, image_bytes up to 30MB.
  ///
  /// AutoML Natural Language Classification
  ///
  /// * A TextSnippet up to 60,000 characters, UTF-8 encoded or a document in
  /// .PDF, .TIF or .TIFF format with size upto 2MB.
  ///
  /// AutoML Natural Language Entity Extraction
  ///
  /// * A TextSnippet up to 10,000 characters, UTF-8 NFC encoded or a document
  ///  in .PDF, .TIF or .TIFF format with size upto 20MB.
  ///
  /// AutoML Natural Language Sentiment Analysis
  ///
  /// * A TextSnippet up to 60,000 characters, UTF-8 encoded or a document in
  /// .PDF, .TIF or .TIFF format with size upto 2MB.
  ///
  /// AutoML Translation
  ///
  /// * A TextSnippet up to 25,000 characters, UTF-8 encoded.
  ///
  /// AutoML Tables
  ///
  /// * A row with column values matching
  ///   the columns of the model, up to 5MB. Not available for FORECASTING
  ///   `prediction_type`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.automl.v1.PredictRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.automl.v1.PredictResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.automl.v1.PredictRequest]: @googleapis_reference_link{google/cloud/automl/v1/prediction_service.proto#L117}
  /// [google.cloud.automl.v1.PredictResponse]: @googleapis_reference_link{google/cloud/automl/v1/prediction_service.proto#L164}
  ///
  // clang-format on
  StatusOr<google::cloud::automl::v1::PredictResponse> Predict(
      google::cloud::automl::v1::PredictRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Perform a batch prediction. Unlike the online [Predict][google.cloud.automl.v1.PredictionService.Predict], batch
  /// prediction result won't be immediately available in the response. Instead,
  /// a long running operation object is returned. User can poll the operation
  /// result via [GetOperation][google.longrunning.Operations.GetOperation]
  /// method. Once the operation is done, [BatchPredictResult][google.cloud.automl.v1.BatchPredictResult] is returned in
  /// the [response][google.longrunning.Operation.response] field.
  /// Available for following ML scenarios:
  ///
  /// * AutoML Vision Classification
  /// * AutoML Vision Object Detection
  /// * AutoML Video Intelligence Classification
  /// * AutoML Video Intelligence Object Tracking * AutoML Natural Language Classification
  /// * AutoML Natural Language Entity Extraction
  /// * AutoML Natural Language Sentiment Analysis
  /// * AutoML Tables
  ///
  /// @param name  Required. Name of the model requested to serve the batch prediction.
  /// @param input_config  Required. The input configuration for batch prediction.
  /// @param output_config  Required. The Configuration specifying where output predictions should
  ///  be written.
  /// @param params  Additional domain-specific parameters for the predictions, any string must
  ///  be up to 25000 characters long.
  ///  @n
  ///  For more information, see [BatchPredictRequest][google.cloud.automl.v1.BatchPredictRequest].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.automl.v1.BatchPredictResult] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.automl.v1.BatchPredictRequest]: @googleapis_reference_link{google/cloud/automl/v1/prediction_service.proto#L202}
  /// [google.cloud.automl.v1.BatchPredictResult]: @googleapis_reference_link{google/cloud/automl/v1/prediction_service.proto#L308}
  /// [google.cloud.automl.v1.PredictionService.Predict]: @googleapis_reference_link{google/cloud/automl/v1/prediction_service.proto#L80}
  /// [google.longrunning.Operation.response]: @googleapis_reference_link{google/longrunning/operations.proto#L160}
  /// [google.longrunning.Operations.GetOperation]: @googleapis_reference_link{google/longrunning/operations.proto#L77}
  ///
  // clang-format on
  future<StatusOr<google::cloud::automl::v1::BatchPredictResult>> BatchPredict(
      std::string const& name,
      google::cloud::automl::v1::BatchPredictInputConfig const& input_config,
      google::cloud::automl::v1::BatchPredictOutputConfig const& output_config,
      std::map<std::string, std::string> const& params, Options opts = {});

  // clang-format off
  ///
  /// Perform a batch prediction. Unlike the online [Predict][google.cloud.automl.v1.PredictionService.Predict], batch
  /// prediction result won't be immediately available in the response. Instead,
  /// a long running operation object is returned. User can poll the operation
  /// result via [GetOperation][google.longrunning.Operations.GetOperation]
  /// method. Once the operation is done, [BatchPredictResult][google.cloud.automl.v1.BatchPredictResult] is returned in
  /// the [response][google.longrunning.Operation.response] field.
  /// Available for following ML scenarios:
  ///
  /// * AutoML Vision Classification
  /// * AutoML Vision Object Detection
  /// * AutoML Video Intelligence Classification
  /// * AutoML Video Intelligence Object Tracking * AutoML Natural Language Classification
  /// * AutoML Natural Language Entity Extraction
  /// * AutoML Natural Language Sentiment Analysis
  /// * AutoML Tables
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.automl.v1.BatchPredictRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.automl.v1.BatchPredictResult] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.automl.v1.BatchPredictRequest]: @googleapis_reference_link{google/cloud/automl/v1/prediction_service.proto#L202}
  /// [google.cloud.automl.v1.BatchPredictResult]: @googleapis_reference_link{google/cloud/automl/v1/prediction_service.proto#L308}
  /// [google.cloud.automl.v1.PredictionService.Predict]: @googleapis_reference_link{google/cloud/automl/v1/prediction_service.proto#L80}
  /// [google.longrunning.Operation.response]: @googleapis_reference_link{google/longrunning/operations.proto#L160}
  /// [google.longrunning.Operations.GetOperation]: @googleapis_reference_link{google/longrunning/operations.proto#L77}
  ///
  // clang-format on
  future<StatusOr<google::cloud::automl::v1::BatchPredictResult>> BatchPredict(
      google::cloud::automl::v1::BatchPredictRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<PredictionServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace automl_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AUTOML_V1_PREDICTION_CLIENT_H
