// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/artifactregistry/v1/service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ARTIFACTREGISTRY_V1_ARTIFACT_REGISTRY_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ARTIFACTREGISTRY_V1_ARTIFACT_REGISTRY_CONNECTION_H

#include "google/cloud/artifactregistry/v1/artifact_registry_connection_idempotency_policy.h"
#include "google/cloud/artifactregistry/v1/internal/artifact_registry_retry_traits.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/devtools/artifactregistry/v1/service.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace artifactregistry_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `ArtifactRegistryConnection`.
class ArtifactRegistryRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<ArtifactRegistryRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `ArtifactRegistryConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class ArtifactRegistryLimitedErrorCountRetryPolicy
    : public ArtifactRegistryRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit ArtifactRegistryLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  ArtifactRegistryLimitedErrorCountRetryPolicy(
      ArtifactRegistryLimitedErrorCountRetryPolicy&& rhs) noexcept
      : ArtifactRegistryLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  ArtifactRegistryLimitedErrorCountRetryPolicy(
      ArtifactRegistryLimitedErrorCountRetryPolicy const& rhs) noexcept
      : ArtifactRegistryLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<ArtifactRegistryRetryPolicy> clone() const override {
    return std::make_unique<ArtifactRegistryLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = ArtifactRegistryRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      artifactregistry_v1_internal::ArtifactRegistryRetryTraits>
      impl_;
};

/**
 * A retry policy for `ArtifactRegistryConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class ArtifactRegistryLimitedTimeRetryPolicy
    : public ArtifactRegistryRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit ArtifactRegistryLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  ArtifactRegistryLimitedTimeRetryPolicy(
      ArtifactRegistryLimitedTimeRetryPolicy&& rhs) noexcept
      : ArtifactRegistryLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  ArtifactRegistryLimitedTimeRetryPolicy(
      ArtifactRegistryLimitedTimeRetryPolicy const& rhs) noexcept
      : ArtifactRegistryLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<ArtifactRegistryRetryPolicy> clone() const override {
    return std::make_unique<ArtifactRegistryLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = ArtifactRegistryRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      artifactregistry_v1_internal::ArtifactRegistryRetryTraits>
      impl_;
};

/**
 * The `ArtifactRegistryConnection` object for `ArtifactRegistryClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `ArtifactRegistryClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `ArtifactRegistryClient`.
 *
 * To create a concrete instance, see `MakeArtifactRegistryConnection()`.
 *
 * For mocking, see `artifactregistry_v1_mocks::MockArtifactRegistryConnection`.
 */
class ArtifactRegistryConnection {
 public:
  virtual ~ArtifactRegistryConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StreamRange<google::devtools::artifactregistry::v1::DockerImage>
  ListDockerImages(
      google::devtools::artifactregistry::v1::ListDockerImagesRequest request);

  virtual StatusOr<google::devtools::artifactregistry::v1::DockerImage>
  GetDockerImage(
      google::devtools::artifactregistry::v1::GetDockerImageRequest const&
          request);

  virtual StreamRange<google::devtools::artifactregistry::v1::MavenArtifact>
  ListMavenArtifacts(
      google::devtools::artifactregistry::v1::ListMavenArtifactsRequest
          request);

  virtual StatusOr<google::devtools::artifactregistry::v1::MavenArtifact>
  GetMavenArtifact(
      google::devtools::artifactregistry::v1::GetMavenArtifactRequest const&
          request);

  virtual StreamRange<google::devtools::artifactregistry::v1::NpmPackage>
  ListNpmPackages(
      google::devtools::artifactregistry::v1::ListNpmPackagesRequest request);

  virtual StatusOr<google::devtools::artifactregistry::v1::NpmPackage>
  GetNpmPackage(
      google::devtools::artifactregistry::v1::GetNpmPackageRequest const&
          request);

  virtual StreamRange<google::devtools::artifactregistry::v1::PythonPackage>
  ListPythonPackages(
      google::devtools::artifactregistry::v1::ListPythonPackagesRequest
          request);

  virtual StatusOr<google::devtools::artifactregistry::v1::PythonPackage>
  GetPythonPackage(
      google::devtools::artifactregistry::v1::GetPythonPackageRequest const&
          request);

  virtual future<StatusOr<
      google::devtools::artifactregistry::v1::ImportAptArtifactsResponse>>
  ImportAptArtifacts(
      google::devtools::artifactregistry::v1::ImportAptArtifactsRequest const&
          request);

  virtual future<StatusOr<
      google::devtools::artifactregistry::v1::ImportYumArtifactsResponse>>
  ImportYumArtifacts(
      google::devtools::artifactregistry::v1::ImportYumArtifactsRequest const&
          request);

  virtual StreamRange<google::devtools::artifactregistry::v1::Repository>
  ListRepositories(
      google::devtools::artifactregistry::v1::ListRepositoriesRequest request);

  virtual StatusOr<google::devtools::artifactregistry::v1::Repository>
  GetRepository(
      google::devtools::artifactregistry::v1::GetRepositoryRequest const&
          request);

  virtual future<StatusOr<google::devtools::artifactregistry::v1::Repository>>
  CreateRepository(
      google::devtools::artifactregistry::v1::CreateRepositoryRequest const&
          request);

  virtual StatusOr<google::devtools::artifactregistry::v1::Repository>
  UpdateRepository(
      google::devtools::artifactregistry::v1::UpdateRepositoryRequest const&
          request);

  virtual future<
      StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
  DeleteRepository(
      google::devtools::artifactregistry::v1::DeleteRepositoryRequest const&
          request);

  virtual StreamRange<google::devtools::artifactregistry::v1::Package>
  ListPackages(
      google::devtools::artifactregistry::v1::ListPackagesRequest request);

  virtual StatusOr<google::devtools::artifactregistry::v1::Package> GetPackage(
      google::devtools::artifactregistry::v1::GetPackageRequest const& request);

  virtual future<
      StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
  DeletePackage(
      google::devtools::artifactregistry::v1::DeletePackageRequest const&
          request);

  virtual StreamRange<google::devtools::artifactregistry::v1::Version>
  ListVersions(
      google::devtools::artifactregistry::v1::ListVersionsRequest request);

  virtual StatusOr<google::devtools::artifactregistry::v1::Version> GetVersion(
      google::devtools::artifactregistry::v1::GetVersionRequest const& request);

  virtual future<
      StatusOr<google::devtools::artifactregistry::v1::OperationMetadata>>
  DeleteVersion(
      google::devtools::artifactregistry::v1::DeleteVersionRequest const&
          request);

  virtual future<StatusOr<
      google::devtools::artifactregistry::v1::BatchDeleteVersionsMetadata>>
  BatchDeleteVersions(
      google::devtools::artifactregistry::v1::BatchDeleteVersionsRequest const&
          request);

  virtual StreamRange<google::devtools::artifactregistry::v1::File> ListFiles(
      google::devtools::artifactregistry::v1::ListFilesRequest request);

  virtual StatusOr<google::devtools::artifactregistry::v1::File> GetFile(
      google::devtools::artifactregistry::v1::GetFileRequest const& request);

  virtual StreamRange<google::devtools::artifactregistry::v1::Tag> ListTags(
      google::devtools::artifactregistry::v1::ListTagsRequest request);

  virtual StatusOr<google::devtools::artifactregistry::v1::Tag> GetTag(
      google::devtools::artifactregistry::v1::GetTagRequest const& request);

  virtual StatusOr<google::devtools::artifactregistry::v1::Tag> CreateTag(
      google::devtools::artifactregistry::v1::CreateTagRequest const& request);

  virtual StatusOr<google::devtools::artifactregistry::v1::Tag> UpdateTag(
      google::devtools::artifactregistry::v1::UpdateTagRequest const& request);

  virtual Status DeleteTag(
      google::devtools::artifactregistry::v1::DeleteTagRequest const& request);

  virtual StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request);

  virtual StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request);

  virtual StatusOr<google::iam::v1::TestIamPermissionsResponse>
  TestIamPermissions(google::iam::v1::TestIamPermissionsRequest const& request);

  virtual StatusOr<google::devtools::artifactregistry::v1::ProjectSettings>
  GetProjectSettings(
      google::devtools::artifactregistry::v1::GetProjectSettingsRequest const&
          request);

  virtual StatusOr<google::devtools::artifactregistry::v1::ProjectSettings>
  UpdateProjectSettings(google::devtools::artifactregistry::v1::
                            UpdateProjectSettingsRequest const& request);

  virtual StatusOr<google::devtools::artifactregistry::v1::VPCSCConfig>
  GetVPCSCConfig(
      google::devtools::artifactregistry::v1::GetVPCSCConfigRequest const&
          request);

  virtual StatusOr<google::devtools::artifactregistry::v1::VPCSCConfig>
  UpdateVPCSCConfig(
      google::devtools::artifactregistry::v1::UpdateVPCSCConfigRequest const&
          request);
};

/**
 * A factory function to construct an object of type
 * `ArtifactRegistryConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of ArtifactRegistryClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `ArtifactRegistryConnection`. Expected options are any of the types
 * in the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::artifactregistry_v1::ArtifactRegistryPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `ArtifactRegistryConnection` created
 * by this function.
 */
std::shared_ptr<ArtifactRegistryConnection> MakeArtifactRegistryConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace artifactregistry_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ARTIFACTREGISTRY_V1_ARTIFACT_REGISTRY_CONNECTION_H
