// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/tensorboard_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_TENSORBOARD_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_TENSORBOARD_CONNECTION_H

#include "google/cloud/aiplatform/v1/internal/tensorboard_retry_traits.h"
#include "google/cloud/aiplatform/v1/tensorboard_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/aiplatform/v1/tensorboard_service.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `TensorboardServiceConnection`.
class TensorboardServiceRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<TensorboardServiceRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `TensorboardServiceConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class TensorboardServiceLimitedErrorCountRetryPolicy
    : public TensorboardServiceRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit TensorboardServiceLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  TensorboardServiceLimitedErrorCountRetryPolicy(
      TensorboardServiceLimitedErrorCountRetryPolicy&& rhs) noexcept
      : TensorboardServiceLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {
  }
  TensorboardServiceLimitedErrorCountRetryPolicy(
      TensorboardServiceLimitedErrorCountRetryPolicy const& rhs) noexcept
      : TensorboardServiceLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {
  }

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<TensorboardServiceRetryPolicy> clone() const override {
    return std::make_unique<TensorboardServiceLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = TensorboardServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      aiplatform_v1_internal::TensorboardServiceRetryTraits>
      impl_;
};

/**
 * A retry policy for `TensorboardServiceConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class TensorboardServiceLimitedTimeRetryPolicy
    : public TensorboardServiceRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit TensorboardServiceLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  TensorboardServiceLimitedTimeRetryPolicy(
      TensorboardServiceLimitedTimeRetryPolicy&& rhs) noexcept
      : TensorboardServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  TensorboardServiceLimitedTimeRetryPolicy(
      TensorboardServiceLimitedTimeRetryPolicy const& rhs) noexcept
      : TensorboardServiceLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<TensorboardServiceRetryPolicy> clone() const override {
    return std::make_unique<TensorboardServiceLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = TensorboardServiceRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      aiplatform_v1_internal::TensorboardServiceRetryTraits>
      impl_;
};

/**
 * The `TensorboardServiceConnection` object for `TensorboardServiceClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `TensorboardServiceClient`. This allows users to inject custom
 * behavior (e.g., with a Google Mock object) when writing tests that use
 * objects of type `TensorboardServiceClient`.
 *
 * To create a concrete instance, see `MakeTensorboardServiceConnection()`.
 *
 * For mocking, see `aiplatform_v1_mocks::MockTensorboardServiceConnection`.
 */
class TensorboardServiceConnection {
 public:
  virtual ~TensorboardServiceConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
  CreateTensorboard(
      google::cloud::aiplatform::v1::CreateTensorboardRequest const& request);

  virtual StatusOr<google::cloud::aiplatform::v1::Tensorboard> GetTensorboard(
      google::cloud::aiplatform::v1::GetTensorboardRequest const& request);

  virtual future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
  UpdateTensorboard(
      google::cloud::aiplatform::v1::UpdateTensorboardRequest const& request);

  virtual StreamRange<google::cloud::aiplatform::v1::Tensorboard>
  ListTensorboards(
      google::cloud::aiplatform::v1::ListTensorboardsRequest request);

  virtual future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboard(
      google::cloud::aiplatform::v1::DeleteTensorboardRequest const& request);

  virtual StatusOr<google::cloud::aiplatform::v1::ReadTensorboardUsageResponse>
  ReadTensorboardUsage(
      google::cloud::aiplatform::v1::ReadTensorboardUsageRequest const&
          request);

  virtual StatusOr<google::cloud::aiplatform::v1::ReadTensorboardSizeResponse>
  ReadTensorboardSize(
      google::cloud::aiplatform::v1::ReadTensorboardSizeRequest const& request);

  virtual StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
  CreateTensorboardExperiment(
      google::cloud::aiplatform::v1::CreateTensorboardExperimentRequest const&
          request);

  virtual StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
  GetTensorboardExperiment(
      google::cloud::aiplatform::v1::GetTensorboardExperimentRequest const&
          request);

  virtual StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
  UpdateTensorboardExperiment(
      google::cloud::aiplatform::v1::UpdateTensorboardExperimentRequest const&
          request);

  virtual StreamRange<google::cloud::aiplatform::v1::TensorboardExperiment>
  ListTensorboardExperiments(
      google::cloud::aiplatform::v1::ListTensorboardExperimentsRequest request);

  virtual future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboardExperiment(
      google::cloud::aiplatform::v1::DeleteTensorboardExperimentRequest const&
          request);

  virtual StatusOr<google::cloud::aiplatform::v1::TensorboardRun>
  CreateTensorboardRun(
      google::cloud::aiplatform::v1::CreateTensorboardRunRequest const&
          request);

  virtual StatusOr<
      google::cloud::aiplatform::v1::BatchCreateTensorboardRunsResponse>
  BatchCreateTensorboardRuns(
      google::cloud::aiplatform::v1::BatchCreateTensorboardRunsRequest const&
          request);

  virtual StatusOr<google::cloud::aiplatform::v1::TensorboardRun>
  GetTensorboardRun(
      google::cloud::aiplatform::v1::GetTensorboardRunRequest const& request);

  virtual StatusOr<google::cloud::aiplatform::v1::TensorboardRun>
  UpdateTensorboardRun(
      google::cloud::aiplatform::v1::UpdateTensorboardRunRequest const&
          request);

  virtual StreamRange<google::cloud::aiplatform::v1::TensorboardRun>
  ListTensorboardRuns(
      google::cloud::aiplatform::v1::ListTensorboardRunsRequest request);

  virtual future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboardRun(
      google::cloud::aiplatform::v1::DeleteTensorboardRunRequest const&
          request);

  virtual StatusOr<
      google::cloud::aiplatform::v1::BatchCreateTensorboardTimeSeriesResponse>
  BatchCreateTensorboardTimeSeries(
      google::cloud::aiplatform::v1::
          BatchCreateTensorboardTimeSeriesRequest const& request);

  virtual StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
  CreateTensorboardTimeSeries(
      google::cloud::aiplatform::v1::CreateTensorboardTimeSeriesRequest const&
          request);

  virtual StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
  GetTensorboardTimeSeries(
      google::cloud::aiplatform::v1::GetTensorboardTimeSeriesRequest const&
          request);

  virtual StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
  UpdateTensorboardTimeSeries(
      google::cloud::aiplatform::v1::UpdateTensorboardTimeSeriesRequest const&
          request);

  virtual StreamRange<google::cloud::aiplatform::v1::TensorboardTimeSeries>
  ListTensorboardTimeSeries(
      google::cloud::aiplatform::v1::ListTensorboardTimeSeriesRequest request);

  virtual future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboardTimeSeries(
      google::cloud::aiplatform::v1::DeleteTensorboardTimeSeriesRequest const&
          request);

  virtual StatusOr<
      google::cloud::aiplatform::v1::BatchReadTensorboardTimeSeriesDataResponse>
  BatchReadTensorboardTimeSeriesData(
      google::cloud::aiplatform::v1::
          BatchReadTensorboardTimeSeriesDataRequest const& request);

  virtual StatusOr<
      google::cloud::aiplatform::v1::ReadTensorboardTimeSeriesDataResponse>
  ReadTensorboardTimeSeriesData(
      google::cloud::aiplatform::v1::ReadTensorboardTimeSeriesDataRequest const&
          request);

  virtual StreamRange<
      google::cloud::aiplatform::v1::ReadTensorboardBlobDataResponse>
  ReadTensorboardBlobData(
      google::cloud::aiplatform::v1::ReadTensorboardBlobDataRequest const&
          request);

  virtual StatusOr<
      google::cloud::aiplatform::v1::WriteTensorboardExperimentDataResponse>
  WriteTensorboardExperimentData(
      google::cloud::aiplatform::v1::
          WriteTensorboardExperimentDataRequest const& request);

  virtual StatusOr<
      google::cloud::aiplatform::v1::WriteTensorboardRunDataResponse>
  WriteTensorboardRunData(
      google::cloud::aiplatform::v1::WriteTensorboardRunDataRequest const&
          request);

  virtual StreamRange<google::cloud::aiplatform::v1::TimeSeriesDataPoint>
  ExportTensorboardTimeSeriesData(
      google::cloud::aiplatform::v1::ExportTensorboardTimeSeriesDataRequest
          request);
};

/**
 * A factory function to construct an object of type
 * `TensorboardServiceConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of
 * TensorboardServiceClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `TensorboardServiceConnection`. Expected options are any of the
 * types in the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::aiplatform_v1::TensorboardServicePolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param location Sets the prefix for the default `EndpointOption` value.
 * @param options (optional) Configure the `TensorboardServiceConnection`
 * created by this function.
 */
std::shared_ptr<TensorboardServiceConnection> MakeTensorboardServiceConnection(
    std::string const& location, Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_TENSORBOARD_CONNECTION_H
