// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/index_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INDEX_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INDEX_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/aiplatform/v1/index_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class IndexServiceConnectionIdempotencyPolicy {
 public:
  virtual ~IndexServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<IndexServiceConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency CreateIndex(
      google::cloud::aiplatform::v1::CreateIndexRequest const& request);

  virtual google::cloud::Idempotency GetIndex(
      google::cloud::aiplatform::v1::GetIndexRequest const& request);

  virtual google::cloud::Idempotency ListIndexes(
      google::cloud::aiplatform::v1::ListIndexesRequest request);

  virtual google::cloud::Idempotency UpdateIndex(
      google::cloud::aiplatform::v1::UpdateIndexRequest const& request);

  virtual google::cloud::Idempotency DeleteIndex(
      google::cloud::aiplatform::v1::DeleteIndexRequest const& request);

  virtual google::cloud::Idempotency UpsertDatapoints(
      google::cloud::aiplatform::v1::UpsertDatapointsRequest const& request);

  virtual google::cloud::Idempotency RemoveDatapoints(
      google::cloud::aiplatform::v1::RemoveDatapointsRequest const& request);
};

std::unique_ptr<IndexServiceConnectionIdempotencyPolicy>
MakeDefaultIndexServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INDEX_CONNECTION_IDEMPOTENCY_POLICY_H
