# Licensed to Elasticsearch B.V. under one or more contributor
# license agreements. See the NOTICE file distributed with
# this work for additional information regarding copyright
# ownership. Elasticsearch B.V. licenses this file to you under
# the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

require 'spec_helper'

describe 'client#inference.put_deepseek' do
  let(:expected_args) do
    [
      'PUT',
      '_inference/foo/bar',
      {},
      nil,
      {},
      { defined_params: { deepseek_inference_id: 'bar', task_type: 'foo' },
        endpoint: 'inference.put_deepseek' }
    ]
  end

  it 'performs the request' do
    expect(client_double.inference.put_deepseek(task_type: 'foo', deepseek_inference_id: 'bar')).to be_a Elasticsearch::API::Response
  end
end
