/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.favorites;

import java.awt.EventQueue;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.favorites.FavoritesNode;
import org.netbeans.modules.favorites.Tab;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.windows.WindowManager;

public final class Actions {
    private static File currentDir = null;
    private static final Logger LOG = Logger.getLogger(Actions.class.getName());

    private Actions() {
    }

    public static ContextAwareAction add() {
        return Add.getDefault();
    }

    public static Action addOnFavoritesNode() {
        return AddOnFavoritesNode.getDefault();
    }

    public static Action remove() {
        return Remove.getDefault();
    }

    public static ContextAwareAction select() {
        return Select.getDefault();
    }

    public static class AddOnFavoritesNode
    extends Add {
        static final long serialVersionUID = -6471284573153172312L;
        private static final AddOnFavoritesNode ADD_ON_FAVORITES_NODE = new AddOnFavoritesNode();

        public static ContextAwareAction getDefault() {
            return ADD_ON_FAVORITES_NODE;
        }

        @Override
        public String getName() {
            return NbBundle.getMessage(Actions.class, (String)"ACT_AddOnFavoritesNode");
        }
    }

    public static class Add
    extends NodeAction {
        static final long serialVersionUID = -6471281373153172312L;
        private static final String HELP_ID = Add.class.getName();
        private static final Add ADD = new Add();

        public static ContextAwareAction getDefault() {
            return ADD;
        }

        private Add() {
            this.putValue("noIconInMenu", Boolean.TRUE);
        }

        public boolean enable(Node[] nodeArray) {
            if (nodeArray == null || nodeArray.length == 0) {
                return false;
            }
            if (nodeArray.length == 1 && nodeArray[0] instanceof FavoritesNode) {
                return true;
            }
            for (Node node : nodeArray) {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (Add.isAllowed(dataObject)) continue;
                return false;
            }
            return true;
        }

        public String getName() {
            return NbBundle.getMessage(Actions.class, (String)"ACT_Add");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(HELP_ID);
        }

        protected void performAction(Node[] nodeArray) {
            try {
                List<Object> list;
                if (nodeArray.length == 1 && nodeArray[0] instanceof FavoritesNode) {
                    FileObject fileObject = Add.chooseFileObject();
                    if (fileObject == null || !VisibilityQuery.getDefault().isVisible(fileObject)) {
                        return;
                    }
                    list = Collections.singletonList(DataObject.find((FileObject)fileObject));
                } else {
                    list = new ArrayList();
                    for (Node node : nodeArray) {
                        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                        if (dataObject == null) continue;
                        list.add(dataObject);
                    }
                }
                Tab.RP.post(() -> Add.addToFavorites(list));
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOG.log(Level.INFO, null, dataObjectNotFoundException);
            }
        }

        private static FileObject chooseFileObject() {
            int n;
            FileObject fileObject = null;
            File file = null;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setDialogTitle(NbBundle.getBundle(Actions.class).getString("CTL_DialogTitle"));
            jFileChooser.setApproveButtonText(NbBundle.getBundle(Actions.class).getString("CTL_ApproveButtonText"));
            if (currentDir != null) {
                jFileChooser.setCurrentDirectory(currentDir);
            }
            if ((n = jFileChooser.showOpenDialog(WindowManager.getDefault().getMainWindow())) == 0) {
                file = jFileChooser.getSelectedFile();
                File file2 = FileUtil.normalizeFile((File)file);
                if (!file2.exists() && file2.getParentFile() != null && file2.getParentFile().exists() && file2.getName().equals(file2.getParentFile().getName())) {
                    file2 = file2.getParentFile();
                }
                if (!new File(file2, "").exists()) {
                    String string = NbBundle.getMessage(Actions.class, (String)"ERR_FileDoesNotExist", (Object)file2.getPath());
                    String string2 = NbBundle.getMessage(Actions.class, (String)"ERR_FileDoesNotExistDlgTitle");
                    DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)string, string2, -1, 1, new Object[]{NotifyDescriptor.CLOSED_OPTION}, NotifyDescriptor.OK_OPTION));
                } else {
                    fileObject = FileUtil.toFileObject((File)file2);
                    assert (fileObject != null);
                }
            }
            currentDir = jFileChooser.getCurrentDirectory();
            return fileObject;
        }

        public static void selectAfterAddition(DataObject dataObject) {
            Tab tab = Tab.findDefault();
            tab.open();
            tab.requestActive();
            if (dataObject != null) {
                Tab.RP.post(() -> {
                    Node[] nodeArray = tab.getExplorerManager().getRootContext().getChildren().getNodes(true);
                    Node[] nodeArray2 = new Node[1];
                    boolean bl = false;
                    for (Node node : nodeArray) {
                        if (!dataObject.getName().equals(node.getName())) continue;
                        nodeArray2[0] = node;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        SwingUtilities.invokeLater(() -> {
                            try {
                                tab.getExplorerManager().setExploredContextAndSelection(nodeArray2[0], nodeArray2);
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                // empty catch block
                            }
                        });
                    }
                });
            }
        }

        static DataObject createShadows(DataFolder dataFolder, List<DataObject> list, List<DataObject> list2) {
            DataShadow dataShadow = null;
            for (DataObject dataObject : list) {
                try {
                    DataShadow dataShadow2 = Add.findShadow(dataFolder, dataObject);
                    if (dataShadow2 != null) {
                        if (dataShadow != null) continue;
                        dataShadow = dataShadow2;
                        continue;
                    }
                    if (dataShadow == null) {
                        dataShadow = dataObject.createShadow(dataFolder);
                        list2.add((DataObject)dataShadow);
                        continue;
                    }
                    list2.add((DataObject)dataObject.createShadow(dataFolder));
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, null, iOException);
                }
            }
            return dataShadow;
        }

        private static DataShadow findShadow(DataFolder dataFolder, DataObject dataObject) {
            FileObject fileObject = dataObject.getPrimaryFile();
            if (fileObject != null) {
                DataObject[] dataObjectArray;
                for (DataObject dataObject2 : dataObjectArray = dataFolder.getChildren()) {
                    DataShadow dataShadow;
                    if (!(dataObject2 instanceof DataShadow) || !fileObject.equals((dataShadow = (DataShadow)dataObject2).getOriginal().getPrimaryFile())) continue;
                    return dataShadow;
                }
            }
            return null;
        }

        public static void reorderAfterAddition(DataFolder dataFolder, DataObject[] dataObjectArray, List<? extends DataObject> list) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (list.size() > 0) {
                DataObject dataObject = null;
                for (DataObject dataObject2 : dataObjectArray) {
                    FileObject fileObject = dataObject2.getPrimaryFile();
                    if (!"Favorites/Root.instance".equals(fileObject.getPath())) continue;
                    dataObject = dataObject2;
                    break;
                }
                if (dataObject != null) {
                    for (DataObject dataObject2 : dataObjectArray) {
                        if (dataObject.equals(dataObject2)) continue;
                        arrayList.add(dataObject2);
                    }
                    arrayList.addAll(list);
                    arrayList.add(dataObject);
                } else {
                    arrayList.addAll(Arrays.asList(dataObjectArray));
                    arrayList.addAll(list);
                }
                DataObject[] dataObjectArray2 = arrayList.toArray(new DataObject[0]);
                try {
                    dataFolder.setOrder(dataObjectArray2);
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, null, iOException);
                }
            }
        }

        protected boolean asynchronous() {
            return false;
        }

        static void addToFavorites(List<DataObject> list) {
            assert (!EventQueue.isDispatchThread());
            DataFolder dataFolder = FavoritesNode.getFolder();
            DataObject[] dataObjectArray = dataFolder.getChildren();
            ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
            DataObject dataObject = Add.createShadows(dataFolder, list, arrayList);
            Add.reorderAfterAddition(dataFolder, dataObjectArray, arrayList);
            EventQueue.invokeLater(() -> Add.selectAfterAddition(dataObject));
        }

        static boolean isAllowed(DataObject dataObject) {
            if (dataObject == null) {
                return false;
            }
            FileObject fileObject = dataObject.getPrimaryFile();
            if (fileObject != null) {
                if (URLMapper.findURL((FileObject)fileObject, (int)1) == null) {
                    return false;
                }
                if (fileObject.isRoot()) {
                    return false;
                }
            }
            try {
                if (dataObject.getPrimaryFile().getFileSystem().isDefault()) {
                    return false;
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return false;
            }
            return true;
        }
    }

    private static class Remove
    extends NodeAction {
        static final long serialVersionUID = -6471281373153172312L;
        private static final String HELP_ID = Remove.class.getName();
        private static final Remove REMOVE = new Remove();

        private Remove() {
        }

        public static Action getDefault() {
            return REMOVE;
        }

        public boolean enable(Node[] nodeArray) {
            if (nodeArray == null || nodeArray.length == 0) {
                return false;
            }
            for (Node node : nodeArray) {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject != null && dataObject.getFolder() == FavoritesNode.getFolder()) continue;
                return false;
            }
            return true;
        }

        public String getName() {
            return NbBundle.getMessage(Actions.class, (String)"ACT_Remove");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(HELP_ID);
        }

        protected void performAction(Node[] nodeArray) {
            for (Node node : nodeArray) {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject == null || dataObject.getFolder() != FavoritesNode.getFolder()) continue;
                try {
                    dataObject.delete();
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, null, iOException);
                }
            }
        }

        protected boolean asynchronous() {
            return false;
        }
    }

    private static class Select
    extends NodeAction {
        private static final Select SELECT = new Select();

        public static ContextAwareAction getDefault() {
            return SELECT;
        }

        private Select() {
            this.putValue("noIconInMenu", Boolean.TRUE);
        }

        protected void performAction(Node[] nodeArray) {
            Tab tab = Tab.findDefault();
            Tab.RP.post(() -> tab.doSelectNode((DataObject)nodeArray[0].getCookie(DataObject.class)));
        }

        protected boolean enable(Node[] nodeArray) {
            if (nodeArray.length != 1) {
                return false;
            }
            DataObject dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class);
            return dataObject != null;
        }

        public String getName() {
            return NbBundle.getMessage(Select.class, (String)"ACT_Select_Main_Menu");
        }

        protected String iconResource() {
            return "org/netbeans/modules/favorites/resources/actionView.png";
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected boolean asynchronous() {
            return false;
        }
    }
}

