/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import java.io.File;
import java.net.URL;
import tim.prune.data.DataPoint;

public class ItemToLoad {
    private final File _dataFile;
    private final File _zipFile;
    private final String _itemPathWithinZip;
    private final URL _url;
    private final DataPoint _point;

    private ItemToLoad(File file, DataPoint dataPoint, File file2, String string, URL uRL) {
        this._dataFile = file;
        this._point = dataPoint;
        this._zipFile = file2;
        this._itemPathWithinZip = string;
        this._url = uRL;
    }

    public static ItemToLoad dataFile(File file) {
        return new ItemToLoad(file, null, null, null, null);
    }

    public static ItemToLoad archivedFile(File file, String string, DataPoint dataPoint) {
        return new ItemToLoad(null, dataPoint, file, string, null);
    }

    public static ItemToLoad mediaUrl(URL uRL, DataPoint dataPoint) {
        return new ItemToLoad(null, dataPoint, null, null, uRL);
    }

    public boolean isDataFile() {
        return this._dataFile != null && this._dataFile.exists() && this._dataFile.canRead();
    }

    public File getDataFile() {
        return this._dataFile;
    }

    public boolean isArchivedFile() {
        return this._zipFile != null && this._zipFile.exists() && this._zipFile.canRead() && this._itemPathWithinZip != null && !this._itemPathWithinZip.isEmpty();
    }

    public File getArchiveFile() {
        return this._zipFile;
    }

    public String getItemPath() {
        return this._itemPathWithinZip;
    }

    public boolean isUrl() {
        return this._url != null;
    }

    public URL getUrl() {
        return this._url;
    }

    public DataPoint getPoint() {
        return this._point;
    }
}

