//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
/// \file F04RunAction.cc
/// \brief Implementation of the F04RunAction class

#include "F04RunAction.hh"

#include "F04RunActionMessenger.hh"

#include "G4Run.hh"
#include "G4RunManager.hh"
#include "Randomize.hh"

#include <ctime>

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

F04RunAction::F04RunAction()
{
  fRunMessenger = new F04RunActionMessenger(this);
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

F04RunAction::~F04RunAction()
{
  delete fRunMessenger;
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......
#include "G4Threading.hh"

void F04RunAction::BeginOfRunAction(const G4Run* aRun)
{
  G4cout << "### Run " << aRun->GetRunID() << " start." << G4endl;

  G4RunManager::GetRunManager()->SetRandomNumberStore(true);
  G4RunManager::GetRunManager()->SetRandomNumberStoreDir("random/");

  if (fAutoSeed) {
    // automatic (time-based) random seeds for each run
    G4cout << "*******************" << G4endl;
    G4cout << "*** AUTOSEED ON ***" << G4endl;
    G4cout << "*******************" << G4endl;
    long seeds[2];
    time_t systime = time(nullptr);
    seeds[0] = (long)systime;
    seeds[1] = (long)(systime * G4UniformRand());
    G4Random::setTheSeeds(seeds);
    G4Random::showEngineStatus();
  }
  else {
    G4Random::showEngineStatus();
  }

  if (fSaveRndm > 0) {
    std::ostringstream os;
    os << "beginOfRun_" << G4Threading::G4GetThreadId() << ".rndm";
    G4Random::saveEngineStatus(os.str().c_str());
  }
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

void F04RunAction::EndOfRunAction(const G4Run*)
{
  if (fSaveRndm == 1) {
    G4Random::showEngineStatus();
    std::ostringstream os;
    os << "endOfRun_" << G4Threading::G4GetThreadId() << ".rndm";
    G4Random::saveEngineStatus(os.str().c_str());
  }
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......
