#ifndef fallback_entities_h
#define fallback_entities_h       1

int unicode_entity(CHAR *s);
int ligature_entity(CHAR *s);
int fallback_entity(CHAR *s);

struct fallback_entities_struct {
	int codepoint;
	char *description;
	CHAR *replacement;
	CHAR *entity;
};

struct fallback_entities_struct fallback_entities[] = {
/* Spacing Modifier Letters */

/* ISO-8859-1 */
{0x00A1, "INVERTED EXCLAMATION MARK", STRING("!"), STRING("&iexcl;")},
{0x00A6, "BROKEN BAR", STRING("|"), STRING("&brvbar;")},
{0x00A8, "DIAERESIS", STRING("\""), STRING("&uml;")},
{0x00A9, "COPYRIGHT SIGN", STRING("(c)"), STRING("&copy;")},
{0x00AB, "LEFT-POINTING DOUBLE ANGLE QUOTATION MARK", STRING("\""), STRING("&laquo;")},
{0x00AE, "REGISTERED SIGN", STRING("(R)"), STRING("&reg;")},
{0x00B1, "PLUS-MINUS SIGN", STRING("+/-"), STRING("&plusmn;")},
{0x00B4, "ACUTE ACCENT", STRING("'"), STRING("&acute;")},
{0x00B7, "MIDDLE DOT", STRING("*"), STRING("&middot;")},
{0x00BB, "RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK", STRING("\""), STRING("&raquo;")},
{0x00BC, "VULGAR FRACTION ONE QUARTER", STRING("1/4"), STRING("&frac14;")},
{0x00BD, "VULGAR FRACTION ONE HALF", STRING("1/2"), STRING("&frac12;")},
{0x00BE, "VULGAR FRACTION THREE QUARTERS", STRING("3/4"), STRING("&frac34;")},
{0x00BF, "INVERTED QUESTION MARK", STRING("?"), STRING("&iquest;")},
{0x00C0, "LATIN CAPITAL LETTER A WITH GRAVE", STRING("A"), STRING("&Agrave;")},
{0x00C1, "LATIN CAPITAL LETTER A WITH ACUTE", STRING("A"), STRING("&Aacute;")},
{0x00C2, "LATIN CAPITAL LETTER A WITH CIRCUMFLEX", STRING("A"), STRING("&Acirc;")},
{0x00C3, "LATIN CAPITAL LETTER A WITH TILDE", STRING("A"), STRING("&Atilde;")},
{0x00C4, "LATIN CAPITAL LETTER A WITH DIAERESIS", STRING("Ae"), STRING("&Auml;")},
{0x00C5, "LATIN CAPITAL LETTER A WITH RING ABOVE", STRING("A"), STRING("&Aring;")},
{0x00C6, "LATIN CAPITAL LETTER AE", STRING("Ae"), STRING("&AElig;")},
{0x00C7, "LATIN CAPITAL LETTER C WITH CEDILLA", STRING("C"), STRING("&Ccedil;")},
{0x00C8, "LATIN CAPITAL LETTER E WITH GRAVE", STRING("E"), STRING("&Egrave;")},
{0x00C9, "LATIN CAPITAL LETTER E WITH ACUTE", STRING("E"), STRING("&Eacute;")},
{0x00CA, "LATIN CAPITAL LETTER E WITH CIRCUMFLEX", STRING("E"), STRING("&Ecirc;")},
{0x00CB, "LATIN CAPITAL LETTER E WITH DIAERESIS", STRING("E"), STRING("&Euml;")},
{0x00CC, "LATIN CAPITAL LETTER I WITH GRAVE", STRING("I"), STRING("&Igrave;")},
{0x00CD, "LATIN CAPITAL LETTER I WITH ACUTE", STRING("I"), STRING("&Iacute;")},
{0x00CE, "LATIN CAPITAL LETTER I WITH CIRCUMFLEX", STRING("I"), STRING("&Icirc;")},
{0x00CF, "LATIN CAPITAL LETTER I WITH DIAERESIS", STRING("I"), STRING("&Iuml;")},
{0x00D0, "LATIN CAPITAL LETTER ETH", STRING("Th"), STRING("&ETH;")},
{0x00D1, "LATIN CAPITAL LETTER N WITH TILDE", STRING("N"), STRING("&Ntilde;")},
{0x00D2, "LATIN CAPITAL LETTER O WITH GRAVE", STRING("O"), STRING("&Ograve;")},
{0x00D3, "LATIN CAPITAL LETTER O WITH ACUTE", STRING("O"), STRING("&Oacute;")},
{0x00D4, "LATIN CAPITAL LETTER O WITH CIRCUMFLEX", STRING("O"), STRING("&Ocirc;")},
{0x00D5, "LATIN CAPITAL LETTER O WITH TILDE", STRING("O"), STRING("&Otilde;")},
{0x00D6, "LATIN CAPITAL LETTER E WITH DIAERESIS", STRING("Oe"), STRING("&Ouml;")},
{0x00D7, "MULTIPLICATION SIGN", STRING("*"), STRING("&times;")},
{0x00D8, "LATIN CAPITAL LETTER O WITH STROKE", STRING("O"), STRING("&Oslash;")},
{0x00D9, "LATIN CAPITAL LETTER U WITH GRAVE", STRING("U"), STRING("&Ugrave;")},
{0x00DA, "LATIN CAPITAL LETTER U WITH ACUTE", STRING("U"), STRING("&Uacute;")},
{0x00DB, "LATIN CAPITAL LETTER U WITH CIRCUMFLEX", STRING("U"), STRING("&Ucirc;")},
{0x00DC, "LATIN CAPITAL LETTER U WITH DIAERESIS", STRING("Ue"), STRING("&Uuml;")},
{0x00DD, "LATIN CAPITAL LETTER Y WITH ACUTE", STRING("Y"), STRING("&Yacute;")},
{0x00DE, "LATIN CAPITAL LETTER THORN", STRING("Th"), STRING("&THORN;")},
{0x00DF, "LATIN SMALL LETTER SHARP S (German)", STRING("ss"), STRING("&szlig;")},
{0x00DF, "LATIN SMALL LETTER SHARP S", STRING("ss"), STRING("&szlig;")},
{0x00E0, "LATIN SMALL LETTER A WITH GRAVE", STRING("a"), STRING("&agrave;")},
{0x00E1, "LATIN SMALL LETTER A WITH ACUTE", STRING("a"), STRING("&aacute;")},
{0x00E2, "LATIN SMALL LETTER A WITH CIRCUMFLEX", STRING("a"), STRING("&acirc;")},
{0x00E3, "LATIN SMALL LETTER A WITH TILDE", STRING("a"), STRING("&atilde;")},
{0x00E4, "LATIN SMALL LETTER A WITH DIAERESIS", STRING("ae"), STRING("&auml;")},
{0x00E5, "LATIN SMALL LETTER A WITH RING ABOVE", STRING("a"), STRING("&aring;")},
{0x00E6, "LATIN SMALL LETTER AE", STRING("ae"), STRING("&aelig;")},
{0x00E7, "LATIN SMALL LETTER C WITH CEDILLA", STRING("c"), STRING("&ccedil;")},
{0x00E8, "LATIN SMALL LETTER E WITH GRAVE", STRING("e"), STRING("&egrave;")},
{0x00E9, "LATIN SMALL LETTER E WITH ACUTE", STRING("e"), STRING("&eacute;")},
{0x00EA, "LATIN SMALL LETTER E WITH CIRCUMFLEX", STRING("e"), STRING("&ecirc;")},
{0x00EB, "LATIN SMALL LETTER E WITH DIAERESIS", STRING("e"), STRING("&euml;")},
{0x00EC, "LATIN SMALL LETTER I WITH GRAVE", STRING("i"), STRING("&igrave;")},
{0x00ED, "LATIN SMALL LETTER I WITH ACUTE", STRING("i"), STRING("&iacute;")},
{0x00EE, "LATIN SMALL LETTER I WITH CIRCUMFLEX", STRING("i"), STRING("&icirc;")},
{0x00EF, "LATIN SMALL LETTER I WITH DIAERESIS", STRING("i"), STRING("&iuml;")},
{0x00F0, "LATIN SMALL LETTER ETH", STRING("th"), STRING("&eth;")},
{0x00F1, "LATIN SMALL LETTER N WITH TILDE", STRING("n"), STRING("&ntilde;")},
{0x00F2, "LATIN SMALL LETTER O WITH GRAVE", STRING("o"), STRING("&ograve;")},
{0x00F3, "LATIN SMALL LETTER O WITH ACUTE", STRING("o"), STRING("&oacute;")},
{0x00F4, "LATIN SMALL LETTER O WITH CIRCUMFLEX", STRING("o"), STRING("&ocirc;")},
{0x00F5, "LATIN SMALL LETTER O WITH TILDE", STRING("o"), STRING("&otilde;")},
{0x00F6, "LATIN SMALL LETTER O WITH DIAERESIS", STRING("oe"), STRING("&ouml;")},
{0x00F7, "DIVISION SIGN", STRING("/"), STRING("&divide;")},
{0x00F8, "LATIN SMALL LETTER O WITH STROKE", STRING("o"), STRING("&oslash;")},
{0x00F9, "LATIN SMALL LETTER U WITH GRAVE", STRING("u"), STRING("&ugrave;")},
{0x00FA, "LATIN SMALL LETTER U WITH ACUTE", STRING("u"), STRING("&uacute;")},
{0x00FB, "LATIN SMALL LETTER U WITH CIRCUMFLEX", STRING("u"), STRING("&ucirc;")},
{0x00FC, "LATIN SMALL LETTER U WITH DIAERESIS", STRING("ue"), STRING("&uuml;")},
{0x00FD, "LATIN SMALL LETTER Y WITH ACUTE", STRING("y"), STRING("&yacute;")},
{0x00FE, "LATIN SMALL LETTER THORN", STRING("th"), STRING("&thorn;")},
{0x00FF, "LATIN SMALL LETTER Y WITH DIAERESIS", STRING("y"), STRING("&yuml;")},

{0x2032, "PRIME", STRING("'"), STRING("&prime;")},
{0x2033, "DOUBLE PRIME", STRING("''"), STRING("&Prime;")},
{0x2044, "FRACTION SLASH", STRING("/"), STRING("&frasl;")},

/* Dashes */
{0x2010, "HYPHEN", STRING("-")},
{0x2011, "NON-BREAKING HYPHEN", STRING("-")},
{0x2012, "FIGURE DASH", STRING("-")},
{0x2013, "EN DASH", STRING("-")},
{0x2014, "EM DASH", STRING("--")},
{0x2015, "HORIZONTAL BAR", STRING("--")},

/* General punctation */
{0x2018, "LEFT SINGLE QUOTATION MARK",            STRING("'")},
{0x2019, "RIGHT SINGLE QUOTATION MARK",           STRING("'")},
{0x201A, "SINGLE LOW-9 QUOTATION MARK",           STRING("'")},
{0x201B, "SINGLE HIGH-REVERSED-9 QUOTATION MARK", STRING("'")},
{0x201C, "LEFT DOUBLE QUOTATION MARK",            STRING("\"")},
{0x201D, "RIGHT DOUBLE QUOTATION MARK",           STRING("\"")},
{0x201E, "DOUBLE LOW-9 QUOTATION MARK",           STRING("\"")},
{0x201F, "DOUBLE HIGH-REVERSED-9 QUOTATION MARK", STRING("\"")},
{0x2024, "ONE DOT LEADER", STRING(".")},
{0x2025, "TWO DOT LEADER", STRING("..")},
{0x2026, "HORIZONTAL ELLIPSIS", STRING("...")},

{0x2032, "PRIME", STRING("'")},
{0x2033, "DOUBLE PRIME", STRING("''")},
{0x2034, "TRIPLE PRIME", STRING("'''")},
{0x2035, "REVERSED PRIME", STRING("`")},
{0x2036, "REVERSED DOUBLE PRIME", STRING("``")},
{0x2037, "REVERSED TRIPLE PRIME", STRING("```")},
{0x2038, "CARET", STRING("^")},
{0x2039, "SINGLE LEFT-POINTING ANGLE QUOTATION MARK", STRING("<")},
{0x203A, "SINGLE RIGHT-POINTING ANGLE QUOTATION MARK", STRING(">")},

{0x2044, "FRACTION SLASH", STRING("/")},

/* @@      2150    Number Forms    218F */
/* @               Fractions */
{0x2150, "VULGAR FRACTION ONE SEVENTH", STRING("1/7")},
{0x2151, "VULGAR FRACTION ONE NINTH",   STRING("1/9")},
{0x2152, "VULGAR FRACTION ONE TENTH",   STRING("1/10")},

{0x2153, "VULGAR FRACTION ONE THIRD",     STRING("1/3")},
{0x2154, "VULGAR FRACTION TWO THIRDS",    STRING("2/3")},
{0x2155, "VULGAR FRACTION ONE FIFTH",     STRING("1/5")},
{0x2156, "VULGAR FRACTION TWO FIFTHS",    STRING("2/5")},
{0x2157, "VULGAR FRACTION THREE FIFTHS",  STRING("3/5")},
{0x2158, "VULGAR FRACTION FOUR FIFTHS",   STRING("4/5")},
{0x2159, "VULGAR FRACTION ONE SIXTH",     STRING("1/6")},
{0x215A, "VULGAR FRACTION FIVE SIXTHS",   STRING("5/6")},
{0x215B, "VULGAR FRACTION ONE EIGHTH",    STRING("1/8")},
{0x215C, "VULGAR FRACTION THREE EIGHTHS", STRING("3/8")},
{0x215D, "VULGAR FRACTION FIVE EIGHTHS",  STRING("5/8")},
{0x215E, "VULGAR FRACTION SEVEN EIGHTHS", STRING("7/8")},

{0x215F, "FRACTION NUMERATOR ONE",        STRING("1/")},
{0x2189, "VULGAR FRACTION ZERO THIRDS",   STRING("0/3")},

{0x2CFD, "COPTIC FRACTION ONE HALF",      STRING("1/2")},

{0x0D73, "MALAYALAM FRACTION ONE QUARTER",    STRING("1/4")},
{0x0D74, "MALAYALAM FRACTION ONE HALF",       STRING("1/2")},
{0x0D75, "MALAYALAM FRACTION THREE QUARTERS", STRING("3/4")},

{0xA830, "NORTH INDIC FRACTION ONE QUARTER", STRING("1/4")},
{0xA831, "NORTH INDIC FRACTION ONE HALF", STRING("1/2")},
{0xA832, "NORTH INDIC FRACTION THREE QUARTERS", STRING("3/4")},
{0xA833, "NORTH INDIC FRACTION ONE SIXTEENTH", STRING("1/16")},
{0xA834, "NORTH INDIC FRACTION ONE EIGHTH", STRING("1/8")},
{0xA835, "NORTH INDIC FRACTION THREE SIXTEENTHS", STRING("3/16")},

{0x10E7B, "RUMI FRACTION ONE HALF", STRING("1/2")},
{0x10E7C, "RUMI FRACTION ONE QUARTER", STRING("1/4")},
{0x10E7D, "RUMI FRACTION ONE THIRD", STRING("1/3")},
{0x10E7E, "RUMI FRACTION TWO THIRDS", STRING("2/3")},


/* Roman numerals */
{0x2160, "ROMAN NUMERAL ONE",                STRING("I")},
{0x2161, "ROMAN NUMERAL TWO",                STRING("II")},
{0x2162, "ROMAN NUMERAL THREE",              STRING("III")},
{0x2163, "ROMAN NUMERAL FOUR",               STRING("IV")},
{0x2164, "ROMAN NUMERAL FIVE",               STRING("V")},
{0x2165, "ROMAN NUMERAL SIX",                STRING("VI")},
{0x2166, "ROMAN NUMERAL SEVEN",              STRING("VII")},
{0x2167, "ROMAN NUMERAL EIGHT",              STRING("VIII")},
{0x2168, "ROMAN NUMERAL NINE",               STRING("IX")},
{0x2169, "ROMAN NUMERAL TEN",                STRING("X")},
{0x216A, "ROMAN NUMERAL ELEVEN",             STRING("XI")},
{0x216B, "ROMAN NUMERAL TWELVE",             STRING("XII")},
{0x216C, "ROMAN NUMERAL FIFTY",              STRING("L")},
{0x216D, "ROMAN NUMERAL ONE HUNDRED",        STRING("C")},
{0x216E, "ROMAN NUMERAL FIVE HUNDRED",       STRING("D")},
{0x216F, "ROMAN NUMERAL ONE THOUSAND",       STRING("M")},
{0x2170, "SMALL ROMAN NUMERAL ONE",          STRING("i")},
{0x2171, "SMALL ROMAN NUMERAL TWO",          STRING("ii")},
{0x2172, "SMALL ROMAN NUMERAL THREE",        STRING("iii")},
{0x2173, "SMALL ROMAN NUMERAL FOUR",         STRING("iv")},
{0x2174, "SMALL ROMAN NUMERAL FIVE",         STRING("v")},
{0x2175, "SMALL ROMAN NUMERAL SIX",          STRING("vi")},
{0x2176, "SMALL ROMAN NUMERAL SEVEN",        STRING("vii")},
{0x2177, "SMALL ROMAN NUMERAL EIGHT",        STRING("viii")},
{0x2178, "SMALL ROMAN NUMERAL NINE",         STRING("ix")},
{0x2179, "SMALL ROMAN NUMERAL TEN",          STRING("x")},
{0x217A, "SMALL ROMAN NUMERAL ELEVEN",       STRING("xi")},
{0x217B, "SMALL ROMAN NUMERAL TWELVE",       STRING("xii")},
{0x217C, "SMALL ROMAN NUMERAL FIFTY",        STRING("l")},
{0x217D, "SMALL ROMAN NUMERAL ONE HUNDRED",  STRING("c")},
{0x217E, "SMALL ROMAN NUMERAL FIVE HUNDRED", STRING("d")},
{0x217F, "SMALL ROMAN NUMERAL ONE THOUSAND", STRING("m")},

/* Addition for German typography */
{0x017F, "LATIN SMALL LETTER LONG S", STRING("s")},
{0x1E9E, "LATIN CAPITAL LETTER SHARP S", STRING("SS")},

/* misc */
{0x20AC, "EURO SIGN", STRING("EUR")},

{0, "", STRING("")}
};

#endif
