local result, l, i6;
i6:= Sqrt(-6);
result:= rec();
result.comment:=
"2\"A5 as 4 x 4 matrices over Z[i6].\n\
Absolutely irreducible representation.\n\
Schur Index 2.\n\
\n\
SEED:\n\
Nonzero v s.t. v.(1+i6*x+y+y^2) = 0. v is fixed by <y^x> = 3.\n\
v has 2 x 20 = 40 images under G; <v> has 20 images under G.\n\
BASIS:\n\
v, v.x, v.y, v.y^2*x.\n\
\n\
Possible matrix entries for any element of the group:\n\
The 31 elements of {0,1,2,4,i6,i61,i62,i63,i65,2i6,2i64} only.\n\
The possible norms are in {0,1,4,6,7,10,15,16,24,31,40} only.\n\
\n\
Average number of nonzero entries for any element of the group:\n\
13 + 1/5  (13.2; 82.5% exactly).\n\
\n\
    Entry         Av/Mat  %Av/Mat\n\
     0             2.8     17.5\n\
    1             2.0 ea  12.5  each\n\
    2             0.4 ea   2.5  each\n\
    4             0.6 ea   3.75 each\n\
 i6               0.4 ea   2.5  each\n\
 i61             0.6 ea   3.75 each\n\
 i62             0.2 ea   1.25 each\n\
 i63             0.2 ea   1.25 each\n\
 i65             0.2 ea   1.25 each\n\
2i6               0.4 ea   2.5  each\n\
2i64             0.2 ea   1.25 each\n\
Norm 0 [0]         2.8     17.5\n\
Norm 1 [1]        4.0     25\n\
Norm 4 [2]        0.8      5\n\
Norm 6 [i6]       0.8      5\n\
Norm 7 [i61]     2.4     15\n\
Norm 10 [i62]    0.8      5\n\
Norm 15 [i63]    0.8      5\n\
Norm 16 [4]       1.2      7.5\n\
Norm 24 [2i6]     0.8      5\n\
Norm 31 [i65]    0.8      5\n\
Norm 40 [2i64]   0.8      5\n\
nonzero           13.2     82.5\n\
";
result.symmetricforms:= [];
result.antisymmetricforms:= [];
result.hermitianforms:= [];
result.centralizeralgebra:= [];
result.generators:= List( [ [
0,1,0,0,
-1,0,0,0,
i6,-1,0,-1,
1,i6,1,0]
,[
0,0,1,0,
0,1,0,0,
-1,-i6,-1,0,
-1,-2,i6+1,1]
], l -> List( [ 0 .. 3 ],
i -> l{ [ i*4+1 .. (i+1)*4 ] } ) );




l:= [
0,0,1,0,
0,0,0,-1,
-1,0,0,-1,
0,1,1,0];
Add( result.antisymmetricforms, List( [ 0 .. 3 ],
i -> l{ [ i*4+1 .. (i+1)*4 ] } ) );

l:= [
12,-4*i6,i6+6,-4*i6,
4*i6,12,4*i6,-i6+6,
-i6+6,-4*i6,12,-i6-6,
4*i6,i6+6,i6-6,12];
Add( result.hermitianforms, List( [ 0 .. 3 ],
i -> l{ [ i*4+1 .. (i+1)*4 ] } ) );


Add( result.centralizeralgebra, IdentityMat(4) );
return result;
