// Package log implements a basic level based logger
package log

import (
	"fmt"
	"io"
	"log/slog"
	"os"
	"path"
)

// Init initializes the logger by setting a max level 'level' and a directory 'directory' where the log should be stored
// internally, it uses slog, so any package just imports slog
// This can be done as this function sets the logger as the default logger in slog
// It returns the log file and the error
// This log file should be closed at the end
func Init(lvl slog.Level, dir string) (*FileRotater, error) {
	err := os.MkdirAll(dir, 0o700)
	if err != nil {
		return nil, err
	}
	name := path.Join(dir, "log")

	fr, err := NewFileRotater(name)
	if err != nil {
		return nil, fmt.Errorf("failed creating log rotater: %w", err)
	}
	multi := io.MultiWriter(os.Stdout, fr)
	handler := slog.NewTextHandler(multi, &slog.HandlerOptions{
		Level: lvl,
	})
	logger := slog.New(handler)
	slog.SetDefault(logger)
	return fr, nil
}
