/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2001 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef CONSOLE_H
#define CONSOLE_H

#include <SDL/SDL.h>
#ifndef _SDL_H
#include <SDL.h>
#endif

#include <SDL/SDL_image.h>
#ifndef _IMG_h
#include <SDL_image.h>
#endif

#include <stdarg.h>

#include "global.h"
#include "Main.h"

#include "Network.h"

#include "CON_console.h"
#include "CON_consolecommands.h"
#include "DT_drawtext.h"

#define MAX_LINES 50
#define MAX_DISPLAYED_LINES 40
#define LINE_HEIGHT 13
#define CONSOLE_ALPHA_OFF 120
#define CONSOLE_ALPHA_DIFF 2

#define SEND_CUR "->"
#define RECV_CUR "<-"

class Console{
 public:

  Console(SDL_Surface*,int,int,int,int,int);
  ~Console(void);
  void draw(void);
  void set_focus(bool);
  bool get_focus(void);
  void set_visible(bool);
  bool get_visible(void);
  void toggle_visibility(void);
  void handle_event(SDL_Event *);
  int get_y(void);
  int get_height(void);
  int get_x(void);
  int get_width(void);
  void print(char *, ...);
  void prompt(char *, ...);
  char* get_response(void);
  bool is_response_available(void);
 protected:
  SDL_Surface *console_font;
  ConsoleInformation *console_info;
  bool focus;  
  bool visible;
  void load_images(void);
  void free_images(void);
  bool prompted;
  char* response;
  bool response_avaiable;
  ////////      command list        ////////////
};
#endif












