// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package spoe

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllSpoeMessageOKCode is the HTTP code returned for type GetAllSpoeMessageOK
const GetAllSpoeMessageOKCode int = 200

/*
GetAllSpoeMessageOK Successful operation

swagger:response getAllSpoeMessageOK
*/
type GetAllSpoeMessageOK struct {
	/*Spoe configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.SpoeMessages `json:"body,omitempty"`
}

// NewGetAllSpoeMessageOK creates GetAllSpoeMessageOK with default headers values
func NewGetAllSpoeMessageOK() *GetAllSpoeMessageOK {

	return &GetAllSpoeMessageOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all spoe message o k response
func (o *GetAllSpoeMessageOK) WithConfigurationVersion(configurationVersion string) *GetAllSpoeMessageOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all spoe message o k response
func (o *GetAllSpoeMessageOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all spoe message o k response
func (o *GetAllSpoeMessageOK) WithPayload(payload models.SpoeMessages) *GetAllSpoeMessageOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all spoe message o k response
func (o *GetAllSpoeMessageOK) SetPayload(payload models.SpoeMessages) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllSpoeMessageOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.SpoeMessages{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllSpoeMessageDefault General Error

swagger:response getAllSpoeMessageDefault
*/
type GetAllSpoeMessageDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllSpoeMessageDefault creates GetAllSpoeMessageDefault with default headers values
func NewGetAllSpoeMessageDefault(code int) *GetAllSpoeMessageDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllSpoeMessageDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all spoe message default response
func (o *GetAllSpoeMessageDefault) WithStatusCode(code int) *GetAllSpoeMessageDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all spoe message default response
func (o *GetAllSpoeMessageDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all spoe message default response
func (o *GetAllSpoeMessageDefault) WithConfigurationVersion(configurationVersion string) *GetAllSpoeMessageDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all spoe message default response
func (o *GetAllSpoeMessageDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all spoe message default response
func (o *GetAllSpoeMessageDefault) WithPayload(payload *models.Error) *GetAllSpoeMessageDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all spoe message default response
func (o *GetAllSpoeMessageDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllSpoeMessageDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
