/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_TerrainTile
#define GUARD_TerrainTile

#include <SDL.h>

#include <vector>

class TerrainTile {
public:
	TerrainTile(SDL_Surface* iPic, SDL_Rect& iRect):
	pic(iPic), rect(iRect) {}

	void DrawSelf();

	SDL_Surface* pic;
	SDL_Rect rect;
};

class TerrainArea {
public:
	SDL_Rect rect;
	std::vector<TerrainTile> tiles;
};

#endif
