/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_SetupBattle
#define GUARD_SetupBattle

#include "GameState.h"
#include "Menu_Base.h"
#include "DragWindow.h"

namespace SetupBattle {

class SetupBattle_State: public GameState {
public:
	SetupBattle_State();
	~SetupBattle_State();
	void Main();
	
	void MouseD(Uint8 button, Uint16 x, Uint16 y);
	void Keyboard(SDL_keysym& keysym);
};

void DrawWorld();

void KickFleet(int nSide);

void GoToBattle();

////

class BasePU: public PopupMenu {
public:
	BasePU(int ix, int iy);
	bool SwitchOnChoice(Uint16 x, Uint16 y);
};

class LoadSideMenu: public FileListMenu {
public:
	LoadSideMenu(int iNSide, int iParentID);
	~LoadSideMenu() {imAlreadyOpen = false;}

	bool SwitchOnChoice(Uint16 x, Uint16 y);

	static bool imAlreadyOpen;

protected:
	int nSide;
};

class PlayerList: public Menu_Base {
public:
	PlayerList(int ix, int iy, int flags);
	void Update();

protected:
	bool SwitchOnChoice(Uint16 x, Uint16 y);
};

class RandomSeed: public SliderWithUnits {
public:
	RandomSeed(int ix, int iy, int flags);
};

void CreateLoadSideWindows(int nSide);

} //end namespace

#endif

